#ifndef pcibios_h
#define pcibios_h

#ifndef uint8_t
typedef unsigned char	uint8_t;
#endif
#ifndef uint16_t
typedef unsigned short	uint16_t;
#endif
#ifndef int32_t
typedef long            int32_t;
#endif
#ifndef uint32_t
typedef unsigned long	uint32_t;
#endif

#define	HiW(dw)	(uint16_t)((uint32_t)dw >> 16)
#define	LoW(dw)	(uint16_t)((uint32_t)dw & 0xFFFF)

#define PCI_FUNCTION_ID		0xB1
#define PCI_BIOS_PRESENT	0x01
#define PCI_FIND_DEVICE		0x02
#define PCI_READ_BYTE		0x08
#define PCI_READ_WORD		0x09
#define PCI_READ_DWORD		0x0A
#define PCI_WRITE_BYTE		0x0B
#define PCI_WRITE_WORD		0x0C
#define PCI_WRITE_DWORD		0x0D
#define PCI_GET_ROUTING		0x0E
#define PCI_SET_INTERRUPT	0x0F
#define PCI_SERVICE		0x1A

#define PCI_SUCCESSFUL		0x00
#define PCI_NOT_SUPPORTED	0x81
#define PCI_BAD_VEMDERID	0x83
#define PCI_DEVICE_NOTFOUND	0x86
#define PCI_BAD_REGNUMBER	0x87
#define PCI_SET_FAILED		0x88
#define PCI_BUFFER_SMALL	0x98

#define PCIR_VID		0x00
#define	PCIR_DID		0x02
#define	PCIR_PCICMD		0x04
#define	PCIR_RID		0x08
#define	PCIR_CCODE		0x0A
#define	PCIR_HEADT		0x0E
#define	PCIR_NAMBAR		0x10
#define	PCIR_NABMBAR		0x14
#define	PCIR_SSVID		0x2C
#define	PCIR_SSID		0x2E
#define	PCIR_INTR_LN		0x3C
#define	PCIR_INTR_PIN		0x3D

typedef struct pci_config_s{
 uint8_t bBus;
 uint8_t bDev;
 uint8_t bFunc;
 uint16_t vendor_id;
 uint16_t device_id;
 char *device_name;  // string
}pci_config_s;

typedef struct pci_device_s{
 char *device_name;  // (constant) string
 uint16_t vendor_id;
 uint16_t device_id;
}pci_device_s;

//uint8_t  pcibios_GetBus(void);
uint8_t	 pcibios_FindDevice(uint16_t, uint16_t, pci_config_s *);
uint8_t  pcibios_search_devices(pci_device_s devices[],pci_config_s *);
uint8_t	 pcibios_ReadConfig_Byte (pci_config_s *, uint16_t);
uint16_t pcibios_ReadConfig_Word (pci_config_s *, uint16_t);
uint32_t pcibios_ReadConfig_Dword(pci_config_s *, uint16_t);
void	 pcibios_WriteConfig_Byte(pci_config_s *, uint16_t, uint8_t);
//void	 pcibios_WriteConfig_Word(pci_config_s *, uint16_t, uint16_t);
//void	 pcibios_WriteConfig_Dword(pci_config_s *, uint16_t, uint32_t);

#endif
