#ifndef dmairq_h
#define dmairq_h

#include "mpxplay.h"

#define DMAMODE_AUTOINIT_OFF 0
#define DMAMODE_AUTOINIT_ON  0x10

typedef struct au_isadma_s{
 unsigned int dma_low;
 unsigned int dma_high;
 dosmem_t *card_dma_dosmem;
}au_isadma_s;

extern struct dosmem_t *MDma_alloc_dosmem(unsigned int buffsize);
extern void MDma_free_dosmem(struct dosmem_t *dm);
extern unsigned int MDma_get_max_pcmoutbufsize(struct audio_info *aui,unsigned int pagesize);
extern unsigned int MDma_init_pcmoutbuf(struct audio_info *aui,unsigned int maxbufsize,unsigned int pagesize);

extern void MDma_clearbuf(struct audio_info *aui);
extern void MDma_writedata(struct audio_info *aui,char *src,unsigned int left);
extern void MDma_interrupt_monitor(struct audio_info *aui);

extern void MDma_ISA_FreeMem(struct audio_info *aui);
extern void MDma_ISA_init(struct audio_info *aui);
extern void MDma_ISA_Start(struct audio_info *aui,unsigned int dmamode,unsigned long initbufpos,unsigned long initbufsize);
extern void MDma_ISA_Stop(struct audio_info *aui);
extern unsigned int MDma_ISA_getbufpos(struct audio_info *aui);
extern void MDma_ISA_Clear(struct audio_info *aui);
extern unsigned int MDma_ISA_autodetect(struct audio_info *aui);

extern void MIrq_OnOff(unsigned int irqnum,unsigned int start);
extern void MIrq_Start(struct audio_info *aui);
extern void MIrq_Stop(struct audio_info *aui);
extern unsigned int MIrq_autodetect(struct audio_info *aui);

#define ENTER_CRITICAL IRQ_PUSH_OFF()
 void IRQ_PUSH_OFF (void);
#pragma aux IRQ_PUSH_OFF = \
	"pushfd",          \
	"cli"              \
	modify [esp];

#define LEAVE_CRITICAL IRQ_POP()
 void IRQ_POP (void);
#pragma aux IRQ_POP =   \
		"popfd" \
		"sti"   \
		modify [esp];

#endif
