//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2004 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: DMA buffer handling (PCI only)

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <io.h>
#include <dos.h>
#include <malloc.h>
#include <string.h>

#include <newfunc\newfunc.h>
#include <au_cards\au_cards.h>
#include <au_cards\dmairq.h>

//-----------------------------------------------------------------------
//common (ISA & PCI)

struct dosmem_t *MDma_alloc_dosmem(unsigned int buffsize)
{
 struct dosmem_t *dm;
 dm=calloc(1,sizeof(dosmem_t));
 if(!dm)
  return dm;
 if(!pds_dpmi_dos_allocmem(dm,buffsize)){
  free(dm);
  return NULL;
 }
 memset(dm->linearptr,0,buffsize);
 return dm;
}

void MDma_free_dosmem(struct dosmem_t *dm)
{
 if(dm){
  pds_dpmi_dos_freemem(dm);
  free(dm);
 }
}

unsigned int MDma_get_max_pcmoutbufsize(struct audio_info *aui,unsigned int pagesize)
{
 unsigned int bufsize;
 if(aui->card_controlbits&AUINFOS_CARDCNTRLBIT_DOUBLEDMA)
  bufsize=65535;
 else
  bufsize=30000;
 if(!pagesize)
  pagesize=4096;
 bufsize+=(pagesize-1);      // rounding up to pagesize
 bufsize-=(bufsize%pagesize);  //
 if(bufsize>65535)                  // !!! must be less than 65536 (yet)
  bufsize=65535-(65535%pagesize);
 return bufsize;
}

unsigned int MDma_init_pcmoutbuf(struct audio_info *aui,unsigned int maxbufsize,unsigned int pagesize)
{
 unsigned int dmabufsize;
 float freq;

 dmabufsize=(unsigned int)((float)maxbufsize
		   *(float)aui->freq_card/44100.0
		   *(float)aui->bits_card/16.0);
 dmabufsize+=(pagesize-1);           // rounding up to pagesize
 dmabufsize-=(dmabufsize%pagesize);  //
 if(dmabufsize<(pagesize*2))
  dmabufsize=(pagesize*2);
 if(dmabufsize>maxbufsize){
  dmabufsize=maxbufsize;
  dmabufsize-=(dmabufsize%pagesize);
 }

 aui->card_bytespersign=aui->chan_card*((aui->bits_card+7)/8);

 //dmabufsize-=(dmabufsize%aui->card_bytespersign);

 aui->card_dmasize=dmabufsize;

 if(!aui->card_outbytes)
  aui->card_outbytes=PCM_OUTSAMPLES*aui->card_bytespersign; // not exact

 aui->card_dmaout_under_int08= (unsigned int)
  ( (float)aui->freq_card*(float)aui->chan_card*(float)aui->bits_card/8.0
   /((float)INT08_DIVISOR_DEFAULT*(float)INT08_CYCLES_DEFAULT/(float)INT08_DIVISOR_NEW) );

 aui->card_dmaout_under_int08+=aui->card_bytespersign-1;                              // rounding up
 aui->card_dmaout_under_int08-=(aui->card_dmaout_under_int08%aui->card_bytespersign); // to pcm_samples

 aui->card_dma_lastgoodpos=0; // !!! the soundcard also must to do this
 aui->card_dmalastput=aui->card_dmaspace=aui->card_dmafilled=aui->card_dmasize>>1;

 freq=(aui->freq_song<22050)? 22050.0:(float)aui->freq_song;
 aui->int08_decoder_cycles=(freq/(float)PCM_OUTSAMPLES)*(float)INT08_DIVISOR_NEW/(float)(INT08_CYCLES_DEFAULT*INT08_DIVISOR_DEFAULT)+1;

 return dmabufsize;
}

void MDma_clearbuf(struct audio_info *aui)
{
 if(aui->card_DMABUFF && aui->card_dmasize)
  pds_memset(aui->card_DMABUFF,0,aui->card_dmasize);
}

void MDma_writedata(struct audio_info *aui,char *src,unsigned int left)
{
 unsigned int todo;

 todo=aui->card_dmasize-aui->card_dmalastput;

 if(todo<=left){
  pds_memcpy(aui->card_DMABUFF+aui->card_dmalastput,src,todo);
  aui->card_dmalastput=0;
  left-=todo;
  src+=todo;
 }
 if(left){
  pds_memcpy(aui->card_DMABUFF+aui->card_dmalastput,src,left);
  aui->card_dmalastput+=left;
 }
}

// *************** called from int08 **********************************

// checks the DMA buffer and if it's empty, fills with zeroes
void MDma_interrupt_monitor(struct audio_info *aui)
{
 if(aui->card_dmafilled<(aui->card_dmaout_under_int08*2)){
  if(!(aui->card_infobits&AUINFOS_CARDINFOBIT_DMAUNDERRUN)){
   MDma_clearbuf(aui);
   funcbit_enable(aui->card_infobits,AUINFOS_CARDINFOBIT_DMAUNDERRUN);
  }
 }else{
  aui->card_dmafilled-=aui->card_dmaout_under_int08;
  funcbit_disable(aui->card_infobits,AUINFOS_CARDINFOBIT_DMAUNDERRUN);
 }
}
