#include <i86.h>
#include <malloc.h>
#include <string.h>

//#define MEMALLOC_DEBUG 1

#define INITIAL_HANDTABLE_SIZE 1024

#ifndef NULL
 #define NULL 0L
#endif

typedef struct memhandler_s{
 unsigned long handler;
 void *linearptr;
}memhandler_s;

static unsigned long handtable_handler,handtable_size;
static struct memhandler_s *memhandlers;

#ifdef MEMALLOC_DEBUG
#include "newfunc\newfunc.h"
extern struct mpxplay_resource_s *mrs;
#endif

//----------------------------------------------------------------------
// memfield edit

#ifdef __WATCOMC__

void *asm_memset(void *,int,unsigned int);

void *memset(void *addr,int num,unsigned int len)
{
#pragma aux asm_memset=\
 "test ebx,ebx"\
 "jz noset"\
  "mov esi,eax"\
  "cld"\
  "mov edi,eax"\
  "mov dh,dl"\
  "mov eax,edx"\
  "bswap eax"\
  "mov ax,dx"\
  "mov ecx,ebx"\
  "shr ecx,2"\
  "repne stosd"\
  "mov ecx,ebx"\
  "and ecx,3"\
  "repne stosb"\
  "mov eax,esi"\
 "noset:"\
 parm[eax][edx][ebx] value[eax] modify[eax ecx edx edi esi];
 return asm_memset(addr,num,len);
}

#else

void *memset(void *p_addr,int num,unsigned int len)
{
 if(len){
  char *addr=p_addr;
  do{
   *addr++=num;
  }while(--len);
 }
 return p_addr;
}

#endif

//--------------------------------------------------------------------
// DPMI callings

static void *dpmi_alloc(unsigned int size,unsigned long *handler)
{
 union REGS regs;
 unsigned long ptr;

 memset((void *)&regs,0,sizeof(union REGS));
 regs.x.eax = 0x0501;
 regs.x.ebx = size>>16;
 regs.x.ecx = size&0xffff;
 regs.x.cflag=1;
 int386(0x31,&regs,&regs);
 ptr=((unsigned long)(regs.w.bx)<<16)|((unsigned long)(regs.w.cx));
 if(regs.x.cflag || (ptr==0xffffffff)){
  *handler=0;
  return NULL;
 }

 *handler=((unsigned long)(regs.w.si)<<16)|(unsigned long)(regs.w.di);

 return ((void *)ptr);
}

static void *dpmi_realloc(unsigned int size,unsigned long *handler)
{
 union REGS regs;
 unsigned long ptr;

 memset((void *)&regs,0,sizeof(union REGS));
 regs.x.eax = 0x0503;
 regs.x.ebx = size>>16;
 regs.x.ecx = size&0xffff;
 regs.w.di  = (*handler)&0xffff;
 regs.w.si  = (*handler)>>16;
 regs.x.cflag=1;
 int386(0x31,&regs,&regs);
 ptr=((unsigned long)(regs.w.bx)<<16)|((unsigned long)(regs.w.cx));
 if(regs.x.cflag || (ptr==0xffffffff)){
  *handler=0;
  return NULL;
 }

 *handler=((unsigned long)(regs.w.si)<<16)|(unsigned long)(regs.w.di);

 return ((void *)ptr);
}

static void dpmi_free(unsigned long handler)
{
 union REGS regs;

 memset((void *)&regs,0,sizeof(union REGS));
 regs.x.eax = 0x0502;
 regs.w.di = handler&0xffff;
 regs.w.si = handler>>16;
 regs.x.cflag=1;
 int386(0x31,&regs,&regs);
}

//---------------------------------------------------------------------
// helpers

static long search_free_handler(void)
{
 long i,retry=3;
 struct memhandler_s *newmemhs;
 unsigned long newhand;

 if(!memhandlers){
  memhandlers=dpmi_alloc(INITIAL_HANDTABLE_SIZE*sizeof(struct memhandler_s),&handtable_handler);
  if(!memhandlers)
   return -1;
  handtable_size=INITIAL_HANDTABLE_SIZE;
  memset((void *)memhandlers,0,handtable_size*sizeof(struct memhandler_s));
 }

 do{
  for(i=0;i<handtable_size;i++)
   if(!memhandlers[i].linearptr)
    return i;

  // free handler not found, allocate more space for handlers
  newmemhs=dpmi_alloc(2*handtable_size*sizeof(struct memhandler_s),&newhand);
  if(!newmemhs)
   break;
  memcpy((void *)newmemhs,(void *)memhandlers,handtable_size*sizeof(struct memhandler_s));
  // clear the new memory field (keep the old one)
  memset((void *)(newmemhs+handtable_size),0,handtable_size*sizeof(struct memhandler_s));
  dpmi_free(handtable_handler);
  memhandlers=newmemhs;
  handtable_handler=newhand;
  handtable_size*=2;
 }while(--retry); // to avoid freezing in the case of no luck (programming error)
 return -1;
}

static long search_allocated_handler(void *ptr)
{
 long i;

 for(i=0;i<handtable_size;i++)
  if(memhandlers[i].linearptr==ptr)
   return i;

 return -1;
}

// free all allocated memory blocks and the memhandlers[]
void memalloc_close(void)
{
 long i;
 if(memhandlers){
  for(i=0;i<handtable_size;i++)
   if(memhandlers[i].linearptr)
    dpmi_free(memhandlers[i].handler);

  dpmi_free(handtable_handler);
  handtable_handler=0;
  handtable_size=0;
  memhandlers=NULL;
 }
}

//--------------------------------------------------------------------
// memory allocation functions instead of the deault WC lib (clib3r.lib)

void *malloc(unsigned int size)
{
 long i;

 if(!size)
  return NULL;

 i=search_free_handler();
 if(i<0)
  return NULL;

 memhandlers[i].linearptr=dpmi_alloc(size,&memhandlers[i].handler);

#ifdef MEMALLOC_DEBUG
 {
  char sout[100];
  sprintf(sout,"malloc : %8.8X %8.8X ",memhandlers[i].handler,memhandlers[i].linearptr);
  mrs->pds_textdisplay_printf(sout);
 }
#endif

 return (memhandlers[i].linearptr);
}

void *calloc(unsigned int nitems,unsigned int itemsize)
{
 unsigned long memsize=nitems*itemsize;
 void *ptr;

 ptr=malloc(memsize);

 if(ptr)
  memset(ptr,0,memsize);

 return ptr;
}

void *realloc(void *ptr,unsigned int newsize)
{
 long i;

 if(!newsize)
  return ptr;

 if(ptr)
  i=search_allocated_handler(ptr);
 else
  i=-1;

 if(i<0)
  ptr=malloc(newsize);
 else
  ptr=memhandlers[i].linearptr=dpmi_realloc(newsize,&memhandlers[i].handler);

#ifdef MEMALLOC_DEBUG
 {
  char sout[100];
  sprintf(sout,"realloc: %8.8X %8.8X ",memhandlers[i].handler,ptr);
  mrs->pds_textdisplay_printf(sout);
 }
#endif

 return ptr;
}

void free(void *ptr)
{
 long i;

 i=search_allocated_handler(ptr);
 if(i>=0){
#ifdef MEMALLOC_DEBUG
  char sout[100];
  sprintf(sout,"free   : %8.8X %8.8X ",memhandlers[i].handler,memhandlers[i].linearptr);
  mrs->pds_textdisplay_printf(sout);
#endif
  dpmi_free(memhandlers[i].handler);
  memhandlers[i].handler=0;
  memhandlers[i].linearptr=NULL;
 }
}

void near *_nmalloc(unsigned int size)
{
 return malloc(size);
}

int _heapchk(void)
{
#ifdef MEMALLOC_DEBUG
 mrs->pds_textdisplay_printf("heapchk");
#endif
 return _HEAPOK;
}

/*void far *_dos_getvect(int intno)
{
 union REGS regs;

 memset((void *)&regs,0,sizeof(union REGS));
 regs.w.ax=0x204;
 regs.h.bl=intno;
 int386(0x31, &regs, &regs);
#ifdef MEMALLOC_DEBUG
 {
  char sout[100];
  sprintf(sout,"getvect: %2d %4.4X %8.8X ",intno,regs.w.cx,regs.x.edx);
  mrs->pds_textdisplay_printf(sout);
 }
#endif
 return MK_FP(regs.w.cx, regs.x.edx);
}

void _dos_setvect(int intno,void far *vect)
{
 union REGS regs;

 memset((void *)&regs,0,sizeof(union REGS));
 regs.w.ax=0x205;
 regs.h.bl=intno;
 regs.w.cx=FP_SEG(vect);
 regs.x.edx=FP_OFF(vect);
#ifdef MEMALLOC_DEBUG
 {
  char sout[100];
  sprintf(sout,"setvect: %2d %4.4X %8.8X ",intno,regs.w.cx,regs.x.edx);
  mrs->pds_textdisplay_printf(sout);
 }
#endif
 int386(0x31, &regs, &regs);
}*/

void far *_dos_getvect(unsigned int intno)
{
 struct SREGS sregs;
 union REGS regs;
 memset((void *)&regs,0,sizeof(union REGS));
 memset((void *)&sregs,0,sizeof(struct SREGS));
 regs.h.ah=0x35;
 regs.h.al=intno;
 sregs.ds=sregs.es=0;
 int386x(0x21, &regs, &regs, &sregs);
 return MK_FP(sregs.es, regs.x.ebx);
}

void _dos_setvect(unsigned int intno, void far *vect)
{
 struct SREGS sregs;
 union REGS regs;
 memset((void *)&regs,0,sizeof(union REGS));
 memset((void *)&sregs,0,sizeof(struct SREGS));
 regs.h.ah=0x25;
 regs.h.al=intno;
 regs.x.edx=FP_OFF(vect);
 sregs.ds=FP_SEG(vect);
 sregs.es=0;
 int386x(0x21, &regs, &regs, &sregs);
}
