' ===========================================================================
'                            
'                                           
'                                    
'                                       
'                       3.00
' ===========================================================================
'                     Copyright 2002, Sebastian Mate
'
'                    - the Real way for MIDI in QB -

'   ---=====  R E A D   T H I S   F I L E   C A R E F U L L Y ! =====---

'
' Program:     RealMIDI 3.00 (sequencer)
' Description: The first REAL MIDI-player for QB!
' Author:      Sebastian Mate (sebmate@arcor.de)
' Version:     3.00 (4)
' Edition:     1

' Disclaimer
' ----------
' The programmer assumes no responsibility for any harm or costs
' that comes from using the material contained in these files and to
' you, your computer, or anything relating to your existence. No
' warranty is provided or implied on these files!
' These files are provided as them are (as if you have written them on your
' own).
' All names and trademarks belong to their owners.

' -> You can use this program in any way you want, however, please
'    give me credits.

' Credits
' -------
' This program would not be possible without using parts from to two
' other great programmers:
' -> Luke Erren wrote a program that could play MIDI-files using the
'    MPU404-interface. You have to connect your computer to a MIDI-keyboard.
' -> Davey W. Taylor, he wrote a FM-Tracker from which I used the support
'    for the FM-Synthesis.
' -> Matthias Becker, he told me some stuff on MIDI so I could develop
'    RealMIDI 2.0 faster. Thx!
' -> Annica Maria Toresson (is it his/her true name???), who helped me
'    very much with the OPL3 stuff. Mainly by him (her?).

' See README.TXT in the base directoy for more information!

'Start of the program:
'DEFINT A-Z
DECLARE SUB DoMIDPlay ()
DECLARE SUB Finish ()
DECLARE SUB InitMIDI ()
DECLARE SUB MidiTune (Tune%, Volume%, Channel%)
DECLARE FUNCTION NextNumber! ()
DECLARE SUB NextVo ()
DECLARE FUNCTION Nibble$ (Cr$, Lr!)
DECLARE FUNCTION Nibble2Number! (ch$)
DECLARE FUNCTION ReadBPM! ()
DECLARE FUNCTION ReadFourBytes! ()
DECLARE FUNCTION ReadText$ ()
DECLARE FUNCTION ReadTimeSignature$ ()
DECLARE FUNCTION ReadTwoBytes! ()
DECLARE FUNCTION ReadVarLen! ()
DECLARE FUNCTION ReadVoice$ ()
DECLARE SUB ResetFM ()
DECLARE SUB SCOLOR (AA%, BB%)
DECLARE SUB SCOLOR2 (AA%)
DECLARE SUB SetInstruments ()
DECLARE SUB StopPlay (Channel%)
DECLARE SUB WavPlay ()
DECLARE SUB WriteReg (Reg%, info%)
DECLARE SUB WriteReg2 (Reg%, Value%)

TYPE ChType
 ChName AS STRING * 8
 ChSett AS STRING * 11
END TYPE

' Variables ... most of them are probably uneused :-) Sorry!
COMMON SHARED Tune%, chan%, Channel%, notune%, PolyPh%, PTime, Volume%, chnnl!, TotalTime!, tempo, rtempo&, DlTime, Tracker%, SpeedIndex&, TTSChan%
DIM SHARED Channe(0 TO 8) AS ChType, T, TL  AS SINGLE
DIM SHARED Instrname(127) AS STRING, FRQ%, ChHistory(0 TO 16) AS STRING
DIM SHARED header AS STRING * 4
DIM SHARED TweeByte AS STRING * 2
DIM SHARED VierByte AS STRING * 4
DIM SHARED FileType AS STRING * 2
DIM SHARED L AS INTEGER, LASTVOL AS INTEGER, F#, MKal&, Ziel&, Anzahl%, MPUPort%, NoMpu%
DIM SHARED VoiceSet(0 TO 127) AS INTEGER, BPort%', ChVoice(0 TO 8) AS STRING,
DIM SHARED voicetab(0 TO 127) AS INTEGER, Inst$, LastVolume%, DrumSetUp(0 TO 255)  AS INTEGER
DIM SHARED I AS LONG, ChUse(0 TO 17) AS INTEGER, UsedByDrumSet(0 TO 8)  AS INTEGER
DIM SHARED A AS STRING * 1, DrumSet%, Lead%, PPOS, onchan(0 TO 17)  AS INTEGER
DIM SHARED VOL(0 TO 17) AS INTEGER, DisplayVol(0 TO 17) AS INTEGER, text(30) AS STRING, CHANON(1 TO 17) AS INTEGER
DIM SHARED Instrument(128)  AS ChType, FILE$, LyrPos%, lastdrumch%, TuneInUse%(0 TO 127)
DIM SHARED InLen(17) AS INTEGER, TrackXisOnCH(0 TO 17, 0 TO 127) AS INTEGER, RealVol(0 TO 17) AS INTEGER
DIM SHARED TuneTable1(0 TO 512) AS SINGLE, CurChan%, TuneTable2(0 TO 512) AS INTEGER, TuneTable3(0 TO 512) AS INTEGER, TuneTable4(0 TO 512) AS INTEGER
DIM SHARED Decr(0 TO 512)  AS SINGLE, InCr(0 TO 512) AS SINGLE, Buffer AS STRING, WaveTable1(0 TO 128) AS DOUBLE, WaveTable2(0 TO 128), lyr$, LyriPos%, Voopen%, CurCnt(1 TO 512) AS INTEGER, WaveTable3(0 TO 128) AS SINGLE
DIM SHARED OutDevice AS INTEGER, IsTTS AS INTEGER, WaveVolume AS INTEGER, MaxVolume%, OverDelay!, reads!, xptr!, TTSFreq%
DIM SHARED CenterFreq%, TTSPath$
DECLARE SUB ffix
'ffix ' Can be commented to run the source in the QB IDE!

'ON ERROR GOTO FatalError:


'Detect soundcard
IF LEN(ENVIRON$("BLASTER")) <> 0 THEN
   FOR Length% = 1 TO LEN(ENVIRON$("BLASTER"))
      SELECT CASE MID$(ENVIRON$("BLASTER"), Length%, 1)
      CASE "A"
	BPort% = VAL("&H" + MID$(ENVIRON$("BLASTER"), Length% + 1, 3))
      END SELECT
   NEXT

   IF LEN(ENVIRON$("BLASTER")) THEN
      FOR Length% = 1 TO LEN(ENVIRON$("BLASTER"))
	 IF MID$(ENVIRON$("BLASTER"), Length%, 1) = "P" THEN MPUPort% = VAL("&H" + MID$(ENVIRON$("BLASTER"), Length% + 1, 3))
      NEXT
   END IF

   IF NOT MPUPort% THEN MPUPort% = &H330
END IF

IF BPort% > 576 OR BPort% = 0 THEN BPort% = &H380

DrumSet% = 10              ' The drumset-track

OPEN "REALMIDI.CFG" FOR INPUT AS #1
 INPUT #1, OutDevice
 INPUT #1, IsTTS
 INPUT #1, WaveVolume
 LINE INPUT #1, TTSPath$
CLOSE #1

IF OutDevice = 1 THEN ResetFM
IF OutDevice = 2 THEN
   OUT MPUPort%, &HFF
   FOR Temp = 255 TO 0 STEP -1
      OUT MPUPort% + 1, Temp + 2
   NEXT Temp
END IF

IF COMMAND$ <> "" THEN FILE$ = COMMAND$

IF FILE$ = "" THEN
PRINT
PRINT "REALMIDI 3.0 MIDI Player - Copyright 2002 Sebastian Mate"
PRINT
PRINT "USAGE: REALMIDI [FILE] (TTS channel)"
PRINT
PRINT "    FILE (required)       : A MIDI format 0 file (*.MID or *.KAR)"
PRINT "    TTS Channel (optional): The MIDI channel 1-16 which is"
PRINT "                            used for the TTS."
PRINT
PRINT "Example:     REALMIDI DEMO.MID 4"
PRINT
END
END IF

IF INSTR(COMMAND$, " ") THEN
   FILE$ = MID$(COMMAND$, 1, INSTR(COMMAND$, " "))
   TTSChan% = VAL(MID$(COMMAND$, INSTR(COMMAND$, " ") + 1, LEN(COMMAND$) - INSTR(COMMAND$, " ")))
END IF

'========================================================================
'Main routine to open and play the file.

IF OutDevice > 3 THEN OPEN "TEMP.WAV" FOR OUTPUT AS #3

InitMIDI

DO
   DoMIDPlay
LOOP UNTIL EOF(1)

'========================================================================

IF OutDevice = 2 THEN
   FOR ic% = 0 TO 15
      FOR J% = 0 TO 120
	 OUT MPUPort%, &H80 + ic%
	 OUT MPUPort%, J%
	 OUT MPUPort%, 0
      NEXT J%
   NEXT ic%
END IF

IF OutDevice = 4 THEN Finish


InstrmntName:
'    MIDI-NAME   FM-DATABASE   DECAY  WAVEFORM ATTACK
DATA "Acoustic Grand", "46", "0.01", "0", "1"
DATA "Bright Acoustic", "46", "0.01", "0", "1"
DATA "Electric Grand", "46", "0.01", "0", "1"
DATA "Honky-Tonk", "32", "0.01", "1", "1"
DATA "Electric Piano 1", "46", "0.01", "0", "1"
DATA "Electric Piano 2", "46", "0.01", "0", "1"
DATA "Harpsichord", "32", "0.01", "1", "1"
DATA "Clavinet", "19", "0.01", "0", "1"
DATA "Celesta", "15", "0.01", "0", "1"
DATA "Glockenspiel", "69", "0.1", "1", ".1"
DATA "Music Box", "69", "0.1", "0", "1"
DATA "Vibraphone", "69", "0.1", "0", "1"
DATA "Marimba", "46", "0.1", "0", "1"
DATA "Xylophone", "71", "0.1", "0", "1"
DATA "Tubular Bells", "11", "0.005", "0", "1"
DATA "Dulcimer", "32", "0.005", "1", "1"
DATA "Drawbar Organ", "45", "0", "1", ".1"
DATA "Percussive Organ", "45", "0.01", "0", "1"
DATA "Rock Organ", "45", "0", "0", "1"
DATA "Church Organ", "45", "0", "1", ".05"
DATA "Reed Organ", "45", "0", "1", ".05"
DATA "Accoridan", "1", "0", "1", ".1"
DATA "Harmonica", "1", "0", "1", ".1"
DATA "Tango Accordian", "1", "0", "1", "1"
DATA "Nylon Guitar", "29", "0.1", "0", "1"
DATA "Steel Guitar", "29", "0.08", "0", "1"
DATA "Jazz Guitar", "29", "0.08", "0", "1"
DATA "Clean Guitar", "29", "0.01", "0", "1"
DATA "Muted Guitar", "29", "0.1", "1", "1"
DATA "Overdriven Guitar", "29", "0.001", "1", "1"
DATA "Distortion Guitar", "29", "0.001", "1", "1"
DATA "Guitar Harmonics", "29", "0.01", "0", "1"
DATA "Acoustic Bass", "72", "0.005", "0", "1"
DATA "Electric Bass(finger)", "72", "0.005", "0", "1"
DATA "Electric Bass(pick)", "49", "0.01", "0", "1"
DATA "Fretless Bass", "72", "0.01", "1", "1"
DATA "Slap Bass 1", "72", "0.01", "1", "1"
DATA "Slap Bass 2", "72", "0.01", "1", "1"
DATA "Synth Bass 1", "72", "0.005", "1", "1"
DATA "Synth Bass 2", "49", "0.005", "1", "1"
DATA "Violin", "70", "0", "1", ".05"
DATA "Viola", "70", "0", "1", ".05"
DATA "Cello", "16", "0", "1", ".05"
DATA "Contrabass", "16", "0", "1", ".05"
DATA "Tremolo Strings", "73", "0", "1", ".05"
DATA "Pizzicato Strings", "31", "0.1", "0", ".05"
DATA "Orchestral Strings", "58", "0.000", "0", ".05"
DATA "Timpani", "10", "0.1", "1", "1"
DATA "Strings 1", "58", "0.000", "1", ".1"
DATA "Strings 2", "58", "0.000", "1", ".1"
DATA "SynthStrings 1", "73", "0.000", "1", ".05"
DATA "SynthStrings 2", "73", "0.000", "1", ".05"
DATA "Choir Aahs", "52", "0.000", "1", ".05"
DATA "Voice Oohs", "44", "0.000", "0", ".05"
DATA "Synth Voice", "73", "0.000", "1", ".05"
DATA "Orchestra Hit", "1", "0.01", "1", "1"
DATA "Trumpet", "67", "0.000", "1", "1"
DATA "Trombone", "66", "0.000", "1", "1"
DATA "Tuba", "68", "0.000", "1", "1"
DATA "Muted Trumpet", "13", "0.000", "1", "1"
DATA "French Horn", "28", "0.000", "1", ".1"
DATA "Brass Section", "13", "0.000", "1", "1"
DATA "SynthBrass 1", "13", "0.000", "1", "1"
DATA "SynthBrass 2", "13", "0.000", "1", "1"
DATA "Soprano Sax", "13", "0.000", "1", "1"
DATA "Alto Sax", "13", "0.000", "1", "1"
DATA "Tenor Sax", "13", "0.000", "1", "1"
DATA "Baritone Sax", "13", "0.000","1", "1"
DATA "Oboe", "44", "0.000", "0", ".1"
DATA "English Horn", "26", "0.000", "0", "1"
DATA "Bassoon", "7", "0", "0", ".1"
DATA "Clarinet", "18", "0", "0", "1"
DATA "Piccolo", "27", "0", "0", "1"
DATA "Flute", "27", "0", "0", "1"
DATA "Recorder", "27", "0", "0", "1"
DATA "Pan Flute", "27", "0", "0", "1"
DATA "Blown Bottle", "27", "0", "0", ".1"
DATA "Skakuhachi", "27", "0", "0", "1"
DATA "Whistle", "27", "0", "0", "1"
DATA "Ocarina", "27", "0", "0", "1"
DATA "Lead 1 (square)", "46", "0", "1", "1"
DATA "Lead 2 (sawtooth)", "74", "0", "1", "1"
DATA "Lead 3 (calliope)", "46", "0", "0", "1"
DATA "Lead 4 (chiff)", "46", "0.001", "0", "1"
DATA "Lead 5 (charang)", "57", "0.001", "0", "1"
DATA "Lead 6 (voice)", "46", "0", "0", "1"
DATA "Lead 7 (fifths)", "46", "0", "0", "1"
DATA "Lead 8 (bass+lead)", "46", "0.001", "0", "1"
DATA "Pad 1 (new age)", "45", "0.001", "0", "1"
DATA "Pad 2 (warm)", "52", "0", "0", "1"
DATA "Pad 3 (polysynth)", "52", "0", "0", "1"
DATA "Pad 4 (choir)", "52", "0", "0", "1"
DATA "Pad 5 (bowed)", "52", "0", "0", ".01"
DATA "Pad 6 (metallic)", "46", "0.001", "0", "1"
DATA "Pad 7 (halo)", "46", "0.001", "0", ".1"
DATA "Pad 8 (sweep)", "45", "0.001", "0", ".1"
DATA "FX 1 (rain)", "55", "0.001", "0", ".1"
DATA "FX 2 (soundtrack)", "45", "0.001", "0", "1"
DATA "FX 3 (crystal)", "45", "0.001", "0", "1"
DATA "FX 4 (atmosphere)", "45", "0.001", "0", "1"
DATA "FX 5 (brightness)", "45", "0.001", "0", "1"
DATA "FX 6 (goblins)", "45", "0.01", "0", "1"
DATA "FX 7 (echoes)", "64", "0.01", "0", "1"
DATA "FX 8 (sci-fi)", "1", "0.001", "0", "1"
DATA "Sitar", "53", "0.1", "0", "1"
DATA "Banjo", "5", "0.1", "0", "1"
DATA "Shamisen", "5", "0.1", "0", "1"
DATA "Koto", "5", "0.1", "0", "1"
DATA "Kalimba", "71", "0.1", "0", "1"
DATA "Bagpipe", "4", "0.001", "0", "1"
DATA "Fiddle", "70", "0.01", "0", "1"
DATA "Shanai", "46", "0.01", "0", "1"
DATA "Tinkle Bell", "46", "0.01", "0", "1"
DATA "Agogo", "46", "0.1", "0", "1"
DATA "Steel Drums", "64", "0.1", "0", "1"
DATA "Woodblock", "71", "0.1", "0", "1"
DATA "Taiko Drum", "71", "0.1", "0", "1"
DATA "Melodic Tom", "64", "0.1", "0", "1"
DATA "Synth Drum", "71", "0.1", "0", "1"
DATA "Reverse Cymbal", "21", "0.1", "0", ".01"
DATA "Guitar Fret Noise", "71", "0.1", "0", "1"
DATA "Breath Noise", "57", "0.1", "0", "1"
DATA "Seashore", "57", "0.1", "0", "1"
DATA "Bird Tweet", "17", "0.1", "0", "1"
DATA "Telephone Ring", "17", "0.01", "0", "1"
DATA "Helicopter", "56", "0", "0", "1"
DATA "Applause", "56", "0", "0", ".1"
DATA "Gunshot", "63", "0.1", "0", "1"

'Drumset-Data:
DATA 10,8,33,56,56,55,10,33,9,33,10,57,64,64,57
DATA 64,33,57,33,33,57,33,57,33,33,64,64,64,64,64
DATA 10,10,33,33,33,33,33,33,33,33,64,64,39,39,65,65

FMIRegs:
DATA 32,64,96,128,224,192

COLOR 7, 0: CLS
SYSTEM

'Error Handler:
FatalError:
RESUME FatalError2:
FatalError2:
COLOR 7, 0: CLS
PRINT "FILE NOT FOUND or FATAL ERROR "

'DEFINT A-Z
SUB DoMIDPlay
   
   X$ = INKEY$:
   IF X$ = CHR$(27) THEN
      SCOLOR 7, 0
      CLS
      IF OutDevice = 4 THEN Finish
      SLEEP 1
      IF OutDevice = 1 THEN StopPlay -1
      IF OutDevice = 2 THEN
	 OUT MPUPort%, &HFF
	 
	 FOR ic% = 0 TO 15
	    FOR J% = 0 TO 120
	       OUT MPUPort%, &H80 + ic%
	       OUT MPUPort%, J%
	       OUT MPUPort%, 0
	    NEXT J%
	 NEXT ic%
      END IF
      END
   END IF

   IF X$ = "-" THEN SpeedIndex& = SpeedIndex& + (SpeedIndex& * .01)
   IF X$ = "=" OR X$ = "+" THEN SpeedIndex& = SpeedIndex& - (SpeedIndex& * .01)
   
   TL = ReadVarLen ' Read the delay until we do anything and delay:
   IF tempo = 0 THEN tempo = 120
   Samples& = 0
   
   IF OutDevice < 4 AND TL > 0 THEN
    Todelay& = SpeedIndex& * (1 / ((tempo / 60) * (rtempo& / TL)) - OverDelay!)
    FOR AA& = 1 TO Todelay&
    NEXT
    OverDelay! = 0
   END IF
  

   IF OutDevice = 4 THEN
   IF TL > 0 THEN Samples& = 22050 / ((tempo / 60) * (rtempo& / TL))

   IF F# > 0 THEN
   Min! = 0
   Min2! = 0

  
   FOR AA& = 1 TO Samples&
     i2! = 0
     FOR AW% = 0 TO 32
      IF TuneTable1(AW%) > 0 THEN
       IF TuneTable2(AW%) = 9 THEN
	i2! = i2! + (((RND * 2) - 1) * ((TuneTable4(AW%) / 6) / Decr(AW%)))
	ELSE
	'SINUS
	IF WaveTable2(TuneTable2(AW%)) = 0 THEN i2! = i2! + (SIN((CurCnt(AW%) / (22050 / 3.141)) * TuneTable1(AW%))) * (((TuneTable4(AW%) / 8) - Decr(AW%)) * InCr(AW%))
	IF WaveTable2(TuneTable2(AW%)) = 1 THEN i2! = i2! + (INT(SIN((((CurCnt(AW%) / (22050 / 3.141))) * TuneTable1(AW%))) + .5) * (((TuneTable4(AW%) / 8) - Decr(AW%))) * InCr(AW%))
	CurCnt(AW%) = CurCnt(AW%) + 1
	IF CurCnt(AW%) > 31415 THEN CurCnt(AW%) = 0
	END IF
	
      END IF
      D! = WaveTable1(VoiceSet(TuneTable2(AW%)))
      IF TuneTable2(AW%) = 9 THEN D! = .0055
      IF Decr(AW%) < (TuneTable4(AW%) / 8) AND D! > 0 THEN Decr(AW%) = Decr(AW%) + (D! / 6)

      IF InCr(AW%) < 1 THEN InCr(AW%) = InCr(AW%) + (WaveTable3(TuneTable2(AW%)) / 500)
      
     NEXT

      IF IsTTS = 1 THEN
       NextVo
       IF Voopen% = 1 THEN N$ = ReadVoice$
       IF N$ <> "" THEN i3! = (ASC(N$) - 128) * 2
      END IF
      
     
      i2! = (i2! + i3!) + 128
      IF i2! < 0 THEN i2! = 0
      IF i2! > 255 THEN i2! = 255
      Buffer = Buffer + CHR$(i2!)
      IF LEN(Buffer) > 1000 THEN WavPlay

     NEXT AA&
   END IF
   END IF
   
   TotalTime! = TotalTime! + TL ' Might be useful for you...
   
   IF TL > 0 THEN
      LOCATE 24, 53: SCOLOR 0, 7
      BT% = ((TotalTime! / (rtempo& / 2) + .5) MOD 8)
      'LOCATE 1, 1: PRINT BT%
      Measure% = ((TotalTime! / rtempo&) / 4 + .5) - 1
      IF BT% = 1 THEN PRINT " Beat 1  ";
      IF BT% = 2 THEN PRINT " Beat 1  ";
      IF BT% = 3 THEN PRINT " Beat 2  ";
      IF BT% = 4 THEN PRINT " Beat 2  ";
      IF BT% = 5 THEN PRINT " Beat 3  ";
      IF BT% = 6 THEN PRINT " Beat 3  ";
      IF BT% = 7 THEN PRINT " Beat 4  ";
      IF BT% = 0 THEN PRINT " Beat 4  ";
      PRINT "Measure"; Measure%;
   END IF
   
   
   IF DlTime + 10 < TotalTime! THEN ' Used to show the volume
      LastVolume% = 0
      DlTime = TotalTime
      FOR V% = 1 TO 16
	 IF DisplayVol(V%) > 0 THEN DisplayVol(V%) = DisplayVol(V%) - 1
		LOCATE V% + 5, 26: SCOLOR 8, 0:
		 PRINT ""
		 LOCATE V% + 5, 26: SCOLOR 1, 0:
		 FOR S% = 1 TO DisplayVol(V%)
		  IF S% > 3 THEN SCOLOR2 9
		  IF S% > 6 THEN SCOLOR2 11
		  IF S% > 8 THEN SCOLOR2 15
		  PRINT "";
		 NEXT S%
		SCOLOR 7, 1
      NEXT V%
   END IF
   
   IF PTime + 20 < TotalTime! THEN   ' Used to show the volume
      PTime = TotalTime
      'Tracker% = Tracker% + 1
      'IF Tracker% = 77 THEN Tracker% = 55: LOCATE 4, 77: scolor 0, 7: PRINT "  "
      'LOCATE 4, Tracker%: scolor 0, 7: PRINT " "
      FOR C% = 1 TO 16
		IF VOL(C%) > 0 OR DisplayVol(C%) > 0 THEN
		 ChHistory(C%) = ChHistory(C%) + ""'""'""'""'""
		ELSE
		 ChHistory(C%) = ChHistory(C%) + " "
		END IF
		ChHistory(C%) = MID$(ChHistory(C%), 2, LEN(ChHistory(C%)) - 1)
		LOCATE C% + 5, 54
		'scolor (c% MOD 6) + 1, 7: PRINT ChHistory(c%)
		'scolor 1, 7
		Iw% = C% MOD 2
		IF Iw% = 0 THEN SCOLOR 1, 7
		IF Iw% = 1 THEN SCOLOR 9, 7
		PRINT ChHistory(C%)
      NEXT
      
      ChHistory(0) = ChHistory(0) + ""
      ChHistory(0) = MID$(ChHistory(0), 2, LEN(ChHistory(0)) - 1)
      LOCATE 5, 54: SCOLOR 0, 7: PRINT ChHistory(0)
      SCOLOR 7, 0
      
   END IF
   
   
   GET 1, , A ' Get the MIDI-command...
   IF A = CHR$(255) THEN '... we have a meta-command!
      GET #1, , A
      SELECT CASE ASC(A)
	'CASE 0:  PRINT "Sequence Number : "; ReadText$
	CASE 1
	 Lyric$ = ReadText$
	 IF Lyric$ <> "" THEN
	  LOCATE 23, 1
	  IF MID$(Lyric$, 1, 1) = "/" OR MID$(Lyric$, 1, 1) = "\" THEN
	   SCOLOR 0, 0: PRINT "                                                                                "; : LyrPos% = 1
	   Lyric$ = MID$(Lyric$, 2, LEN(Lyric$))
	  Lyric$ = " " + Lyric$
	  END IF
	  lyr$ = LTRIM$(RTRIM$(Lyric$)): LyriPos% = 0
	  LOCATE 23, LyrPos%: SCOLOR 15, 1: PRINT Lyric$;
	  LyrPos% = POS(0)
	  LOCATE 24, 1: SCOLOR 0, 7: PRINT " [ESC] Exit  [+] Speed  [-] Speed ";
	 END IF
	 CASE 32: PRINT "MIDI ch. Prefix.. ": A$ = ReadText$: REM <====== What is this ?
	CASE 47:
	StopPlay -1: SCOLOR 7, 0: CLS
	CASE 81: tempo = (60000000 / ReadBPM):
      
	  LOCATE 12, 56: SCOLOR 15, 0: PRINT " Speed change to ";
	  LOCATE 13, 60: SCOLOR 15, 0: PRINT INT(tempo); "bpm ";
	  MID$(ChHistory(0), 21, 1) = "S"
	  LOCATE 25, 1: SCOLOR 15, 1: PRINT INT(tempo); "bpm ";
	CASE 84: PRINT "SMPTE Offset    : "; : t2$ = ReadText$: PRINT ASC(LEFT$(t2$, 1)); " "; ASC(MID$(t2$, 2, 1))
	CASE 88 ' Time signature
	  N$ = ReadTimeSignature$
	  'PRINT n$
	CASE 89 ' Key signature
	  N$ = ReadText$
	CASE 127 'Sequencer-specific Meta Event
	  N$ = ReadText$
	CASE ELSE
	'LOCATE 1, 1: PRINT ASC(a)
	 t2$ = ReadText$ ' Unkown Meta Event
      END SELECT
      ELSE
      
      IF HEX$(ASC(A)) = "F0" OR HEX$(ASC(A)) = "F7" THEN
		t2$ = ReadText$
	 ELSE
	 
	 IF Nibble$(A, 1) = "8" THEN 'Send: Tune Off
		IF PolyPh% > 0 THEN PolyPh% = PolyPh% - 1
		IF PolyPh% < 0 THEN PolyPh% = 0
		Channel% = Nibble2Number(Nibble$(A, 0))
		InLen(Channel%) = 0
		Tune% = NextNumber
		Volume% = NextNumber
		'OPL 3:
	    
		IF OutDevice = 2 THEN
		OUT MPUPort%, &H80 + Channel%
		OUT MPUPort%, Tune%
		OUT MPUPort%, Volume%
		END IF
	    
		N% = 0
		DO: N% = N% + 1
		LOOP UNTIL TuneTable2(N%) = Channel% AND TuneTable3(N%) = Tune% OR N% >= 512
		TuneTable1(N%) = 0

		IF Channel% <> 9 THEN StopPlay (TrackXisOnCH(Channel%, Tune%)): TuneInUse%(Tune%) = 0
		RealVol(TrackXisOnCH(Channel%, Tune%)) = 0
		
		'ChUse(channel%) = ChUse(channel%) - 1
		'IF ChUse(channel%) < 0 THEN ChUse(channel%) = 0
		SCOLOR 0, 7: LOCATE Channel% + 6, 39: PRINT " ": VOL(Channel% + 1) = 0
	 END IF
	 
	 IF Nibble$(A, 1) = "9" THEN 'Send: Tune On
		'LOCATE Channel% + 6, 39 : scolor 15, 7: PRINT CHR$(14)
	    
		Channel% = Nibble2Number(Nibble$(A, 0))
		Tune% = NextNumber
		Volume% = NextNumber

		T# = Tune%
		F# = 440 * (2 ^ ((T# - 9) / 12)) / 32' Convert Tune to frequency.
		F# = F# * 2

		IF Volume% > 10 THEN
		N% = 0
		DO: N% = N% + 1: LOOP UNTIL TuneTable1(N%) = 0
		'LOCATE 1, 1: PRINT N%

		TuneTable1(N%) = F#
		TuneTable2(N%) = Channel%
		TuneTable3(N%) = Tune%

		IF Channel% = TTSChan% - 1 THEN
		 IF Tune% > 74 THEN
		  DO
		   Tune% = Tune% - 13
		  LOOP UNTIL Tune% <= 74
		 END IF
		 IF Tune% < 60 THEN
		  DO
		   Tune% = Tune% + 13
		  LOOP UNTIL Tune% >= 60
		 END IF
		 TTSFreq% = 440 * (2 ^ ((Tune% - 9) / 12)) / 32' Convert Tune to frequency.
		 'LOCA TE 1, 1: PRINT TTSFreq%
		END IF

		TuneTable4(N%) = WaveVolume + (Volume% / 5)
		'TUnetable5(N%) = VoiceSet(Channel% - 3)
		Decr(N%) = 1
		InCr(N%) = 0
	     END IF

		IF OutDevice = 2 THEN
		 OUT MPUPort%, &H90 + Channel%
		 OUT MPUPort%, Tune%
		 OUT MPUPort%, Volume%
		END IF

		IF Volume% > 0 THEN
		 CALL MidiTune(Tune%, Volume%, Channel%)
		 IF Channel% <> 9 THEN TuneInUse%(Tune%) = 1
		 PolyPh% = PolyPh% + 1
		 SCOLOR 0, 7: LOCATE 24, 38: PRINT " Voices:"; PolyPh%; " ";
		 InLen(Channel%) = 40
	    '  ChUse(channel%) = ChUse(channel%) + 1
		 LOCATE Channel% + 5, 26: SCOLOR 8, 0:
		 'PRINT ""
		 LOCATE Channel% + 6, 26: SCOLOR 1, 0:
		 DisplayVol(Channel% + 1) = Volume% / 10
		 FOR S% = 1 TO DisplayVol(Channel% + 1) - 1
		  IF S% > 3 THEN SCOLOR2 9
		  IF S% > 6 THEN SCOLOR2 11
		  IF S% > 8 THEN SCOLOR2 15
		  PRINT "";
		 NEXT S%
		 END IF
		 SCOLOR 11, 7: LOCATE Channel% + 6, 39: PRINT CHR$(14): SCOLOR 0, 7
	 END IF
	 
	 IF Nibble$(A, 1) = "A" THEN 'Key after-touch
		 Temp = Nibble2Number(Nibble$(A, 0))
		 'Temp = TuneName(NextNumber)
		 Temp = NextNumber
	 END IF
	 
	 IF Nibble$(A, 1) = "B" THEN
		Channel% = Nibble2Number(Nibble$(A, 0))
		Instrmnt% = NextNumber
		NewVal% = NextNumber
	 END IF
	 
	 IF Nibble$(A, 1) = "C" THEN ' Change voice
		Channel% = Nibble2Number(Nibble$(A, 0))
		Instrmnt% = NextNumber
	    
		 IF OutDevice = 2 THEN
		 OUT MPUPort%, &HC0 + Channel%
		 OUT MPUPort%, Instrmnt%
		 END IF
	    
		 LOCATE Channel% + 6, 1
		 LOCATE , 1
		 SCOLOR 0, 7
		 PRINT "    empty              VOICE CHANGE         ";
		 IF Channel% <> 10 - 1 THEN SCOLOR 1, 7: LOCATE , 5: PRINT Instrname(Instrmnt%); " ";
		 IF Channel% = 10 - 1 THEN SCOLOR 1, 7: LOCATE , 5: PRINT "General MIDI Drumset";
		 VoiceSet(Channel%) = voicetab(Instrmnt%) + 3
		 LOCATE Channel% + 6, 1: SCOLOR 0, 7: PRINT Channel% + 1;
		 SCOLOR 8, 7: LOCATE , 40: PRINT Instrument(VoiceSet(Channel%)).ChName
		 SCOLOR 0, 7
		 MID$(ChHistory(0), 21, 1) = "V"
	 END IF
	 
	 
	 IF Nibble$(A, 1) = "D" THEN ' <- ???
	    Temp = Nibble2Number(Nibble$(A, 0))
	    Temp = NextNumber
	 END IF
	 
	 IF Nibble$(A, 1) = "E" THEN 'Pitch wheel change
	    wchannel% = Nibble2Number(Nibble$(A, 0))
	    Bottom% = NextNumber
	    Top% = NextNumber
	 END IF
	 
      END IF
   END IF
   
END SUB

SUB Drum
   ' Generates a "drum-sound" for the speaker.
      FOR H& = 1 TO 150
      X = INT(RND * 2)
      FOR N& = 1 TO (SpeedIndex& / 15000): NEXT
	 IF X = 0 THEN OUT 97, 1
	 IF X = 1 THEN OUT 97, 2
      NEXT
END SUB

DEFINT A-Z
SUB Finish
      CLS
      PRINT "Finishing ..."
      PRINT "Creating PCM wave (with header) ... ";

      CLOSE
      OPEN "TEMP.WAV" FOR BINARY AS #1
      OPEN "OUT.WAV" FOR OUTPUT AS #2

      LNTH& = LOF(1)
      WHeader$ = ""
      WHeader$ = WHeader$ + "RIFF" + MKL$(LOF(1) + 36) + "WAVE"
      WHeader$ = WHeader$ + "fmt" + CHR$(&H20) + CHR$(&H10) + CHR$(0) + CHR$(0) + CHR$(0) + CHR$(1) + CHR$(0) + CHR$(1) + CHR$(0)
      WHeader$ = WHeader$ + MKL$(22050) + MKL$(22050) + MKI$(1) + MKI$(8)
      WHeader$ = WHeader$ + "data" + MKL$(LOF(1))
      PRINT #2, WHeader$;

      DO
	 LNTH& = LNTH& - 1024
	 IF NOT EOF(1) THEN SS$ = INPUT$(1024, #1)
	 IF NOT EOF(1) THEN PRINT #2, SS$;
      LOOP UNTIL EOF(1) OR LNTH& < 1024

      DO
	 IF NOT EOF(1) THEN SS$ = INPUT$(1, #1)
	 IF NOT EOF(1) THEN PRINT #2, SS$;
      LOOP UNTIL EOF(1)

      CLOSE

      KILL "TEMP.WAV"
      CLS : PRINT "Done! OUT.WAV created."
      SYSTEM

END SUB

DEFSNG A-Z
'DEFINT A-Z
SUB InitMIDI
   
   CLS : SCOLOR 15, 1
   PRINT
   PRINT
   LOCATE , 10: PRINT "                                                          "
   LOCATE , 10: PRINT "                       "
   LOCATE , 10: PRINT "                                      "
   LOCATE , 10: PRINT "                               "
   LOCATE , 10: PRINT "                                  "
   LOCATE , 10: PRINT "                 "
   LOCATE , 10: PRINT "                                                    3.00  "
   LOCATE , 10: PRINT "            Copyright 2002 (C) Sebastian Mate             "
   LOCATE , 10: PRINT "                                                          "
   PRINT : PRINT
   SCOLOR 15, 0
   PRINT "                            L O A D I N G   . . ."
   PRINT "                     (calibrating the meta-delay timer)"
   
   
   ' Detect the PC's speed. We have to perform very short delays which only
   ' can be done with FOR ... NEXT loops.
   Where& = 100
   DO
    Z! = TIMER
    Where& = Where& * 2
    FOR AA& = 1 TO Where&
    NEXT AA&
    II! = TIMER - Z!
   LOOP UNTIL II! > .5

   SpeedIndex& = Where& / II!
   
   ' Read the sound-file:
   OPEN "INSTDATA.FMI" FOR BINARY ACCESS READ AS #1
   DBID$ = STRING$(14, 0)
   GET #1, , DBID$
   IF DBID$ <> "FMTInstruments" THEN PRINT "Invalid FMT instrument file!": SCOLOR 7, 0: END
   DBVer$ = STRING$(2, 0)
   GET #1, , DBVer$
   IF DBVer$ <> CHR$(1) + CHR$(0) THEN PRINT "Not version 1.0 instrument file!": SCOLOR 7, 0: END
   DBName$ = STRING$(20, 0)
   GET #1, , DBName$
   X$ = CHR$(0)
   GET #1, , X$
   insts% = ASC(X$) + 1
   CLS
   FOR N% = 1 TO insts%
      GET #1, , Instrument(N%).ChName
   NEXT N%
   FOR N% = 1 TO insts%
      GET #1, , Instrument(N%).ChSett
   NEXT N%
   CLOSE #1
   
   ResetFM
   
   FOR C% = 1 TO 16
      ChHistory(C%) = "                    "
   NEXT
   ChHistory(0) = ""
   
   Tracker% = 65
   PPOS = 39
   XPOS = 1
   
   
   'Resets the card and initializes the extensions
   IF OutDevice = 1 THEN
   FOR q% = 1 TO &HF5
      CALL WriteReg(q%, 0)
   NEXT q%
   FOR q% = 1 TO &HF5
      CALL WriteReg2(q%, 0)
   NEXT q%
   END IF

   IF OutDevice = 2 THEN
   CALL WriteReg2(5, 1) 'Initializes OPL3 extensions
   CALL WriteReg(1, 32) 'Initializes Waveform extensions
   END IF

   ' Draw Screen:
   SCOLOR 7, 0: CLS
   SCOLOR 15, 1: LOCATE 1, 1: PRINT " RealMIDI Sequencer version 3.00                                                "
   SCOLOR 7, 0: PRINT " "'                   OPL3 routines by ??? (please contact me!)"
   SCOLOR 0, 7
   PRINT "";
   PRINT " TR VOICE               VOLUME      OUTPUT   CH  TRACK HISTORY             ";
   PRINT "";
   FOR X = 1 TO 16
      SCOLOR 0, 7
      PRINT "    empty     VOICE CHANGE         ";
      LOCATE , 1
      PRINT X;
      LOCATE , 26: SCOLOR 8, 0:
      PRINT ""
   NEXT
   LOCATE 22, 1: SCOLOR 0, 7: PRINT "";
   LOCATE 23, 1: SCOLOR 15, 0: PRINT " No Lyrics."
   LOCATE 24, 1: SCOLOR 0, 7: PRINT " [ESC] Exit  [+] Speed  [-] Speed ";
   LOCATE 25, 1: SCOLOR 0, 1: PRINT "                                             Copyright (C) 2002 Sebastian Mate ";
   
   ' Read the General-MIDI names and translation for the sound-database.
   ' The sound-database does not contain all 127 General-MIDI sounds.
   
   FOR I = 0 TO 127
      READ Instrname(I)
      READ N$: voicetab(I) = VAL(N$)
      READ N$: WaveTable1(I) = VAL(N$) 'Decay
      READ N$: WaveTable2(I) = VAL(N$) 'WaveForm
      IF WaveVolume > 110 THEN WaveTable2(I) = 1
      READ N$: WaveTable3(I) = VAL(N$) 'Attack
   NEXT I

   FOR I = 35 TO 81
      READ DrumTab%
      DrumSetUp(I) = DrumTab%
   NEXT I
   
   ' Open and start playing the MIDI-file:
   LyrPos% = 1
   IF INSTR(FILE$, ".") = 0 THEN FILE$ = FILE$ + ".MID"
   OPEN FILE$ FOR BINARY AS #1
   GET 1, , header
   IF header <> "MThd" THEN CLS : PRINT "Not a valid MIDI file. (See documentation!)": COLOR 7, 0: CLS : END
   GET 1, , VierByte
   GET 1, , FileType
   IF ASC(RIGHT$(FileType, 1)) = 0 THEN
      ELSE
      SCOLOR 15, 0: CLS : PRINT "Multy tracks, this file type is not supported. (See documentation!) ": COLOR 7, 0: CLS : END
   END IF
   Tracks = ReadTwoBytes
   LOCATE 25, 1: SCOLOR 15, 1
   rtempo& = ReadTwoBytes: tempo = rtempo&
   PRINT rtempo&; "bpm";
   GET 1, , header
   TrkLengte = ReadFourBytes + LOC(1)

END SUB

DEFINT A-Z
SUB MidiTune (Tune%, Volume%, Channel%)
   'Plays a Tune
   
   IF OutDevice = 1 THEN
    SetInstruments
    IF notune% = 1 THEN EXIT SUB
   END IF

   VOL(Channel% + 1) = Volume% / 10
   
   T# = Tune%: oct# = 5
   IF Tune% >= 84 THEN
      DO
	 T# = T# - 12: oct# = oct# + 1
      LOOP UNTIL T# < 84
   END IF
   
   F# = 440 * (2 ^ ((T# - 9) / 12)) / 32' Convert Tune to frequency.

   'fraser# = (RND * 3) - 2
   'f# = f# + fraser#
   
   IF OutDevice = 1 THEN
      
      TrackXisOnCH(Channel%, Tune%) = chan%
      S# = (INT(F# / 256))
      'PAN% = INT(RND * 2) + 1
      PAN% = (Channel% MOD 3) + 1
      IF Channel% = 9 THEN PAN% = 3
      C0% = ASC(MID$(Inst$, 11, 1)) 'OR 48
      
      IF chan% > 8 THEN
	 CALL WriteReg2(&HC0 + chan% - 9, (C0% AND 207) OR (PAN% * 16))
	 CALL WriteReg2(&HA0 + chan% - 9, F# AND 255)
	 CALL WriteReg2(&HB0 + chan% - 9, INT(F# / 256) OR 32 OR (oct# * 4))
	 ELSE
	 CALL WriteReg(&HC0 + chan%, (C0% AND 207) OR (PAN% * 16))
	 CALL WriteReg(&HA0 + chan%, F# AND 255)
	 CALL WriteReg(&HB0 + chan%, INT(F# / 256) OR 32 OR (oct# * 4))
      END IF
   END IF
   
   IF OutDevice = 3 AND F# > 36 THEN
      IF Channel% = DrumSet% - 1 THEN SOUND 2000, .2'drum
      IF Channel% <> DrumSet% - 1 THEN
       IF PolyPh% = 7 OR PolyPh% = 14 THEN SOUND 0, 0
       SOUND F#, .4
       OverDelay! = OverDelay + (.4 / 18)
      END IF
   END IF
   
   
   
END SUB

DEFSNG A-Z
FUNCTION NextNumber
   GET #1, , A
NextNumber = ASC(A)
END FUNCTION

DEFINT A-Z
SUB NextVo

'Convert the TTS to wave
'Source mainly based on HVSS!

IF lyr$ = "" THEN EXIT SUB

Voopen% = 1
CLOSE #5
reads! = 0: xptr! = 0

OPEN "Text.TMP" FOR OUTPUT AS #7
PRINT #7, lyr$
CLOSE #7

lyr$ = ""

OPEN "Text.TMP" FOR INPUT AS #7
OPEN "tts.wav" FOR OUTPUT AS #10

DO

  Out$ = ""
  DO

NewWord:

  Wrd$ = ""

  DO

   DO

' =============================== WORD-IN ==================================

     ' This part of the program reads the text-file and gets the words. If
     ' required, this part will convert a number to text with the
     ' Number2Text function. Can be compared eyes that read a text.

     IF NUMBER% = 0 AND NOT EOF(7) THEN A$ = INPUT$(1, #7)

     IF EOF(7) THEN GOTO Ende:

     'IF ASC(A$) <> 10 AND NUMBER% = 0 THEN LOCATE 2, 1: PRINT A$; "      "
     IF ASC(A$) >= 65 AND ASC(A$) < 122 OR A$ = "!" OR A$ = "?" OR A$ = "," OR A$ = "." OR A$ = ";" THEN
      IF ASC(A$) < 91 OR ASC(A$) > 96 THEN Wrd$ = Wrd$ + A$
     END IF
   LOOP UNTIL ASC(A$) < 65 OR ASC(A$) > 122
   LAST$ = A$

  Wrd$ = LTRIM$(RTRIM$(Wrd$))
  
  LOOP UNTIL Wrd$ <> ""
  Wrd$ = UCASE$(Wrd$)

' =============================== WORD-TO-PHONEMS ===========================

  ' This routine finds out how to speak the word, that means it converts
  ' the word to its phonems by a database look-up (here it uses the CMU-
  ' phonetic dictionairy, see README).

'((
  IF LEN(Wrd$) = 1 AND Wrd$ = "." OR Wrd$ = "!" OR Wrd$ = "?" OR Wrd$ = "," OR Wrd$ = ";" THEN GOTO NewWord:
  ENDING$ = MID$(Wrd$, LEN(Wrd$), 1)

  IF ENDING$ = "!" OR ENDING$ = ":" OR ENDING$ = "?" OR ENDING$ = "," OR ENDING$ = "." OR ENDING$ = ";" THEN
   Wrd$ = MID$(Wrd$, 1, LEN(Wrd$) - 1)
  ELSE
   ENDING$ = ""
  END IF                                      ' )) Currently not supported because of DSP



  ' Open the correct DAT-file which contains the word...
  IF LEN(Wrd$) > 1 THEN OPEN TTSPath$ + "\DICT\" + MID$(Wrd$, 1, 1) + "\" + MID$(Wrd$, 2, 1) + ".DAT" FOR INPUT AS #8
  IF LEN(Wrd$) = 1 THEN OPEN TTSPath$ + "\DICT\" + MID$(Wrd$, 1, 1) + ".DAT" FOR INPUT AS #8

    '... and search it.
    DO
     IF NOT EOF(8) THEN LINE INPUT #8, B$
    LOOP UNTIL EOF(8) OR MID$(B$, 1, LEN(Wrd$)) = Wrd$
    'PRINT WRD$, B$

    IF MID$(B$, 1, INSTR(B$, " ") - 1) <> Wrd$ THEN

     Letters% = LEN(Wrd$)

     cn% = 0: done$ = "": cnt% = 0

     DO
      N$ = MID$(B$, INSTR(B$, " ") + cn% + 2, 1)
      IF N$ = " " THEN cnt% = cnt% + 1
      done$ = done$ + N$
      cn% = cn% + 1
     LOOP UNTIL cnt% = Letters% OR INSTR(B$, " ") + cn% + 2 > LEN(B$)

     'LOCATE 3, 1: PRINT done$
     B$ = Wrd$ + "  " + done$

    END IF
    
    IF NOT EOF(8) THEN Out$ = B$ ' Not EOF: word found in database!

    
  CLOSE #8


 LOOP UNTIL Out$ <> ""

 ' And here's the phonetic string with all phonems of our word:
 Vocal$ = MID$(Out$, LEN(Wrd$) + 3, LEN(Out$) - LEN(Wrd$) - 1)


 SCOLOR 15, 0: LOCATE 2, 1: PRINT "TTS: "; Vocal$; "                   "

' =============================== PHONEMS-TO-WAVE ===========================
  ' The rest of the program just plays the phonems as described in the
  ' Vocal$-varible.

 S% = 1
 DO

   'Get next phonem-name (which is also the name of the wave-file):
   PHONEM$ = ""
   DO
    A$ = MID$(Vocal$, S%, 1)
    S% = S% + 1
    IF A$ <> "1" AND A$ <> "2" AND A$ <> "0" AND A$ <> " " THEN PHONEM$ = PHONEM$ + A$
   LOOP UNTIL A$ = "1" OR A$ = "2" OR A$ = "0" OR A$ = " " OR S% > LEN(Vocal$)

   ' Is there any stress on that sound?
   STRESS$ = "": IF A$ = "1" THEN STRESS$ = "1"
   IF A$ = "2" THEN STRESS$ = "2"

   IF PHONEM$ <> "" THEN

     IF AP% = 1 THEN ' For word's like "It's", "don't", "doesn't", etc.
      IF UCASE$(Wrd$) = "T" THEN PHONEM$ = "T"
      IF UCASE$(Wrd$) = "S" THEN PHONEM$ = "S"
     END IF

     ' Open the wave file, ...
     OPEN TTSPath$ + "\WAVE\" + STRESS$ + PHONEM$ + ".WAV" FOR BINARY AS #9

     ' ... get the part of it we want (SPEEDUP!), ...
     Size% = LOF(9) - 44
     REMSPDUP% = (Size% / 3)
     Size% = Size% - REMSPDUP%
     Temp$ = INPUT$(44 + REMSPDUP%, #9)

     DO

       ' ... add it to our "work-buffer" if there's enouth free space in it ...
       IF LEN(WaveBuffer1) + Size% <= 22050 THEN
	IF NOT EOF(9) THEN IN$ = INPUT$(Size%, #9)
	WaveBuffer1$ = WaveBuffer1$ + IN$
       END IF

       ' ... or play it (the buffer) if not.
       IF LEN(WaveBuffer1$) + Size% > 1000 THEN
	 PRINT #10, WaveBuffer1$;
	 WaveBuffer1$ = ""
       END IF

     LOOP UNTIL EOF(9)

   END IF

N:

    CLOSE #9
    IF AP% = 1 THEN AP% = 0: GOTO NewWord:


 LOOP UNTIL S% > LEN(Vocal$) ' Next word


 IF LAST$ = CHR$(39) THEN AP% = 1

LOOP WHILE NOT EOF(1)

Ende:
CLOSE #7
CLOSE #10

OPEN "TTS.WAV" FOR BINARY AS #5: Voopen% = 1


lyr$ = ""
EXIT SUB

END SUB

DEFSNG A-Z
FUNCTION Nibble$ (Cr$, Lr)
   ' A Nibble are 4 Bit or a half byte. Strange name!
   
   IF Lr = 1 THEN
      Nibble$ = LEFT$(HEX$(ASC(Cr$) AND 240), 1)
      ELSE
      Nibble$ = RIGHT$(HEX$(ASC(Cr$) AND 15), 1)
   END IF
END FUNCTION

FUNCTION Nibble2Number (ch$)
   SELECT CASE ch$
   CASE "0": Nibble2Number = 0
   CASE "1": Nibble2Number = 1
   CASE "2": Nibble2Number = 2
   CASE "3": Nibble2Number = 3
   CASE "4": Nibble2Number = 4
   CASE "5": Nibble2Number = 5
   CASE "6": Nibble2Number = 6
   CASE "7": Nibble2Number = 7
   CASE "8": Nibble2Number = 8
   CASE "9": Nibble2Number = 9
   CASE "A": Nibble2Number = 10
   CASE "B": Nibble2Number = 11
   CASE "C": Nibble2Number = 12
   CASE "D": Nibble2Number = 13
   CASE "E": Nibble2Number = 14
   CASE "F": Nibble2Number = 15
   END SELECT
END FUNCTION

FUNCTION ReadBPM
   DIM Temp AS LONG
   GET #1, , A
   IF A = CHR$(3) THEN
      FOR I = 1 TO 3
	 GET #1, , A
	 Temp = (Temp * 256) + ASC(A)
      NEXT I
   END IF
   ReadBPM = Temp
END FUNCTION

FUNCTION ReadFourBytes
   GET #1, , A
   T = ASC(A) * 2 ^ 8
   GET #1, , A
   T = (ASC(A) + T) * 2 ^ 8
   GET #1, , A
   T = (ASC(A) + T) * 2 ^ 8
   GET #1, , A
   ReadFourBytes = T + ASC(A)
END FUNCTION

FUNCTION ReadText$
   Lengte = ReadVarLen
   FOR tt = 1 TO Lengte
      GET #1, , A
      Temp$ = Temp$ + A
   NEXT tt
   ReadText$ = Temp$
END FUNCTION

FUNCTION ReadTimeSignature$
   
   GET 1, , A
   GET 1, , A: t1 = ASC(A)
   GET 1, , A: t2 = ASC(A)
   GET 1, , A
   GET 1, , A
   
   ReadTimeSignature$ = STR$(t1) + " /" + STR$(2 ^ t2)
   
END FUNCTION

FUNCTION ReadTwoBytes
   GET #1, , A
   T = ASC(A) * 2 ^ 8
   GET #1, , A
   ReadTwoBytes = T + ASC(A)
END FUNCTION

FUNCTION ReadVarLen
   GET #1, , A
   Value = ASC(A)
   IF (Value AND 128) THEN
      Value = (Value AND 127)
      DO
	 GET #1, , A
	 Value2 = ASC(A)
	 Value = (Value * (2 ^ 7)) + (Value2 AND 127)
      LOOP WHILE (Value2 AND 128)
   END IF
   ReadVarLen = Value
END FUNCTION

DEFINT A-Z
FUNCTION ReadVoice$

RT% = 0: AddRem% = 0

Freq% = TTSFreq%

xStep! = Freq% / 350
xptr! = xptr! + xStep!

IF reads! < xptr! THEN
DO
 N$ = INPUT$(1, #5)
 reads! = reads! + 1
LOOP UNTIL reads! >= xptr!
END IF

'reads! = reads! - INT(xptr!)
'LOCATE 1, 1: PRINT xptr!

IF xptr! > 30000 THEN xptr! = 0
IF reads! > 30000 THEN reads! = 0

ReadVoice$ = N$

END FUNCTION

DEFSNG A-Z
SUB ResetFM
   FOR N% = 0 TO &HF5
      WriteReg N%, 0
   NEXT N%
END SUB

DEFINT A-Z
SUB SCOLOR (AA%, BB%)
COLOR AA%, BB%
END SUB

SUB SCOLOR2 (AA%)
COLOR AA%
END SUB

SUB SetInstruments
   
   ' Searches a free FM-channel (0-18) and sets the instrument.

   chan% = Channel%
   
   MaXChannels% = 17
   
   notune% = 0
   
   FOR an% = 0 TO MaXChannels% ' Detect, if the channel is free.
      IF RealVol(an%) = 0 THEN chan% = an%: GOTO selected:
   NEXT an%
   
   ' Detect, if the same tune is already playing at the current volume:
   SetVol% = Volume%
   FOR LowVol% = 0 TO SetVol% ' If no free channel, "kill" one.
      FOR an% = 1 TO MaXChannels%
	 IF Volume% > VOL(an%) AND VOL(an%) < SetVol% AND TuneInUse(Tune%) > 0 THEN
	    chan% = an%
	    GOTO selected:
	 END IF
      NEXT
   NEXT
   
   SetVol% = Volume%
   FOR LowVol% = 0 TO SetVol% ' If no free channel, "kill" one.
      FOR an% = 1 TO MaXChannels%
	 IF Volume% > RealVol(an%) AND RealVol(an%) <= SetVol% THEN
	    chan% = an%
	    GOTO selected:
	 END IF
      NEXT
   NEXT
   
   notune% = 1: EXIT SUB

selected:
   
   StopPlay chan%
   
   '  WriteReg &HA0 + Chan%, 0
   '  WriteReg &HB0 + Chan%, 0
   RealVol(chan%) = Volume%
   
   Inst$ = Instrument(VoiceSet(Channel%)).ChSett
   '  LOCATE channel% + 6, 40: scolor 15, 7: PRINT Instrument(voiceset(channel%)).ChName
   
   SCOLOR 8, 7
   
   IF Channel% = DrumSet% - 1 THEN
      Inst$ = Instrument(DrumSetUp(Tune%) + 3).ChSett: LOCATE Channel% + 6, 40: PRINT Instrument(DrumSetUp(Tune%) + 3).ChName
      IF Tune% < 35 OR Tune% > 81 THEN Inst$ = Instrument(55 + 3).ChSett: SCOLOR 8, 7: LOCATE Channel% + 6, 40: PRINT Instrument(33 + 3).ChName
ok2:
   END IF
   
   LOCATE Channel% + 6, 49: PRINT chan%
   
   RESTORE FMIRegs
   '  ChanX% = ((Chan% MOD 3) + 8 * INT(Chan% / 3))
   '  FOR N% = 1 TO 11
   '   IF N% AND 1 THEN READ Reg% ELSE Reg% = Reg% + 3
   '   IF N% = 11 THEN WReg% = Reg% + Chan% ELSE WReg% = Reg% + ChanX%
   '  WriteReg WReg%, ASC(MID$(Inst$, N%, 1))
   '  NEXT N%
   
   'Exactly as SetInst, but uses RealMidi-style instrument info
   
   INSTINFO$ = Inst$
   
   'Chan% = channel%
   
   tempchan% = chan%
   'volume% = 30
   
   ovol% = ((Volume% * .5) + 63) / 2
   ovol% = -ovol% + 63
   
   IF chan% > 8 THEN
      chan% = chan% - 9
      ChanX% = (chan% MOD 3) + 8 * INT(chan% / 3)
      CALL WriteReg2(&H20 + ChanX%, ASC(MID$(INSTINFO$, 1, 1)))
      CALL WriteReg2(&H40 + ChanX%, ASC(MID$(INSTINFO$, 3, 1)))
      CALL WriteReg2(&H60 + ChanX%, ASC(MID$(INSTINFO$, 5, 1)))
      CALL WriteReg2(&H80 + ChanX%, ASC(MID$(INSTINFO$, 7, 1)))
      CALL WriteReg2(&H23 + ChanX%, ASC(MID$(INSTINFO$, 2, 1)))
      CALL WriteReg2(&H43 + ChanX%, ovol%)'ASC(MID$(INSTINFO$, 4, 1)))
      CALL WriteReg2(&H63 + ChanX%, ASC(MID$(INSTINFO$, 6, 1)))
      CALL WriteReg2(&H83 + ChanX%, ASC(MID$(INSTINFO$, 8, 1)))
      CALL WriteReg2(&HC0 + chan%, ASC(MID$(INSTINFO$, 11, 1)) OR 48)
      CALL WriteReg2(&HE0 + ChanX%, ASC(MID$(INSTINFO$, 9, 1)))
      CALL WriteReg2(&HE3 + ChanX%, ASC(MID$(INSTINFO$, 10, 1)))
      ELSE
      ChanX% = (chan% MOD 3) + 8 * INT(chan% / 3)
      CALL WriteReg(&H20 + ChanX%, ASC(MID$(INSTINFO$, 1, 1)))
      CALL WriteReg(&H40 + ChanX%, ASC(MID$(INSTINFO$, 3, 1)))
      CALL WriteReg(&H60 + ChanX%, ASC(MID$(INSTINFO$, 5, 1)))
      CALL WriteReg(&H80 + ChanX%, ASC(MID$(INSTINFO$, 7, 1)))
      CALL WriteReg(&H23 + ChanX%, ASC(MID$(INSTINFO$, 2, 1)))
      CALL WriteReg(&H43 + ChanX%, ovol%)'ASC(MID$(INSTINFO$, 4, 1)))
      CALL WriteReg(&H63 + ChanX%, ASC(MID$(INSTINFO$, 6, 1)))
      CALL WriteReg(&H83 + ChanX%, ASC(MID$(INSTINFO$, 8, 1)))
      CALL WriteReg(&HC0 + chan%, ASC(MID$(INSTINFO$, 11, 1)) OR 48)
      CALL WriteReg(&HE0 + ChanX%, ASC(MID$(INSTINFO$, 9, 1)))
      CALL WriteReg(&HE3 + ChanX%, ASC(MID$(INSTINFO$, 10, 1)))
   END IF
   
   chan% = tempchan%
   
END SUB

SUB StopPlay (Channel%)
   IF Channel% = -1 THEN
      FOR E% = 0 TO 17
	 CALL StopPlay(E%)
      NEXT E%
      ELSE
      IF Channel% > 8 THEN
	 CALL WriteReg2(&HA0 + Channel% - 9, &H0) 'Makes sure no extra sound is left playing
	 CALL WriteReg2(&HB0 + Channel% - 9, &H0) 'Makes sure no extra sound is left playing
	 ELSE
	 CALL WriteReg(&HA0 + Channel%, &H0) 'Makes sure no extra sound is left playing
	 CALL WriteReg(&HB0 + Channel%, &H0) 'Makes sure no extra sound is left playing
      END IF
   END IF
   
END SUB

SUB WavPlay
 PRINT #3, Buffer;
 Buffer = ""
END SUB

DEFSNG A-Z
SUB WriteReg (Reg%, info%)
   
   OUT BPort% + 8, Reg%
  
   FOR D = 1 TO 5
      X = INP(&H388)
   NEXT D
  
   OUT BPort% + 9, info%
  
   FOR D = 1 TO 24
      X = INP(&H388)
   NEXT D
   
END SUB

DEFINT A-Z
SUB WriteReg2 (Reg%, Value%) 'Write to register set #1
   
   
   OUT BPort% + 2, Reg%     'OPL3 won't need any delay
  
   FOR D = 1 TO 5
      X = INP(&H388)
   NEXT D
   
   FOR D = 1 TO 24
      X = INP(&H388)
   NEXT D
   
   OUT BPort% + 3, Value%
END SUB

