/*  LPTransfer.c  -- (header functions)

Copyright (C) 2003 Ronchi Alessandro

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For support and all you can need from Autors you can contact them at the url
of the project:
http://lptransfer.sourceforge.net
or by email address:
onoma@katamail.com
Any bug report will be appreciated.

Program and relative documentation written by
Ronchi Alessandro, Boschi Alessandro, Scozzoli Angelo

*/

  /* The possible address for a parallel port are:
     0x3bc - 0x3bf
     0x378 - 0x37f  (usually used for LPT1)
     0x278 - 0x27f  (usually used for LPT2)
     When a computer is turned on, the BIOS check what parallel ports it has on the motherboard and it assigns the names LPT1, LPT2, LPT3.
     That names are assigned with order, from the first hexadecimal address to arrive at the last of the list. */

#ifdef __WATCOMC__
#include <conio.h>
#define inb inp
#define outb outp
#endif

  /* Here you must insert the address of the port you want to use. */
#define BASEPORT 0x378
  int character, start, i, full, c2;
char invio, c, c1, arrivo, supporto, *sourcepath, *destpath;
unsigned long timer, timerc;
static unsigned long crc_table[256];

struct options {
  int is_pc_host;
  /* If this var is setted to 1 it will send the file from this pc, otherwise this pc
     will wait to receive the files from the other side of the cable */
};

struct options opt = {1};
/* ^ I Declare the var opt as a struct and in the meantime I initialize it to standards
   value, so the user doesn't want to insert in the command line the options will use the
   standard ones */


/* fsize prints the dimension of the file "name" */
int fsize(char *sourcepath) {
  struct stat stbuf;
  /* This struct is defined in the file <sys/stat.h and contains all the file details, such as the
     file dimension expressed in characters, the one we need. */
  if (stat(sourcepath, &stbuf) == -1)
    {
      fprintf(stderr, "Error: Impossible to open %s to find his dimension\n", sourcepath);
      exit(1);
      return 0;
    }
  return stbuf.st_size;
}

/* This function sends a char after it has divided it in two parts, because we can send only for bits in one time. The var called "supporto" is used only for sincronizing the two pc (the values of that var are random and they uses the fifth bit) */
void send(int character) {
  if (character < 256)
    {
      c=(character&0x0F);    /* It takes the 4 right bits */
      outb(c, BASEPORT);     /* It send the first 4 bits   */
      arrivo =inb(BASEPORT+1);

      supporto=(arrivo&0x80)>>3;
      timer=(clock()/1000000);
      while (supporto!=16)
	{
	  timerc=(clock()/1000000);
	  if ((timerc-timer)>20)                    /*se per troppo tempo il pc non riceve informazini dal secondo pc si disconnette*/
	    {
	      fprintf(stderr, "Error: Transmission is blocked, maybe dued to disconnection of the port\n");
	      exit(1);
	    }
	  outb(c, BASEPORT);
	  arrivo =inb (BASEPORT+1);
	  supporto=(arrivo&0x80)>>3;
	}
      arrivo =inb (BASEPORT+1);
      supporto=(arrivo&0x80)>>3;
      c=(character&0xF0)>>4;               /* This takes the left 4 bits*/
      c=c+0x10;
      outb(c, BASEPORT);                 /* This takes the right 4 bits*/
      timer=(clock()/1000000);
      while (supporto!=0)
	{
	  timerc=(clock()/1000000);
	  if ((timerc-timer)>20)             /*se per troppo tempo il pc non riceve informazioni dal secondo pc si disconnette*/
	    {
	      fprintf(stderr, "Error: Transmission is blocked, maybe dued to disconnection of the port\n");
	      exit(1);
	    }

	  outb(c, BASEPORT);
	  arrivo =inb (BASEPORT+1);
	  supporto=(arrivo&0x80)>>3;

	}
    }
  else /* (if the char is a bad integer, >256 */
    {
      fprintf(stderr, "Error: Found a non ASCII character in the file.\n");
      exit(1);
    }
}

/* This function is the correspondent of the expedition one and receive a char divided in two nibbles. */
int receive_data(void) {
  full=1;
  arrivo =inb (BASEPORT+1);
  supporto=(arrivo&0x80)>>3;
  timer=(clock()/1000000);
  while (supporto==0)
    {
      timerc=(clock()/1000000);
      if ((timerc-timer)>20)
	{
	  fprintf(stderr, "Error: Transmission is blocked, maybe dued to disconnection of the port\n");
	  exit(1);
	}
      arrivo = inb (BASEPORT+1);
      supporto= (arrivo&0x80)>>3;
    }
  c1 = inb(BASEPORT+1);     /* Receive the less significative four bits and sends a zero to request the expedition of the other 4 bits. */
  c2= (c1&0x7F)>>3;
  full=c2;
  outb(0,BASEPORT);
  arrivo =inb (BASEPORT+1);
  supporto=(arrivo&0x80)>>3;
  timer=(clock()/1000000);
  while (supporto==16)
    {
      timerc=(clock()/1000000);
      if ((timerc-timer)>20)
	{
          fprintf(stderr, "Error: Transmission is blocked, maybe dued to disconnection of the port\n");
	  exit(1);
	}

      arrivo =inb (BASEPORT+1);
      supporto=(arrivo&0x80)>>3;
    }
  c1 = inb(BASEPORT+1);
  c2=(c1&0x78)<<1;
  full+=c2;
  outb(16,BASEPORT);
  return full;
}

/* This build the table to calculate the CRC error control */
static void crc32_init(void) {
  unsigned long crc, poly;
  int x, y;   poly = 0xEDB88320L;
  for (x = 0; x < 256; x++)
    {
      crc = x;
      for (y = 8; y > 0; y--)
	{
	  if (crc & 1)
	    crc = (crc >> 1) ^ poly;
	  else
	    crc >>= 1;
	}
      crc_table[x] = crc;
    }
}

/* This function sends a long integer */
void sendint(unsigned long tosend) {
  character=(tosend&0x000000ff)>>(0);
  send(character);
  character=(tosend&0x0000ffff)>>(8);
  send(character);
  character=(tosend&0x00ffffff)>>(16);
  send(character);
  character=(tosend&0xffffffff)>>(24);
  send(character);
  character=(tosend&0x00000000);
  send(character);
}


void sincronizza() {
  /*la funzione mi mette in grado di sincronizzare i due computer e mi consente di essere sicuro che entrambi
    i programmi siano stati inviati. I valori inviati per questi controlli non hanno un particolare significato,
    ma sono stati scelti in modo da non intralciare l'invio di dati */
  if (opt.is_pc_host == 1)
    {
      i=0;
    }
  else
    {
      i=1;
    }
  invio=24;
  outb(invio,BASEPORT);
  arrivo =inb (BASEPORT+1);
  supporto=(arrivo&0xF8)>>3;
  timer=(clock()/1000000);
  while ((supporto!=8) && (supporto!=9)&& (supporto!=10))
    {
      timerc=(clock()/1000000);
      if (((timerc-timer)>20) && start==0)
	{
	  fprintf(stderr, "Error: Transmission is blocked, maybe dued to disconnection of the port\n");
	  exit(1);
	}
      arrivo=inb (BASEPORT+1);
      supporto=(arrivo&0xF8)>>3;
    }
  invio=25+i;
  outb(invio,BASEPORT);
  arrivo =inb (BASEPORT+1);
  supporto=(arrivo&0xF8)>>3;
  timer=(clock()/1000000);
  while (supporto!=10+i)
    {
      timerc=(clock()/1000000);
      if (((timerc-timer)>20) && start==0)
	{
	  fprintf(stderr, "Error: Transmission is blocked, maybe dued to disconnection of the port\n");
	  exit(1);
	}
      arrivo =inb (BASEPORT+1);
      supporto=(arrivo&0xF8)>>3;
    }
  invio=27;
  outb(invio,BASEPORT);
  timer=(clock()/1000000);
  while ((supporto!=11) &&(supporto!=12))
    {
      timerc=(clock()/1000000);
      if ((timerc-timer)>20)
	{
	  fprintf(stderr, "Error: Transmission is blocked, maybe dued to disconnection of the port\n");
	  exit(1);
	}
      arrivo =inb (BASEPORT+1);
      supporto=(arrivo&0xF8)>>3;
    }
  invio=28;
  outb(invio,BASEPORT);
  if (opt.is_pc_host == 1)
    {
      timer=(clock()/1000000);
      while (supporto!=12)
	{
	  timerc=(clock()/1000000);
	  if ((timerc-timer)>20)
	    {
	      fprintf(stderr, "Error: Transmission is blocked, maybe dued to disconnection of the port\n");
	      exit(1);
	    }

	  arrivo =inb (BASEPORT+1);
	  supporto=(arrivo&0xF8)>>3;
	}
    }
}

/*il distacco della parallela comporter il termine del programma. Le scelte delle costanti possono sembrare bizzarre
  a prima vista, ma molte di esse sono state allocate in modo di sfruttare al massimo i cinque bit di trasmissione, dei quali  spiegato il
  funzionamento nell'allegato*/


void getarguments( int argc, char **argv){
  char *program_name = argv[0];
  destpath="";
  sourcepath="";
  for (i=1; i<argc ; i++)
    {
      /* This control the arguments given from console */
      if (!(memcmp( argv[i], "--help",6) )) {
	printf ("\
        Usage for the host pc: \"lptlink -s=<SOURCE_DEST> -d=<TARGET_DEST> -h\" (options order is uninteresting)\n\
        Usage for the client pc: \"lptlink -c\"\n\
        or  Usage: \"lptlink --help\" to get this screen\n ", program_name, program_name, program_name);
	exit(0);
      } else

	if ( ! (memcmp( argv[i], "-h", 2) && memcmp( argv[i], "--host", 6) ) ) {
	  opt.is_pc_host = 1;
	  printf("I'm waiting for the connection to the client pc\n");

        }  else

	  if (!(memcmp( argv[i], "-c", 2) && memcmp( argv[i], "--client", 8) )) {
	    opt.is_pc_host = 0;
	    printf("I'm waiting for the connection to the host pc\n");

	  } else

	    if (!(memcmp( argv[i], "-s=", 3) )) {
	      sourcepath=(char *) (memchr( argv[i], '=', 4));
	      sourcepath=sourcepath++;
	      /* printf("Sourcepath is=%s \n", sourcepath); */

	    } else
	      if (!(memcmp( argv[i], "-d=", 3) )) {
	        destpath=(char *) (memchr( argv[i], '=', 4));
		destpath=destpath++;

	      } else


		/* if an argument is invalid */
		{
		  printf("Invalid argument, --help for usage informations\n");
		  exit(1);
		}

    }
}

void controlarguments(){
  /* controls are be grouped in a function for better source reading */

  if ( (opt.is_pc_host==1) && ( sourcepath=="" || destpath== "")) {
    printf("Pc host must declare sourcepath and destpath of the file to be trasfered,\n\
		--help for usage informations\n");
    exit(1);
  }
  if ((opt.is_pc_host != 1 ) && (opt.is_pc_host != 0)) {
    printf("This program can be used only as host or client, other options are not permitted\n\
		--help for usage informations\n");
    exit(1);
  }

}
