/*  LPTransfer.c  -- (main routines)

Copyright (C) 2003 Ronchi Alessandro

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

For support and all you can need from Autors you can contact them at the url
of the project:
http://lptransfer.sourceforge.net
or by email address:
onoma@katamail.com
Any bug report will be appreciated.

Program and relative documentation written by
Ronchi Alessandro, Boschi Alessandro, Scozzoli Angelo

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdarg.h>
#include <sys/stat.h>
#include <time.h>

#include "lptransfer.h"





#define STATUSPORT BASEPORT+1
#define CONTROLPORT BASEPORT+2
#define PROGRAM_NAME "LPTransfer"
#define AUTHORS "Ronchi Alessandro, Boschi Alessandro, Scozzoli Angelo"
#define bufferlength 8192 /* This is the length of the buffer sent before calculating the crc for error detecting */

  int  i , full , total, cycles, evaluate, perc, percent, c2, size, control, step, start, number, stringlenght;
unsigned long crcarv, crc, dimension, real, speed, tempo, ti;
char c1, rit , rit1 ,  arrivo, dato, visualizza[21]="                    ", *sourcepath, *destpath, command, *executestring;
FILE *filesource, *tempfile ;



int main(int argc,char **argv) {

  getarguments(argc,argv);
  controlarguments();
  crc32_init(); /* Richiamo la funzione che inizializza la tabella per il calcolo del crc */


  /* Il comando che segue chiede il permesso al sistema operativo di aprire ed
     utilizzare la porta parallela. Per ottenerlo bisogna che il programma sia
     eseguito da root. */

/*  if (ioperm(BASEPORT, 3, 1 )) {
    fprintf(stderr, "Error: It's impossible to open the lpt port, maybe you are not root or you don't have the needed permission.\n");
    perror("ioperm");
    exit(1);
  }*/

  start=1;
  sincronizza();                 /* rileva che entrambi i programmi siano stati inviati */
  start=0;


  if (opt.is_pc_host == 1 ) {

    /* se opt.is_pc_host==1 allora invio il nome del nuovo file,2 la dimension,3 il file e il crc */
    if ((filesource = (fopen(sourcepath,"r"))) == NULL) {
      fprintf(stderr, "Error: It's impossible to open the input file\n");
      exit(1);
    }

    stringlenght = strlen(destpath);

    for (i=0; i < stringlenght; i++) {
      send(destpath[i]);
    }

    send(255);
    dimension=fsize(sourcepath);
    sendint(dimension);
    cycles=(dimension /bufferlength);
    evaluate=0;
    perc=0;
    speed=0;
    percent=(dimension/100);
    system("clear");
    tempo=(clock()/1000000);
    printf("Time is  %d sec\n",tempo);
    visualizza[(perc/5)]=*".";
    printf("[0%s100]   %d%\n",visualizza,perc);
    printf("The transfer speed is %d bit per second\n",speed);
    do {
      total=1;
      tempfile = fopen("tempfile","w");
      crc = 0xFFFFFFFF;
      real=dimension;
      while ((real!=0)) {
	timer=(clock()/1000000);
	while (control==8) {
	  timerc=(clock()/1000000);
	  if ((timerc-timer)>20) {
	    fprintf(stderr, "Error: Transmission is blocked, maybe dued to a disconnection of the port\n");
	    exit(1);
	  }
	  control=(inb(BASEPORT+1)&0x78)>>3;
	}

	(character = getc(filesource));
	crc = ((crc>>8) & 0x00FFFFFF) ^ crc_table[ (crc^character) & 0xFF ];

	/*calcolo del crc: shifto di otto bit a destra il valore gi esistente e faccio l'end bit a bit in modo da essere
	  sicuro di aver azzerato i primi otto bit. Poi faccio lo xor con il valore della tabella che si trova nella
	  posizione ( crc_precedente xor nuovo carattere ). */

	putc(character,tempfile); 	/*scrivo il char del file su un file temporaneo*/
	send(character);        /*invio char del file*/
	real--;
	evaluate++;
	if (evaluate>=percent)    /*visualizza lo stato della trasmissione*/
	  {
	    perc++;
	    tempo=(clock()/1000000);
	    if (tempo == 0 )
	      {
		tempo = 1; /* Questo if evita un errore di division by zero */
	      }
	    speed=(((percent * perc)/tempo)*8);
	    evaluate=0;
	    system("clear");
	    printf("Time is  %d sec\n",tempo);
	    visualizza[(perc/5)]=*".";
	    printf("[0%s100]   %d%\n",visualizza,perc);
	    printf("The transfer speed is %d bit per second\n",speed);
	  }
	if (total == bufferlength)  	     /*invio pacchetti da 8192 dit per il calcolo del crc*/
	  break;
	total++;
      }
      fclose(tempfile);
      sendint(crc);
      control=(inb(BASEPORT+1)&0x78)>>3;
      timer=(clock()/1000000);
      while ((control!=15) && (control!=8)) {
	/*aspetto che l destinatario mi dica se il crc  esatto ossia se la trasmissione  stata effettuata
	  con successo "control =8" in caso contrario riinvio l'ultimo pacchetto*/

	timerc=(clock()/1000000);
	if ((timerc-timer)>20)
	  {
	    fprintf(stderr,"The port is disconnected\n");
	    exit(1);
	  }

	control=(inb(BASEPORT+1)&0x78)>>3;
      }
      if (control==8)     /*invio un nuovo blocco di istruzioni*/
	{
	  sincronizza();
	  dimension=real;
	  cycles--;
	  total=1;
	}
      else
	{
	  while (control==15)         /*riinvio l'ultimo blocco*/
	    {
	      size = total;
	      real=dimension;
	      fprintf(stderr, "Error: A transmitted packet is not correct. I retry to resend it.\n");
	      tempfile=fopen("tempfile","r");
	      while (size!=0)
		{
		  (character = getc(tempfile));
		  send(character);
		  size--;
		}
	      fclose(tempfile);
	      sendint(crc);
	    }
	}
    }
    while(cycles>=0);
    fclose(filesource);
    system("rm tempfile");
  }
  else {
    while (1) {
      /* if pc isn't the host */
      printf("This pc is receiving data\n");

      /*se host==0 allora ricevo "Il nome del nuovo file,2 la dimension,3 il file e il crc*/
      number=0;
      executestring = (char*) calloc(sizeof(char)*300, sizeof(char));
      destpath = (char*) calloc(sizeof(char)*300, sizeof(char));
  
      while ((dato = receive_data()) != -1) {
        /* I receive the complete filename */
        /* the function receive_data gets a char and a -1 when the name is complete.*/
        strcat(destpath, &dato);      
      }

      strcat(executestring,"cat tempfile >> \"");
      strcat(executestring, destpath);
      strcat(executestring, "\"\0"); /* I insert a " before and after the name of the file, because it can contain spaces. */

      printf("I'm receiving the file %s  \n", destpath);

      /* I receive the dimension of the file */

      dimension=receive_data();
      dimension+=(receive_data()*256);
      dimension+=(receive_data()*256*256);
      dimension+=(receive_data()*256*256*256);
      cycles=(dimension / bufferlength);
      receive_data();

      if ((filesource = (fopen(destpath,"w"))) == NULL) {
        fprintf(stderr, "Error: It's impossible to open the output file\n");
        exit(1);
      }

      else {
	real=dimension;
	do {
	  total=1;
	  tempfile = fopen("tempfile","w");
	  crc = 0xFFFFFFFF;
	  while (real!=0) {
	    character=receive_data();
	    crc = ((crc>>8) & 0x00FFFFFF) ^ crc_table[ (crc^character) & 0xFF ];  /* Calculate the crc of the char arrived */
	    putc(character,tempfile);
	    real--;
	    if (total == bufferlength)
	      break;
	    total++;
	  }
	  fclose(tempfile);
	  /*ricezione crc*/
	  crcarv=receive_data();
	  crcarv+=(receive_data()*256);
	  crcarv+=(receive_data()*256*256);
	  crcarv+=(receive_data()*256*256*256);
	  receive_data();
	  if (crcarv == crc) {
	    /* We continue if the two crc are the same */

	    system(executestring);
	    sincronizza();
	    cycles--;
	    total=1;
	    dimension=real;
	  }
	  else {
	    /* If the two crc are different, we send a signal to the host */
	    outb(15,BASEPORT);
	    real=dimension;
	  }
	} while (cycles >= 0);
	system("rm tempfile");
      }

      /* Now we wait for another file */
      printf("File %s transfered successfully\n", destpath);
      start=1;
      sincronizza();                 /* rileva che entrambi i programmi siano stati inviati */
      start=0;
    }
  }


  /* We release the port, because we don't need it */
/*  if (ioperm(BASEPORT, 3, 0 )) {
    fprintf(stderr, "Error: It's impossible to close the lpt port, maybe you are not root or you don't have the needed permission.\n");
    perror("ioperm");
    exit(1);
  }*/

  /* And Then we exit */
  return 0;
}

