;=============================================================================
; overflow
;-----------------------------------------------------------------------------
; Overflow handler.
; In:	---
; Out:	DX:AX == ULONG_MAX
;	[error_code] == ERR_OVERFLOW
; Modf:	!AX, !DX
; Call:	---
; Use:	---
;
overflow:
		mov	byte [error_code],ERR_OVERFLOW
		mov	ax,-1
		cwd
		ret
;=============================================================================
; add_proc, sub_proc, mul_proc, div_proc, mod_proc
; and_proc, or_proc, xor_proc, shl_proc, shr_proc, sar_proc
; sqrt_proc, not_proc
;-----------------------------------------------------------------------------
; Performs arithmetical/logical operations.
; THESE PROCEDURES MUST PRESERVE SI!
; In:	DX:AX -- first operand
;	CX:BX -- second operand (only for binary operators)
; Out:	DX:AX -- result
; Modf:	!AX, ?BX, ?CX, !DX, ?DI, ?BP
; Call:	---
; Use:	---
;
add_proc:
		add	ax,bx
		adc	dx,cx
;		jc	overflow
		ret
;=============================================================================
; sub_proc
;-----------------------------------------------------------------------------
sub_proc:
		sub	ax,bx
		sbb	dx,cx
		ret
;=============================================================================
; mul_proc
;-----------------------------------------------------------------------------
; This code borrowed from FreeDOS kernel sources and slightly modified.
; Original comment follows:
; > this one adapted from elks, http://elks.sourceforge.net
; > multiply cx:bx * dx:ax, result in dx:ax
; > optimized by Arkady Belousov:
; >   dx:ax * cx:bx
; > = xh:xl * yh:yl
; > = xh:xl*yh*w + xh:xl*yl
; > = [xh*yh*w*w +] (xl*yh + xh*yl)*w + xl*yl
;
mul_proc:
		xchg	bp,ax		; bp=xl		(XCHG instead MOV)
		xchg	ax,dx		; ax=xh		(XCHG instead MOV)
		mul	bx		; dx:ax=xh*yl (forget dx)
		xchg	cx,ax		; cx=low(xh*yl), ax=yh
		mul	bp		; dx:ax=xl*yh (forget dx)
		add	cx,ax		; cx=low(xl*yh+xh*yl)
		xchg	ax,bp		; ax=xl		(XCHG instead MOV)
		mul	bx		; dx:ax=xl*yl
		add	dx,cx
		ret
;=============================================================================
; div_proc
;-----------------------------------------------------------------------------
div_proc:
		push	bx
		or	bx,cx
		pop	bx
		jz	overflow
@@m0:
		push	si
		mov	si,bx
		mov	di,cx
		mov	cx,32
		xor	bx,bx
		xor	bp,bp
		shl	ax,1
		rcl	dx,1
@@m1:
		rcl	bx,1
		rcl	bp,1
		push	bx
		push	bp
		sub	bx,si
		sbb	bp,di
		jnc	@@m2
		pop	bp
		pop	bx
		jmp	@@m3
@@m2:
		add	sp,4
@@m3:
		cmc
		rcl	ax,1
		rcl	dx,1
		loop	@@m1

		pop	si
		ret
;=============================================================================
; mod_proc
;-----------------------------------------------------------------------------
; x % y == x - (x / y) * y
;
mod_proc:
		push	ax
		push	dx
		push	bx
		push	cx
		call	div_proc
		pop	cx
		pop	bx
		call	mul_proc
		xchg	ax,bx
		xchg	dx,cx
		pop	dx
		pop	ax
		call	sub_proc
		ret
;=============================================================================
; and_proc
;-----------------------------------------------------------------------------
and_proc:
		and	ax,bx
		and	dx,cx
		ret
;=============================================================================
; or_proc
;-----------------------------------------------------------------------------
or_proc:
		or	ax,bx
		or	dx,cx
		ret
;=============================================================================
; xor_proc
;-----------------------------------------------------------------------------
xor_proc:
		xor	ax,bx
		xor	dx,cx
null_proc:
		ret
;=============================================================================
; shl_proc
;-----------------------------------------------------------------------------
shl_proc:
		jcxz	@@cx_ok
		xor	ax,ax
		cwd
		ret
@@cx_ok:
		mov	cx,bx
		jcxz	@@quit
@@loop:
		shl	ax,1
		rcl	dx,1
		loop	@@loop
@@quit:
		ret
;=============================================================================
; shr_proc
;-----------------------------------------------------------------------------
shr_proc:
		jcxz	@@cx_ok
		xor	ax,ax
		cwd
		ret
@@cx_ok:
		mov	cx,bx
		jcxz	@@quit
@@loop:
		shr	dx,1
		rcr	ax,1
		loop	@@loop
@@quit:
		ret
;=============================================================================
; sar_proc
;-----------------------------------------------------------------------------
sar_proc:
		jcxz	@@cx_ok
		xchg	ax,dx
		cwd
		ret
@@cx_ok:
		mov	cx,bx
		jcxz	@@quit
@@loop:
		sar	dx,1
		rcr	ax,1
		loop	@@loop
@@quit:
		ret
;=============================================================================
; sqrt_proc
;-----------------------------------------------------------------------------
sqrt_proc:
		mov	bx,1
		xor	cx,cx
@@next:
		sub	ax,bx
		sbb	dx,0
		jc	@@done
		inc	cx
		inc	bx
		inc	bx
		jmp	@@next
@@done:
		xor	dx,dx
		xchg	ax,cx
		ret
;=============================================================================
; not_proc
;-----------------------------------------------------------------------------
not_proc:
		not	ax
		not	dx
		ret
;=============================================================================
; neg_proc
;-----------------------------------------------------------------------------
neg_proc:
		neg	dx
		neg	ax
		sbb	dx,0
		ret
;=============================================================================

