;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; This file is a part of FreeDOS Resident Calculator sources.
; Copyright (c) 2006, 2007 Oleg O. Chukaev
;
; Constants, structures, and macros.
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-


;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Constants and structures
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;
CR		equ	0dh
LF		equ	0ah
COLOR_SEG	equ	0b800h
MONO_SEG	equ	0b000h
;
CALC_WIDTH	equ	36		;Width of calculator's window
CALC_HEIGHT	equ	6		;Height of calculator's window
SCR_BUF_LENGTH	equ	CALC_WIDTH*CALC_HEIGHT	;
LEN		equ	CALC_WIDTH-3	;Length of input line
;
MAGICK_CODE	equ	0fdcah		;Magick code (INT 10h function)
;
RC_ALL_OK	equ	0		;All Ok
RC_NOT_INST	equ	1		;FDRC not installed
RC_INTERC	equ	2		;Some INTs intercepted
RC_NO_MUX_NUMS	equ	3		;Multiplex numbers exhausted
RC_ALR_INST	equ	4		;FDRC already installed
RC_BAD_OPT	equ	5		;Invalid option
;
P_EOL		equ	0
P_OP		equ	1
P_EH		equ	2
P_ED		equ	3
P_EB		equ	4
P_ES		equ	5
P_ER		equ	6
P_EC		equ	7
P_ERR		equ	8
P_START		equ	8
P_HEX		equ	9
P_DEC		equ	10
P_BIN		equ	11
P_STR		equ	12
P_REG		equ	13
P_C		equ	14
P_EX		equ	15
;
ERR_ALL_OK	equ	0
ERR_PARSE	equ	1
ERR_UNDERFLOW	equ	2
ERR_NOT_EMPTY	equ	3
ERR_OVERFLOW	equ	4
ERR_EMPTY	equ	5
;
FUNC_EN_DIS	equ	2
FUNC_SET_L	equ	3
FUNC_SET_T	equ	4
FUNC_SET_K	equ	5
FUNC_SET_S	equ	6
;
%ifdef		COLOR_GRAY
COL_BG		equ	70h
COL_NUM		equ	70h
COL_TITLE	equ	7eh
COL_LETTER	equ	7fh
COL_ERRMSG	equ	74h
COL_ERRCHR	equ	4eh
COL_INPUT	equ	7fh
COL_INPUT0	equ	1fh
COL_FILL	equ	70h
%elifdef	COLOR_CYAN
COL_BG		equ	30h
COL_NUM		equ	3eh
COL_TITLE	equ	31h
COL_LETTER	equ	31h
COL_ERRMSG	equ	34h
COL_ERRCHR	equ	4eh
COL_INPUT	equ	3fh
COL_INPUT0	equ	7fh
COL_FILL	equ	30h
%else
COL_BG		equ	07h
COL_NUM		equ	02h
COL_TITLE	equ	09h
COL_LETTER	equ	0bh
COL_ERRMSG	equ	0ch
COL_ERRCHR	equ	4eh
COL_INPUT	equ	03h
COL_INPUT0	equ	2fh
COL_FILL	equ	07h
%endif
;
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Macros
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;
%macro		keystr	2
		dw	%1
		dw	%2
%endmacro
;
%macro		opstr	2
		db	%1
		dw	%2
%endmacro
;
%macro		prtstr	4
		dw	%1
		dw	%2
		db	%3
		db	%4
%endmacro

%macro		state	12
	%rep	6
		db	%1 * 16 + %2
	%rotate	2
	%endrep
%endmacro
;
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; E0F
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-


