;=============================================================================
; ins_char
;-----------------------------------------------------------------------------
; Inserts char into input buffer.
;
; if (insert_mode) {
;     if (no_free_space_in_buffer)
;         return
;     if (cur_ptr < eol_ptr)
;         shift_string_to_right_from_current
;     put_char
;     if (cursor_at_the_end_of_window) {
;         ++start_ptr
;         ++end_ptr
;     } else {
;         if (end_of_string_in_window) {
;             ++end_ptr
;         }
;     }
;     ++eol_ptr
; } else {
;     if (cur_ptr -> end_of_buffer)
;         return
;     put_char
;     if (cursor_at_the_end_of_window) {
;         ++start_ptr
;         ++end_ptr
;     } else {
;         if (cur_ptr == eol_ptr) {
;             ++end_ptr
;         }
;     }
;     if (cur_ptr == eol_ptr) {
;         ++eol_ptr
;     }
; }
; ++cur_ptr
;
; In:	BL -- char
; Out:	---
; Modf:	AX, BX, CX, DX, DI, SI
; Call:	---
; Use:	eol_ptr, cur_ptr, start_ptr, end_ptr, ins_flag
;
ins_char:
		cmp	byte [ins_flag],0
		jne	@@over

		mov	si,[eol_ptr]	;Shift string
		cmp	si,input_buf+BUF_LENGTH-1
		jae	@@exit		;Exit if buffer is full
@@loop:
		cmp	si,[cur_ptr]
		je	@@end_loop
		mov	ah,[si-1]
		mov	[si],ah
		dec	si
		jmp	@@loop
@@end_loop:
		mov	[si],bl

		mov	ax,[start_ptr]
		add	ax,LEN
		cmp	[cur_ptr],ax
		jb	@@no_shift2
		inc	word [start_ptr]
		inc	word [end_ptr]
		jmp	@@quit
@@no_shift2:
		cmp	[eol_ptr],ax
		adc	word [end_ptr],0	;Instead of the following
;		jae	@@no_shift3		;<-- instructions
;		inc	[end_ptr]		;<--
;@@no_shift3:					;<--
@@quit:
		inc	word [eol_ptr]
@@exit_0:
		inc	word [cur_ptr]
@@exit:
		ret
;------------
@@over:
		mov	si,[cur_ptr]
		cmp	si,input_buf+BUF_LENGTH-1
		jae	@@exit

		mov	[si],bl

		mov	ax,[start_ptr]
		add	ax,LEN
		cmp	[cur_ptr],ax
		jb	@@ne1
		inc	word [start_ptr]
		inc	word [end_ptr]
		jmp	@@0001
@@ne1:
		cmp	si,[eol_ptr]
		jne	@@0001
		inc	word [end_ptr]
@@0001:
		cmp	si,[eol_ptr]
		jne	@@ne2
		inc	word [eol_ptr]
;		inc	word [end_ptr]
@@ne2:
		inc	word [cur_ptr]
		ret
;=============================================================================
; insert_char
;-----------------------------------------------------------------------------
; Front-end for ins_char.
; In:	BL -- char
; Out:	---
; Modf:	AX, BX, CX, DX, DI, SI
; Call:	clear_str, ins_char, cur_left
; Use:	autoclear, result
;
insert_char:
		cmp	bl,0
		je	@@exit		;Exit if char is invalid
		cmp	byte [autoclear],0
		je	@@ins_char
		test	byte [autoclear],1
		jz	@@ins_char
		call	clear_str
		mov	di,result	;OPTIMIZE: instead of
		xor	ax,ax		;mov word [result],0
		stosw			;mov word [result+2],0
		stosw
@@ins_char:
		and	byte [autoclear],~1
		call	ins_char
		cmp	bl,'"'
		jne	@@exit
		call	ins_char
		call	cur_left
@@exit:
		ret
;=============================================================================
; backspace
;-----------------------------------------------------------------------------
; Deletes one char before cursor.
; if (no_chars_before_cursor)
;     return
; shift_string_to_left_from_current
; --eol_ptr
; if (beginning_of_string_in_window) {
;     if (end_of_string_in_window) {
;         --end_ptr
;     }
; } else {
;     --start_ptr
;     --end_ptr
; }
; --cur_ptr
;
; In:	---
; Out:	---
; Modf:	AX, BX, CX, DX, DI, SI
; Call:	shift_str
; Use:	eol_ptr, cur_ptr, start_ptr, end_ptr
;
backspace:
		mov	ax,[cur_ptr]
		cmp	ax,input_buf
		je	@@quit

		call	shift_str
		dec	word [cur_ptr]
		mov	ax,[start_ptr]
		cmp	ax,input_buf
		jne	@@0001
		add	ax,LEN
		cmp	[eol_ptr],ax
		jb	@@0003
		ret
@@0001:
		dec	word [start_ptr]
@@0003:
		dec	word [end_ptr]
@@quit:
		ret
;=============================================================================
; delete
;-----------------------------------------------------------------------------
; Deletes char under cursor.
; if (cursor_at_the_end_of_string)
;     return
; shift_string_to_left_from_current
; --eol_ptr
; if (end_of_string_in_window) {
;     if (beginning_of_string_not_in_window) {
;         --start_ptr
;     }
;     --end_ptr
; }
;
; In:	---
; Out:	---
; Modf:	AX, BX, CX, DX, DI, SI
; Call:	shift_str
; Use:	cur_ptr, eol_ptr, start_ptr, end_ptr
;
delete:
		mov	ax,[cur_ptr]
		cmp	ax,[eol_ptr]
		je	@@quit

		inc	ax
		call	shift_str
		mov	ax,[start_ptr]
		add	ax,LEN
		cmp	[eol_ptr],ax
		jae	@@quit
		dec	word [end_ptr]
		mov	ax,[start_ptr]
		cmp	ax,input_buf
		je	@@quit
		dec	word [start_ptr]
@@quit:
		ret
;=============================================================================
; clear_str
;-----------------------------------------------------------------------------
; Clears input buffer.
; In:	---
; Out:	---
; Modf:	AX, DI
; Call:	---
; Use:	---
;
clear_str:
		mov	ax,input_buf
		mov	di,ed_pointers
		stosw			;start_ptr
		stosw			;cur_ptr
		stosw			;end_ptr
		stosw			;eol_ptr
		ret
;=============================================================================
; clear_eol
;-----------------------------------------------------------------------------
; Clears input buffer from current position to the end of bufer.
; In:	---
; Out:	---
; Modf:	AX
; Call:	---
; Use:	cur_ptr, end_ptrm eol_ptr, start_ptr
;
clear_eol:
		mov	ax,[cur_ptr]
		mov	[end_ptr],ax
		mov	[eol_ptr],ax
		sub	ax,LEN
		cmp	ax,input_buf
		jae	@@quit
		mov	ax,input_buf
@@quit:
		mov	[start_ptr],ax
		ret
;=============================================================================
; shift_str
;-----------------------------------------------------------------------------
; Shifts string, from current position to end, on 1 char left.
; (For use w/ `backspace' and `delete'.)
; In:	AX -> string
; Out:	---
; Modf:	AX, SI
; Call:	---
; Use:	eol_ptr
;
shift_str:
		xchg	si,ax		;OPTIMIZE: instead of MOV SI,AX
@@loop:
		lodsb
		mov	[si-2],al
		cmp	si,[eol_ptr]
		jb	@@loop

		dec	word [eol_ptr]
		ret
;=============================================================================
; cur_right
;-----------------------------------------------------------------------------
; Moves cursor right.
; In:	---
; Out:	---
; Modf:	AX
; Call:	---
; Use:	cur_ptr, eol_ptr, end_ptr, start_ptr
;
cur_right:
		mov	ax,[cur_ptr]
		cmp	ax,[eol_ptr]
		je	@@quit

		inc	word [cur_ptr]
		cmp	ax,[end_ptr]
		jb	@@quit
		inc	word [start_ptr]
		inc	word [end_ptr]
@@quit:
		ret
;=============================================================================
; cur_left
;-----------------------------------------------------------------------------
; Moves cursor left.
; In:	---
; Out:	---
; Modf:	AX
; Call:	---
; Use:	cur_ptr, start_ptr, end_ptr
;
cur_left:
		mov	ax,[cur_ptr]
		cmp	ax,input_buf
		je	@@quit

		dec	word [cur_ptr]
		cmp	ax,[start_ptr]
		ja	@@quit
		dec	word [start_ptr]
		dec	word [end_ptr]
@@quit:
		ret
;=============================================================================
; cur_home
;-----------------------------------------------------------------------------
; Moves cursor to the beginning of input line.
; In:	---
; Out:	---
; Modf:	AX
; Call:	---
; Use:	start_ptr, cur_ptr, eol_ptr, end_ptr
;
cur_home:
		mov	ax,input_buf
		mov	[start_ptr],ax
		mov	[cur_ptr],ax
		add	ax,LEN
		cmp	[eol_ptr],ax
		ja	@@0001
		mov	ax,[eol_ptr]
@@0001:
		mov	[end_ptr],ax
		ret
;=============================================================================
; cur_end
;-----------------------------------------------------------------------------
; Moves cursor to the end of input line.
; In:	---
; Out:	---
; Modf:	AX
; Call:	---
; Use:	start_ptr, cur_ptr, eol_ptr, end_ptr
;
cur_end:
		mov	ax,[eol_ptr]
		mov	[cur_ptr],ax
		mov	[end_ptr],ax
		sub	ax,LEN
		cmp	ax,input_buf
		jae	@@0001
		mov	ax,input_buf
@@0001:
		mov	[start_ptr],ax
		ret
;=============================================================================

