@echo off
:*** MAKEROM.BAT ***
:
: Copyright 1996,2002,2003 Luchezar Georgiev. All Rights Reserved.
: ROMDSK Copyright (c) 1996 Stanislav Bonchev. All Rights Reserved.
:
: This file prepares the binary image of the FreeDOS ROM-disk.
: It must reside in the same directory as the tools used by it.
:
: Usage:  makerom {size_in_KB} [-t]
:
: Only sizes of 64 or 128 KB are supported by this batch file.
:
: Options: -t  means that a test diskette will be created too.
:
: Caveats:  1. Doesn't run in Windows. Runs in DOS mode only.
:	    2. If there is no physical drive B:, a message appears:
:	"Insert diskette for drive B: and press any key when ready"
:
: Notes:
: a) Commands in capital letters are part of the ROM-disk package
: b) Commands in small letters are from FreeDOS or external ones.

:* Check if Microsoft Windows is running (what about NT/2K/XP/03?)
WINCHK

:* Multiple lines necessary for 4DOS compatibility
if errorlevel == 255 goto windows
if errorlevel == 5 goto windows
if errorlevel == 4 goto windows
if errorlevel == 3 goto windows
if errorlevel == 2 goto windows

:* Pure DOS detected -- check its version
DOSVER
if not errorlevel == 7 goto dosold

:* DOS version high enough -- check parameters
if "%1"=="" goto usage
if "%1"=="64" goto check2
if not "%1"=="128" goto invalid

:Check2
if "%2"=="" goto create
if not "%2"=="-t" goto usage

:Create an empty ROM disk for logical drive B:
ROMDSK /%1
: ^This is a virtual disk driver (a TSR-program)

:* Transfer DOS to the ROM-disk
nucleus\sys nucleus b: > nul
: "Insert diskette for drive B:..." appears, just
: press a key here; don't know how to prevent this

:* Patch the boot record so that upon bootstrap
:    it will tell DOS that B: is the boot drive
DRIVEB

:* Copy all the files needed to the ROM disk
copy romdisk\*.* b: > nul

:* Write the ROM-disk to a binary image file
if exist disk.rom del disk.rom > nul
WROM disk.rom

:* Remove the ROM-disk from memory
REMOVE

:* We need to switch back to A: for next runs!
:vol a: > nul
:* "Insert diskette for drive A:..." appears
echo DISK.ROM created.

:* Write the image to a bootable test diskette
if not "%2"=="-t" goto quit
DISKET disk.rom
REBOOT

:* Windows doesn't allow a TSR to change drives
:windows
echo Can't run inside Windows!
goto quit

:dosold
echo DOS version 7.00 or higher required
goto quit

:usage
echo Usage:  makerom {size_in_KB} [-t]
echo.
echo	-t: disk test
goto quit

:invalid
echo Size must be 64 or 128 KBytes

:quit

:*** End of MAKEROM.BAT ***
