; Import: S_time, S_timebuf
; Export: saytime, sayASCIIZ

;
; In:	DS:SI			(TIME structure)
;	ES			(=DS)
; Out:	none
; Use:	none
; Modf: AX, DI
; Call:	put4digit, put2digit, say
;
saytime		proc	C uses si
		mov	di,dataref:S_timebuf
		lodsw				; year
		 call	put4digit
	countloop_ 5				; month/day/hour/min/sec
		inc	di			; skip separator
		lodsw
		 call	put2digit
	end_
		say	si
		say	dataref:S_time
		ret
saytime		endp

;
; In:	AX			(year)
;	ES:DI			(output buffer)
; Out:	ES:DI
; Use:	none
; Modf:	AX, DX
; Call:	put2digit
;
put4digit	proc
		push	cx
		xor	dx,dx
		mov	cx,100
		div	cx			; AX=century, DX=year
		pop	cx
		call	put2digit
		xchg	ax,dx			; OPTIMIZE: instead MOV AL,DL
		;j	put2digit
put4digit	endp

;
; In:	AL			(value)
;	ES:DI			(output buffer)
; Out:	ES:DI
; Use:	none
; Modf:	AX
; Call:	none
;
put2digit	proc
		aam
		add	ax,'00'
		xchg	al,ah
		stosw
		ret
put2digit	endp

;
; In:	DS:DI			(null terminated string)
; Out:	none
; Use:	none
; Modf:	AH, DL, DI
; Call:	none
;
sayASCIIZ_	proc
	loop_
		DOSWriteC dl
		inc	di
sayASCIIZ:	mov	dl,[di]
		test	dl,dl
	until_ zero
		ret
sayASCIIZ_	endp
