; KEEPTIME - Backup/restore system date/time to/from time stamp of file
; Copyright (c) 2003 Arkady Belousov <ark@mos.ru>
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;

%pagesize 255
%noincl
;%macs
%nosyms
;%depth 0
%linum 0
%pcnt 0
;%bin 0
warn
locals

.model use16 tiny

dataref equ <offset @data>	; offset relative data group

include asm.mac
include hll.mac
include macro.mac
include DOS/country.def
include DOS/file.mac
include DOS/io.mac
include DOS/time.mac

nl		equ <13,10>
eos		equ <0>

TIME		struc
  year		dw ?
  month		db ?,0
  day		db ?,0
  hour		db ?,0
  min		db ?,0
  sec		db ?,0
ends

say		macro	stroff:vararg
		MOVOFF_	di,<stroff>
		call	sayASCIIZ
endm


; DATA SEGMENTS 

.const

Syntax	db 'KEEPTIME v1.1 - Backup system date/time to time stamp of file',nl
	db 'Copyright (c) 2003 by Arkady V.Belousov, licensed under GPL2',nl
	db nl
	db 'Syntax:  keeptime <filename-to-store-time>',nl
	db 'Example: keeptime keeptime.com',nl
	db nl
	db 'KEEPTIME stores system time to time stamp of given file (and creates',nl
	db 'file if it absent) or restores system time from time stamp of file',nl
	db 'if file time newer than system time.',nl
	db nl
	db 'KEEPTIME useful for computers with occasionally cleared clock. It',nl
	db 'should be runned at startup (in autoexec.bat) and before shutdown',nl
	db '(to keep most modern time).',nl
	db nl
	db 'Errorlevel: nonzero if system time updated from file time.'
CRLF	db nl,eos

E_open	db 'Error: open: ',eos

.data

systm		TIME ?
		db 'Current',eos
filetm		TIME ?
		db 'Updated',eos

S_time		db ' time: '   ; yyyy-mm-dd hh:mm:ss
S_timebuf	db		'    '
S_dtsep1	db		    '-  '
S_dtsep2	db		       '-     '
S_tmsep1	db			     ':  '
S_tmsep2	db				':  ',nl,eos


; CODE SEGMENT 

.code
.startup
		cld
		;MOVSEG	es,ds

;----- find argument in command line

		mov	si,80h			; offset PSP:cmdline_len
		lodsb
		cbw				; OPTIMIZE: instead MOV AH,0
		xchg	bx,ax			; OPTIMIZE: instead MOV BX,AX
		mov	byte ptr [si+bx],0	; make ASCIIZ string

; WARNING: above instruction changes byte in PSP and may fill first
; byte of program image (if command line uses all 128 bytes)

	loop_					; find argument start:
		lodsb
		sub	al,' '+1
		cmp	al,0-(' '+1)
	until_ be				; loop while white space

		mov	di,dataref:Syntax
		je	EXITSAY			; exit if EOL
		dec	si

;----- open file (create, if not exists)

		DOSGetFileAttr ,,si		; if CF=0 (success) then
		;mov	dx,si			;  AH=3Dh (open existing file)
		mov	ax,3D00h		;  AL=O_RDONLY
						; else (couldn't get attributes)
		sbb	ah,al			;  AH=3Ch (create file)
		MOVREG_	cx,FA_NORMAL		;  CX=FA_NORMAL
		int	21h			; open/create file (DS:DX)

	if_ carry
		say	dataref:E_open		; 'Error: open: '
		say	si			; filename
		mov	di,dataref:CRLF
EXITSAY:	say
		mov	al,0
		jmp	EXIT
	end_

;----- get and unpack file time stamp record

		push	ax			; preserve file handle
		xchg	bx,ax			; OPTIMIZE: instead MOV BX,AX
		DOSGetFileTime bx

		;MOVSEG	es,ds
		mov	di,dataref:filetm
		call	unpackftime

;----- get country info and copy date/time string separators

if 0
.data?

ci		COUNTRY ?	; buffer for country info

.code

		mov	dx,dataref:ci		; DS:DX=buffer
		mov	ax,3800h		; get country info
		int	21h
	if_ nc
		mov	al,[ci.co_dtsep]
		 mov	[S_dtsep1],al
		 mov	[S_dtsep2],al
		mov	al,[ci.co_tmsep]
		 mov	[S_tmsep1],al
		 mov	[S_tmsep2],al
	end_
endif

;----- get system time

		mov	si,dataref:systm
		DOSGetDate
		mov	[si.year],cx
		mov	[si.month],dh
		mov	[si.day],dl
		DOSGetTime
		mov	[si.hour],ch
		mov	[si.min],cl
		mov	[si.sec],dh

		;MOVSEG	es,ds
		call	saytime

;----- compare file time and system time

		;MOVSEG	es,ds
		;mov	si,dataref:systm
		mov	di,dataref:filetm
		mov	cx,size TIME/2
	repe	cmpsw

		pop	bx			; restore file handle
	if_ below				; if system time lesser
						;  than file time
		mov	si,dataref:filetm
		DOSSetDate [si.year],[si.month],[si.day]
		DOSSetTime [si.hour],[si.min],[si.sec],0

		;MOVSEG	es,ds
		call	saytime
		mov	dl,1

	else_

		mov	si,dataref:systm
		call	packftime
		DOSSetFileTime bx,dx,cx		; renew file time stamp

		mov	dl,0

	end_ if

		DOSCloseFile bx

		xchg	ax,dx			; OPTIMIZE: instead MOV AL,DL
EXIT:		.exit				; terminate, al=return code

include filetime.inc
include say.inc

;

end
