; Import: TIME
; Export: unpackftime, packftime

.const

TIMEshift	db width DOSFDATE_year80
		db width DOSFDATE_month
		db width DOSFDATE_day
		db width DOSFTIME_hour
		db width DOSFTIME_min
		db width DOSFTIME_sec2+1

.code

;
; In:	DX:CX			(date:time)
;	ES:DI			(TIME structure)
; Out:	none
; Use:	none
; Modf:	AX, CX, DX, SI, DI
; Call:	none
;
unpackftime	proc
		mov	si,dataref:TIMEshift
		push	cx
		call	@@unpackrecord
		add	[di-6].year,1980
		pop	dx
		;j	@@unpackrecord

@@unpackrecord:	call	@@unpackfield
		call	@@unpackfield
		;j	@@unpackfield

@@unpackfield:	lodsb
		xchg	cx,ax			; OPTIMIZE: instead MOV CL,AL
		mov	al,0
		mov	ah,dh
		shl	dx,cl
		rol	ax,cl
		stosb
		inc	di
		ret
unpackftime	endp

;
; In:	DS:SI			(TIME structure)
; Out:	DX:CX			(date:time)
; Use:	none
; Modf:	AX, SI, DI
; Call:	none
;
packftime	proc
		std
		lea	si,[si+size TIME-2]
		mov	di,dataref:TIMEshift+5
		call	@@packrecord
		push	dx
		call	@@packrecord
		sub	dh,((1980 shl DOSFDATE_year80) and mask DOSFDATE_year80) shr 8
		pop	cx
		cld
		ret

@@packrecord:	call	@@packfield
		call	@@packfield
		;j	@@packfield

@@packfield:	mov	cl,[di]
		lodsw
		dec	di
		ror	ax,cl
		shr	dx,cl
		or	dh,ah
		ret
packftime	endp
