/*
 *      readhelp.c
 *
 *      Copyright 2009 Blair <blair@blair-laptop>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 */

#include "helpcomp.h"
#include <stdlib.h>
#include <stdio.h>

HELP *help_open( const char *filename )
{
    HELP *retval = malloc( sizeof( HELP ) );
    FILE *hfile;
    int pages, links;
    struct help_page_entry *ppages;
    struct help_link       *plinks;

    if( retval == NULL ) return( NULL );
    if( ( hfile = fopen( filename, "rb" ) ) == NULL ) goto exit_error;
    if( fread( &retval->hfinf_index, sizeof( struct help_index ), 1, hfile ) != 1 ) goto exit_error;
    pages = retval->hfinf_index.help_npages;
    links = retval->hfinf_index.help_nlinks;
    ppages = malloc( sizeof( struct help_page_entry ) * pages );
    plinks = malloc( sizeof( struct help_link ) * links );
    if( !retval->hfinf_pages || !retval->hfinf_links ) goto exit_fclose;

    if( fread( ppages, sizeof( struct help_page_entry ), pages, hfile ) != pages ) goto exit_fclose;
    if( fread( plinks, sizeof( struct help_link ), links, hfile ) != links ) goto exit_fclose;

    retval->hfinf_pages = ppages;
    retval->hfinf_links = plinks;
    retval->hfinf_file  = hfile;

    return( retval );
exit_fclose:
    fclose( hfile );
    free( ppages );
    free( plinks );
exit_error:
    free( retval );
    return( NULL );
}

void help_close( HELP *hlp )
{
    fclose( hlp->hfinf_file );
    free( hlp->hfinf_pages );
    free( hlp->hfinf_links );
    free( hlp );
}

char *help_readpage( HELP *hlp, int page )
{
    char *pagestring;
    long pagesize;

    if( page >= help_pages( hlp ) ) return( NULL );
    pagesize = help_pagesize( hlp, page );

    if( ( pagestring = malloc( pagesize ) ) == NULL ) return( NULL );

    fseek( hlp->hfinf_file, help_pagestart( hlp, page ), SEEK_SET );
    if( fread( pagestring, pagesize, 1, hlp->hfinf_file ) != 1 ) return( NULL );

    return( pagestring );
}
