/*
 *      fdav_tui.c
 *
 *      Copyright 2009 Blair <blair@blair-laptop>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 */

#include "fdav.h"

static int ftw_handler( const char *path, struct stat *stbuf, int flag )
{
    int r;
    const char *vname;

    if( flag != FTW_F ) return( 0 );
    dos_filename( ( char * )path );
    if( !TUI_OPTION( TUI_ALLF ) && !has_ext( path ) ) return( 0 );

    logprintf( "Scanning \"%s\"\n", path );
    if( !( opts & FDAV_NODISP ) ) printf( "Scanning %s: ", path );

    if( ( r = cl_scanfile( path, &vname, &scanned, scan_engine, &vlimits, CL_SCAN_STDOPT ) ) == CL_VIRUS ) {
        viruses++;
        logprintf( "Found the virus \"%s\" in \"%s\"\n", vname, path );
        beep();
        if( opts & FDAV_NODISP ) printf( "%s is ", path );
        printf( "INFECTED with %s\n", vname );
        if( !TUI_OPTION( TUI_NALARM ) ) beep();
        if( opts & FDAV_QUTINE ) {
            logprintf( "Attempting to quarrantine \"%s\"\n", path );
            if( backup_file( path ) ) {
                printf( "Could not quarrantine %s\n", path );
                opts &= ~FDAV_REMOVE;
            } else opts |= FDAV_REMOVE;
        }
        if( opts & FDAV_REMOVE ) {
            logprintf( "Attempting to remove \"%s\"\n", path );
            if( unlink( path ) ) {
                perror( "Could not remove" );
            } else {
                printf( "Removed %s\n", path );
                viruses_removed++;
            }
        }
    } else if( r != CL_CLEAN ) {
        logprintf( "An error occured while scanning \"%s\"\n", path );
        printf( "Virus scanning error: %s\n", cl_strerror( r ) );
        return( -1 );
    } else if( !( opts & FDAV_NODISP ) ) printf( "Clean\n" );

    files_checked++;

    return( 0 );
}

/* Fairly simple; walk through the file/directory arguments and call ftw */
int walk_args( char **walk_files, int walk_num )
{
    int i, r = 0;
    char *cur_file;

    for( i = 0; i < walk_num; i++ ) {
        cur_file = walk_files[ i ];
        if( access( cur_file, D_OK ) == 0 ) r = ftw( cur_file, ftw_handler, 16 );
        else r = ftw_handler( cur_file, NULL, FTW_F );

        if( r != 0 ) break;
        if( opts & FDAV_REPORT && create_report( cur_file ) < 0 ) printf( "Error creating report file for %s.\n", cur_file );
        viruses = viruses_removed = files_checked = 0L;
    }

    return( r );
}

/* The simple command-line front-end */
int fdav_cli( void )
{
    int r;

    logprintf( "Loading database...\n" );
    if( ( r = load_database() ) ) {
        printf( "Virus database load error: %s\n", cl_strerror( r ) );
        return( 2 );
    }
    if( opts & FDAV_DSPTXT ) {
        char *s = dirname( fdav_filename );
        char buf[ 512 ];
        FILE *fp;

        realloc( s, strlen( s ) + 10 );
        strcat( s, "\\fdav.txt" );

        logprintf( "Trying to read and display %s\n", s );
        if( ( fp = fopen( s, "r" ) ) ) {
            while( fgets( buf, 512, fp ) ) printf( buf );
            fclose( fp );
        }

        free( s );
    }
    if( walk_args( filev, files ) < 0 ) return( 2 );
    if( viruses ) {
        if( opts & FDAV_DSPTXT ) return( 86 );
        return( 1 );
    }
    return( 0 );
}
