_seg    segment para public
	assume cs:_seg
        MASM
        JUMPS
        LOCALS

;DebugVer        equ 1

IFNDEF IsWin
Win     equ 0
ENDIF

IF Win
MoveInInt       equ 0
NotMoveInInt    equ 1
VxDmem  equ 1
LockDMA equ 1
PreIO   equ 0
ELSE
VxDmem  equ 0
MoveInInt equ 0
VxD     equ 0
LockDMA equ 0
PreIO   equ 0
ENDIF

Prot    equ 0
sw      equ Prot

        .386c

timer   equ 46Ch
motoroff equ 440h

	org 100h
start:  jmp initXMS

FailAll db 0

secslid0 db 2
secslid1 db 2

disk    db 0
head    db 0    ; 0 or 4
cyl     db 0
sec     db 0
buf     dw 0    ; Current buffer

sig     db '35sec1.4'
IF Win
sig2    db '1 Win   '
ELSE
sig2    db '1 DOS   '
ENDIF
ver     db 14h
flags   db (1h * Win) + (2h * Prot)

curbuf0 db 1
curbuf1 db 2

TimeStart dd 0
TimeEnd dd 0

WriteEn db 0
Drive0  db 0
Drive1  db 0

ErrCode dw 0

; Compatibility - offsets of usefull areas

offBufs dw offset bufs
IF Win
offWin  dw offset MoveNow
ELSE
offWin  dw 0
ENDIF

numhead db 1
numcyl  db 80
numsec  db 18

sec2r   db 18   ; Sectors to read
SecBad  db 0
TSecBad dw 0
lBuf    dd 0

phase   db 0
dstep   db 0    ; Double - step
secslid db 0

tableadr dw 0
done    db 0
InWin   db 0    ; 0..No windows, 1..Windows, 2..Windows going down
TNumSec dw 0    ; Number of sectors

numbufs equ 9
bufs    db numbufs
bufslot db 32*numbufs dup (0)



; single sided floppy disks not supported

; Phase
;  0 ... do nothing
;  1 ... ReadRes & seek
;  2 ... ReadRes & read / write
;  3 ... SenseIntStatus & read / write
;  4 ... Seek to track zero
;  5 ... Wait for seek to be completed
; 80 ... done

; WriteEn
;  0 ... read
;  1 ... write whole disk
;  2 ... write only parts


; Needed actions
; 
;                                                           A: B:
; Allocate memory & read disk from A:/B: to buffer       ... A  Q  *  1 2
; Set active buffer for A:/B: to buffer                  ... S  W  *  3 4
; Free memory for buffer                                 ... Z     *  9
; Write changed fields from buffer to A:/B:              ... D  E  *  5 6
; Write whole buffer to A:/B:                            ... F  R  *  7 8
; Report current operation                               ... X
; Status of buffer                                       ... C     *  A
; Write buffer for to hard-disk file 1..0                ... V     *  B
; Read buffer for from hard-disk file 1..0               ... B     *  C
; Help

buffer dw 256 dup (255)

Pushax  macro
        pushad
IF 0
        push eax
        push ebx
        push ecx
        push edx
        push si
        push di
        push bp
ENDIF
        endm

Popax   macro
        popad
IF 0
        pop bp
        pop di
        pop si
        pop edx
        pop ecx
        pop ebx
        pop eax
ENDIF
        endm

InitInt macro Num,New,Old
        mov ax,3500h + Num
	int 21h
        mov word ptr cs:[Old+1],bx
        mov word ptr cs:[Old+3],es

        mov ax,2500h + Num
	push cs
	pop ds
        mov dx, offset New
	int 21h
        endm

;INCLUDE 35beep.asm
        INCLUDE ..\Hgcinc.asm
INCLUDE 35int.asm
INCLUDE 35disk.asm
INCLUDE 35bios.asm
INCLUDE 35win.asm
IF Prot
INCLUDE 35beep.asm
ENDIF
INCLUDE 35buf.asm ; Musi byt posledni, je tam InitXMS

Install db '35sec'
IF win
        db 'Win'
ENDIF
        db ' 1.41 - floppy disk accelerator',13,10
        db '  1995 Pavel Machek',13,10
IF sw
        db 13,10
        db '*** This is unregistered shareware version',13,10
        db '*** Please register after 21-days testing period',13,10
ELSE
        db '  Note: You are using version registered to ........................',13,10
ENDIF
        db '$'
DriveA  db 'Drive A: $'
DriveB  db 'Drive B: $'

None    db '<Not present>',13,10,'$'    ; Vse musi byt stejne dlouhe!
K360    db '5" -   360KB',13,10,'$'
M120    db '5" - 1 200KB',13,10,'$'
K720    db '3" -   720KB',13,10,'$'
M144    db '3" - 1 440KB',13,10,'$'

M5      db '<Unknown - 5>',13,10,'$'
M6      db '<Unknown - 6>',13,10,'$'
M7      db '<Unknown - 7>',13,10,'$'
M8      db '<Unknown - 8>',13,10,'$'
M9      db '<Unknown - 9>',13,10,'$'
M10     db '<Unknown - A>',13,10,'$'
M11     db '<Unknown - B>',13,10,'$'
M12     db '<Unknown - C>',13,10,'$'
M13     db '<Unknown - D>',13,10,'$'
M14     db '<Unknown - E>',13,10,'$'
M15     db '<Unknown - F>',13,10,'$'

IF win
boundary db 'DMA buffer is on 64K boundary, please load this resident elsewhere.',13,10
        db '(Load into UMB or change order of other residents)',13,10,'$'
ENDIF

errAlreadyThere db '35sec'
IF Win
        db 'W'
ENDIF
        db ' is already loaded. Instalation Aborted.',13,10,'$'


;
;  ********     Inicializace      **********
;
IF Win
initXMS:
ENDIF
init:
        Debug 'Testing presence'
        mov eax,35EC1515h
        mov bx,0
        int 13h
IF Win
        test bl,2
ELSE
        test bl,1
ENDIF
        jnz AlreadyThere

        Debug 'Getting Int9'
        InitInt 0Eh New0E Old0E
;       InitInt 09h New09 Old09
        Debug 'Getting Int13'
IF PreIO
; Install pre-io.sys handler
        push cs
        pop ds
        mov dx,offset New13
        mov ah,13h
        int 2Fh
        mov word ptr Old13+1,dx
        mov word ptr Old13+3,ds

ELSE
        InitInt 13h New13 Old13
ENDIF
        Debug 'Getting Int2F'
        InitInt 2Fh New2F Old2F

IF Win
        Debug 'Examining environment'
        mov     ah,62h
	int	21h			;bx -> psp
	mov	es,bx
	mov	bx,2ch			;environment segment
	mov	es,es:[bx]
	xor	di,di
	mov	cx,-1			;big number
	xor	al,al			;search for a null
	cld
@@5:
	repne	scasb			;get past one null and stop
	cmp	byte ptr es:[di],0	;another null
        jnz     @@5                     ;no.
	add	di,3			;skip the word before the name.

        mov siDevice,di
        mov siDeviceSeg,es
        repne   scasb
        sub di,11
        mov eax,'.MEM'
        stosd
        mov eax,'683'
        stosd
ENDIF

IF MoveInInt
        Debug 'Getting IntE8'
        InitInt 0E8h New70 Old70
ENDIF
        push cs
        pop ds

        Debug 'Printing installation message'
        mov dx,offset Install
        mov ah,09h
        int 21h

        mov ax,0910h    ; Do ah si pripravim cislo sluzby tiskni
        out 70h,al
        jmp $+2
        jmp $+2
        jmp $+2
        in al,71h
        mov bp,ax

        mov dx,offset DriveA
        shr al,4
        and al,0Fh
        mov Drive0,al

        call DType

        mov ax,bp
        mov dx,offset DriveB
        and al,0Fh
        mov Drive1,al

        call DType

IF Win
        xor edx,edx
        mov cx,cs
        movzx eax,cx
        shl eax,4
        lea dx,DMAbuf
        add eax,edx
        shr eax,16

        mov bx,ax
        movzx eax,cx
        shl eax,4
        add dx,512
        add eax,edx
        shr eax,16
        cmp ax,bx
        je @@1
        mov dx,offset boundary
        jmp ferror

@@1:
ENDIF
        Debug '35sec going resident...'

IF Prot
        mov dx,200
        mov cx,50
        call dobell

        mov dx,600
        mov cx,25
        call dobell

        mov dx,400
        mov cx,50
        call dobell

        mov dx,300
        mov cx,25
        call dobell

        mov dx,200
        mov cx,50
        call dobell

        mov dx,0
        mov cx,250
        call dobell

        mov dx,offset initXMS+1
        retf
ELSE
        mov dx,offset initXMS+1
	int 27h
ENDIF

DType:
        push ax
        int 21h
        pop ax
        mov cl,(offset K360- offset None)
        mul cl
        add ax,offset None
        mov dx,ax
        mov ah,09h
        int 21h
        retn

AlreadyThere:
        mov dx,offset errAlreadyThere
        jmp ferror

IF Win
ELSE
noxms:
        mov dx,offset errNoXMS
ENDIF

ferror:
        mov ah,09
        int 21h
        mov dx,offset errNotInst
        int 21h
IF Prot
        xor dx,dx
        retf
ELSE
        mov ax,4C01h
        int 21h
ENDIF

_seg	ends
	end start
