;
; This is include file
;

JmpTable dw offset InstalledCall
         dw offset StartRead, offset StartRead  ; Read   A:/B:
         dw offset SetBuf,    offset SetBuf     ; Set    A:/B:
         dw offset WriteChg,  offset WriteChg   ; WriteC A:/B:
         dw offset WriteAll,  offset WriteAll   ; WriteA A:/B:
         dw offset FreeMem,   offset Cancel     ;
         dw offset AllocMem,  offset AllRead
         dw offset SomeRead,  offset FreeAll
         dw offset Specify,   offset NotImpl
         dw offset NotImpl,   offset NotImpl
         dw offset NotImpl,   offset NotImpl
         dw offset NotImpl,   offset NotImpl

;
; What is BEFORE SetBuf, does not require buffer number
; What is AFTER SetBUf, requires buffer number
;

XNotImpl        equ 0
XFreeErr        equ 1
XFree           equ 2
XWorking        equ 3
XBufEmpty       equ 4
XBadBoot        equ 5
XBadBuffer      equ 6
XNoMem          equ 7
XBadForm        equ 8
XOK             equ 9
XReadBoot       equ 0Ah
XBufSet         equ 0Bh
XBufReset       equ 0Ch
XNoDrive        equ 0Dh
XCantCancel     equ 0Eh
XCanceled       equ 0Fh

CallBackSig     equ 35ECCA11h

;
; StartCmd - v cl cislo bufferu, v bl kod prikazu
;

RetCX   dw 0

Int13Command:
        pushax
        xor ax,ax
        mov ErrCode,ax
        mov al,cl

        mov dl,bl
        xor bh,bh
        mov bp,XNotImpl
        cmp bx,0Eh
        ja RetIt

        shl bx,1

        dec dx
        and dx,1h
        xor ah,ah
        mov si,ax
        dec si

        mov bx,word ptr cs:JmpTable[bx]
        cmp bx,offset SetBuf
        jbe @@2
        cmp al,0
        je InvalidBuff
        cmp al,NumBufs
        ja InvalidBuff
@@2:    call bx
        mov RetCX,ax
RetIt:  mov ErrCode,bp

        popax
        mov eax,35EC35ECh
        mov bx,cs:ErrCode
        mov cx,cs:RetCX
        clc
        retf 2

InvalidBuff:
        mov bp,XBadBuffer
        jmp RetIt

;
; Specify - specifies memory to work with
;
Specify:
IF Win
        mov SpecLinear,esi
        mov SpecHandle,edx
        mov SpecSize,cx
        retn
ENDIF

NotImpl:
        mov bp,XNotImpl
        retn

;
; Installed? call
;

InstalledCall:
        push cs
        pop ds
        mov bp,cs
        retn

;
; Free all buffers
;

FreeAll:
        mov cl,NumBufs
@@1:
        mov eax,0EABECEDAh
        mov bl,9
        push cx
        int 13h
        pop cx
        loop @@1
        retn

;
; Cancel - prerusi operaci
;

Cancel:
        mov al,Phase
        cmp al,2
        je CancelIt
        cmp al,1
        je CancelIt

        mov bp,XCantCancel
        retn

CancelIt:
        mov bp,XCanceled
        mov Phase,4
        inc TSecBad
        retn

;
; Set actual buffer
;
SetBuf:
        mov bp,XBufSet
        cmp al,NumBufs
        jbe @@1
        mov bp,XBufReset
        xor al,al
@@1:    mov bx,dx
        xchg curbuf0[bx],al
        retn

;
; Free buffer
;

FreeMem:
        mov bp,XWorking
        test phase,7Fh
        jnz @@1

        call FreeBuf
        mov bp,XFreeErr
IF VxDmem
        or eax,eax
        jz @@1
        mov bp,XFree
        xor eax,eax
        mov dword ptr bufslot[si + ohandle],eax
        mov dword ptr bufslot[si + olinadr],eax
ELSE
        cmp ax,1
        jne @@1
        mov bp,XFree
        xor ax,ax
        mov word ptr bufslot[si + ohandle],ax
ENDIF
@@1:    retn

;
; Allocate memory only
;

AllocMem:
        call PhaseTest
        push dx si
        call FreeMem
        pop si dx
        push es
        mov WriteEn,0
        call ProcessBoot
IF Win
        call UnLockBuf
ENDIF
        pop es
        mov bp,XOK
        retn

;
; Mark all tracks read
;

AllRead:
        mov bp,XOK
        mov al,0FFh
        shl si,5
        push es
        call SetReaded
        pop es
        retn

;
; Mark selected track read
;

SomeRead:
        mov al,ch
        xor ah,ah
        shl si,5
        bts cs:tableadr[si],ax
        mov bp,XOK
        retn


;
; Read done
;

ReadDone:
        push es
        mov si,buf
        shl si,5
        test WriteEn,0FFh
        jz @@1
        call ClearNeeds
IF Win
        jmp @@2
@@1:    ; What about unlocking memory?
        call UnLockBuf
@@2:
ELSE
@@1:
ENDIF
        xor ax,ax
        mov es,ax
        mov eax,es:[46Ch]
        mov TimeEnd,eax
        pop es

        mov dx,03F2h
        mov al,0Ch
        out dx,al

        inc Done
        mov eax,CallBackSig
        xor bx,bx
l:
        test TSecBad,0FFFFh
        jz @@1
        or bx,100h
@@1:    test WriteEn,0FFh
        jz @@2
        or bx,1
@@2:    int 13h
        retn

;
; WriteAll - zapise vsechno
;

WriteAll:
        call PhaseTest
        mov al,1
        jmp WriteCommon

;
; WriteChg - zapise zmenene
;

WriteChg:
        call PhaseTest
        mov al,2
WriteCommon:
        push es si
        shl si,5
        mov bx,dx
        test word ptr bufslot[ si+ohandle ],0FFFFh
        mov bp, XBufEmpty
        jz Error2
        mov dx,bx
        pop si es
        jmp StartRW

;
; Process boot - does whatever needed with boot record
;

ProcessBoot:
        Debug 'Processing boot...'
        mov bp,XBadBoot
        mov ax,es:[ bnumsec + di ]
        mov numsec,al
        mov sec2r,al
        or al,al
        jz Error3
        mov ax,es:[ bnumhead + di ]
        mov numhead,al
        or al,al
        jz Error3

        mov ax,es:[ btotsec + di ]
        mov dx,ax                       ; Schovam si pocet sektoru
        div numsec
        or ah,ah
        jnz Error3
        div numhead
        or ah,ah
        jnz Error3
        mov numcyl,al

        mov ah,0
        cmp al,50
        ja @@2
        inc ah
@@2:    mov DStep,ah

        test WriteEn,0FFh
        jnz @@3
; Cteni
        call allocbuf
        mov bp,XNoMem
        jc Error3
        jmp @@4
; Zapis
@@3:
        shl si,5
        mov bp,XBadForm
        mov al,numhead
        cmp bufslot [si+ohead],al
        jne Error3
        mov al,numsec
        cmp bufslot [si+osec],al
        jne Error3
        mov al,numcyl
        cmp bufslot [si+ocyl],al
        jne Error3
@@4:
        Debug '...done'
        retn
;
; Start Read - v DX cislo disku
;

bnumsec  equ 18h
bnumhead equ 1Ah
btotsec  equ 13h

PhaseTest:
        mov bx,XWorking
        test phase,7Fh
        jnz @@2
        mov bx,dx
        and bx,1
        test byte ptr Drive0[bx],0FFh
        jnz @@1
        mov bp,XNoDrive
@@2:    pop ax         ; Exit; Exit;
@@1:    retn

StartRead:
        call PhaseTest

        push dx si
        call FreeMem
        pop si dx
        xor al,al

StartRW:
        mov buf,si
        mov WriteEn,al
        mov disk,dl
        xor bx,bx
        mov bl,dl
        mov bl,cs:[secslid0+bx]
        mov secslid,bl

        xor ax,ax
        mov sec,al
        mov cyl,al
        mov head,al
        mov SecBad,al
        mov TSecBad,ax
;
; Nacti boot sector
;
        Debug 'Reading boot...'
        push es
        mov bp,4
Retry:
        mov ah,0
        pushf
        push cs
        call old13

        mov cx,1
        mov ax,0201h
        mov bx,offset buffer
        push cs
        pop es
        pushf
        push cs
        call old13
        jc ErrorReading

        mov di,offset buffer
        call ProcessBoot

IF Win
        test WriteEn,0FFh
        jz @@1
        call LockBuf
        mov bp,XNoMem
        or ebx,ebx
        jz Error2
@@1:

ENDIF
        Debug 'Starting timer...'
        xor ax,ax
        mov es,ax
        mov eax,es:[46Ch]
        mov TimeStart,eax

        cmp WriteEn,2
        jne @@5
        call GetBitArray
        call WNextSec
        cmp Phase,4
        je NothingToDo
        jmp @@6
@@5:    cmp WriteEn,0
        jne @@6
        call ClearNeeds
@@6:
        pop es

        Debug 'Starting action...'
        pushf
        push cs
        call SeekNow2
        mov bp,XOK
        retn

NothingToDo:
        mov Phase,80h
        call ReadDone

        pop es
        mov bp,XOK
        retn

;
; Clear "needs writing" flags, needs si>>5 buffer number
;
ClearNeeds:
        push cs
        pop es
        mov bx,offset buffer
        mov di,bx
        mov cx,512
        movzx eax,cx
        mov Num,eax
        xor ax,ax
        rep stosb
        jmp ToXMS

;
; Retry & error handling
;

ErrorReading:
        dec bp
        jnz Retry
ErrorGetStat:
        mov bp,XReadBoot
Error2:
        pop es
        retn
Error3: pop ax
        jmp error2

SeekNow2:
        pushax
        push es ds
        jmp SeekNow

        assume ds:nothing

