IOS_HACK        equ 1

; Beep
; DX=period * 1193180, CL=duration * 100

dobell:
	cli
	in	al,61h		; Stop old tone
	and	al,0fch
	out	61h,al

        mov bl,3
        or dx,dx
        jnz @@1
        mov bl,1
        mov dx,200
@@1:

        mov     al,10000110b    ; Initialize the timer: mode
;                  |||||||\--- Binary
;                  ||||\\\---- Mode 3 - generate square wave
;                  ||\\------- Latch value
;                  \\--------- Chanel 2
	out	43h,al
	mov	ax,dx
	out	42h,al		; Period
	xchg	al,ah
	out	42h,al

        in      al,61h          ; Start the tone
        or      al,bl
; Speaker enabled/disabled, feed it from timer, chanel 2
        out     61h,al

        ifndef  IOS_HACK
	sti
	endif

	mov	bx,dx
	xor	ch,ch
	inc	cx
	mov	ax,11932
	mul	cx
	mov	cx,ax		; DXCX = number of clock ticks to wait
	mov	bp,bx		; BP=period
	shr	bx,1		; BX=half of period
setbe1:	call	reacnt
	cmp	ax,bx
	jnc	setbe1
setbe2:	call	reacnt
	cmp	ax,bx
	jc	setbe2
	sub	cx,bp
	jnc	setbe1
	dec	dx
	jns	setbe1

	ifndef	IOS_HACK
	cli
	endif

	in	al,61h		; Stop the tone
	and	al,0fch
	out	61h,al
	sti
	ret

reacnt:
	ifndef	IOS_HACK
	cli
	endif

	mov	al,10000110b	; Latch present value
	out	43h,al
	in	al,42h		; Read channel 2 counter
	xchg	ah,al
	in	al,42h
	xchg	ah,al

        ifndef  IOS_HACK
        sti
	endif

	ret
