;;
;; ffix -- fix up the FWAIT bug in the Microsoft FPU emulation library used
;;         in QuickBASIC 4.x; PDS 6+ and VBDOS 1 interpreters and compilers.
;;
;; copyleft 1998 by v1ctor [av1ctor@yahoo.com.br]
;;
;; QB prototype: declare sub ffix ()
;;
;; to assemble: tasm ffix
;;          or: masm ffix _or_ ml /c ffix.asm
;;          or: a86 +so ffix.asm
;;
;; to add to a library: lib _libfilename_ +ffix;

                .model  medium, basic
                .186

.code
old_int3d       dd      ?
installed       db      0

;;::::::::::::::::::
int3d:          push    bp
                mov     bp, sp
                push    ds

                lds     bp, [bp + 2]            ;; ds:bp -> return address                
                mov     word ptr ds:[bp-2],909Bh;; fix up with: fwait; nop

                pop     ds
                pop     bp
                iret

;;::::::::::::::::::
done:           ;; restore old interrupt 3Dh vector
                push    ds
                lds     dx, cs:old_int3d
                mov     ax, 253Dh               ;; set int vector
                int     21h
                pop     ds

                mov     cs:installed, 0
                retf

;;::::::::::::::::::
                public  ffix
ffix            proc

                cmp     cs:installed, 0
                jne     exit                    ;; already installed?
                mov     cs:installed, 1

                ;; add done proc to QB exit queue
                push    cs
                push    offset done
                extrn   B_ONEXIT:far
                call    B_ONEXIT

                ;; save old interrupt 3Dh vector
                push    es
                mov     ax, 353Dh               ;; get int vector
                int     21h
                mov     word ptr old_int3d+0, bx
                mov     word ptr old_int3d+2, es
                pop     es

                ;; point the vector to int3d ISR
                push    ds
                mov     ax, cs
                mov     ds, ax
                mov     dx, offset int3d
                mov     ax, 253Dh               ;; set int vector
                int     21h
                pop     ds

exit:           retf
ffix            endp
                end
