;**************************************************************************
;*                     This file is part of the                           *
;*                      Mpxplay - audio player.                           *
;*                  The source code of Mpxplay is                         *
;*        (C) copyright 1998-2006 by PDSoft (Attila Padar)                *
;*                    http://mpxplay.cjb.net                              *
;*                  email: mpxplay@freemail.hu                            *
;**************************************************************************
;*  This program is distributed in the hope that it will be useful,       *
;*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
;*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
;*  Please contact with the author (with me) if you want to use           *
;*  or modify this source.                                                *
;**************************************************************************
;function: Audio MPEG Layer II & III sub-routines (subband-synthesis)
;based on the MPG123 MPEG decoder source + ideas from some others
;
;32-bit float output
;

.387
.386p
.model flat
		PUBLIC	mpxdec_synth_granule_
		PUBLIC	mpxdec_synth_init_

                PUBLIC	mpxdec_synth_granule
		PUBLIC	mpxdec_synth_init

DGROUP		GROUP	CONST,CONST2,_DATA,_BSS
_TEXT		SEGMENT	BYTE PUBLIC USE32 'CODE'
		ASSUME CS:_TEXT, DS:DGROUP, SS:DGROUP

;-------------------------------------------------------------------------
mpxdec_synth_granule:
push edx
push ebx
push ecx
mov eax,dword ptr [esp+ 4+12];
mov edx,dword ptr [esp+ 8+12];
mov ebx,dword ptr [esp+12+12];
mov ecx,dword ptr [esp+16+12];
call mpxdec_synth_granule_
pop ecx
pop ebx
pop edx
ret

;eax=bandPtr edx=((bo<<8)|channels) ebx=pcmout ecx=synth_rollbuff
mpxdec_synth_granule_:
 push      ecx
 push      esi
 push      edi
 push      ebp
 mov       ebp,esp
 sub       esp,352                      ; 32 + 2 * 16*10

;  -4[ebp] : bo1
;  -8[ebp] : loc_bandptr
; -12[ebp] : bo
; -16[ebp] : loc_rollbuff
; -20[ebp] : b0
; -24[ebp] : loc_pcmout
; -28[ebp] : ss
; -192[ebp]: b1 (tmp in dct64)
; -352[ebp]: b2

 add  eax,120                        ;dct64 addressing (-120[edi])
 mov  dword ptr  -8[ebp],eax         ;loc_bandptr=bandPtr_p
 mov  dword ptr -16[ebp],ecx         ;loc_rollbuff=synth_rollbuff
 mov  dword ptr -24[ebp],ebx         ;loc_pcmout=pcmout
 mov  eax,edx                        ;
 shr  eax,8                          ;
 mov  dword ptr -12[ebp],eax         ;bo=(edx>>8)
 and  edx,0x7f                       ;channels=edx&0x7f

 mov  dword ptr -28[ebp],18          ;ss=18
 cmp  edx,2                          ;
 jne  L$19                           ;if(channels==2){
L$1:                                  ;do{ // while(--ss)
  mov  ebx,dword ptr -12[ebp]          ;
  dec  ebx                             ;bo--
  and  ebx,15                          ;bo&=0xf
  mov  dword ptr -12[ebp],ebx          ;
  mov  edi,ebx                         ;
  shl  edi,2                           ;bo1=bo (addressing for window[])(*4)
  mov  esi,edi                         ;
  shl  esi,1                           ;
  mov  edx,ebx                         ;
  shl  edx,1                           ;
  add  edx,esi                         ;addressing bo (for bufp0)(*10)
  mov  eax,dword ptr -16[ebp]          ;bufp0 = loc_rollbuff
  mov  ecx,eax                         ;b0=bufp0
  test bl,1                            ;
  jz   L$2                             ;if(bo&1){
   lea  edx,[eax+edx]                  ; bufp1=bufp0+bo
   inc  ebx                            ;
   and  ebx,15                         ;
   mov  esi,ebx                        ;
   shl  esi,3                          ;
   shl  ebx,1                          ;
   add  ebx,esi                        ;
   lea  eax,[eax+ebx+2720]             ; bufp0+=((bo+1)&0xf)+SYNTHBUF_SIZE
  jmp  L$3                             ;}else{
L$2:                                   ;
   add  eax,edx                        ; bufp0+=bo
   lea  edx,[eax+2730]                 ; bufp1=bufp0+SYNTHBUF_SIZE+1
   add  ecx,2720                       ; b0+=SYNTHBUF_SIZE
   add  edi,4                          ; bo1++
L$3:                                   ;}
  mov  dword ptr -20[ebp],ecx          ;->b0
  mov  dword ptr  -4[ebp],edi          ;->bo1
  lea  ebx,-112[ebp]                   ;b1 (tmpbuf)  + 8*10
  lea  ecx,-272[ebp]                   ;b2 (tmpbuf-16*10 + 8*10)
  mov  edi,dword ptr  -8[ebp]          ;bandPtr=loc_bandptr;
  mov  esi,offset FLAT:_dct64costab+120;dct64costab+12
  call near ptr FLAT:dct64_1_          ;dct64_1(bufp0,bufp1,b1,b2,bandPtr,dct64costab)
  add  eax,5440                        ;bufp0+=2*SYNTHBUF_SIZE;
  add  edx,5440                        ;bufp1+=2*SYNTHBUF_SIZE;
  add  edi,5760                        ;bandPtr+=SBLIMIT*SSLIMIT;
  call near ptr FLAT:dct64_1_          ;dct64_1(bufp0,bufp1,b1,b2,bandPtr,dct64costab)
  sub  edi,5440                        ;bandPtr-=(SSLIMIT-1)*SBLIMIT;
  mov  dword ptr  -8[ebp],edi          ;loc_bandptr=bandPtr;

  mov  ebx,dword ptr -24[ebp]          ;pcm_out=loc_pcmout
  mov  edx,dword ptr FLAT:_decwin16    ;
  sub  edx,dword ptr  -4[ebp]          ;window = decwin16 - bo1;
  mov  edi,dword ptr -20[ebp]          ;b0
  add  edi,40                          ;b0+=4
  lea  esi,5440[edi]                   ;b1=b0+2*SYNTHBUF_SIZE
  mov  ecx,16                          ;j=16
L$4:                                   ;do{
   fild   dword ptr   4[edx]
   fld    tbyte ptr -30[edi]
   fmul   st,st(1)
   fld    tbyte ptr -30[esi]
   fmulp  st(2),st
   fild   dword ptr   0[edx]
   fld    tbyte ptr -40[edi]
   fmul   st,st(1)
   fld    tbyte ptr -40[esi]
   fmulp  st(2),st
   fsubp  st(2),st
   fsubp  st(2),st
   fild   dword ptr   8[edx]
   fld    tbyte ptr -20[edi]
   fmul   st,st(1)
   fld    tbyte ptr -20[esi]
   fmulp  st(2),st
   fsubp  st(2),st
   fsubp  st(2),st
   fild   dword ptr  12[edx]
   fld    tbyte ptr -10[edi]
   fmul   st,st(1)
   fld    tbyte ptr -10[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr  16[edx]
   fld    tbyte ptr   0[edi]
   fmul   st,st(1)
   fld    tbyte ptr   0[esi]
   fmulp  st(2),st
   fsubp  st(2),st
   fsubp  st(2),st
   fild   dword ptr  20[edx]
   fld    tbyte ptr  10[edi]
   fmul   st,st(1)
   fld    tbyte ptr  10[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr  24[edx]
   fld    tbyte ptr  20[edi]
   fmul   st,st(1)
   fld    tbyte ptr  20[esi]
   fmulp  st(2),st
   fsubp  st(2),st
   fsubp  st(2),st
   fild   dword ptr  28[edx]
   fld    tbyte ptr  30[edi]
   fmul   st,st(1)
   fld    tbyte ptr  30[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr  32[edx]
   fld    tbyte ptr  40[edi]
   fmul   st,st(1)
   fld    tbyte ptr  40[esi]
   fmulp  st(2),st
   fsubp  st(2),st
   fsubp  st(2),st
   fild   dword ptr  36[edx]
   fld    tbyte ptr  50[edi]
   fmul   st,st(1)
   fld    tbyte ptr  50[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr  40[edx]
   fld    tbyte ptr  60[edi]
   fmul   st,st(1)
   fld    tbyte ptr  60[esi]
   fmulp  st(2),st
   fsubp  st(2),st
   fsubp  st(2),st
   fild   dword ptr  44[edx]
   fld    tbyte ptr  70[edi]
   fmul   st,st(1)
   fld    tbyte ptr  70[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr  48[edx]
   fld    tbyte ptr  80[edi]
   fmul   st,st(1)
   fld    tbyte ptr  80[esi]
   fmulp  st(2),st
   fsubp  st(2),st
   fsubp  st(2),st
   fild   dword ptr  52[edx]
   fld    tbyte ptr  90[edi]
   fmul   st,st(1)
   fld    tbyte ptr  90[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr  56[edx]
   fld    tbyte ptr 100[edi]
   fmul   st,st(1)
   fld    tbyte ptr 100[esi]
   fmulp  st(2),st
   fsubp  st(2),st
   fsubp  st(2),st
   fild   dword ptr  60[edx]
   fld    tbyte ptr 110[edi]
   fmul   st,st(1)
   fld    tbyte ptr 110[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fmul   dword ptr FLAT:_scale         ;suml *=scale
   add    edx,128                       ;window+=32
   add    edi,160                       ;b0+=16
   add    esi,160                       ;b1+=16
   fstp   dword ptr 0[ebx]              ;pcm_out[0]=suml
   fmul   dword ptr FLAT:_scale         ;sumr *=scale
   add    ebx,8                         ;pcm_out+=2
   dec    ecx                           ;j--
   fstp   dword ptr -4[ebx]             ;pcm_out[-1]=sumr
  jne   L$4                            ;}while(j)

  fild   dword ptr   0[edx]
  fchs
  fld    tbyte ptr -40[edi]
  fmul   st,st(1)
  fld    tbyte ptr -40[esi]
  fmulp  st(2),st
  fild   dword ptr   8[edx]
  fld    tbyte ptr -20[edi]
  fmul   st,st(1)
  fld    tbyte ptr -20[esi]
  fmulp  st(2),st
  fsubp  st(2),st
  fsubp  st(2),st
  fild   dword ptr  16[edx]
  fld    tbyte ptr   0[edi]
  fmul   st,st(1)
  fld    tbyte ptr   0[esi]
  fmulp  st(2),st
  fsubp  st(2),st
  fsubp  st(2),st
  fild   dword ptr  24[edx]
  fld    tbyte ptr  20[edi]
  fmul   st,st(1)
  fld    tbyte ptr  20[esi]
  fmulp  st(2),st
  fsubp  st(2),st
  fsubp  st(2),st
  fild   dword ptr  32[edx]
  fld    tbyte ptr  40[edi]
  fmul   st,st(1)
  fld    tbyte ptr  40[esi]
  fmulp  st(2),st
  fsubp  st(2),st
  fsubp  st(2),st
  fild   dword ptr  40[edx]
  fld    tbyte ptr  60[edi]
  fmul   st,st(1)
  fld    tbyte ptr  60[esi]
  fmulp  st(2),st
  fsubp  st(2),st
  fsubp  st(2),st
  fild   dword ptr  48[edx]
  fld    tbyte ptr  80[edi]
  fmul   st,st(1)
  fld    tbyte ptr  80[esi]
  fmulp  st(2),st
  fsubp  st(2),st
  fsubp  st(2),st
  fild   dword ptr  56[edx]
  fld    tbyte ptr 100[edi]
  fmul   st,st(1)
  fld    tbyte ptr 100[esi]
  fmulp  st(2),st
  fsubp  st(2),st
  fsubp  st(2),st
  fmul   dword ptr FLAT:_scale         ;
  sub    edi,160                       ;b0-=16
  sub    esi,160                       ;b1-=16
  mov    ecx,dword ptr  -4[ebp]        ;
  shl    ecx,1                         ;
  sub    ecx,132                       ;
  add    edx,ecx                       ;window+=(bo1<<1)-33
  fstp   dword ptr   0[ebx]            ;pcm_out[0]=suml
  fmul   dword ptr FLAT:_scale         ;
  add    ebx,8                         ;pcm_out+=2
  fstp   dword ptr  -4[ebx]            ;pcm_out[-1]=sumr

  mov    ecx,15                        ;j=15
L$13:                                  ;do{
   fild   dword ptr   0[edx]
   fld    tbyte ptr -40[edi]
   fmul   st,st(1)
   fld    tbyte ptr -40[esi]
   fmulp  st(2),st
   fild   dword ptr  -4[edx]
   fld    tbyte ptr -30[edi]
   fmul   st,st(1)
   fld    tbyte ptr -30[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr  -8[edx]
   fld    tbyte ptr -20[edi]
   fmul   st,st(1)
   fld    tbyte ptr -20[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr -12[edx]
   fld    tbyte ptr -10[edi]
   fmul   st,st(1)
   fld    tbyte ptr -10[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr -16[edx]
   fld    tbyte ptr   0[edi]
   fmul   st,st(1)
   fld    tbyte ptr   0[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr -20[edx]
   fld    tbyte ptr  10[edi]
   fmul   st,st(1)
   fld    tbyte ptr  10[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr -24[edx]
   fld    tbyte ptr  20[edi]
   fmul   st,st(1)
   fld    tbyte ptr  20[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr -28[edx]
   fld    tbyte ptr  30[edi]
   fmul   st,st(1)
   fld    tbyte ptr  30[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr -32[edx]
   fld    tbyte ptr  40[edi]
   fmul   st,st(1)
   fld    tbyte ptr  40[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr -36[edx]
   fld    tbyte ptr  50[edi]
   fmul   st,st(1)
   fld    tbyte ptr  50[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr -40[edx]
   fld    tbyte ptr  60[edi]
   fmul   st,st(1)
   fld    tbyte ptr  60[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr -44[edx]
   fld    tbyte ptr  70[edi]
   fmul   st,st(1)
   fld    tbyte ptr  70[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr -48[edx]
   fld    tbyte ptr  80[edi]
   fmul   st,st(1)
   fld    tbyte ptr  80[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr -52[edx]
   fld    tbyte ptr  90[edi]
   fmul   st,st(1)
   fld    tbyte ptr  90[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr -56[edx]
   fld    tbyte ptr 100[edi]
   fmul   st,st(1)
   fld    tbyte ptr 100[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fild   dword ptr -60[edx]
   fld    tbyte ptr 110[edi]
   fmul   st,st(1)
   fld    tbyte ptr 110[esi]
   fmulp  st(2),st
   faddp  st(2),st
   faddp  st(2),st
   fmul   dword ptr FLAT:_scale         ;
   sub    edx,128                       ;window-=32
   sub    edi,160                       ;b0-=16
   sub    esi,160                       ;b1-=16
   fstp   dword ptr 0[ebx]              ;pmc_out[0]=suml
   fmul   dword ptr FLAT:_scale         ;
   add    ebx,8                         ;pcm_out+=2
   dec    ecx                           ;j--
   fstp   dword ptr -4[ebx]             ;pcm_out[-1]=sumr
  jne   L$13                           ;}while(j)
  mov  dword ptr -24[ebp],ebx          ;loc_pcmout=pcm_out
  dec  dword ptr -28[ebp]              ;ss--
 jnz  L$1                             ;}while(ss)
jmp  near ptr L$30                   ;}else{ // channels==1
L$19:                                  ;do{ // while(--ss)
  mov  ebx,dword ptr -12[ebp]          ;
  dec  ebx                             ;bo--
  and  ebx,15                          ;bo&=0xf
  mov  dword ptr -12[ebp],ebx          ;
  mov  edi,ebx                         ;
  shl  edi,2                           ;bo1=bo (addressing for window[])(*4)
  mov  esi,edi                         ;
  shl  esi,1                           ;
  mov  edx,ebx                         ;
  shl  edx,1                           ;
  add  edx,esi                         ;addressing bo (for bufp0)(*10)
  mov  eax,dword ptr -16[ebp]          ;bufp0 = loc_rollbuff
  mov  ecx,eax                         ;b0=bufp0
  test bl,1                            ;
  jz   L$20                            ;if(bo&1){
   lea  edx,[eax+edx]                  ; bufp1=bufp0+bo
   inc  ebx                            ;
   and  ebx,15                         ;
   mov  esi,ebx                        ;
   shl  esi,3                          ;
   shl  ebx,1                          ;
   add  ebx,esi                        ;
   lea  eax,[eax+ebx+2720]             ; bufp0+=((bo+1)&0xf)+SYNTHBUF_SIZE
  jmp  L$21                            ;}else{
L$20:                                  ;
   add  eax,edx                        ; bufp0+=bo
   lea  edx,[eax+2730]                 ; bufp1=bufp0+SYNTHBUF_SIZE+1
   add  ecx,2720                       ; b0+=SYNTHBUF_SIZE
   add  edi,4                          ; bo1++
L$21:                                  ;}
  mov  dword ptr -20[ebp],ecx          ;->b0
  mov  dword ptr  -4[ebp],edi          ;->bo1
  lea  ebx,-112[ebp]                   ;b1 (tmpbuf)  + 8*10
  lea  ecx,-272[ebp]                   ;b2 (tmpbuf-16*10 + 8*10)
  mov  edi,dword ptr  -8[ebp]          ;bandPtr=loc_bandptr;
  mov  esi,offset FLAT:_dct64costab+120;dct64costab+12
  call near ptr FLAT:dct64_1_          ;dct64_1(bufp0,bufp1,b1,b2,bandPtr,dct64costab)
  add  edi,320                         ;bandPtr+=SBLIMIT;
  mov  dword ptr  -8[ebp],edi          ;loc_bandptr=bandPtr;

  mov  ebx,dword ptr -24[ebp]          ;pcm_out=loc_pcmout
  mov  edx,dword ptr FLAT:_decwin16    ;
  sub  edx,dword ptr  -4[ebp]          ;window = decwin16 - bo1;
  mov  edi,dword ptr -20[ebp]          ;b0
  add  edi,40                          ;
  mov  ecx,16                          ;j=16
L$22:                                  ;do{
   fld    tbyte ptr  -30[edi]           ;
   fimul  dword ptr    4[edx]           ;
   fld    tbyte ptr  -40[edi]           ;
   fimul  dword ptr    0[edx]           ;
   fsubp  st(1),st                      ;
   fld    tbyte ptr  -20[edi]           ;
   fimul  dword ptr    8[edx]           ;
   fsubp  st(1),st                      ;
   fld    tbyte ptr  -10[edi]           ;
   fimul  dword ptr   12[edx]           ;
   faddp  st(1),st                      ;
   fld    tbyte ptr    0[edi]           ;
   fimul  dword ptr   16[edx]           ;
   fsubp  st(1),st                      ;
   fld    tbyte ptr   10[edi]           ;
   fimul  dword ptr   20[edx]           ;
   faddp  st(1),st                      ;
   fld    tbyte ptr   20[edi]           ;
   fimul  dword ptr   24[edx]           ;
   fsubp  st(1),st                      ;
   fld    tbyte ptr   30[edi]           ;
   fimul  dword ptr   28[edx]           ;
   faddp  st(1),st                      ;
   fld    tbyte ptr   40[edi]           ;
   fimul  dword ptr   32[edx]           ;
   fsubp  st(1),st                      ;
   fld    tbyte ptr   50[edi]           ;
   fimul  dword ptr   36[edx]           ;
   faddp  st(1),st                      ;
   fld    tbyte ptr   60[edi]           ;
   fimul  dword ptr   40[edx]           ;
   fsubp  st(1),st                      ;
   fld    tbyte ptr   70[edi]           ;
   fimul  dword ptr   44[edx]           ;
   faddp  st(1),st                      ;
   fld    tbyte ptr   80[edi]           ;
   fimul  dword ptr   48[edx]           ;
   fsubp  st(1),st                      ;
   fld    tbyte ptr   90[edi]           ;
   fimul  dword ptr   52[edx]           ;
   faddp  st(1),st                      ;
   fld    tbyte ptr  100[edi]           ;
   fimul  dword ptr   56[edx]           ;
   fsubp  st(1),st                      ;
   fld    tbyte ptr  110[edi]           ;
   fimul  dword ptr   60[edx]           ;
   faddp  st(1),st                      ;
   fmul   dword ptr FLAT:_scale         ;sum *=scale
   add    edx,128                       ;
   add    edi,160                       ;
   fstp   dword ptr   0[ebx]            ;
   add    ebx,4                         ;
   dec    ecx                           ;
  jne    L$22                          ;}while(--j)
  fld    tbyte ptr  -40[edi]           ;
  fchs                                 ;
  fimul  dword ptr    0[edx]           ;
  fld    tbyte ptr  -20[edi]           ;
  fimul  dword ptr    8[edx]           ;
  fsubp  st(1),st                      ;
  fld    tbyte ptr    0[edi]           ;
  fimul  dword ptr   16[edx]           ;
  fsubp  st(1),st                      ;
  fld    tbyte ptr   20[edi]           ;
  fimul  dword ptr   24[edx]           ;
  fsubp  st(1),st                      ;
  fld    tbyte ptr   40[edi]           ;
  fimul  dword ptr   32[edx]           ;
  fsubp  st(1),st                      ;
  fld    tbyte ptr   60[edi]           ;
  fimul  dword ptr   40[edx]           ;
  fsubp  st(1),st                      ;
  fld    tbyte ptr   80[edi]           ;
  fimul  dword ptr   48[edx]           ;
  fsubp  st(1),st                      ;
  fld    tbyte ptr  100[edi]           ;
  fimul  dword ptr   56[edx]           ;
  fsubp  st(1),st                      ;
  fmul   dword ptr FLAT:_scale         ;sum *=scale
  sub    edi,160                       ;
  mov    ecx,dword ptr  -4[ebp]        ;
  shl    ecx,1                         ;
  sub    ecx,132                       ;
  add    edx,ecx                       ;
  fstp   dword ptr   0[ebx]            ;
  add    ebx,4                         ;

  mov    ecx,15                        ;j=15
L$27:                                  ;do{
   fld    tbyte ptr  -40[edi]           ;
   fimul  dword ptr    0[edx]
   fld    tbyte ptr  -30[edi]    ;
   fimul  dword ptr   -4[edx]
   fadd
   fld    tbyte ptr  -20[edi]    ;
   fimul  dword ptr   -8[edx]
   fadd
   fld    tbyte ptr  -10[edi]    ;
   fimul  dword ptr  -12[edx]
   fadd
   fld    tbyte ptr    0[edi]    ;
   fimul  dword ptr  -16[edx]
   fadd
   fld    tbyte ptr   10[edi]    ;
   fimul  dword ptr  -20[edx]
   fadd
   fld    tbyte ptr   20[edi]    ;
   fimul  dword ptr  -24[edx]
   fadd
   fld    tbyte ptr   30[edi]    ;
   fimul  dword ptr  -28[edx]
   fadd
   fld    tbyte ptr   40[edi]    ;
   fimul  dword ptr  -32[edx]
   fadd
   fld    tbyte ptr   50[edi]    ;
   fimul  dword ptr  -36[edx]
   fadd
   fld    tbyte ptr   60[edi]    ;
   fimul  dword ptr  -40[edx]
   fadd
   fld    tbyte ptr   70[edi]    ;
   fimul  dword ptr  -44[edx]
   fadd
   fld    tbyte ptr   80[edi]    ;
   fimul  dword ptr  -48[edx]
   fadd
   fld    tbyte ptr   90[edi]    ;
   fimul  dword ptr  -52[edx]
   fadd
   fld    tbyte ptr  100[edi]    ;
   fimul  dword ptr  -56[edx]
   fadd
   fld    tbyte ptr  110[edi]    ;
   fimul  dword ptr  -60[edx]
   fadd
   fmul   dword ptr FLAT:_scale         ;sum *=scale
   sub    edx,128
   sub    edi,160
   fstp   dword ptr   0[ebx]
   add    ebx,4                         ;pcm_out++
   dec    ecx                           ;j--
  jne    L$27                          ;}while(j)
  mov    dword ptr -24[ebp],ebx        ;loc_pcmout=pcm_out
  dec    dword ptr -28[ebp]            ;ss--
 jnz    L$19                          ;}while(ss)

L$30:
mov    eax,dword ptr -24[ebp]    ;return loc_pcmout

mov    esp,ebp
pop    ebp
pop    edi
pop    esi
pop    ecx

ret

;---------------------------------------------------------------------------
; eax=out0, edx=out1, ebx=b1, ecx=b2, edi=bandPtr, esi=dct64costab
dct64_1_:

 fld    tbyte ptr -120[edi]  ;
 fld    tbyte ptr  190[edi]  ;
 fadd                        ; tmp0=samples[0x00]+samples[0x1f]
 fld   st                    ;
 fld    tbyte ptr   30[edi]  ;
 fld    tbyte ptr   40[edi]  ;
 fadd                        ; tmp1=samples[0x0f]+samples[0x10]
 fadd  st(2),st              ; tmp2=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr   40[esi]  ;
 fmul                        ; tmp3=(tmp0-tmp1)*costab[16]
 fld    tbyte ptr  -50[edi]  ;
 fld    tbyte ptr  120[edi]  ;
 fadd                        ; tmp0=samples[0x07]+samples[0x18]
 fld    tbyte ptr  -40[edi]  ;
 fld    tbyte ptr  110[edi]  ;
 fadd                        ; tmp1=samples[0x08]+samples[0x17]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -80[ebx]  ; b1[0x00]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr  110[esi]  ;
 fmul                        ; tmp4=(tmp0-tmp1)*costab[23]
 fld    tbyte ptr  -90[edi]  ;
 fld    tbyte ptr  160[edi]  ;
 fadd                        ; tmp0=samples[0x03]+samples[0x1c]
 fld    tbyte ptr    0[edi]  ;
 fld    tbyte ptr   70[edi]  ;
 fadd                        ; tmp1=samples[0x0c]+samples[0x13]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -70[ebx]  ; b1[0x01]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr   70[esi]  ;
 fmul                        ; tmp5=(tmp0-tmp1)*costab[19]
 fld    tbyte ptr  -80[edi]  ;
 fld    tbyte ptr  150[edi]  ;
 fadd                        ; tmp0=samples[0x04]+samples[0x1b]
 fld    tbyte ptr  -10[edi]  ;
 fld    tbyte ptr   80[edi]  ;
 fadd                        ; tmp1=samples[0x0b]+samples[0x14]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -60[ebx]  ; b1[0x02]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr   80[esi]  ;
 fmul                        ; tmp6=(tmp0-tmp1)*costab[20]
fld   st(3)                  ;
 fadd  st,st(3)              ; tmp0=tmp3+tmp4
 fld   st(2)                 ;
 fadd  st,st(2)              ; tmp1=tmp5+tmp6
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr    0[ecx]  ; b2[0x08]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr  160[esi]  ;
 fmul                        ;
 fstp   tbyte ptr   30[ecx]  ; b2[0x0b]=(tmp0-tmp1)*costab[28]
fsubp st(1),st               ;
 fld    tbyte ptr  150[esi]  ;
 fmul                        ; tmp0=(tmp3-tmp4)*costab[27]
 fxch  st(2)                 ;
 fsubrp st(1),st             ;
 fld    tbyte ptr  120[esi]  ;
 fmul                        ; tmp1=(tmp5-tmp6)*costab[24]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr   40[ecx]  ; b2[0x0c]=tmp0+tmp1
 fsubrp st(1),st             ;
 fld    tbyte ptr  160[esi]  ;
 fmul                        ;
 fstp   tbyte ptr   70[ecx]  ; b2[0x0f]=(tmp0-tmp1)*costab[28]
fld   st                     ;
 fld    tbyte ptr  -80[ebx]  ;
 fadd                        ; tmp0=tmp2+b1[0x00]
 fld    tbyte ptr  -70[ebx]  ;
 fld    tbyte ptr  -60[ebx]  ;
 fadd                        ; tmp1=b1[0x01]+b1[0x02]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -80[ecx]  ; b2[0x00]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr  160[esi]  ;
 fmul                        ;
 fstp   tbyte ptr  -50[ecx]  ; b2[0x03]=(tmp0-tmp1)*costab[28]
 fld    tbyte ptr  -80[ebx]  ;
 fsub                        ;
 fld    tbyte ptr  120[esi]  ;
 fmul                        ; tmp0=(tmp2-b1[0x00])*costab[24]
 fld    tbyte ptr  -70[ebx]  ;
 fld    tbyte ptr  -60[ebx]  ;
 fsub                        ;
 fld    tbyte ptr  150[esi]  ;
 fmul                        ; tmp1=(b1[0x01]-b1[0x02])*costab[27]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -40[ecx]  ; b2[0x04]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr  160[esi]  ;
 fmul                        ;
 fstp   tbyte ptr  -10[ecx]  ; b2[0x07]=(tmp0-tmp1)*costab[28]
;-----------------------------------------------------------
 fld    tbyte ptr -110[edi]  ;
 fld    tbyte ptr  180[edi]  ;
 fadd                        ; tmp0=samples[0x01]+samples[0x1e]
 fld   st                    ;
 fld    tbyte ptr   20[edi]  ;
 fld    tbyte ptr   50[edi]  ;
 fadd                        ; tmp1=samples[0x0e]+samples[0x11]
 fadd  st(2),st              ; tmp2=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr   50[esi]  ;
 fmul                        ; tmp3=(tmp0-tmp1)*costab[17]
 fld    tbyte ptr  -60[edi]  ;
 fld    tbyte ptr  130[edi]  ;
 fadd                        ; tmp0=samples[0x06]+samples[0x19]
 fld    tbyte ptr  -30[edi]  ;
 fld    tbyte ptr  100[edi]  ;
 fadd                        ; tmp1=samples[0x09]+samples[0x16]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -80[ebx]  ; b1[0x00]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr  100[esi]  ;
 fmul                        ; tmp4=(tmp0-tmp1)*costab[22]
 fld    tbyte ptr -100[edi]  ;
 fld    tbyte ptr  170[edi]  ;
 fadd                        ; tmp0=samples[0x02]+samples[0x1d]
 fld    tbyte ptr   10[edi]  ;
 fld    tbyte ptr   60[edi]  ;
 fadd                        ; tmp1=samples[0x0d]+samples[0x12]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -70[ebx]  ; b1[0x01]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr   60[esi]  ;
 fmul                        ; tmp5=(tmp0-tmp1)*costab[18]
 fld    tbyte ptr  -70[edi]  ;
 fld    tbyte ptr  140[edi]  ;
 fadd                        ; tmp0=samples[0x05]+samples[0x1a]
 fld    tbyte ptr  -20[edi]  ;
 fld    tbyte ptr   90[edi]  ;
 fadd                        ; tmp1=samples[0x0a]+samples[0x15]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -60[ebx]  ; b1[0x02]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr   90[esi]  ;
 fmul                        ; tmp6=(tmp0-tmp1)*costab[21]
fld   st(3)                  ;
 fadd  st,st(3)              ; tmp0=tmp3+tmp4
 fld   st(2)                 ;
 fadd  st,st(2)              ; tmp1=tmp5+tmp6
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr   10[ecx]  ; b2[0x09]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr  170[esi]  ;
 fmul                        ;
 fstp   tbyte ptr   20[ecx]  ; b2[0x0a]=(tmp0-tmp1)*costab[29]
fsubp st(1),st               ;
 fld    tbyte ptr  140[esi]  ;
 fmul                        ; tmp0=(tmp3-tmp4)*costab[26]
 fxch  st(2)                 ;
 fsubrp st(1),st             ;
 fld    tbyte ptr  130[esi]  ;
 fmul                        ; tmp1=(tmp5-tmp6)*costab[25]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr   50[ecx]  ; b2[0x0d]=tmp0+tmp1
 fsubrp st(1),st             ;
 fld    tbyte ptr  170[esi]  ;
 fmul                        ;
 fstp   tbyte ptr   60[ecx]  ; b2[0x0e]=(tmp0-tmp1)*costab[29]
fld   st                     ;
 fld    tbyte ptr  -80[ebx]  ;
 fadd                        ; tmp0=tmp2+b1[0x00]
 fld    tbyte ptr  -70[ebx]  ;
 fld    tbyte ptr  -60[ebx]  ;
 fadd                        ; tmp1=b1[0x01]+b1[0x02]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -70[ecx]  ; b2[0x01]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr  170[esi]  ;
 fmul                        ;
 fstp   tbyte ptr  -60[ecx]  ; b2[0x02]=(tmp0-tmp1)*costab[29]
 fld    tbyte ptr  -80[ebx]  ;
 fsub                        ;
 fld    tbyte ptr  130[esi]  ;
 fmul                        ; tmp0=(tmp2-b1[0x00])*costab[25]
 fld    tbyte ptr  -70[ebx]  ;
 fld    tbyte ptr  -60[ebx]  ;
 fsub                        ;
 fld    tbyte ptr  140[esi]  ;
 fmul                        ; tmp1=(b1[0x01]-b1[0x02])*costab[26]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -30[ecx]  ; b2[0x05]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr  170[esi]  ;
 fmul                        ;
 fstp   tbyte ptr  -20[ecx]  ; b2[0x06]=(tmp0-tmp1)*costab[29]
;-----------------------------------------------------------

 fld    tbyte ptr  180[esi]  ; cos0 = costab[30];
 fld    tbyte ptr  -80[ecx]  ;
 fld   st                    ;
 fld    tbyte ptr  -70[ecx]  ;
 fadd                        ;
 fstp   tbyte ptr 2560[eax]  ; out0[0x10*16]= b2[0x00]+ b2[0x01]
 fld    tbyte ptr  -70[ecx]  ;
 fsub                        ;
 fmul  st,st(1)              ;
 fld st                      ;
 fstp   tbyte ptr    0[eax]  ; out0[0x10* 0]=
 fstp   tbyte ptr    0[edx]  ; out1[0x10* 0]= (b2[0x00] - b2[0x01]) * cos0
 fld    tbyte ptr  -50[ecx]  ;
 fld    tbyte ptr  -60[ecx]  ;
 fsub                        ;
 fmul  st,st(1)              ; tmp0         = (b2[0x03] - b2[0x02]) * cos0
 fld st                      ;
 fstp   tbyte ptr 1280[edx]  ; out1[0x10* 8]= tmp0
 fld    tbyte ptr  -60[ecx]  ;
 fadd                        ;
 fld    tbyte ptr  -50[ecx]  ;
 fadd                        ;
 fstp   tbyte ptr 1280[eax]  ; out0[0x10* 8]= tmp0 + b2[0x02] + b2[0x03]
 fld    tbyte ptr  -10[ecx]  ;
 fld    tbyte ptr  -20[ecx]  ;
 fsub                        ;
 fmul  st,st(1)              ; tmp2         = (b2[0x07] - b2[0x06]) * cos0
 fld st                      ;
 fstp   tbyte ptr 1920[edx]  ; out1[0x10*12]= tmp2
 fld   st                    ;
 fld    tbyte ptr  -20[ecx]  ;
 fadd                        ;
 fld    tbyte ptr  -10[ecx]  ;
 fadd                        ; tmp0         =  b2[0x06] + b2[0x07] + tmp2
 fld    tbyte ptr  -40[ecx]  ;
 fld    tbyte ptr  -30[ecx]  ;
 fadd                        ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr 1920[eax]  ; out0[0x10*12]=  b2[0x04] + b2[0x05] + tmp0
 fld    tbyte ptr  -40[ecx]  ;
 fld    tbyte ptr  -30[ecx]  ;
 fsub                        ;
 fmul  st,st(3)              ; tmp1         = (b2[0x04] - b2[0x05])*cos0
 fadd  st(1),st              ; tmp0+=tmp1
 faddp st(2),st              ; tmp2+=tmp1
 fstp   tbyte ptr  640[eax]  ; out0[0x10* 4]=  tmp0
 fstp   tbyte ptr  640[edx]  ; out1[0x10* 4]=  tmp2
;-----------------------------------------------------------
 fld    tbyte ptr   70[ecx]  ;
 fld    tbyte ptr   60[ecx]  ;
 fsub                        ;
 fmul  st,st(1)              ; tmp4         = (b2[0x0F]-b2[0x0E])*cos0
 fld st                      ;
 fstp   tbyte ptr 2240[edx]  ; out1[0x10*14]= tmp4
 fld   st                    ;
 fld    tbyte ptr   60[ecx]  ;
 fadd                        ;
 fld    tbyte ptr   70[ecx]  ;
 fadd                        ; tmp1         =  b2[0x0E] + b2[0x0F] + tmp4
 fld    tbyte ptr   40[ecx]  ;
 fld    tbyte ptr   50[ecx]  ;
 fadd                        ;
 fadd  st,st(1)              ; tmp2         =  b2[0x0C] + b2[0x0D] + tmp1
 fld    tbyte ptr    0[ecx]  ;
 fld    tbyte ptr   10[ecx]  ;
 fadd                        ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr 2240[eax]  ; out0[0x10*14]=  b2[0x08] + b2[0x09] + tmp2
 fld    tbyte ptr   40[ecx]  ;
 fld    tbyte ptr   50[ecx]  ;
 fsub                        ;
 fmul  st,st(4)              ; tmp3         = (b2[0x0C] - b2[0x0D])*cos0
 fadd  st(2),st              ; tmp1        += tmp3
 fadd  st,st(3)              ; tmp3        += tmp4
 fld    tbyte ptr    0[ecx]  ;
 fld    tbyte ptr   10[ecx]  ;
 fsub                        ;
 fmul  st,st(5)              ; tmp0         = (b2[0x08] - b2[0x09])*cos0
 fld   st(3)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  320[eax]  ; out0[0x10* 2]= tmp1 + tmp0
 fadd  st,st(1)              ;
 fstp   tbyte ptr  320[edx]  ; out1[0x10* 2]= tmp0 + tmp3
 fld    tbyte ptr   30[ecx]  ;
 fld    tbyte ptr   20[ecx]  ;
 fsub                        ;
 fmul  st,st(5)              ; tmp0         = (b2[0x0B] - b2[0x0A])*cos0
 fadd  st(1),st              ; tmp3        += tmp0
 fadd  st(4),st              ; tmp4        += tmp0
 fld    tbyte ptr   20[ecx]  ;
 fadd                        ;
 fld    tbyte ptr   30[ecx]  ;
 fadd                        ; tmp0        +=  b2[0x0A] + b2[0x0B]
 fadd  st(3),st              ; tmp1        += tmp0
 faddp st(2),st              ; tmp2        += tmp0
 fstp   tbyte ptr  960[edx]  ; out1[0x10* 6]= tmp3
 fstp   tbyte ptr 1600[eax]  ; out0[0x10*10]= tmp2
 fstp   tbyte ptr  960[eax]  ; out0[0x10* 6]= tmp1
 fstp   tbyte ptr 1600[edx]  ; out1[0x10*10]= tmp4
 fstp  st                    ; pop cos0

;*************************************************************************

 fld    tbyte ptr -120[edi]  ;
 fld    tbyte ptr  190[edi]  ;
 fsub                        ;
 fld    tbyte ptr -120[esi]  ;
 fmul                        ; tmp0=(samples[0x00]-samples[0x1f])*costab[0]
 fld   st                    ;
 fld    tbyte ptr   30[edi]  ;
 fld    tbyte ptr   40[edi]  ;
 fsub                        ;
 fld    tbyte ptr   30[esi]  ;
 fmul                        ; tmp1=(samples[0x0f]-samples[0x10])*costab[15]
 fadd  st(2),st              ; tmp2=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr   40[esi]  ;
 fmul                        ; tmp3=(tmp0-tmp1)*costab[16]
 fld    tbyte ptr  -50[edi]  ;
 fld    tbyte ptr  120[edi]  ;
 fsub                        ;
 fld    tbyte ptr  -50[esi]  ;
 fmul                        ; tmp0=(samples[0x07]-samples[0x18])*costab[7]
 fld    tbyte ptr  -40[edi]  ;
 fld    tbyte ptr  110[edi]  ;
 fsub                        ;
 fld    tbyte ptr  -40[esi]  ;
 fmul                        ; tmp1=(samples[0x08]-samples[0x17])*costab[8]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -80[ebx]  ; b1[0x00]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr  110[esi]  ;
 fmul                        ; tmp4=(tmp0-tmp1)*costab[23]
 fld    tbyte ptr  -90[edi]  ;
 fld    tbyte ptr  160[edi]  ;
 fsub                        ;
 fld    tbyte ptr  -90[esi]  ;
 fmul                        ; tmp0=(samples[0x03]-samples[0x1c])*costab[3]
 fld    tbyte ptr    0[edi]  ;
 fld    tbyte ptr   70[edi]  ;
 fsub                        ;
 fld    tbyte ptr    0[esi]  ;
 fmul                        ; tmp1=(samples[0x0c]-samples[0x13])*costab[12]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -70[ebx]  ; b1[0x01]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr   70[esi]  ;
 fmul                        ; tmp5=(tmp0-tmp1)*costab[19]
 fld    tbyte ptr  -80[edi]  ;
 fld    tbyte ptr  150[edi]  ;
 fsub                        ;
 fld    tbyte ptr  -80[esi]  ;
 fmul                        ; tmp0=(samples[0x04]-samples[0x1b])*costab[4]
 fld    tbyte ptr  -10[edi]  ;
 fld    tbyte ptr   80[edi]  ;
 fsub                        ;
 fld    tbyte ptr  -10[esi]  ;
 fmul                        ; tmp1=(samples[0x0b]-samples[0x14])*costab[11]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -60[ebx]  ; b1[0x02]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr   80[esi]  ;
 fmul                        ; tmp6=(tmp0-tmp1)*costab[20]
fld   st(3)                  ;
 fadd  st,st(3)              ; tmp0=tmp3+tmp4
 fld   st(2)                 ;
 fadd  st,st(2)              ; tmp1=tmp5+tmp6
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr    0[ecx]  ; b2[0x08]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr  160[esi]  ;
 fmul                        ;
 fstp   tbyte ptr   30[ecx]  ; b2[0x0b]=(tmp0-tmp1)*costab[28]
fsubp st(1),st               ;
 fld    tbyte ptr  150[esi]  ;
 fmul                        ; tmp0=(tmp3-tmp4)*costab[27]
 fxch  st(2)                 ;
 fsubrp st(1),st             ;
 fld    tbyte ptr  120[esi]  ;
 fmul                        ; tmp1=(tmp5-tmp6)*costab[24]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr   40[ecx]  ; b2[0x0c]=tmp0+tmp1
 fsubrp st(1),st             ;
 fld    tbyte ptr  160[esi]  ;
 fmul                        ;
 fstp   tbyte ptr   70[ecx]  ; b2[0x0f]=(tmp0-tmp1)*costab[28]
fld   st                     ;
 fld    tbyte ptr  -80[ebx]  ;
 fadd                        ; tmp0=tmp2+b1[0x00]
 fld    tbyte ptr  -70[ebx]  ;
 fld    tbyte ptr  -60[ebx]  ;
 fadd                        ; tmp1=b1[0x01]+b1[0x02]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -80[ecx]  ; b2[0x00]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr  160[esi]  ;
 fmul                        ;
 fstp   tbyte ptr  -50[ecx]  ; b2[0x03]=(tmp0-tmp1)*costab[28]
 fld    tbyte ptr  -80[ebx]  ;
 fsub                        ;
 fld    tbyte ptr  120[esi]  ;
 fmul                        ; tmp0=(tmp2-b1[0x00])*costab[24]
 fld    tbyte ptr  -70[ebx]  ;
 fld    tbyte ptr  -60[ebx]  ;
 fsub                        ;
 fld    tbyte ptr  150[esi]  ;
 fmul                        ; tmp1=(b1[0x01]-b1[0x02])*costab[27]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -40[ecx]  ; b2[0x04]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr  160[esi]  ;
 fmul                        ;
 fstp   tbyte ptr  -10[ecx]  ; b2[0x07]=(tmp0-tmp1)*costab[28]
;-----------------------------------------------------------
 fld    tbyte ptr -110[edi]  ;
 fld    tbyte ptr  180[edi]  ;
 fsub                        ;
 fld    tbyte ptr -110[esi]  ;
 fmul                        ; tmp0=(samples[0x01]-samples[0x1e])*costab[1]
 fld   st                    ;
 fld    tbyte ptr   20[edi]  ;
 fld    tbyte ptr   50[edi]  ;
 fsub                        ;
 fld    tbyte ptr   20[esi]  ;
 fmul                        ; tmp1=(samples[0x0e]-samples[0x11])*costab[14]
 fadd  st(2),st              ; tmp2=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr   50[esi]  ;
 fmul                        ; tmp3=(tmp0-tmp1)*costab[17]
 fld    tbyte ptr  -60[edi]  ;
 fld    tbyte ptr  130[edi]  ;
 fsub                        ;
 fld    tbyte ptr  -60[esi]  ;
 fmul                        ; tmp0=(samples[0x06]-samples[0x19])*costab[6]
 fld    tbyte ptr  -30[edi]  ;
 fld    tbyte ptr  100[edi]  ;
 fsub                        ;
 fld    tbyte ptr  -30[esi]  ;
 fmul                        ; tmp1=(samples[0x09]-samples[0x16])*costab[9]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -80[ebx]  ; b1[0x00]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr  100[esi]  ;
 fmul                        ; tmp4=(tmp0-tmp1)*costab[22]
 fld    tbyte ptr -100[edi]  ;
 fld    tbyte ptr  170[edi]  ;
 fsub                        ;
 fld    tbyte ptr -100[esi]  ;
 fmul                        ; tmp0=(samples[0x02]-samples[0x1d])*costab[2]
 fld    tbyte ptr   10[edi]  ;
 fld    tbyte ptr   60[edi]  ;
 fsub                        ;
 fld    tbyte ptr   10[esi]  ;
 fmul                        ; tmp1=(samples[0x0d]-samples[0x12])*costab[13]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -70[ebx]  ; b1[0x01]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr   60[esi]  ;
 fmul                        ; tmp5=(tmp0-tmp1)*costab[18]
 fld    tbyte ptr  -70[edi]  ;
 fld    tbyte ptr  140[edi]  ;
 fsub                        ;
 fld    tbyte ptr  -70[esi]  ;
 fmul                        ; tmp0=(samples[0x05]-samples[0x1a])*costab[5]
 fld    tbyte ptr  -20[edi]  ;
 fld    tbyte ptr   90[edi]  ;
 fsub                        ;
 fld    tbyte ptr  -20[esi]  ;
 fmul                        ; tmp1=(samples[0x0a]-samples[0x15])*costab[10]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -60[ebx]  ; b1[0x02]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr   90[esi]  ;
 fmul                        ; tmp6=(tmp0-tmp1)*costab[21]
fld   st(3)                  ;
 fadd  st,st(3)              ; tmp0=tmp3+tmp4
 fld   st(2)                 ;
 fadd  st,st(2)              ; tmp1=tmp5+tmp6
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr   10[ecx]  ; b2[0x09]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr  170[esi]  ;
 fmul                        ;
 fstp   tbyte ptr   20[ecx]  ; b2[0x0a]=(tmp0-tmp1)*costab[29]
fsubp st(1),st               ;
 fld    tbyte ptr  140[esi]  ;
 fmul                        ; tmp0=(tmp3-tmp4)*costab[26]
 fxch  st(2)                 ;
 fsubrp st(1),st             ;
 fld    tbyte ptr  130[esi]  ;
 fmul                        ; tmp1=(tmp5-tmp6)*costab[25]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr   50[ecx]  ; b2[0x0d]=tmp0+tmp1
 fsubrp st(1),st             ;
 fld    tbyte ptr  170[esi]  ;
 fmul                        ;
 fstp   tbyte ptr   60[ecx]  ; b2[0x0e]=(tmp0-tmp1)*costab[29]
fld   st                     ;
 fld    tbyte ptr  -80[ebx]  ;
 fadd                        ; tmp0=tmp2+b1[0x00]
 fld    tbyte ptr  -70[ebx]  ;
 fld    tbyte ptr  -60[ebx]  ;
 fadd                        ; tmp1=b1[0x01]+b1[0x02]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -70[ecx]  ; b2[0x01]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr  170[esi]  ;
 fmul                        ;
 fstp   tbyte ptr  -60[ecx]  ; b2[0x02]=(tmp0-tmp1)*costab[29]
 fld    tbyte ptr  -80[ebx]  ;
 fsub                        ;
 fld    tbyte ptr  130[esi]  ;
 fmul                        ; tmp0=(tmp2-b1[0x00])*costab[25]
 fld    tbyte ptr  -70[ebx]  ;
 fld    tbyte ptr  -60[ebx]  ;
 fsub                        ;
 fld    tbyte ptr  140[esi]  ;
 fmul                        ; tmp1=(b1[0x01]-b1[0x02])*costab[26]
 fld   st(1)                 ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr  -30[ecx]  ; b2[0x05]=tmp0+tmp1
 fsubp st(1),st              ;
 fld    tbyte ptr  170[esi]  ;
 fmul                        ;
 fstp   tbyte ptr  -20[ecx]  ; b2[0x06]=(tmp0-tmp1)*costab[29]

;-----------------------------------------------------------
 fld    tbyte ptr  180[esi]  ; cos0=costab[30]
 fld    tbyte ptr   70[ecx]  ;
 fld    tbyte ptr   60[ecx]  ;
 fsub                        ;
 fmul  st,st(1)              ; tmp6         =(b2[0x0F]-b2[0x0E])*cos0
 fld st                      ;
 fstp   tbyte ptr 2400[edx]  ; out1[0x10*15]= tmp6
 fld    tbyte ptr   60[ecx]  ;
 fld    tbyte ptr   70[ecx]  ;
 fadd                        ;
 fadd  st,st(1)              ;
 fld st                      ;
 fstp   tbyte ptr  -40[ebx]  ; b1[0x04]     = b2[0x0E] + b2[0x0F] + tmp6
 fld    tbyte ptr   40[ecx]  ;
 fadd                        ;
 fld    tbyte ptr   50[ecx]  ;
 fadd                        ; tmp3         = b2[0x0C] + b2[0x0D] + b1[0x04]
 fld    tbyte ptr    0[ecx]  ;
 fld    tbyte ptr   10[ecx]  ;
 fadd                        ;
 fadd  st,st(1)              ; tmp2         = b2[0x08] + b2[0x09] + tmp3
 fld    tbyte ptr  -80[ecx]  ;
 fld    tbyte ptr  -70[ecx]  ;
 fadd                        ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr 2400[eax]  ; out0[0x10*15]= b2[0x00] + b2[0x01] + tmp2
 fld    tbyte ptr  -10[ecx]  ;
 fld    tbyte ptr  -20[ecx]  ;
 fsub                        ;
 fmul  st,st(4)              ;
 fld st                      ;
 fstp   tbyte ptr  -10[ebx]  ; b1[0x07]     =(b2[0x07]-b2[0x06])*cos0
 fld   st                    ;
 fadd  st,st(4)              ;
 fstp   tbyte ptr 2080[edx]  ; out1[0x10*13]= b1[0x07] + tmp6
 fld    tbyte ptr  -20[ecx]  ;
 fadd                        ;
 fld    tbyte ptr  -10[ecx]  ;
 fadd                        ;
 fld st                      ;
 fstp   tbyte ptr  -20[ebx]  ; b1[0x06]     = b2[0x06] + b2[0x07] + b1[0x07]
 fld    tbyte ptr  -40[ecx]  ;
 fadd                        ;
 fld    tbyte ptr  -30[ecx]  ;
 fadd                        ; tmp1         = b2[0x04] + b2[0x05] + b1[0x06]
 fadd  st(1),st              ; tmp2        += tmp1
 fld    tbyte ptr   30[ecx]  ;
 fld    tbyte ptr   20[ecx]  ;
 fsub                        ;
 fmul  st,st(5)              ;
 fld st                      ;
 fstp   tbyte ptr  -80[ebx]  ; b1[0x00]     =(b2[0x0B]-b2[0x0A])*cos0
 fld    tbyte ptr   20[ecx]  ;
 fadd                        ;
 fld    tbyte ptr   30[ecx]  ;
 fadd                        ;
 fld st                      ;
 fstp   tbyte ptr  -70[ebx]  ; b1[0x01]     = b2[0x0A] + b2[0x0B] + b1[0x00]
 faddp st(3),st              ; tmp3        += b1[0x01]
 fadd  st,st(2)              ;
 fstp   tbyte ptr 1760[eax]  ; out0[0x10*11]= tmp1 + tmp3
 fstp   tbyte ptr 2080[eax]  ; out0[0x10*13]= tmp2
 fld    tbyte ptr  -50[ecx]  ;
 fld    tbyte ptr  -60[ecx]  ;
 fsub                        ;
 fmul  st,st(3)              ;
 fld st                      ;
 fstp   tbyte ptr  -50[ebx]  ; b1[0x03]     =(b2[0x03]-b2[0x02])*cos0
 fld    tbyte ptr  -60[ecx]  ;
 fadd                        ;
 fld    tbyte ptr  -50[ecx]  ;
 fadd                        ;
 fld st                      ;
 fstp   tbyte ptr  -60[ebx]  ; b1[0x02]     = b2[0x02] + b2[0x03] + b1[0x03]
 faddp st(1),st              ;
 fstp   tbyte ptr 1440[eax]  ; out0[0x10* 9]= tmp3 + b1[0x02]
;-----------------------------------------------------------
 fld    tbyte ptr    0[ecx]  ;
 fld    tbyte ptr   10[ecx]  ;
 fsub                        ;
 fmul  st,st(2)              ; tmp5         =(b2[0x08]-b2[0x09])*cos0
 fld    tbyte ptr   40[ecx]  ;
 fld    tbyte ptr   50[ecx]  ;
 fsub                        ;
 fmul  st,st(3)              ; tmp4         =(b2[0x0C]-b2[0x0D])*cos0
 fld    tbyte ptr  -40[ebx]  ;
 fadd  st,st(1)              ; tmp3         = b1[0x04] + tmp4
 fld    tbyte ptr  -40[ecx]  ;
 fld    tbyte ptr  -30[ecx]  ;
 fsub                        ;
 fmul  st,st(5)              ;
 fld st                      ;
 fstp   tbyte ptr  -30[ebx]  ; b1[0x05]     =(b2[0x04]-b2[0x05])*cos0
 fld    tbyte ptr  -20[ebx]  ;
 fadd                        ; tmp2         = b1[0x06] + b1[0x05]
 fld    tbyte ptr  -70[ebx]  ;
 fadd  st,st(2)              ; tmp1         = b1[0x01] + tmp3
 fld    tbyte ptr  -60[ebx]  ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr 1120[eax]  ; out0[0x10* 7]= b1[0x02] + tmp1
 fadd  st,st(1)              ;
 fstp   tbyte ptr  800[eax]  ; out0[0x10* 5]= tmp1 + tmp2
 fld   st(3)                 ;
 faddp st(2),st              ; tmp3        += tmp5
 fadd  st,st(1)              ;
 fstp   tbyte ptr  480[eax]  ; out0[0x10* 3]= tmp2 + tmp3
 fld    tbyte ptr  -80[ecx]  ;
 fld    tbyte ptr  -70[ecx]  ;
 fsub                        ;
 fmulp st(5),st              ; cos0        *=(b2[0x00]-b2[0x01])
 fld   st(3)                 ;
 faddp st(2),st              ; tmp4        += tmp6
 fld   st(1)                 ;
 faddp st(3),st              ; tmp5        += tmp4
 fld   st(4)                 ;
 fadd  st,st(3)              ;
 fstp   tbyte ptr  160[edx]  ; out1[0x10* 1]= tmp5 + cos0
 faddp st(4),st              ; cos0        += tmp3
 fld    tbyte ptr  -80[ebx]  ;
 fadd                        ; tmp1         = tmp4     + b1[0x00]
 fld    tbyte ptr  -30[ebx]  ;
 fld    tbyte ptr  -10[ebx]  ;
 fadd                        ; tmp2         = b1[0x05] + b1[0x07]
 fadd  st(2),st              ; tmp5        += tmp2
 fadd  st,st(1)              ;
 fstp   tbyte ptr  800[edx]  ; out1[0x10* 5]= tmp2     + tmp1
 fld    tbyte ptr  -50[ebx]  ;
 fadd                        ;
 fstp   tbyte ptr 1120[edx]  ; out1[0x10* 7]= tmp1     + b1[0x03]
 fstp   tbyte ptr  480[edx]  ; out1[0x10* 3]= tmp5
 fld    tbyte ptr  -80[ebx]  ;
 fadd                        ; tmp6        += b1[0x00]
 fld    tbyte ptr  -50[ebx]  ;
 fadd  st,st(1)              ;
 fstp   tbyte ptr 1440[edx]  ; out1[0x10* 9]= b1[0x03] + tmp6
 fld    tbyte ptr  -10[ebx]  ;
 fadd                        ;
 fstp   tbyte ptr 1760[edx]  ; out1[0x10*11]= tmp6     + b1[0x07]
 fstp   tbyte ptr  160[eax]  ; out0[0x10* 1]= cos0

 ret

;--------------------------------------------------------------------------
; eax=scale
mpxdec_synth_init_:
 push      ecx
 push      edx
 push      edi
 push      ebp
 mov       ebp,esp
 sub       esp,4

;initialize/calculate window table

 shr     eax,1                         ; scale>>=1
 mov     dword ptr -4[ebp],eax         ;
 fild    dword ptr -4[ebp]             ;
 mov     dword ptr -4[ebp],65536       ;
 fidiv   dword ptr -4[ebp]             ; scale/=65536
 fstp    dword ptr FLAT:_scale         ;

 mov     ecx,offset FLAT:_intwinbase   ; intwinp=&intwinbase[0];
 mov     edi,offset FLAT:_decwin       ; table=decwin
 mov     eax,edi                       ;
 add     eax,64                        ;
 mov     dword ptr FLAT:_decwin16,eax  ; decwin16=decwin+16
 mov     ah,17                         ; i=17
L$31:                                  ; do{
  mov    al,16                          ; j=16
L$32:                                   ; do{
   mov    edx,dword ptr [ecx]            ; int w=intwinp[0]
   add    ecx,4                          ; intwinp++
   mov    dword ptr [edi],edx            ; table[0]=w
   add    edi,4                          ; table++
   mov    dword ptr 60[edi],edx          ; table[15]=w
   dec    al                             ; j--
  jne    L$32                           ; }while(j)
  add    edi,64                         ; table+=16
  dec    ah                             ; i--;
 jne    L$31                           ; }while(i)

;calculate cos table for dct64

 mov  edi,offset FLAT:_dct64costab+300   ; costabp=&dct64costab[30]
 mov  ecx,4                              ; i=4
 fldpi                                   ; PI
 fld1                                    ; 1.0
 mov       dword ptr -4H[ebp],2          ;
 fild      dword ptr -4H[ebp]            ; 2.0
L$33:                                    ; do{
  mov       eax,64                       ;
  shr       eax,cl                       ;  divv=64>>i
  mov       dword ptr -4H[ebp],eax       ;
  fild      dword ptr -4H[ebp]           ;
  mov       eax,16                       ;
  shr       eax,cl                       ;
  dec       eax                          ;  k=(16>>i)-1
L$34:                                    ;
   mov       dword ptr -4H[ebp],eax      ;
   fild      dword ptr -4H[ebp]          ;
   fmul      st,st(2)                    ;
   fadd      st,st(3)                    ;
   fmul      st,st(4)                    ;
   fdiv      st,st(1)                    ;
   fcos                                  ;
   fmul      st,st(2)                    ;
   fdivr     st,st(3)                    ;
   fstp      tbyte ptr [edi]             ;   *costab=1.0 / (2.0*cos(M_PI * ((float)k*2.0+1.0) / (float)divv));
   sub       edi,10                      ;   costabp--
   dec       eax                         ;   j--
  jns       L$34                         ;  }while(j>=0)
  fstp      st                           ;
  dec       ecx                          ;  i--
 jns       L$33                          ; }while(i>=0)
 fstp      st                            ; pop 2.0
 fstp      st                            ; pop 1.0
 fstp      st                            ; pop PI

 mov       esp,ebp
 pop       ebp
 pop       edi
 pop       edx
 pop       ecx
 ret

mpxdec_synth_init:
push eax
mov  eax,dword ptr  [esp+4+4];
call mpxdec_synth_init_
pop eax
ret

;-------------------------------------------------------------------------

_TEXT		ENDS
CONST		SEGMENT	DWORD PUBLIC USE32 'DATA'
CONST		ENDS
CONST2		SEGMENT	DWORD PUBLIC USE32 'DATA'
CONST2		ENDS
_DATA		SEGMENT	DWORD PUBLIC USE32 'DATA'

_intwinbase:
    DB	00H, 00H, 00H, 00H, 0e3H, 0ffH, 0ffH, 0ffH
    DB	0d5H, 00H, 00H, 00H, 35H, 0feH, 0ffH, 0ffH
    DB	0f5H, 07H, 00H, 00H, 0dfH, 0ebH, 0ffH, 0ffH
    DB	0aeH, 19H, 00H, 00H, 8fH, 6dH, 0ffH, 0ffH
    DB	1eH, 25H, 01H, 00H, 71H, 92H, 00H, 00H
    DB	0aeH, 19H, 00H, 00H, 21H, 14H, 00H, 00H
    DB	0f5H, 07H, 00H, 00H, 0cbH, 01H, 00H, 00H
    DB	0d5H, 00H, 00H, 00H, 1dH, 00H, 00H, 00H
    DB	0ffH, 0ffH, 0ffH, 0ffH, 0e1H, 0ffH, 0ffH, 0ffH
    DB	0daH, 00H, 00H, 00H, 0f9H, 0fdH, 0ffH, 0ffH
    DB	0d0H, 07H, 00H, 00H, 73H, 0eaH, 0ffH, 0ffH
    DB	47H, 17H, 00H, 00H, 58H, 66H, 0ffH, 0ffH
    DB	0f0H, 24H, 01H, 00H, 38H, 8bH, 00H, 00H
    DB	0deH, 1bH, 00H, 00H, 0b4H, 12H, 00H, 00H
    DB	0fH, 08H, 00H, 00H, 91H, 01H, 00H, 00H
    DB	0d0H, 00H, 00H, 00H, 1aH, 00H, 00H, 00H
    DB	0ffH, 0ffH, 0ffH, 0ffH, 0ddH, 0ffH, 0ffH, 0ffH
    DB	0deH, 00H, 00H, 00H, 0bbH, 0fdH, 0ffH, 0ffH
    DB	0a0H, 07H, 00H, 00H, 09H, 0e9H, 0ffH, 0ffH
    DB	0a8H, 14H, 00H, 00H, 28H, 5fH, 0ffH, 0ffH
    DB	68H, 24H, 01H, 00H, 0ffH, 83H, 00H, 00H
    DB	0d8H, 1dH, 00H, 00H, 49H, 11H, 00H, 00H
    DB	20H, 08H, 00H, 00H, 5bH, 01H, 00H, 00H
    DB	0caH, 00H, 00H, 00H, 18H, 00H, 00H, 00H
    DB	0ffH, 0ffH, 0ffH, 0ffH, 0daH, 0ffH, 0ffH, 0ffH
    DB	0e1H, 00H, 00H, 00H, 7bH, 0fdH, 0ffH, 0ffH
    DB	65H, 07H, 00H, 00H, 0a3H, 0e7H, 0ffH, 0ffH
    DB	0d1H, 11H, 00H, 00H, 02H, 58H, 0ffH, 0ffH
    DB	86H, 23H, 01H, 00H, 0cbH, 7cH, 00H, 00H
    DB	9cH, 1fH, 00H, 00H, 0dfH, 0fH, 00H, 00H
    DB	27H, 08H, 00H, 00H, 26H, 01H, 00H, 00H
    DB	0c4H, 00H, 00H, 00H, 15H, 00H, 00H, 00H
    DB	0ffH, 0ffH, 0ffH, 0ffH, 0d7H, 0ffH, 0ffH, 0ffH
    DB	0e3H, 00H, 00H, 00H, 39H, 0fdH, 0ffH, 0ffH
    DB	1eH, 07H, 00H, 00H, 43H, 0e6H, 0ffH, 0ffH
    DB	0c0H, 0eH, 00H, 00H, 0ebH, 50H, 0ffH, 0ffH
    DB	49H, 22H, 01H, 00H, 0a0H, 75H, 00H, 00H
    DB	2cH, 21H, 00H, 00H, 79H, 0eH, 00H, 00H
    DB	25H, 08H, 00H, 00H, 0f4H, 00H, 00H, 00H
    DB	0beH, 00H, 00H, 00H, 13H, 00H, 00H, 00H
    DB	0ffH, 0ffH, 0ffH, 0ffH, 0d3H, 0ffH, 0ffH, 0ffH
    DB	0e4H, 00H, 00H, 00H, 0f5H, 0fcH, 0ffH, 0ffH
    DB	0cbH, 06H, 00H, 00H, 0e9H, 0e4H, 0ffH, 0ffH
    DB	77H, 0bH, 00H, 00H, 0e7H, 49H, 0ffH, 0ffH
    DB	0b4H, 20H, 01H, 00H, 81H, 6eH, 00H, 00H
    DB	88H, 22H, 00H, 00H, 17H, 0dH, 00H, 00H
    DB	1bH, 08H, 00H, 00H, 0c5H, 00H, 00H, 00H
    DB	0b7H, 00H, 00H, 00H, 11H, 00H, 00H, 00H
    DB	0ffH, 0ffH, 0ffH, 0ffH, 0cfH, 0ffH, 0ffH, 0ffH
    DB	0e4H, 00H, 00H, 00H, 0b0H, 0fcH, 0ffH, 0ffH
    DB	6cH, 06H, 00H, 00H, 99H, 0e3H, 0ffH, 0ffH
    DB	0f5H, 07H, 00H, 00H, 0faH, 42H, 0ffH, 0ffH
    DB	0c7H, 1eH, 01H, 00H, 72H, 67H, 00H, 00H
    DB	0b3H, 23H, 00H, 00H, 0bcH, 0bH, 00H, 00H
    DB	09H, 08H, 00H, 00H, 99H, 00H, 00H, 00H
    DB	0b0H, 00H, 00H, 00H, 10H, 00H, 00H, 00H
    DB	0feH, 0ffH, 0ffH, 0ffH, 0cbH, 0ffH, 0ffH, 0ffH
    DB	0e3H, 00H, 00H, 00H, 69H, 0fcH, 0ffH, 0ffH
    DB	0ffH, 05H, 00H, 00H, 53H, 0e2H, 0ffH, 0ffH
    DB	3aH, 04H, 00H, 00H, 27H, 3cH, 0ffH, 0ffH
    DB	83H, 1cH, 01H, 00H, 76H, 60H, 00H, 00H
    DB	0adH, 24H, 00H, 00H, 67H, 0aH, 00H, 00H
    DB	0f0H, 07H, 00H, 00H, 6fH, 00H, 00H, 00H
    DB	0a9H, 00H, 00H, 00H, 0eH, 00H, 00H, 00H
    DB	0feH, 0ffH, 0ffH, 0ffH, 0c6H, 0ffH, 0ffH, 0ffH
    DB	0e0H, 00H, 00H, 00H, 21H, 0fcH, 0ffH, 0ffH
    DB	86H, 05H, 00H, 00H, 1aH, 0e1H, 0ffH, 0ffH
    DB	46H, 00H, 00H, 00H, 73H, 35H, 0ffH, 0ffH
    DB	0e9H, 19H, 01H, 00H, 91H, 59H, 00H, 00H
    DB	78H, 25H, 00H, 00H, 1aH, 09H, 00H, 00H
    DB	0d1H, 07H, 00H, 00H, 48H, 00H, 00H, 00H
    DB	0a1H, 00H, 00H, 00H, 0dH, 00H, 00H, 00H
    DB	0feH, 0ffH, 0ffH, 0ffH, 0c1H, 0ffH, 0ffH, 0ffH
    DB	0ddH, 00H, 00H, 00H, 0d8H, 0fbH, 0ffH, 0ffH
    DB	00H, 05H, 00H, 00H, 0efH, 0dfH, 0ffH, 0ffH
    DB	1aH, 0fcH, 0ffH, 0ffH, 0e2H, 2eH, 0ffH, 0ffH
    DB	0fcH, 16H, 01H, 00H, 0c5H, 52H, 00H, 00H
    DB	16H, 26H, 00H, 00H, 0d6H, 07H, 00H, 00H
    DB	0aaH, 07H, 00H, 00H, 24H, 00H, 00H, 00H
    DB	9aH, 00H, 00H, 00H, 0bH, 00H, 00H, 00H
    DB	0feH, 0ffH, 0ffH, 0ffH, 0bcH, 0ffH, 0ffH, 0ffH
    DB	0d7H, 00H, 00H, 00H, 8fH, 0fbH, 0ffH, 0ffH
    DB	6bH, 04H, 00H, 00H, 0d5H, 0deH, 0ffH, 0ffH
    DB	0b6H, 0f7H, 0ffH, 0ffH, 76H, 28H, 0ffH, 0ffH
    DB	0beH, 13H, 01H, 00H, 16H, 4cH, 00H, 00H
    DB	87H, 26H, 00H, 00H, 9cH, 06H, 00H, 00H
    DB	7fH, 07H, 00H, 00H, 02H, 00H, 00H, 00H
    DB	93H, 00H, 00H, 00H, 0aH, 00H, 00H, 00H
    DB	0fdH, 0ffH, 0ffH, 0ffH, 0b7H, 0ffH, 0ffH, 0ffH
    DB	0d0H, 00H, 00H, 00H, 46H, 0fbH, 0ffH, 0ffH
    DB	0caH, 03H, 00H, 00H, 0cdH, 0ddH, 0ffH, 0ffH
    DB	1cH, 0f3H, 0ffH, 0ffH, 36H, 22H, 0ffH, 0ffH
    DB	2fH, 10H, 01H, 00H, 87H, 45H, 00H, 00H
    DB	0cfH, 26H, 00H, 00H, 6cH, 05H, 00H, 00H
    DB	4eH, 07H, 00H, 00H, 0e3H, 0ffH, 0ffH, 0ffH
    DB	8bH, 00H, 00H, 00H, 09H, 00H, 00H, 00H
    DB	0fdH, 0ffH, 0ffH, 0ffH, 0b1H, 0ffH, 0ffH, 0ffH
    DB	0c8H, 00H, 00H, 00H, 0fdH, 0faH, 0ffH, 0ffH
    DB	1aH, 03H, 00H, 00H, 0daH, 0dcH, 0ffH, 0ffH
    DB	4bH, 0eeH, 0ffH, 0ffH, 23H, 1cH, 0ffH, 0ffH
    DB	54H, 0cH, 01H, 00H, 1bH, 3fH, 00H, 00H
    DB	0eeH, 26H, 00H, 00H, 47H, 04H, 00H, 00H
    DB	19H, 07H, 00H, 00H, 0c7H, 0ffH, 0ffH, 0ffH
    DB	84H, 00H, 00H, 00H, 08H, 00H, 00H, 00H
    DB	0fcH, 0ffH, 0ffH, 0ffH, 0abH, 0ffH, 0ffH, 0ffH
    DB	0bdH, 00H, 00H, 00H, 0b4H, 0faH, 0ffH, 0ffH
    DB	5dH, 02H, 00H, 00H, 0fdH, 0dbH, 0ffH, 0ffH
    DB	46H, 0e9H, 0ffH, 0ffH, 42H, 16H, 0ffH, 0ffH
    DB	2dH, 08H, 01H, 00H, 0d4H, 38H, 00H, 00H
    DB	0e7H, 26H, 00H, 00H, 2eH, 03H, 00H, 00H
    DB	0dfH, 06H, 00H, 00H, 0adH, 0ffH, 0ffH, 0ffH
    DB	7dH, 00H, 00H, 00H, 07H, 00H, 00H, 00H
    DB	0fcH, 0ffH, 0ffH, 0ffH, 0a5H, 0ffH, 0ffH, 0ffH
    DB	0b1H, 00H, 00H, 00H, 6cH, 0faH, 0ffH, 0ffH
    DB	92H, 01H, 00H, 00H, 38H, 0dbH, 0ffH, 0ffH
    DB	0eH, 0e4H, 0ffH, 0ffH, 97H, 10H, 0ffH, 0ffH
    DB	0beH, 03H, 01H, 00H, 0b4H, 32H, 00H, 00H
    DB	0bcH, 26H, 00H, 00H, 21H, 02H, 00H, 00H
    DB	0a2H, 06H, 00H, 00H, 96H, 0ffH, 0ffH, 0ffH
    DB	75H, 00H, 00H, 00H, 07H, 00H, 00H, 00H
    DB	0fbH, 0ffH, 0ffH, 0ffH, 9fH, 0ffH, 0ffH, 0ffH
    DB	0a3H, 00H, 00H, 00H, 26H, 0faH, 0ffH, 0ffH
    DB	0b9H, 00H, 00H, 00H, 8fH, 0daH, 0ffH, 0ffH
    DB	0a4H, 0deH, 0ffH, 0ffH, 24H, 0bH, 0ffH, 0ffH
    DB	0aH, 0ffH, 00H, 00H, 0bfH, 2cH, 00H, 00H
    DB	6eH, 26H, 00H, 00H, 20H, 01H, 00H, 00H
    DB	62H, 06H, 00H, 00H, 81H, 0ffH, 0ffH, 0ffH
    DB	6fH, 00H, 00H, 00H, 06H, 00H, 00H, 00H
    DB	0fbH, 0ffH, 0ffH, 0ffH, 98H, 0ffH, 0ffH, 0ffH
    DB	92H, 00H, 00H, 00H, 0e1H, 0f9H, 0ffH, 0ffH
    DB	0d3H, 0ffH, 0ffH, 0ffH, 01H, 0daH, 0ffH, 0ffH
    DB	09H, 0d9H, 0ffH, 0ffH, 0edH, 05H, 0ffH, 0ffH
    DB	13H, 0faH, 00H, 00H, 0f7H, 26H, 00H, 00H
    DB	0ffH, 25H, 00H, 00H, 2dH, 00H, 00H, 00H
    DB	1fH, 06H, 00H, 00H, 6eH, 0ffH, 0ffH, 0ffH
    DB	68H, 00H, 00H, 00H, 05H, 00H, 00H, 00H

_DATA		ENDS
_BSS		SEGMENT	DWORD PUBLIC USE32 'BSS'
    ORG 0
_dct64costab  LABEL	BYTE ; 32*10
    ORG 320
_decwin    LABEL	BYTE ; (512+32)*4
    ORG 2496
_decwin16    LABEL	BYTE ; 4
    ORG 2500
_scale       LABEL      BYTE ; 4
    ORG 2504

_BSS		ENDS

		END
