//**************************************************************************
//*                     This file is part of the                           *
//*             Ogg Vorbis encoder output DLL plug-in for                  *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//WavPack encoding

#include <mpxplay.h>
#include "wvenclib\wavpack.h"
#include "wvenclib\md5.h"
#include <newfunc\newfunc.h>
#include <control\control.h>
//#include "utf8.h"
#include <string.h>
#include <malloc.h>
#include <time.h>

#define PRG_VERSION "1.54"

typedef struct {
 uint32_t bytes_written, first_block_size;
 int filehand;
 int error;
}write_id;

typedef struct wavpack_main_info{
 WavpackContext *wpc;
 int32_t *sample_buffer;
 unsigned long sample_bufsize;
 WavpackConfig config;
 write_id wv_file;
 MD5_CTX md5_context;
}wavpack_main_info;

static unsigned int config_flags,config_xmode;
static float config_bitrate;

static topt oggenc_opts[] = {
{"wv_b"   ,ARG2|ARG_FLO|ARG_OR,&config_flags        ,CONFIG_HYBRID_FLAG,&config_bitrate},
{"wv_f"   ,ARG_OR,             &config_flags        ,(CONFIG_FAST_FLAG|CONFIG_VERY_FAST_FLAG),0},
{"wv_h"   ,ARG_OR,             &config_flags        ,(CONFIG_HIGH_FLAG|CONFIG_VERY_HIGH_FLAG),0},
{"wv_m"   ,ARG_OR,             &config_flags        ,CONFIG_MD5_CHECKSUM,0},
{"wv_x"   ,ARG2|ARG_NUM|ARG_OR,&config_flags        ,CONFIG_EXTRA_MODE,&config_xmode},
{NULL    ,0,0,0,0}
};

#ifdef __DOS__
struct mpxplay_resource_s *mrs;
#define WAVP_PRINTF(s) mrs->pds_textdisplay_printf(s)
#else
#include <share.h>
void WAVP_PRINTF(char *s)
{
 printf("%s\n",s);
}
#endif

static unsigned int wec_ready;

static void wavpack_encoder_config(void)
{
 if(!wec_ready){
  if(config_flags&CONFIG_HYBRID_FLAG){
   if(config_bitrate<2.0)
    config_bitrate=2.0;
   else if(config_bitrate>9600.0)
    config_bitrate=9600.0;
   if(config_bitrate>=24.0)
    config_flags|=CONFIG_BITRATE_KBPS;
  }
  if(config_flags&CONFIG_EXTRA_MODE){
   if(config_xmode>6)
    config_xmode=6;
   else if(!config_xmode)
    config_flags&=~CONFIG_EXTRA_MODE;
  }
  wec_ready=1;
 }
}

static int write_block(void *id, void *data, int32_t length)
{
 write_id *wid = (write_id *) id;
 uint32_t bcount;

 if(!wid || wid->error)
  return FALSE;

 if(wid->filehand && data && length){
#ifdef __DOS__
  bcount=mrs->pds_dos_write(wid->filehand,data,length);
#else
  bcount=write(wid->filehand,data,length);
#endif
  if(!bcount){
   wid->error = 1;
   return FALSE;
  }else{
   wid->bytes_written += length;

   if(!wid->first_block_size)
    wid->first_block_size = bcount;
  }
 }

 return TRUE;

}

static int wavpack_encoder_open(struct mpxplay_audioout_info_s *aui)
{
 struct wavpack_main_info *wpmi;
 unsigned int bytespersample;
 unsigned long total_samples=0;
 char fullname[MAX_PATHNAMELEN];

 wavpack_encoder_config();

 aui->card_private_data=wpmi=malloc(sizeof(struct wavpack_main_info));
 if(wpmi==NULL)
  return -1;
 memset(wpmi,0,sizeof(struct wavpack_main_info));

 pds_getfilename_noext_from_fullname(fullname,aui->mvp->pei0->filename);
 pds_strcat(fullname,".WV");

 if(pds_stricmp(fullname,aui->mvp->pei0->filename)!=0) // input and output filename must be different
#ifdef __DOS__
  wpmi->wv_file.filehand=mrs->pds_open_create(fullname,O_RDWR|O_BINARY);
#else
  wpmi->wv_file.filehand=sopen(fullname,O_RDWR|O_BINARY|O_CREAT|O_TRUNC,SH_DENYWR,S_IREAD|S_IWRITE);
#endif
 if(!wpmi->wv_file.filehand){
  WAVP_PRINTF("wavpack error: cannot open output file!");
  return -1;
 }

 wpmi->wpc = WavpackOpenFileOutput (write_block, &wpmi->wv_file, NULL);
 if(!wpmi->wpc)
  return -1;

 if(aui->card_wave_id==MPXPLAY_WAVEID_PCM_FLOAT){
  bytespersample=4;
  aui->bits_card=1; // output scale (-1.0 - +1.0)
  wpmi->config.float_norm_exp = 127; // ???
  wpmi->config.bits_per_sample=32;
 }else{
  wpmi->config.bits_per_sample=aui->bits_card;
  bytespersample=(aui->bits_card+7)/8;
 }
 wpmi->config.bytes_per_sample=bytespersample;
 wpmi->config.num_channels=aui->chan_card;
 wpmi->config.sample_rate=aui->freq_card;
 if(aui->chan_card <= 2)
  wpmi->config.channel_mask = 0x5 - aui->chan_card;
 else
  wpmi->config.channel_mask = (1 << aui->chan_card) - 1;

 wpmi->config.flags=config_flags;
 wpmi->config.bitrate=config_bitrate;
 wpmi->config.xmode=config_xmode;

 WavpackSetConfiguration (wpmi->wpc, &wpmi->config, total_samples);

 if(wpmi->wpc->config.flags & CONFIG_MD5_CHECKSUM)
  MD5Init(&wpmi->md5_context);

 WavpackPackInit(wpmi->wpc);

 return 0;
}

//-------------------------------------------------------------------------

static void WAVPACK_writedata(struct mpxplay_audioout_info_s *aui,char *pcm_sample,unsigned long outbytes)
{
 unsigned int outsamplenum=outbytes/aui->bytespersample_card;
 struct wavpack_main_info *wpmi=aui->card_private_data;

 if(!wpmi || !outsamplenum)
  return;

 if(wpmi->sample_bufsize<outsamplenum){
  wpmi->sample_buffer=realloc(wpmi->sample_buffer,outsamplenum*sizeof(int32_t));
  wpmi->sample_bufsize=outsamplenum;
 }

 if(wpmi->wpc->config.flags & CONFIG_MD5_CHECKSUM)
  MD5Update(&wpmi->md5_context,pcm_sample,outbytes);

 {
  unsigned int i=outsamplenum;
  uchar *sptr=pcm_sample;
  int32_t *dptr=wpmi->sample_buffer;
  switch(WavpackGetBytesPerSample(wpmi->wpc)){
   case 1:do{ *dptr++ = *sptr++ - 128; }while(--i); break;
   case 2:do{ *dptr++ = sptr [0] | ((int32_t)(signed char) sptr [1] << 8); sptr+=2; }while(--i); break;
   case 3:do{ *dptr++ = sptr [0] | ((int32_t) sptr [1] << 8) | ((int32_t)(signed char) sptr [2] << 16); sptr+=3; }while(--i); break;
   case 4:do{ *dptr++ = sptr [0] | ((int32_t) sptr [1] << 8) | ((int32_t) sptr [2] << 16) | ((int32_t)(signed char) sptr [3] << 24); sptr+=4; }while(--i); break;
  }
 }

 if(!WavpackPackSamples(wpmi->wpc,wpmi->sample_buffer, outsamplenum/aui->chan_card))
  return;

 return;
}

static void wavpack_encoder_close(struct mpxplay_audioout_info_s *aui)
{
 struct wavpack_main_info *wpmi;
 char *block_buff;
 write_id *wid;

 if(aui->card_private_data){
  wpmi=aui->card_private_data;

  if(wpmi->wpc)
   WavpackFlushSamples(wpmi->wpc);

  wid=&wpmi->wv_file;
  if(wid->filehand){
   if(wpmi->wpc){
    // finalize md5
    if(wpmi->wpc->config.flags & CONFIG_MD5_CHECKSUM) {
     char md5_string [] = "original md5 signature: 00000000000000000000000000000000";
     uchar md5_digest [16];
     int i;

     MD5Final (md5_digest, &wpmi->md5_context);

     for (i = 0; i < 16; ++i)
      sprintf (md5_string + 24 + (i * 2), "%02x", md5_digest [i]);

      WavpackStoreMD5Sum (wpmi->wpc, md5_digest);
    }

    // finalize header (number of samples)
    block_buff = malloc(wid->first_block_size);
#ifdef __DOS__
    if(block_buff && mrs->pds_lseek(wid->filehand,0,SEEK_SET)==0){
     if(mrs->pds_dos_read(wid->filehand,block_buff,wid->first_block_size)==wid->first_block_size){
      if(pds_strncmp(block_buff,"wvpk",4)==0){
       WavpackUpdateNumSamples(wpmi->wpc, block_buff);
       if(mrs->pds_lseek(wid->filehand,0,SEEK_SET)==0)
        mrs->pds_dos_write(wid->filehand,block_buff,wid->first_block_size);
      }
     }
    }
    if(block_buff)
     free(block_buff);
   }
   mrs->pds_close(wid->filehand);
#else
   if(block_buff && lseek(wid->filehand,0,SEEK_SET)==0){
     if(read(wid->filehand,block_buff,wid->first_block_size)==wid->first_block_size){
      if(pds_strncmp(block_buff,"wvpk",4)==0){
       WavpackUpdateNumSamples(wpmi->wpc, block_buff);
       if(lseek(wid->filehand,0,SEEK_SET)==0)
        write(wid->filehand,block_buff,wid->first_block_size);
      }
     }
    }
    if(block_buff)
     free(block_buff);
   }
   close(wid->filehand);
#endif
  }

  if(wpmi->wpc)
   WavpackCloseFile(wpmi->wpc);

  if(wpmi->sample_buffer)
   free(wpmi->sample_buffer);

  free(aui->card_private_data);
  aui->card_private_data=NULL;
 }
}

static void WAVPACK_close(struct mpxplay_audioout_info_s *aui)
{
 wavpack_encoder_close(aui);
}

//--------------------------------------------------------------------
static int WAVPACK_init(struct mpxplay_audioout_info_s *aui)
{
 aui->card_port=aui->card_isa_dma=aui->card_irq=aui->card_isa_hidma=aui->card_type=0;
 return 1;
}

static int WAVPACK_detect(struct mpxplay_audioout_info_s *aui)
{
 aui->card_port=aui->card_isa_dma=aui->card_irq=aui->card_isa_hidma=aui->card_type=0;
 return 1;
}

static void WAVPACK_card_info(struct mpxplay_audioout_info_s *aui)
{
 WAVP_PRINTF("-------------------------------------------------------------------------------");
 WAVP_PRINTF("WAVP : WavPack v4.31 encoder output plugin (disk writer) v1.54");
 WAVP_PRINTF("");
 WAVP_PRINTF("Available options (use in the command line of Mpxplay):");
 WAVP_PRINTF(" -wv_b NUM  : hybrid/lossy encoding (NUM = 2.0-23.9 or 24-9600)");
 WAVP_PRINTF(" -wv_f      : fastest encoding (worse compression)");
 WAVP_PRINTF(" -wv_h      : best compression (slower encoding)");
 WAVP_PRINTF(" -wv_m      : add MD5 checksum");
 WAVP_PRINTF(" -wv_x NUM  : extra encoding (NUM = 1-6)");
 WAVP_PRINTF("-------------------------------------------------------------------------------");
}

static void WAVPACK_setrate(struct mpxplay_audioout_info_s *aui)
{
 WAVPACK_close(aui);
 if(wavpack_encoder_open(aui)!=0)
  wavpack_encoder_close(aui);
}

one_sndcard_info WAVPACK_sndcard_info={
 "WV",
 SNDCARD_FLAGS_DISKWRITER,

 NULL,               // card_config
 &WAVPACK_init,      // card_init
 &WAVPACK_detect,    // card_detect
 &WAVPACK_card_info, // card_info
 NULL,               // card_start
 NULL,               // card_stop
 &WAVPACK_close,     // card_close
 &WAVPACK_setrate,   // card_setrate

 &WAVPACK_writedata, // cardbuf_writedata
 NULL,            // cardbuf_pos
 NULL,            // cardbuf_clear
 NULL,            // cardbuf_int_monitor
 NULL,            // irq_routine

 NULL,            // card_writemixer
 NULL,            // card_readmixer
 NULL             // card_mixerchans
};

static mpxplay_module_entry_s oggenc_output_module_entry={
 MPXPLAY_DLLMODULETYPE_AUCARD,
 0,
 "WAVP",
 MPXPLAY_DLLMODULEVER_AUCARD,
 (void *)&WAVPACK_sndcard_info
};

static mpxplay_module_entry_s oggenc_cmdline_module_entry={
 MPXPLAY_DLLMODULETYPE_CONTROL_CMDLINE,
 0,
 NULL,
 MPXPLAY_DLLMODULEVER_CONTROL_CMDLINE,
 (void *)oggenc_opts
};

static mpxplay_dll_entry_s mpxplay_dll_entry_structure={
 MPXPLAY_DLLENTRY_STRUCTURE_VERSION,
 {
  &oggenc_output_module_entry,
  &oggenc_cmdline_module_entry,
  NULL
 }
};

#ifdef __DOS__

extern void dllstrtr_update_crwdata(unsigned long *cwd);

long __export mpxplay_dll_entrypoint(struct mpxplay_resource_s *p_mrs,unsigned long *crwdata_begin)
{
 mrs=p_mrs;
 dllstrtr_update_crwdata(crwdata_begin);
 return (long)(&mpxplay_dll_entry_structure);
}

#else

int matherr(struct _exception *a)
{
 a->retval=1.0;
 return 1;
}

__declspec( dllexport ) mpxplay_dll_entry_s *mpxplay_dll_entrypoint(void)
{
 return (&mpxplay_dll_entry_structure);
}

#endif

