/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE OggVorbis SOFTWARE CODEC SOURCE CODE.   *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE OggVorbis SOURCE CODE IS (C) COPYRIGHT 1994-2002             *
 * by the XIPHOPHORUS Company http://www.xiph.org/                  *
 *                                                                  *
 ********************************************************************

 function: toplevel residue templates for 32/44.1/48kHz
 last mod: $Id: residue_44.h 7187 2004-07-20 07:24:27Z xiphmont $

 ********************************************************************/

#include "codec.h"
#include "backends.h"
//#include "books/coupled/res_books_stereo.h"
#include "bookresc.h"
#include "bookresu.h"

/***** residue backends *********************************************/

static vorbis_info_residue0 _residue_44_low={
  0,-1, -1, 9,-1,
  /*  0     1     2     3     4     5     6     7  */
  {0},
  {-1},
  {  .5,  1.5,  2.5,  2.5,  4.5,  8.5,  16.5, 32.5},
  {  .5,   .5,   .5,  999., 4.5,  8.5,  16.5, 32.5},
};

static vorbis_info_residue0 _residue_44_mid={
  0,-1, -1, 10,-1,
  /*  0     1     2     3     4     5     6     7     8  */
  {0},
  {-1},
  {  .5,  1.5,  1.5,  2.5,  2.5,  4.5,  8.5,  16.5, 32.5},
  {  .5,   .5, 999.,   .5,  999., 4.5,  8.5,  16.5, 32.5},
};

static vorbis_info_residue0 _residue_44_high={
  0,-1, -1, 10,-1,
  /*  0     1     2     3     4     5     6     7     8  */
  {0},
  {-1},
  {  .5,  1.5,  2.5,  4.5,  8.5, 16.5, 32.5, 71.5,157.5},
  {  .5,  1.5,  2.5,  3.5,  4.5,  8.5, 16.5, 71.5,157.5},
};

static static_bookblock _resbook_44s_n1={
  {
    {0},{0,0,&_44cn1_s_p1_0},{0,0,&_44cn1_s_p2_0},
    {0,0,&_44cn1_s_p3_0},{0,0,&_44cn1_s_p4_0},{0,0,&_44cn1_s_p5_0},
    {&_44cn1_s_p6_0,&_44cn1_s_p6_1},{&_44cn1_s_p7_0,&_44cn1_s_p7_1},
    {&_44cn1_s_p8_0,&_44cn1_s_p8_1,&_44cn1_s_p8_2}
   }
};
static static_bookblock _resbook_44sm_n1={
  {
    {0},{0,0,&_44cn1_sm_p1_0},{0,0,&_44cn1_sm_p2_0},
    {0,0,&_44cn1_sm_p3_0},{0,0,&_44cn1_sm_p4_0},{0,0,&_44cn1_sm_p5_0},
    {&_44cn1_sm_p6_0,&_44cn1_sm_p6_1},{&_44cn1_sm_p7_0,&_44cn1_sm_p7_1},
    {&_44cn1_sm_p8_0,&_44cn1_sm_p8_1,&_44cn1_sm_p8_2}
   }
};

static static_bookblock _resbook_44s_0={
  {
    {0},{0,0,&_44c0_s_p1_0},{0,0,&_44c0_s_p2_0},
    {0,0,&_44c0_s_p3_0},{0,0,&_44c0_s_p4_0},{0,0,&_44c0_s_p5_0},
    {&_44c0_s_p6_0,&_44c0_s_p6_1},{&_44c0_s_p7_0,&_44c0_s_p7_1},
    {&_44c0_s_p8_0,&_44c0_s_p8_1,&_44c0_s_p8_2}
   }
};
static static_bookblock _resbook_44sm_0={
  {
    {0},{0,0,&_44c0_sm_p1_0},{0,0,&_44c0_sm_p2_0},
    {0,0,&_44c0_sm_p3_0},{0,0,&_44c0_sm_p4_0},{0,0,&_44c0_sm_p5_0},
    {&_44c0_sm_p6_0,&_44c0_sm_p6_1},{&_44c0_sm_p7_0,&_44c0_sm_p7_1},
    {&_44c0_sm_p8_0,&_44c0_sm_p8_1,&_44c0_sm_p8_2}
   }
};

static static_bookblock _resbook_44s_1={
  {
    {0},{0,0,&_44c1_s_p1_0},{0,0,&_44c1_s_p2_0},
    {0,0,&_44c1_s_p3_0},{0,0,&_44c1_s_p4_0},{0,0,&_44c1_s_p5_0},
    {&_44c1_s_p6_0,&_44c1_s_p6_1},{&_44c1_s_p7_0,&_44c1_s_p7_1},
    {&_44c1_s_p8_0,&_44c1_s_p8_1,&_44c1_s_p8_2}
   }
};
static static_bookblock _resbook_44sm_1={
  {
    {0},{0,0,&_44c1_sm_p1_0},{0,0,&_44c1_sm_p2_0},
    {0,0,&_44c1_sm_p3_0},{0,0,&_44c1_sm_p4_0},{0,0,&_44c1_sm_p5_0},
    {&_44c1_sm_p6_0,&_44c1_sm_p6_1},{&_44c1_sm_p7_0,&_44c1_sm_p7_1},
    {&_44c1_sm_p8_0,&_44c1_sm_p8_1,&_44c1_sm_p8_2}
   }
};

static static_bookblock _resbook_44s_2={
  {
    {0},{0,0,&_44c2_s_p1_0},{0,0,&_44c2_s_p2_0},{0,0,&_44c2_s_p3_0},
    {0,0,&_44c2_s_p4_0},{0,0,&_44c2_s_p5_0},{0,0,&_44c2_s_p6_0},
    {&_44c2_s_p7_0,&_44c2_s_p7_1},{&_44c2_s_p8_0,&_44c2_s_p8_1},
    {&_44c2_s_p9_0,&_44c2_s_p9_1,&_44c2_s_p9_2}
   }
};
static static_bookblock _resbook_44s_3={
  {
    {0},{0,0,&_44c3_s_p1_0},{0,0,&_44c3_s_p2_0},{0,0,&_44c3_s_p3_0},
    {0,0,&_44c3_s_p4_0},{0,0,&_44c3_s_p5_0},{0,0,&_44c3_s_p6_0},
    {&_44c3_s_p7_0,&_44c3_s_p7_1},{&_44c3_s_p8_0,&_44c3_s_p8_1},
    {&_44c3_s_p9_0,&_44c3_s_p9_1,&_44c3_s_p9_2}
   }
};
static static_bookblock _resbook_44s_4={
  {
    {0},{0,0,&_44c4_s_p1_0},{0,0,&_44c4_s_p2_0},{0,0,&_44c4_s_p3_0},
    {0,0,&_44c4_s_p4_0},{0,0,&_44c4_s_p5_0},{0,0,&_44c4_s_p6_0},
    {&_44c4_s_p7_0,&_44c4_s_p7_1},{&_44c4_s_p8_0,&_44c4_s_p8_1},
    {&_44c4_s_p9_0,&_44c4_s_p9_1,&_44c4_s_p9_2}
   }
};
static static_bookblock _resbook_44s_5={
  {
    {0},{0,0,&_44c5_s_p1_0},{0,0,&_44c5_s_p2_0},{0,0,&_44c5_s_p3_0},
    {0,0,&_44c5_s_p4_0},{0,0,&_44c5_s_p5_0},{0,0,&_44c5_s_p6_0},
    {&_44c5_s_p7_0,&_44c5_s_p7_1},{&_44c5_s_p8_0,&_44c5_s_p8_1},
    {&_44c5_s_p9_0,&_44c5_s_p9_1,&_44c5_s_p9_2}
   }
};
static static_bookblock _resbook_44s_6={
  {
    {0},{0,0,&_44c6_s_p1_0},{0,0,&_44c6_s_p2_0},{0,0,&_44c6_s_p3_0},
    {0,0,&_44c6_s_p4_0},
    {&_44c6_s_p5_0,&_44c6_s_p5_1},
    {&_44c6_s_p6_0,&_44c6_s_p6_1},
    {&_44c6_s_p7_0,&_44c6_s_p7_1},
    {&_44c6_s_p8_0,&_44c6_s_p8_1},
    {&_44c6_s_p9_0,&_44c6_s_p9_1,&_44c6_s_p9_2}
   }
};
static static_bookblock _resbook_44s_7={
  {
    {0},{0,0,&_44c7_s_p1_0},{0,0,&_44c7_s_p2_0},{0,0,&_44c7_s_p3_0},
    {0,0,&_44c7_s_p4_0},
    {&_44c7_s_p5_0,&_44c7_s_p5_1},
    {&_44c7_s_p6_0,&_44c7_s_p6_1},
    {&_44c7_s_p7_0,&_44c7_s_p7_1},
    {&_44c7_s_p8_0,&_44c7_s_p8_1},
    {&_44c7_s_p9_0,&_44c7_s_p9_1,&_44c7_s_p9_2}
   }
};
static static_bookblock _resbook_44s_8={
  {
    {0},{0,0,&_44c8_s_p1_0},{0,0,&_44c8_s_p2_0},{0,0,&_44c8_s_p3_0},
    {0,0,&_44c8_s_p4_0},
    {&_44c8_s_p5_0,&_44c8_s_p5_1},
    {&_44c8_s_p6_0,&_44c8_s_p6_1},
    {&_44c8_s_p7_0,&_44c8_s_p7_1},
    {&_44c8_s_p8_0,&_44c8_s_p8_1},
    {&_44c8_s_p9_0,&_44c8_s_p9_1,&_44c8_s_p9_2}
   }
};
static static_bookblock _resbook_44s_9={
  {
    {0},{0,0,&_44c9_s_p1_0},{0,0,&_44c9_s_p2_0},{0,0,&_44c9_s_p3_0},
    {0,0,&_44c9_s_p4_0},
    {&_44c9_s_p5_0,&_44c9_s_p5_1},
    {&_44c9_s_p6_0,&_44c9_s_p6_1},
    {&_44c9_s_p7_0,&_44c9_s_p7_1},
    {&_44c9_s_p8_0,&_44c9_s_p8_1},
    {&_44c9_s_p9_0,&_44c9_s_p9_1,&_44c9_s_p9_2}
   }
};

static vorbis_residue_template _res_44s_n1[]={
  {2,0,  &_residue_44_low,
   &_huff_book__44cn1_s_short,&_huff_book__44cn1_sm_short,
   &_resbook_44s_n1,&_resbook_44sm_n1},

  {2,0,  &_residue_44_low,
   &_huff_book__44cn1_s_long,&_huff_book__44cn1_sm_long,
   &_resbook_44s_n1,&_resbook_44sm_n1}
};
static vorbis_residue_template _res_44s_0[]={
  {2,0,  &_residue_44_low,
   &_huff_book__44c0_s_short,&_huff_book__44c0_sm_short,
   &_resbook_44s_0,&_resbook_44sm_0},

  {2,0,  &_residue_44_low,
   &_huff_book__44c0_s_long,&_huff_book__44c0_sm_long,
   &_resbook_44s_0,&_resbook_44sm_0}
};
static vorbis_residue_template _res_44s_1[]={
  {2,0,  &_residue_44_low,
   &_huff_book__44c1_s_short,&_huff_book__44c1_sm_short,
   &_resbook_44s_1,&_resbook_44sm_1},

  {2,0,  &_residue_44_low,
   &_huff_book__44c1_s_long,&_huff_book__44c1_sm_long,
   &_resbook_44s_1,&_resbook_44sm_1}
};

static vorbis_residue_template _res_44s_2[]={
  {2,0,  &_residue_44_mid,
   &_huff_book__44c2_s_short,&_huff_book__44c2_s_short,
   &_resbook_44s_2,&_resbook_44s_2},

  {2,0,  &_residue_44_mid,
   &_huff_book__44c2_s_long,&_huff_book__44c2_s_long,
   &_resbook_44s_2,&_resbook_44s_2}
};
static vorbis_residue_template _res_44s_3[]={
  {2,0,  &_residue_44_mid,
   &_huff_book__44c3_s_short,&_huff_book__44c3_s_short,
   &_resbook_44s_3,&_resbook_44s_3},

  {2,0,  &_residue_44_mid,
   &_huff_book__44c3_s_long,&_huff_book__44c3_s_long,
   &_resbook_44s_3,&_resbook_44s_3}
};
static vorbis_residue_template _res_44s_4[]={
  {2,0,  &_residue_44_mid,
   &_huff_book__44c4_s_short,&_huff_book__44c4_s_short,
   &_resbook_44s_4,&_resbook_44s_4},

  {2,0,  &_residue_44_mid,
   &_huff_book__44c4_s_long,&_huff_book__44c4_s_long,
   &_resbook_44s_4,&_resbook_44s_4}
};
static vorbis_residue_template _res_44s_5[]={
  {2,0,  &_residue_44_mid,
   &_huff_book__44c5_s_short,&_huff_book__44c5_s_short,
   &_resbook_44s_5,&_resbook_44s_5},

  {2,0,  &_residue_44_mid,
   &_huff_book__44c5_s_long,&_huff_book__44c5_s_long,
   &_resbook_44s_5,&_resbook_44s_5}
};
static vorbis_residue_template _res_44s_6[]={
  {2,0,  &_residue_44_high,
   &_huff_book__44c6_s_short,&_huff_book__44c6_s_short,
   &_resbook_44s_6,&_resbook_44s_6},

  {2,0,  &_residue_44_high,
   &_huff_book__44c6_s_long,&_huff_book__44c6_s_long,
   &_resbook_44s_6,&_resbook_44s_6}
};
static vorbis_residue_template _res_44s_7[]={
  {2,0,  &_residue_44_high,
   &_huff_book__44c7_s_short,&_huff_book__44c7_s_short,
   &_resbook_44s_7,&_resbook_44s_7},

  {2,0,  &_residue_44_high,
   &_huff_book__44c7_s_long,&_huff_book__44c7_s_long,
   &_resbook_44s_7,&_resbook_44s_7}
};
static vorbis_residue_template _res_44s_8[]={
  {2,0,  &_residue_44_high,
   &_huff_book__44c8_s_short,&_huff_book__44c8_s_short,
   &_resbook_44s_8,&_resbook_44s_8},

  {2,0,  &_residue_44_high,
   &_huff_book__44c8_s_long,&_huff_book__44c8_s_long,
   &_resbook_44s_8,&_resbook_44s_8}
};
static vorbis_residue_template _res_44s_9[]={
  {2,0,  &_residue_44_high,
   &_huff_book__44c9_s_short,&_huff_book__44c9_s_short,
   &_resbook_44s_9,&_resbook_44s_9},

  {2,0,  &_residue_44_high,
   &_huff_book__44c9_s_long,&_huff_book__44c9_s_long,
   &_resbook_44s_9,&_resbook_44s_9}
};

static vorbis_mapping_template _mapres_template_44_stereo[]={
  { _map_nominal, _res_44s_n1 }, /* -1 */
  { _map_nominal, _res_44s_0 }, /* 0 */
  { _map_nominal, _res_44s_1 }, /* 1 */
  { _map_nominal, _res_44s_2 }, /* 2 */
  { _map_nominal, _res_44s_3 }, /* 3 */
  { _map_nominal, _res_44s_4 }, /* 4 */
  { _map_nominal, _res_44s_5 }, /* 5 */
  { _map_nominal, _res_44s_6 }, /* 6 */
  { _map_nominal, _res_44s_7 }, /* 7 */
  { _map_nominal, _res_44s_8 }, /* 8 */
  { _map_nominal, _res_44s_9 }, /* 9 */
};

/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE OggVorbis SOFTWARE CODEC SOURCE CODE.   *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE OggVorbis SOURCE CODE IS (C) COPYRIGHT 1994-2002             *
 * by the XIPHOPHORUS Company http://www.xiph.org/                  *
 *                                                                  *
 ********************************************************************

 function: toplevel residue templates for 32/44.1/48kHz uncoupled
 last mod: $Id: residue_44u.h 7187 2004-07-20 07:24:27Z xiphmont $

 ********************************************************************/

//#include "vorbis/codec.h"
//#include "backends.h"
//#include "books/uncoupled/res_books_uncoupled.h"


/***** residue backends *********************************************/


static vorbis_info_residue0 _residue_44_low_un={
  0,-1, -1, 8,-1,
  {0},
  {-1},
  {  .5,  1.5,  1.5,  2.5,  2.5,  4.5, 28.5},
  {  -1,   25,   -1,   45,   -1,   -1,   -1}
};

static vorbis_info_residue0 _residue_44_mid_un={
  0,-1, -1, 10,-1,
  /*  0     1     2     3     4     5     6     7     8     9 */
  {0},
  {-1},
  {  .5,  1.5,  1.5,  2.5,  2.5,  4.5,  4.5, 16.5, 60.5},
  {  -1,   30,   -1,   50,   -1,   80,   -1,   -1,   -1}
};

static vorbis_info_residue0 _residue_44_hi_un={
  0,-1, -1, 10,-1,
  /*  0     1     2     3     4     5     6     7     8     9 */
  {0},
  {-1},
  {  .5,  1.5,  2.5,  4.5,  8.5, 16.5, 32.5, 71.5,157.5},
  {  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1}
};

/* mapping conventions:
   only one submap (this would change for efficient 5.1 support for example)*/
/* Four psychoacoustic profiles are used, one for each blocktype */
static vorbis_info_mapping0 _map_nominal_u[2]={
  {1, {0,0}, {0}, {0}, 0,{0},{0}},
  {1, {0,0}, {1}, {1}, 0,{0},{0}}
};

static static_bookblock _resbook_44u_n1={
  {
    {0},
    {0,0,&_44un1__p1_0},
    {0,0,&_44un1__p2_0},
    {0,0,&_44un1__p3_0},
    {0,0,&_44un1__p4_0},
    {0,0,&_44un1__p5_0},
    {&_44un1__p6_0,&_44un1__p6_1},
    {&_44un1__p7_0,&_44un1__p7_1,&_44un1__p7_2}
   }
};
static static_bookblock _resbook_44u_0={
  {
    {0},
    {0,0,&_44u0__p1_0},
    {0,0,&_44u0__p2_0},
    {0,0,&_44u0__p3_0},
    {0,0,&_44u0__p4_0},
    {0,0,&_44u0__p5_0},
    {&_44u0__p6_0,&_44u0__p6_1},
    {&_44u0__p7_0,&_44u0__p7_1,&_44u0__p7_2}
   }
};
static static_bookblock _resbook_44u_1={
  {
    {0},
    {0,0,&_44u1__p1_0},
    {0,0,&_44u1__p2_0},
    {0,0,&_44u1__p3_0},
    {0,0,&_44u1__p4_0},
    {0,0,&_44u1__p5_0},
    {&_44u1__p6_0,&_44u1__p6_1},
    {&_44u1__p7_0,&_44u1__p7_1,&_44u1__p7_2}
   }
};
static static_bookblock _resbook_44u_2={
  {
    {0},
    {0,0,&_44u2__p1_0},
    {0,0,&_44u2__p2_0},
    {0,0,&_44u2__p3_0},
    {0,0,&_44u2__p4_0},
    {0,0,&_44u2__p5_0},
    {&_44u2__p6_0,&_44u2__p6_1},
    {&_44u2__p7_0,&_44u2__p7_1,&_44u2__p7_2}
   }
};
static static_bookblock _resbook_44u_3={
  {
    {0},
    {0,0,&_44u3__p1_0},
    {0,0,&_44u3__p2_0},
    {0,0,&_44u3__p3_0},
    {0,0,&_44u3__p4_0},
    {0,0,&_44u3__p5_0},
    {&_44u3__p6_0,&_44u3__p6_1},
    {&_44u3__p7_0,&_44u3__p7_1,&_44u3__p7_2}
   }
};
static static_bookblock _resbook_44u_4={
  {
    {0},
    {0,0,&_44u4__p1_0},
    {0,0,&_44u4__p2_0},
    {0,0,&_44u4__p3_0},
    {0,0,&_44u4__p4_0},
    {0,0,&_44u4__p5_0},
    {&_44u4__p6_0,&_44u4__p6_1},
    {&_44u4__p7_0,&_44u4__p7_1,&_44u4__p7_2}
   }
};
static static_bookblock _resbook_44u_5={
  {
    {0},
    {0,0,&_44u5__p1_0},
    {0,0,&_44u5__p2_0},
    {0,0,&_44u5__p3_0},
    {0,0,&_44u5__p4_0},
    {0,0,&_44u5__p5_0},
    {0,0,&_44u5__p6_0},
    {&_44u5__p7_0,&_44u5__p7_1},
    {&_44u5__p8_0,&_44u5__p8_1},
    {&_44u5__p9_0,&_44u5__p9_1,&_44u5__p9_2}
   }
};
static static_bookblock _resbook_44u_6={
  {
    {0},
    {0,0,&_44u6__p1_0},
    {0,0,&_44u6__p2_0},
    {0,0,&_44u6__p3_0},
    {0,0,&_44u6__p4_0},
    {0,0,&_44u6__p5_0},
    {0,0,&_44u6__p6_0},
    {&_44u6__p7_0,&_44u6__p7_1},
    {&_44u6__p8_0,&_44u6__p8_1},
    {&_44u6__p9_0,&_44u6__p9_1,&_44u6__p9_2}
   }
};
static static_bookblock _resbook_44u_7={
  {
    {0},
    {0,0,&_44u7__p1_0},
    {0,0,&_44u7__p2_0},
    {0,0,&_44u7__p3_0},
    {0,0,&_44u7__p4_0},
    {0,0,&_44u7__p5_0},
    {0,0,&_44u7__p6_0},
    {&_44u7__p7_0,&_44u7__p7_1},
    {&_44u7__p8_0,&_44u7__p8_1},
    {&_44u7__p9_0,&_44u7__p9_1,&_44u7__p9_2}
   }
};
static static_bookblock _resbook_44u_8={
  {
    {0},
    {0,0,&_44u8_p1_0},
    {0,0,&_44u8_p2_0},
    {0,0,&_44u8_p3_0},
    {0,0,&_44u8_p4_0},
    {&_44u8_p5_0,&_44u8_p5_1},
    {&_44u8_p6_0,&_44u8_p6_1},
    {&_44u8_p7_0,&_44u8_p7_1},
    {&_44u8_p8_0,&_44u8_p8_1},
    {&_44u8_p9_0,&_44u8_p9_1,&_44u8_p9_2}
   }
};
static static_bookblock _resbook_44u_9={
  {
    {0},
    {0,0,&_44u9_p1_0},
    {0,0,&_44u9_p2_0},
    {0,0,&_44u9_p3_0},
    {0,0,&_44u9_p4_0},
    {&_44u9_p5_0,&_44u9_p5_1},
    {&_44u9_p6_0,&_44u9_p6_1},
    {&_44u9_p7_0,&_44u9_p7_1},
    {&_44u9_p8_0,&_44u9_p8_1},
    {&_44u9_p9_0,&_44u9_p9_1,&_44u9_p9_2}
   }
};

static vorbis_residue_template _res_44u_n1[]={
  {1,0,  &_residue_44_low_un,
   &_huff_book__44un1__short,&_huff_book__44un1__short,
   &_resbook_44u_n1,&_resbook_44u_n1},

  {1,0,  &_residue_44_low_un,
   &_huff_book__44un1__long,&_huff_book__44un1__long,
   &_resbook_44u_n1,&_resbook_44u_n1}
};
static vorbis_residue_template _res_44u_0[]={
  {1,0,  &_residue_44_low_un,
   &_huff_book__44u0__short,&_huff_book__44u0__short,
   &_resbook_44u_0,&_resbook_44u_0},

  {1,0,  &_residue_44_low_un,
   &_huff_book__44u0__long,&_huff_book__44u0__long,
   &_resbook_44u_0,&_resbook_44u_0}
};
static vorbis_residue_template _res_44u_1[]={
  {1,0,  &_residue_44_low_un,
   &_huff_book__44u1__short,&_huff_book__44u1__short,
   &_resbook_44u_1,&_resbook_44u_1},

  {1,0,  &_residue_44_low_un,
   &_huff_book__44u1__long,&_huff_book__44u1__long,
   &_resbook_44u_1,&_resbook_44u_1}
};
static vorbis_residue_template _res_44u_2[]={
  {1,0,  &_residue_44_low_un,
   &_huff_book__44u2__short,&_huff_book__44u2__short,
   &_resbook_44u_2,&_resbook_44u_2},

  {1,0,  &_residue_44_low_un,
   &_huff_book__44u2__long,&_huff_book__44u2__long,
   &_resbook_44u_2,&_resbook_44u_2}
};
static vorbis_residue_template _res_44u_3[]={
  {1,0,  &_residue_44_low_un,
   &_huff_book__44u3__short,&_huff_book__44u3__short,
   &_resbook_44u_3,&_resbook_44u_3},

  {1,0,  &_residue_44_low_un,
   &_huff_book__44u3__long,&_huff_book__44u3__long,
   &_resbook_44u_3,&_resbook_44u_3}
};
static vorbis_residue_template _res_44u_4[]={
  {1,0,  &_residue_44_low_un,
   &_huff_book__44u4__short,&_huff_book__44u4__short,
   &_resbook_44u_4,&_resbook_44u_4},

  {1,0,  &_residue_44_low_un,
   &_huff_book__44u4__long,&_huff_book__44u4__long,
   &_resbook_44u_4,&_resbook_44u_4}
};

static vorbis_residue_template _res_44u_5[]={
  {1,0,  &_residue_44_mid_un,
   &_huff_book__44u5__short,&_huff_book__44u5__short,
   &_resbook_44u_5,&_resbook_44u_5},

  {1,0,  &_residue_44_mid_un,
   &_huff_book__44u5__long,&_huff_book__44u5__long,
   &_resbook_44u_5,&_resbook_44u_5}
};

static vorbis_residue_template _res_44u_6[]={
  {1,0,  &_residue_44_mid_un,
   &_huff_book__44u6__short,&_huff_book__44u6__short,
   &_resbook_44u_6,&_resbook_44u_6},

  {1,0,  &_residue_44_mid_un,
   &_huff_book__44u6__long,&_huff_book__44u6__long,
   &_resbook_44u_6,&_resbook_44u_6}
};

static vorbis_residue_template _res_44u_7[]={
  {1,0,  &_residue_44_mid_un,
   &_huff_book__44u7__short,&_huff_book__44u7__short,
   &_resbook_44u_7,&_resbook_44u_7},

  {1,0,  &_residue_44_mid_un,
   &_huff_book__44u7__long,&_huff_book__44u7__long,
   &_resbook_44u_7,&_resbook_44u_7}
};

static vorbis_residue_template _res_44u_8[]={
  {1,0,  &_residue_44_hi_un,
   &_huff_book__44u8__short,&_huff_book__44u8__short,
   &_resbook_44u_8,&_resbook_44u_8},

  {1,0,  &_residue_44_hi_un,
   &_huff_book__44u8__long,&_huff_book__44u8__long,
   &_resbook_44u_8,&_resbook_44u_8}
};
static vorbis_residue_template _res_44u_9[]={
  {1,0,  &_residue_44_hi_un,
   &_huff_book__44u9__short,&_huff_book__44u9__short,
   &_resbook_44u_9,&_resbook_44u_9},

  {1,0,  &_residue_44_hi_un,
   &_huff_book__44u9__long,&_huff_book__44u9__long,
   &_resbook_44u_9,&_resbook_44u_9}
};

static vorbis_mapping_template _mapres_template_44_uncoupled[]={
  { _map_nominal_u, _res_44u_n1 }, /* -1 */
  { _map_nominal_u, _res_44u_0 }, /* 0 */
  { _map_nominal_u, _res_44u_1 }, /* 1 */
  { _map_nominal_u, _res_44u_2 }, /* 2 */
  { _map_nominal_u, _res_44u_3 }, /* 3 */
  { _map_nominal_u, _res_44u_4 }, /* 4 */
  { _map_nominal_u, _res_44u_5 }, /* 5 */
  { _map_nominal_u, _res_44u_6 }, /* 6 */
  { _map_nominal_u, _res_44u_7 }, /* 7 */
  { _map_nominal_u, _res_44u_8 }, /* 8 */
  { _map_nominal_u, _res_44u_9 }, /* 9 */
};


/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE OggVorbis SOFTWARE CODEC SOURCE CODE.   *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE OggVorbis SOURCE CODE IS (C) COPYRIGHT 1994-2002             *
 * by the XIPHOPHORUS Company http://www.xiph.org/                  *
 *                                                                  *
 ********************************************************************

 function: toplevel residue templates 16/22kHz
 last mod: $Id: residue_16.h 7187 2004-07-20 07:24:27Z xiphmont $

 ********************************************************************/



/***** residue backends *********************************************/

static static_bookblock _resbook_16s_0={
  {
    {0},
    {0,0,&_16c0_s_p1_0},
    {0,0,&_16c0_s_p2_0},
    {0,0,&_16c0_s_p3_0},
    {0,0,&_16c0_s_p4_0},
    {0,0,&_16c0_s_p5_0},
    {0,0,&_16c0_s_p6_0},
    {&_16c0_s_p7_0,&_16c0_s_p7_1},
    {&_16c0_s_p8_0,&_16c0_s_p8_1},
    {&_16c0_s_p9_0,&_16c0_s_p9_1,&_16c0_s_p9_2}
   }
};
static static_bookblock _resbook_16s_1={
  {
    {0},
    {0,0,&_16c1_s_p1_0},
    {0,0,&_16c1_s_p2_0},
    {0,0,&_16c1_s_p3_0},
    {0,0,&_16c1_s_p4_0},
    {0,0,&_16c1_s_p5_0},
    {0,0,&_16c1_s_p6_0},
    {&_16c1_s_p7_0,&_16c1_s_p7_1},
    {&_16c1_s_p8_0,&_16c1_s_p8_1},
    {&_16c1_s_p9_0,&_16c1_s_p9_1,&_16c1_s_p9_2}
   }
};
static static_bookblock _resbook_16s_2={
  {
    {0},
    {0,0,&_16c2_s_p1_0},
    {0,0,&_16c2_s_p2_0},
    {0,0,&_16c2_s_p3_0},
    {0,0,&_16c2_s_p4_0},
    {&_16c2_s_p5_0,&_16c2_s_p5_1},
    {&_16c2_s_p6_0,&_16c2_s_p6_1},
    {&_16c2_s_p7_0,&_16c2_s_p7_1},
    {&_16c2_s_p8_0,&_16c2_s_p8_1},
    {&_16c2_s_p9_0,&_16c2_s_p9_1,&_16c2_s_p9_2}
   }
};

static vorbis_residue_template _res_16s_0[]={
  {2,0,  &_residue_44_mid,
   &_huff_book__16c0_s_single,&_huff_book__16c0_s_single,
   &_resbook_16s_0,&_resbook_16s_0},
};
static vorbis_residue_template _res_16s_1[]={
  {2,0,  &_residue_44_mid,
   &_huff_book__16c1_s_short,&_huff_book__16c1_s_short,
   &_resbook_16s_1,&_resbook_16s_1},
  
  {2,0,  &_residue_44_mid,
   &_huff_book__16c1_s_long,&_huff_book__16c1_s_long,
   &_resbook_16s_1,&_resbook_16s_1}
};
static vorbis_residue_template _res_16s_2[]={
  {2,0,  &_residue_44_high,
   &_huff_book__16c2_s_short,&_huff_book__16c2_s_short,
   &_resbook_16s_2,&_resbook_16s_2},
  
  {2,0,  &_residue_44_high,
   &_huff_book__16c2_s_long,&_huff_book__16c2_s_long,
   &_resbook_16s_2,&_resbook_16s_2}
};

static vorbis_mapping_template _mapres_template_16_stereo[3]={
  { _map_nominal, _res_16s_0 }, /* 0 */
  { _map_nominal, _res_16s_1 }, /* 1 */
  { _map_nominal, _res_16s_2 }, /* 2 */
};

static static_bookblock _resbook_16u_0={
  {
    {0},
    {0,0,&_16u0__p1_0},
    {0,0,&_16u0__p2_0},
    {0,0,&_16u0__p3_0},
    {0,0,&_16u0__p4_0},
    {0,0,&_16u0__p5_0},
    {&_16u0__p6_0,&_16u0__p6_1},
    {&_16u0__p7_0,&_16u0__p7_1,&_16u0__p7_2}
   }
};
static static_bookblock _resbook_16u_1={
  {
    {0},
    {0,0,&_16u1__p1_0},
    {0,0,&_16u1__p2_0},
    {0,0,&_16u1__p3_0},
    {0,0,&_16u1__p4_0},
    {0,0,&_16u1__p5_0},
    {0,0,&_16u1__p6_0},
    {&_16u1__p7_0,&_16u1__p7_1},
    {&_16u1__p8_0,&_16u1__p8_1},
    {&_16u1__p9_0,&_16u1__p9_1,&_16u1__p9_2}
   }
};
static static_bookblock _resbook_16u_2={
  {
    {0},
    {0,0,&_16u2_p1_0},
    {0,0,&_16u2_p2_0},
    {0,0,&_16u2_p3_0},
    {0,0,&_16u2_p4_0},
    {&_16u2_p5_0,&_16u2_p5_1},
    {&_16u2_p6_0,&_16u2_p6_1},
    {&_16u2_p7_0,&_16u2_p7_1},
    {&_16u2_p8_0,&_16u2_p8_1},
    {&_16u2_p9_0,&_16u2_p9_1,&_16u2_p9_2}
   }
};

static vorbis_residue_template _res_16u_0[]={
  {1,0,  &_residue_44_low_un,
   &_huff_book__16u0__single,&_huff_book__16u0__single,
   &_resbook_16u_0,&_resbook_16u_0},
};
static vorbis_residue_template _res_16u_1[]={
  {1,0,  &_residue_44_mid_un,
   &_huff_book__16u1__short,&_huff_book__16u1__short,
   &_resbook_16u_1,&_resbook_16u_1},
  
  {1,0,  &_residue_44_mid_un,
   &_huff_book__16u1__long,&_huff_book__16u1__long,
   &_resbook_16u_1,&_resbook_16u_1}
};
static vorbis_residue_template _res_16u_2[]={
  {1,0,  &_residue_44_hi_un,
   &_huff_book__16u2__short,&_huff_book__16u2__short,
   &_resbook_16u_2,&_resbook_16u_2},

  {1,0,  &_residue_44_hi_un,
   &_huff_book__16u2__long,&_huff_book__16u2__long,
   &_resbook_16u_2,&_resbook_16u_2}
};


static vorbis_mapping_template _mapres_template_16_uncoupled[3]={
  { _map_nominal_u, _res_16u_0 }, /* 0 */
  { _map_nominal_u, _res_16u_1 }, /* 1 */
  { _map_nominal_u, _res_16u_2 }, /* 2 */
};





/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE OggVorbis SOFTWARE CODEC SOURCE CODE.   *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE OggVorbis SOURCE CODE IS (C) COPYRIGHT 1994-2002             *
 * by the XIPHOPHORUS Company http://www.xiph.org/                  *
 *                                                                  *
 ********************************************************************

 function: toplevel residue templates 8/11kHz
 last mod: $Id: residue_8.h 7187 2004-07-20 07:24:27Z xiphmont $

 ********************************************************************/

//#include "vorbis/codec.h"
//#include "backends.h"

/***** residue backends *********************************************/

static static_bookblock _resbook_8s_0={
  {
    {0},{0,0,&_8c0_s_p1_0},{0,0,&_8c0_s_p2_0},{0,0,&_8c0_s_p3_0},
    {0,0,&_8c0_s_p4_0},{0,0,&_8c0_s_p5_0},{0,0,&_8c0_s_p6_0},
    {&_8c0_s_p7_0,&_8c0_s_p7_1},{&_8c0_s_p8_0,&_8c0_s_p8_1},
    {&_8c0_s_p9_0,&_8c0_s_p9_1,&_8c0_s_p9_2}
   }
};
static static_bookblock _resbook_8s_1={
  {
    {0},{0,0,&_8c1_s_p1_0},{0,0,&_8c1_s_p2_0},{0,0,&_8c1_s_p3_0},
    {0,0,&_8c1_s_p4_0},{0,0,&_8c1_s_p5_0},{0,0,&_8c1_s_p6_0},
    {&_8c1_s_p7_0,&_8c1_s_p7_1},{&_8c1_s_p8_0,&_8c1_s_p8_1},
    {&_8c1_s_p9_0,&_8c1_s_p9_1,&_8c1_s_p9_2}
   }
};

static vorbis_residue_template _res_8s_0[]={
  {2,0,  &_residue_44_mid,
   &_huff_book__8c0_s_single,&_huff_book__8c0_s_single,
   &_resbook_8s_0,&_resbook_8s_0},
};
static vorbis_residue_template _res_8s_1[]={
  {2,0,  &_residue_44_mid,
   &_huff_book__8c1_s_single,&_huff_book__8c1_s_single,
   &_resbook_8s_1,&_resbook_8s_1},
};

static vorbis_mapping_template _mapres_template_8_stereo[2]={
  { _map_nominal, _res_8s_0 }, /* 0 */
  { _map_nominal, _res_8s_1 }, /* 1 */
};

static static_bookblock _resbook_8u_0={
  {
    {0},
    {0,0,&_8u0__p1_0},
    {0,0,&_8u0__p2_0},
    {0,0,&_8u0__p3_0},
    {0,0,&_8u0__p4_0},
    {0,0,&_8u0__p5_0},
    {&_8u0__p6_0,&_8u0__p6_1},
    {&_8u0__p7_0,&_8u0__p7_1,&_8u0__p7_2}
   }
};
static static_bookblock _resbook_8u_1={
  {
    {0},
    {0,0,&_8u1__p1_0},
    {0,0,&_8u1__p2_0},
    {0,0,&_8u1__p3_0},
    {0,0,&_8u1__p4_0},
    {0,0,&_8u1__p5_0},
    {0,0,&_8u1__p6_0},
    {&_8u1__p7_0,&_8u1__p7_1},
    {&_8u1__p8_0,&_8u1__p8_1},
    {&_8u1__p9_0,&_8u1__p9_1,&_8u1__p9_2}
   }
};

static vorbis_residue_template _res_8u_0[]={
  {1,0,  &_residue_44_low_un,
   &_huff_book__8u0__single,&_huff_book__8u0__single,
   &_resbook_8u_0,&_resbook_8u_0},
};
static vorbis_residue_template _res_8u_1[]={
  {1,0,  &_residue_44_mid_un,
   &_huff_book__8u1__single,&_huff_book__8u1__single,
   &_resbook_8u_1,&_resbook_8u_1},
};

static vorbis_mapping_template _mapres_template_8_uncoupled[2]={
  { _map_nominal_u, _res_8u_0 }, /* 0 */
  { _map_nominal_u, _res_8u_1 }, /* 1 */
};
