#ifndef BYTESWAP_H
#define BYTESWAP_H

#include <inttypes.h>

uint16_t bswap_16(uint16_t);
#pragma aux bswap_16 parm [ax] value [ax] = "xchg al,ah"

uint32_t bswap_32(uint32_t);
#pragma aux bswap_32 parm [eax] value [eax] = "bswap eax"

static inline uint64_t bswap_64(uint64_t x)
{
    union {
        uint64_t ll;
        uint32_t l[2];
    } w, r;
    w.ll = x;
    r.l[0] = bswap_32(w.l[1]);
    r.l[1] = bswap_32(w.l[0]);
    return r.ll;
}

#endif /* BYTESWAP_H */
