//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2007 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//

#ifndef diskdriv_h
#define diskdriv_h

#include "in_file.h"

#define MPXPLAY_DISKDRIVEDATA_INFOBIT_INTMDDS 1 // internally allocated mdds

typedef struct mpxplay_diskdrive_data_s{
 struct mpxplay_drivehand_func_s *mdfs;
 void *drive_data;
 void *file_data;
 mpxp_int32_t infobits;
}mpxplay_diskdrive_data_s;

extern struct mpxplay_drivehand_func_s *mpxplay_diskdrive_search_driver(char *pathname);
extern void mpxplay_diskdrive_drive_about(struct mpxplay_diskdrive_data_s *mdds);
extern void mpxplay_diskdrive_drive_config(struct mpxplay_diskdrive_data_s *mdds);
extern unsigned int mpxplay_diskdrive_drive_mount(struct mpxplay_diskdrive_data_s *mdds,char *pathname);
extern void mpxplay_diskdrive_drive_unmount(struct mpxplay_diskdrive_data_s *mdds);
extern unsigned int mpxplay_diskdrive_drive_getname_and_type(struct mpxplay_diskdrive_data_s *mdds,char *drivenamebuf,unsigned int maxdrivenamelen,char *typenamebuf,unsigned int maxtypenamelen);
extern unsigned int mpxplay_diskdrive_findfirst(struct mpxplay_diskdrive_data_s *mdds,char *pathname,unsigned int attrib,struct pds_find_t *ffblk);
extern unsigned int mpxplay_diskdrive_findnext(struct mpxplay_diskdrive_data_s *mdds,struct pds_find_t *ffblk);
extern void mpxplay_diskdrive_findclose(struct mpxplay_diskdrive_data_s *mdds,struct pds_find_t *ffblk);
extern char *mpxplay_diskdrive_getcwd(struct mpxplay_diskdrive_data_s *mdds,char *buf,unsigned int buflen);
extern int mpxplay_diskdrive_chdir(struct mpxplay_diskdrive_data_s *mdds,char *path);
extern int mpxplay_diskdrive_mkdir(struct mpxplay_diskdrive_data_s *mdds,char *path);
extern int mpxplay_diskdrive_rmdir(struct mpxplay_diskdrive_data_s *mdds,char *path);
extern int mpxplay_diskdrive_rename(struct mpxplay_diskdrive_data_s *mdds,char *oldfilename,char *newfilename);
extern int mpxplay_diskdrive_unlink(struct mpxplay_diskdrive_data_s *mdds,char *filename);
extern int mpxplay_diskdrive_media_unload_load(struct mpxplay_diskdrive_data_s *mdds);

extern struct mpxplay_drivehand_func_s *mpxplay_diskdrive_filehandler_search(char *filename);
extern struct mpxplay_diskdrive_data_s *mpxplay_diskdrive_filehandler_alloc(char *filename);
extern void mpxplay_diskdrive_filehandler_free(struct mpxplay_diskdrive_data_s *mdds);
extern void *mpxplay_diskdrive_file_open_read(struct mpxplay_diskdrive_data_s *mdds,char *filename);
extern void *mpxplay_diskdrive_file_open_write(struct mpxplay_diskdrive_data_s *mdds,char *filename);
extern void *mpxplay_diskdrive_file_open_create(struct mpxplay_diskdrive_data_s *mdds,char *filename);
extern void mpxplay_diskdrive_file_close(void *mdfd);
extern long mpxplay_diskdrive_file_read(void *mdfd,char *buf,unsigned int len);
extern long mpxplay_diskdrive_file_write(void *mdfd,char *buf,unsigned int len);
extern mpxp_filesize_t mpxplay_diskdrive_file_seek(void *mdfd,mpxp_filesize_t offset,int fromwhere);
extern mpxp_filesize_t mpxplay_diskdrive_file_tell(void *mdfd);
extern mpxp_filesize_t mpxplay_diskdrive_file_length(void *mdfd);
extern int mpxplay_diskdrive_file_eof(void *mdfd);
extern int mpxplay_diskdrive_file_chsize(void *mdfd,mpxp_filesize_t offset);

extern unsigned int mpxplay_diskdrive_subdirscan_open(struct mpxplay_diskdrive_data_s *mdds,char *path_and_filename,unsigned int attrib,struct pds_subdirscan_t *dsi);
extern int mpxplay_diskdrive_subdirscan_findnextfile(struct mpxplay_diskdrive_data_s *mdds,struct pds_subdirscan_t *dsi);
extern void mpxplay_diskdrive_subdirscan_close(struct mpxplay_diskdrive_data_s *mdds,struct pds_subdirscan_t *dsi);
extern unsigned int mpxplay_diskdrive_dir_exists(struct mpxplay_diskdrive_data_s *mdds,char *path);

#endif // diskdriv_h
