
/*
 * Convert a string between UTF-8 and the locale's charset.
 * Invalid bytes are replaced by '#', and characters that are
 * not available in the target encoding are replaced by '?'.
 *
 * If the locale's charset is not set explicitly then it is
 * obtained using nl_langinfo(CODESET), where available, the
 * environment variable CHARSET, or assumed to be US-ASCII.
 *
 * Return value of conversion functions:
 *
 *  -1 : memory allocation failed
 *   0 : data was converted exactly
 *   1 : valid data was converted approximately (using '?')
 *   2 : input was invalid (but still converted, using '#')
 *   3 : unknown encoding (but still converted, using '?')
 */

#ifndef __UTF8_H
#define __UTF8_H

#ifdef	__cplusplus
extern "C" {
#endif

int utf8_encode(const char *from, char **to);
int utf8_decode(const char *from, char **to);

#ifndef _WIN32

 void convert_set_charset(char *charset);

 int utf8_mbtowc(int *pwc, const char *s, size_t n);
 int utf8_wctomb(char *s, int wc);

 struct charset;

 struct charset *charset_find(const char *code);

 int charset_mbtowc(struct charset *charset, int *pwc, const char *s, size_t n);
 int charset_wctomb(struct charset *charset, char *s, int wc);
 int charset_max(struct charset *charset);

 int charset_convert(const char *fromcode, const char *tocode,
		    const char *from, size_t fromlen,
		    char **to, size_t *tolen);

#endif // !_WIN32


#ifdef	__cplusplus
}
#endif

#endif /* __UTF8_H */
