//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function:directory routines

#include "newfunc\newfunc.h"
#include "in_funcs.h"
#include "control\control.h"
#include "display\display.h"
#include "playlist.h"

#define MAX_DIRECTORY_DEPTH 32

static struct playlist_entry_info *drives_getall(struct playlist_entry_info *,char **);
static struct playlist_entry_info *get_directories(struct playlist_entry_info *,struct playlist_side_info *,char **);
static struct playlist_entry_info *get_files_from_dir(struct playlist_entry_info *,struct playlist_side_info *,char **,char *);

extern unsigned int desktopmode;

static char allscanstring[16]="d:\\*.*\\*.*";

static unsigned int playlist_loaddir_scandirs(struct playlist_side_info *psi,char *searchpath)
{
 char *pointer,*shortfname,*p2;
 int level,reach,drive;
 unsigned int dirtree,lastdirmask,aktdrive,fferror;
 struct playlist_entry_info *pei,*begine;
 char *dirmasks[MAX_DIRECTORY_DEPTH];
 char filemask[300];
 struct pds_find_t ffblk[MAX_DIRECTORY_DEPTH]; // !!! a little big

 if(!searchpath || !searchpath[0])
  return 0;

 save_dir();
 begine=pei=psi->lastentry+1;
 pointer=psi->filenameslastp;

 pds_strcpy(filemask,searchpath);

 //set drive
 if(filemask[1]==':'){
  drive=pds_getdrivenum_from_path(filemask);
  if(drive>=0){
   pds_setdrive(drive);
   pds_getdrive(&aktdrive);
   if(aktdrive!=drive)
    goto scan_end;
   p2=&filemask[2];
  }else
   goto scan_end;
 }else{
  drive=0;
  p2=&filemask[0];
 }
 //set rootdir
 if(p2[0]=='\\'){
  pds_chdir("\\");
  p2++;
 }
 dirtree=lastdirmask=0;

 //set subdir
 do{
  shortfname=pds_strchr(p2,'\\');
  if(shortfname!=NULL){
   shortfname[0]=0;
   if(pds_strchr(p2,'*')==NULL && pds_strchr(p2,'?')==NULL)
    pds_chdir(p2);
   else{
    dirmasks[lastdirmask++]=p2;
    dirtree=1;
   }
   p2=shortfname+1;
  }else{
   shortfname=p2;
   break;
  }
 }while(1);

 if(dirtree){ // scan subdirs
  level=0;
  reach=-1;
  do{
   if(reach<level){
    pei=get_files_from_dir(pei,psi,&pointer,shortfname);
    reach=level;
    if(level<lastdirmask)
     fferror=pds_findfirst(dirmasks[level],_A_SUBDIR,&ffblk[level]);
    else
     fferror=pds_findfirst("*.*",_A_SUBDIR,&ffblk[level]);
    while(((pds_stricmp("..",ffblk[level].name)==0)
        || (pds_stricmp(".",ffblk[level].name)==0)
	|| !(ffblk[level].attrib&_A_SUBDIR))
	&& !fferror){
     fferror=pds_findnext(&ffblk[level]);
    }
   }else{
    do{
     fferror=pds_findnext(&ffblk[level]);
    }while(((pds_stricmp("..",ffblk[level].name)==0)
	 || (pds_stricmp(".",ffblk[level].name)==0)
	 || !(ffblk[level].attrib&_A_SUBDIR))
	 && !fferror);
   }
   if(!fferror){
    if(pds_chdir(ffblk[level].name)==0)
     level++;
   }else
    if(level>0){
     pds_chdir("..");
     pds_findclose(&ffblk[level]);
     level--;
     reach--;
    }else
     break;
  }while((level>=0) && pds_look_extgetch()!=KEY_ESC);
  pds_findclose(&ffblk[0]);
 }else{ // scan one dir only
  pei=get_files_from_dir(pei,psi,&pointer,shortfname);
 }

 if(pei==begine)  // do not load (here) cdw tracks from mixed-mode CDs
  pei=cdw_get_allfiles(pei,&pointer,drive,shortfname);

scan_end:

 if(pei>psi->firstentry)
  playlist_enable_side(psi);
 else
  playlist_disable_side(psi);

 psi->lastentry=pei-1;
 psi->filenameslastp=pointer;
 restore_dir();
 clear_message();
 if(pds_look_extgetch()==KEY_ESC){
  pds_extgetch();
  return KEY_ESC;
 }
 return 1;
}

void playlist_loaddir_scandrives(struct playlist_side_info *psi,char *searchpath,char *dslp)
{
 char filemask[300];

 if(dslp && *dslp){
  if(!searchpath || !searchpath[0])
   searchpath=&allscanstring[0];
  do{
   filemask[0]=0;
   if(searchpath[1]!=':'){
    pds_strcpy(filemask,"d:");
    if(searchpath[0]!='\\')
     pds_strcat(filemask,"\\*.*\\");
   }
   pds_strcat(filemask,searchpath);
   filemask[0]=dslp[0];
   if(playlist_loaddir_scandirs(psi,filemask)==KEY_ESC)
    break;
   dslp++;
  }while(*dslp);
 }else{
  playlist_loaddir_scandirs(psi,searchpath);
 }
}

//***************************************************************************
void playlist_loaddir_buildbrowser(struct playlist_side_info *psi)
{
 char *filenamesp;
 struct playlist_entry_info *pei;

 playlist_clear_side(psi);
 playlist_enable_side(psi);

 filenamesp=psi->filenameslastp;
 pei=psi->firstentry;
 if(desktopmode&DTM_EDIT_DRIVES)
  pei=drives_getall(pei,&filenamesp);
 if(pei==(psi->firstentry+1)){ // disable drive list if there's 1 drive only in the computer
  playlist_clear_side(psi); // ??? (a little slow)
  playlist_enable_side(psi);
  pei=psi->firstentry;
 }
 pei=get_directories(pei,psi,&filenamesp);
 pei=get_files_from_dir(pei,psi,&filenamesp,"*.*"); // load all supported filetypes
 if(pei>psi->firstentry)
  psi->lastentry=pei-1;
 playlist_order_dft(psi);              // order directories & filenames
 psi->currdrive=pds_getdrivenum_from_path(psi->currdir);
 pei=cdw_get_allfiles(pei,&filenamesp,psi->currdrive,"*.*"); // get all cdw files
 psi->lastentry=pei-1;
 psi->filenameslastp=filenamesp;
 playlist_search_firstsong(psi);
}

//#define SHOW_DRIVE_VOLUME_NAMES

#ifdef SHOW_DRIVE_VOLUME_NAMES
static void drive_getname(unsigned int drivenum,char *filenamesfieldp)
{
 unsigned int error;
 struct pds_find_t ffblk;

 filenamesfieldp[0]=drivenum+65;
 filenamesfieldp[1]=':';
 error=pds_findfirst("\\*.*",_A_VOLID,&ffblk);
 if(!error && (ffblk.attrib&_A_VOLID)){
  filenamesfieldp[2]=32;
  filenamesfieldp+=3;
  pds_strcpy(filenamesfieldp,ffblk.name);
  filenamesfieldp[8]=0;
 }else{
  filenamesfieldp[2]=0;
 }
 pds_findclose(&ffblk);
}
#else
static void drive_getname(unsigned int drivenum,char *filenamesfieldp)
{
 filenamesfieldp[0]=drivenum+65;
 filenamesfieldp[1]=':';
 filenamesfieldp[2]=0;
}
#endif

//                                                  dynamic field   static field
static void drive_getnameinfo(unsigned int drivenum,char *drivename,char **driveinfo)
{
 drive_getname(drivenum,drivename);
 if(cdw_is_drive_cd(drivenum))
  *driveinfo="<CD_ROM>";
 else
  *driveinfo="<DRIVE>";
}

static struct playlist_entry_info *drives_getall(struct playlist_entry_info *pei,char **filenamesfieldp)
{
 unsigned int startdrive,lastdrive,aktdrive,chkdrive;
 struct playlist_entry_info *pei_begin=pei;

 pds_drivesinfo(&startdrive,&lastdrive);
 for(chkdrive=2;chkdrive<=lastdrive;chkdrive++){
  pds_setdrive(chkdrive);
  pds_getdrive(&aktdrive);
  if(aktdrive==chkdrive){
   pei->entrytype=DFT_DRIVE;
   pei->filename=*filenamesfieldp;
   drive_getnameinfo(chkdrive,pei->filename,&pei->id3info[I3I_DFT_STORE]);
   *filenamesfieldp+=pds_strlen(*filenamesfieldp)+1;
   pei++;
  }
 }
 if(pei>pei_begin){
  if(startdrive<2) // if Mpxplay started from floppy, we don't step back
   startdrive=2;
  pds_setdrive(startdrive);
 }
 return pei;
}

static struct playlist_entry_info *get_directories(struct playlist_entry_info *pei,struct playlist_side_info *psi,char **filenamesfieldp)
{
 unsigned int error,pathlen;
 struct pds_find_t ffblk;
 char path[300];

 pds_getcwd(path);

 pathlen=pds_strcpy(psi->currdir,path);

 if(path[pathlen-1]!='\\')
  pds_strcpy(&path[pathlen],"\\");

 if(pathlen>3){ // we assume this is not the root directory (more than "c:\")
  pei->id3info[I3I_DFT_STORE]="<UP--DIR>";
  pds_strcpy(*filenamesfieldp,path);
  pds_strcat(*filenamesfieldp,"..");
  pei->filename=*filenamesfieldp;
  *filenamesfieldp+=pds_strlen(*filenamesfieldp)+1;
  pei->entrytype=DFT_UPDIR;
  pei++;
 }

 error=pds_findfirst("*.*",_A_SUBDIR,&ffblk);
 while(!error){
  if((ffblk.attrib&_A_SUBDIR) && pds_stricmp(".",ffblk.name)!=0 && pds_stricmp("..",ffblk.name)!=0){
   pei->id3info[I3I_DFT_STORE]="<SUB-DIR>";
   pds_strcpy(*filenamesfieldp,path);
   pds_strcat(*filenamesfieldp,ffblk.name);
   pei->filename=*filenamesfieldp;
   *filenamesfieldp+=pds_strlen(*filenamesfieldp)+1;
   pei->entrytype=DFT_SUBDIR;
   pei++;
  }
  error=pds_findnext(&ffblk);
 }
 pds_findclose(&ffblk);
 return pei;
}

static struct playlist_entry_info *get_files_from_dir(struct playlist_entry_info *pei,
              struct playlist_side_info *psi,char **filenamesfieldp,char *scanfilename)
{
 unsigned int error,pathlen,scanallfiletypes;
 struct pds_find_t ffblk;
 char *ext,path[300],strtemp[64];

 pds_getcwd(path);

 pathlen=pds_strlen(path);
 if(path[pathlen-1]!='\\')
  pds_strcpy(&path[pathlen],"\\");

 if(!(psi->editsidetype&PLT_DIRECTORY)){
  sprintf(strtemp,"Read filenames (%3d) from ",pei-psi->firstentry);
  display_message(0,0,strtemp);
  display_message(1,0,path);
 }

 scanallfiletypes=0;
 ext=pds_strrchr(scanfilename,'.');
 if(ext){
  if(pds_stricmp(ext,".*")==0)
   scanallfiletypes=1;
 }

 error=pds_findfirst(scanfilename,_A_NORMAL,&ffblk);
 while(!error && (pei<=psi->endentry) && (*filenamesfieldp<psi->filenamesendp)){
  if(!(ffblk.attrib&(_A_SUBDIR|_A_VOLID))){
   unsigned int found=0;
   if((psi->editsidetype&PLT_DIRECTORY) || !scanallfiletypes)
    found=playlist_loadlist_get_header_by_ext(pei,psi,ffblk.name); // get playlist-filenames too
   if(!scanallfiletypes)  // don't check the extension
    found=1;
   if(!found)
    found=infile_check_extension(ffblk.name);
   if(found){
    pds_strcpy(*filenamesfieldp,path);
    pds_strcat(*filenamesfieldp,ffblk.name);
    pei->filename=*filenamesfieldp;
    *filenamesfieldp+=pds_strlen(*filenamesfieldp)+1;
    pei++;
   }
  }
  error=pds_findnext(&ffblk);
 }
 pds_findclose(&ffblk);
 return pei;
}

struct playlist_side_info *playlist_loaddir_changedir(struct playlist_side_info *psi,unsigned long head)
{
 struct playlist_entry_info *pei=psi->editorhighline;
 char lastdir[300];

 lastdir[0]=0;
 if(head==DFT_ROOTDIR){
  pds_chdir("\\");
 }else{
  if(head==DFT_DRIVE){
   int drive;
   lastdir[0]=psi->currdrive+65;
   lastdir[1]=':';
   lastdir[2]=0;
   drive=pds_getdrivenum_from_path(pei->filename);
   if(drive>=0)
    pds_setdrive(drive);
  }else{
   if(head==DFT_SUBDIR){
    if(pei->filename){
     pds_strcpy(lastdir,pei->filename);
     pds_strcat(lastdir,"\\..");
     pds_chdir(pei->filename);
    }
   }else{
    if(head==DFT_UPDIR){
     pds_getcwd(lastdir);
     pds_chdir("..");
    }
   }
  }
 }

 pds_getcwd(&psi->currdir);

 playlist_loaddir_buildbrowser(psi);
 playlist_id3list_load(psi->mvp,psi);
 playlist_search_lastdir(psi,lastdir);
 return psi;
}

void playlist_loaddir_search_paralell_dir(struct playlist_side_info *psi,int step)
{
 unsigned int found;
 struct playlist_entry_info *pei;
 char lastdir[300];

 pds_strcpy(lastdir,psi->currdir);
 playlist_loaddir_changedir(psi,DFT_UPDIR);
 if(pds_stricmp(lastdir,psi->currdir)!=0){
  found=0;
  pei=psi->editorhighline;
  pei+=step;
  while((step==1 && pei<=psi->lastentry) || (step==-1 && pei>=psi->firstentry)){
   if(pei->entrytype==DFT_SUBDIR){
    psi->editorhighline=pei;
    playlist_loaddir_changedir(psi,DFT_SUBDIR);
    found=1;
    break;
   }
   pei+=step;
  }
  if(!found)
   playlist_loaddir_changedir(psi,DFT_SUBDIR);
 }
 playlist_chkfile_start_norm(psi,0);
}
