//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function:jukebox

#include "newfunc\newfunc.h"
#include "playlist.h"
#include "display\display.h"

extern unsigned int refdisp,playcontrol,playlistload,playrand;

void playlist_jukebox_add_entry(struct mainvars *mvp,struct playlist_side_info *psi_src)
{
 if((mvp->newsong>=psi_src->firstsong) && (mvp->newsong<=psi_src->lastentry)){ // if the doomlist-side and the newsong-side match (they don't match at album-skip)
  struct playlist_side_info *psi_dest=mvp->psip;
  unsigned int sideused=psi_dest->editsidetype&PLT_ENABLED;

  playlist_editlist_addfile_any(psi_src,mvp->newsong);
  if((!sideused && !(playcontrol&PLAYC_RUNNING)) || !mvp->frp0->infile_datas)
   start_sideplay(mvp,psi_dest);
  else
   refdisp|=RDT_BROWSER|RDT_EDITOR;
  mvp->newsong=NULL;
 }
}

void playlist_jukebox_skip(struct mainvars *mvp)
{
 struct playlist_side_info *psi=mvp->psip;
 struct playlist_entry_info *peiakt,*peinew;

 if(mvp->direction==0)
  mvp->direction=1;
 if(psi->lastentry>=psi->firstentry){

  if(mvp->aktfilenum>=psi->firstentry){
   if(mvp->aktfilenum>psi->lastentry)
    mvp->aktfilenum=psi->lastentry;
   peinew=mvp->newfilenum;
   peiakt=mvp->aktfilenum;
   if(peiakt!=peinew){ // do not delete if newfilenum==aktfilenum
    if(peiakt->entrytype<DFT_AUDIOFILE)
     peiakt->entrytype=DFT_UNKNOWN;              // else delfile will not delete HFT_DFT
    playlist_editlist_delfile(psi,peiakt,EDITLIST_MODE_ALL);
    if(playrand && !peinew)
     mvp->newfilenum=NULL;
   }
  }

  playlist_skip(mvp);

  if(mvp->aktfilenum>psi->lastentry)
   mvp->aktfilenum=psi->lastentry;
  if(mvp->aktfilenum<psi->firstentry)
   mvp->aktfilenum=psi->firstentry;
 }
 if(psi->lastentry<psi->firstentry)
  mpxplay_stop_and_clear(mvp,0);
}

void playlist_jukebox_switch(struct mainvars *mvp)
{
 struct playlist_side_info *psi0=mvp->psi0;
 struct playlist_side_info *psi1=mvp->psi0+1;

 playlistload^=PLL_DOOMBOX;

 playlist_disable_side(psi1);
 playlist_reset_side(psi0);
 playlist_reset_side(psi1);

 if(!(playlistload&PLL_LISTS_ALL) || !(playlistload&PLL_DOOMBOX))
  psi0->editsidetype|=PLT_DIRECTORY;

 playlist_init_pointers(mvp);

 playlist_get_allfilenames(mvp);

 if((playlistload&PLL_DOOMBOX) || (psi1->editsidetype&PLT_ENABLED))
  mvp->psip=psi1;
 else
  mvp->psip=psi0;

 if(!(playlistload&PLL_DOOMBOX) && (mvp->psie==mvp->psi0) && (mvp->psip!=mvp->psie)){
  struct playlist_side_info *psie;
  playlist_change_editorside(mvp);
  psie=mvp->psie;
  playlist_editorhighline_set(psie,psie->firstentry);
 }
 mvp->aktfilenum=mvp->psip->firstsong-1;
 playlist_chkfile_start_norm(psi0,0);
 playlist_chkfile_start_norm(psi1,0);
}
