//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: memory handling

#include <malloc.h>
#include "newfunc.h"
#include "mpxplay.h"

//extern unsigned int intsoundconfig,intsoundcontrol;

#ifdef NEWFUNC_ASM

void asm_memcpy(void *,void *,unsigned int);

void pds_memcpy(void *addr_dest,void *addr_src,unsigned int len)
{
 #pragma aux asm_memcpy=\
 "cld"\
 "mov esi,edx"\
 "mov edi,eax"\
 "mov eax,ebx"\
 "mov ecx,eax"\
 "shr ecx,2"\
 "repne movsd"\
 "mov ecx,eax"\
 "and ecx,3"\
 "repne movsb"\
 parm[eax][edx][ebx] modify[eax ecx edi esi];
 asm_memcpy(addr_dest,addr_src,len);
}

void asm_memset(void *,int,unsigned int);

void pds_memset(void *addr,int num,unsigned int len)
{
#pragma aux asm_memset=\
 "cld"\
 "mov edi,eax"\
 "mov dh,dl"\
 "mov eax,edx"\
 "bswap eax"\
 "mov ax,dx"\
 "mov ecx,ebx"\
 "shr ecx,2"\
 "repne stosd"\
 "mov ecx,ebx"\
 "and ecx,3"\
 "repne stosb"\
 parm[eax][edx][ebx] modify[eax ecx edx edi];
 asm_memset(addr,num,len);
}

void asm_qmemreset(void *,unsigned int);

void pds_qmemreset(void *addr,unsigned int len)
{
 #pragma aux asm_qmemreset=\
 "cld"\
 "mov edi,eax"\
 "mov ecx,edx"\
 "xor eax,eax"\
 "repne stosd"\
 parm[eax][edx] modify[eax ecx edi];
 asm_qmemreset(addr,len);
}

void asm_qmemcpy(void *,void *,unsigned int);

void pds_qmemcpy(void *addr_dest,void *addr_src,unsigned int len)
{
 #pragma aux asm_qmemcpy=\
 "cld"\
 "mov edi,eax"\
 "mov esi,edx"\
 "mov ecx,ebx"\
 "repne movsd"\
 parm[eax][edx][ebx] modify[ecx edi esi];
 asm_qmemcpy(addr_dest,addr_src,len);
}

void asm_qmemcpyr(void *,void *,unsigned int);

void pds_qmemcpyr(void *addr_dest,void *addr_src,unsigned int len)
{
 #pragma aux asm_qmemcpyr=\
 "std"\
 "mov edi,eax"\
 "mov esi,edx"\
 "mov ecx,ebx"\
 "dec ebx"\
 "shl ebx,2"\
 "add edi,ebx"\
 "add esi,ebx"\
 "repne movsd"\
 "cld"\
 parm[eax][edx][ebx] modify[ebx ecx edi esi];
 asm_qmemcpyr(addr_dest,addr_src,len);
}

void asm_memxch(char *,char *,unsigned int);

void pds_memxch(char *addr1,char *addr2,unsigned int len)
{
#pragma aux asm_memxch=\
 "mov ecx,ebx"\
 "and ecx,3"\
 "jz jump1"\
 "back1:"\
  "mov edi,dword ptr [eax]"\
  "mov esi,dword ptr [edx]"\
  "mov dword ptr [edx],edi"\
  "mov dword ptr [eax],esi"\
  "inc edx"\
  "inc eax"\
  "dec ecx"\
 "jnz back1"\
 "jump1:"\
 "shr ebx,2"\
 "mov ecx,4"\
 "back2:"\
  "mov edi,dword ptr [eax]"\
  "mov esi,dword ptr [edx]"\
  "mov dword ptr [edx],edi"\
  "mov dword ptr [eax],esi"\
  "add edx,ecx"\
  "add eax,ecx"\
  "dec ebx"\
 "jnz back2"\
 parm[eax][edx][ebx] modify[eax edx ebx ecx edi esi];
 asm_memxch(addr1,addr2,len);
}

#else

void pds_memxch(char *addr1,char *addr2,unsigned int len)
{
 while(len--){
  char tmp1=*addr1,tmp2=*addr2;
  *addr1=tmp2;
  *addr2=tmp1;
  addr1++;addr2++;
 }
}

#endif

// can be different (more safe) than the normal malloc
void *pds_malloc(unsigned int bufsize)
{
 //unsigned int intsoundcntrl_save;
 void *bufptr;
 if(!bufsize)
  return NULL;
 //MPXPLAY_INTSOUNDDECODER_DISALLOW;
 //_disable();
 bufptr=malloc(bufsize);
 //_enable();
 //MPXPLAY_INTSOUNDDECODER_ALLOW;
 return bufptr;
}

void *pds_calloc(unsigned int nitems,unsigned int itemsize)
{
 //unsigned int intsoundcntrl_save;
 void *bufptr;
 if(!nitems || !itemsize)
  return NULL;
 //MPXPLAY_INTSOUNDDECODER_DISALLOW;
 //_disable();
 bufptr=calloc(nitems,itemsize);
 //_enable();
 //MPXPLAY_INTSOUNDDECODER_ALLOW;
 return bufptr;
}

void *pds_realloc(void *bufptr,unsigned int bufsize)
{
 //unsigned int intsoundcntrl_save;
 //MPXPLAY_INTSOUNDDECODER_DISALLOW;
 //_disable();
 bufptr=realloc(bufptr,bufsize);
 //_enable();
 //MPXPLAY_INTSOUNDDECODER_ALLOW;
 return bufptr;
}

void pds_free(void *bufptr)
{
 //unsigned int intsoundcntrl_save;
 if(bufptr){
  //MPXPLAY_INTSOUNDDECODER_DISALLOW;
  //_disable();
  free(bufptr);
  //_enable();
  //MPXPLAY_INTSOUNDDECODER_ALLOW;
 }
}
