//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: drive & dir handling

#include <direct.h>
#include <dos.h>
#include <io.h>
#include <stdlib.h>
#include "newfunc.h"

extern unsigned int is_lfn_support,uselfn;
extern volatile unsigned long mpxplay_signal_events;
extern dosmem_t dm_int2x_1,dm_int2x_2;

void pds_fullpath(char *fullname,char *name)
{
 if(uselfn)
  pds_truename_lfn(fullname,name);
 else
  pds_truename_dos(fullname,name);
}

/*void pds_getdcwd(int drive,char *path)  // 0:default drive, A=1,B=2,C=3
{
#ifdef __DOS__
 if(pds_filehand_check_entrance()){
  *path=0;
  return;
 }
 pds_filehand_lock_entrance();
 if(is_lfn_support && uselfn){
  struct rminfo RMI;
  pds_dpmi_rmi_clear(&RMI);
  RMI.EAX=0x00007147;
  RMI.EDX=drive&0xff; // doesn't work under Win98SE ?  // 0:default drive, A=1,B=2,C=3
  RMI.DS =dm_int2x_1.segment;
  funcbit_enable(RMI.flags,RMINFO_FLAG_CARRY);
  pds_dpmi_realmodeint_call(0x21,&RMI);
  if(funcbit_test(RMI.flags,RMINFO_FLAG_CARRY) || (pds_strlen((char *)dm_int2x_1.linearptr)>=300))
   path[0]=0;
  else{
   if(dm_int2x_1.linearptr[1]!=':'){
    unsigned int drivenum;
    pds_getdrive(&drivenum);
    path[0]='A'+drivenum;
    path[1]=':';
    path[2]='\\';
    path+=3;
   }
   pds_strcpy(path,dm_int2x_1.linearptr);
  }
 }else
#endif
  _getdcwd(drive&0xff,path,300); // 0:default drive, A=1,B=2,C=3
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
}

void pds_getcwd(char *path)
{
#ifdef __DOS__
 if(pds_filehand_check_entrance()){
  *path=0;
  return;
 }
 if(is_lfn_support && uselfn){
  pds_getdcwd(0,path);
 }else
#endif
  getcwd(path,300);
}*/

void pds_getcwd(char *path)
{
#ifdef __DOS__
 if(pds_filehand_check_entrance()){
  *path=0;
  return;
 }
 pds_filehand_lock_entrance();
 if(is_lfn_support && uselfn){
  struct rminfo RMI;
  pds_dpmi_rmi_clear(&RMI);
  RMI.EAX=0x00007147;
  RMI.DS =dm_int2x_1.segment;
  funcbit_enable(RMI.flags,RMINFO_FLAG_CARRY);
  pds_dpmi_realmodeint_call(0x21,&RMI);
  if(funcbit_test(RMI.flags,RMINFO_FLAG_CARRY) || (pds_strlen((char *)dm_int2x_1.linearptr)>=300))
   path[0]=0;
  else{
   if(dm_int2x_1.linearptr[1]!=':'){
    unsigned int drivenum;
    pds_filehand_unlock_entrance(); // !!!
    pds_getdrive(&drivenum);
    path[0]='A'+drivenum;
    path[1]=':';
    path[2]='\\';
    path+=3;
   }
   pds_strcpy(path,dm_int2x_1.linearptr);
  }
 }else
#endif
  getcwd(path,300);
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
}

void pds_getdcwd(int drive,char *path) // 0:default drive, A=1,B=2,C=3
{
#ifdef __DOS__
 if(pds_filehand_check_entrance()){
  *path=0;
  return;
 }
 pds_filehand_lock_entrance();
#endif
 _getdcwd(drive,path,300);
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
}

int pds_chdir(char *setpath)
{
 int result=-1;
#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return result;
 pds_filehand_lock_entrance();
 if(is_lfn_support && uselfn){
  struct rminfo RMI;
  pds_dpmi_rmi_clear(&RMI);
  RMI.EAX=0x0000713B;
  RMI.DS =dm_int2x_1.segment;
  funcbit_enable(RMI.flags,RMINFO_FLAG_CARRY);
  pds_strcpy(dm_int2x_1.linearptr,setpath);
  pds_dpmi_realmodeint_call(0x21,&RMI);
  if(!funcbit_test(RMI.flags,RMINFO_FLAG_CARRY))
   result=0;
 }else
#endif
  result=chdir(setpath);
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
 return result;
}

int pds_mkdir(char *newdirname)
{
 int result=-1;
#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return result;
 pds_filehand_lock_entrance();
 if(is_lfn_support && uselfn){
  struct rminfo RMI;
  pds_dpmi_rmi_clear(&RMI);
  RMI.EAX=0x00007139;
  RMI.DS =dm_int2x_1.segment;
  funcbit_enable(RMI.flags,RMINFO_FLAG_CARRY);
  pds_strcpy(dm_int2x_1.linearptr,newdirname);
  pds_dpmi_realmodeint_call(0x21,&RMI);
  if(!funcbit_test(RMI.flags,RMINFO_FLAG_CARRY))
   result=0;
 }else
#endif
 result=mkdir(newdirname);
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
 return result;
}

int pds_rmdir(char *dirname)
{
 int result=-1;
#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return result;
 pds_filehand_lock_entrance();
 if(is_lfn_support && uselfn){
  struct rminfo RMI;
  pds_dpmi_rmi_clear(&RMI);
  RMI.EAX=0x0000713A;
  RMI.DS =dm_int2x_1.segment;
  funcbit_enable(RMI.flags,RMINFO_FLAG_CARRY);
  pds_strcpy(dm_int2x_1.linearptr,dirname);
  pds_dpmi_realmodeint_call(0x21,&RMI);
  if(!funcbit_test(RMI.flags,RMINFO_FLAG_CARRY))
   result=0;
 }else
#endif
 result=rmdir(dirname);
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
 return result;
}

int pds_rename(char *oldfilename,char *newfilename)
{
 int result=-1;
#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return result;
 pds_filehand_lock_entrance();
 if(is_lfn_support && uselfn){
  struct rminfo RMI;
  pds_dpmi_rmi_clear(&RMI);
  RMI.EAX=0x00007156;
  RMI.DS =dm_int2x_1.segment;
  RMI.ES =dm_int2x_2.segment;
  funcbit_enable(RMI.flags,RMINFO_FLAG_CARRY);
  pds_strcpy(dm_int2x_1.linearptr,oldfilename);
  pds_strcpy(dm_int2x_2.linearptr,newfilename);
  pds_dpmi_realmodeint_call(0x21,&RMI);
  if(!funcbit_test(RMI.flags,RMINFO_FLAG_CARRY))
   result=0;
 }else
#endif
 result=rename(oldfilename,newfilename);
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
 return result;
}

int pds_unlink(char *filename)
{
 int result=-1;
#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return result;
 pds_filehand_lock_entrance();
 if(is_lfn_support && uselfn){ // readonly files?
  struct rminfo RMI;
  pds_dpmi_rmi_clear(&RMI);
  RMI.EAX=0x00007141;
  RMI.DS =dm_int2x_1.segment;
  funcbit_enable(RMI.flags,RMINFO_FLAG_CARRY);
  pds_strcpy(dm_int2x_1.linearptr,filename);
  pds_dpmi_realmodeint_call(0x21,&RMI);
  if(!funcbit_test(RMI.flags,RMINFO_FLAG_CARRY))
   result=0;
 }else
#endif
 {
  unsigned int attrib;
  if(_dos_getfileattr(filename,&attrib)!=0)
   goto unlink_end;
  if(attrib&(_A_HIDDEN|_A_SYSTEM|_A_VOLID|_A_SUBDIR))
   goto unlink_end;
  attrib&=~_A_RDONLY;
  if(_dos_setfileattr(filename,attrib)!=0)
   goto unlink_end;
  result=unlink(filename);
 }
unlink_end:
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
 return result;
}

//-------------------------------------------------------------------------
struct lfn_find_t
{
 unsigned char ff_attrib[4];  /* Attributes, DOS and extended   */
 unsigned long ff_lctime;     /* Creation time (low)   DOS date */
 unsigned long ff_hctime;     /* Creation time (high)           */
 unsigned long ff_latime;     /* Access time (low)    Date only */
 unsigned long ff_hatime;     /* Access time (high)             */
 unsigned long ff_lmtime;     /* Modification time (low)        */
 unsigned long ff_hmtime;     /* Modification time (high)       */
 unsigned long ff_hsize;      /* File size (high end)           */
 unsigned long ff_lsize;      /* File size (low end)            */
 unsigned char ff_reserved[8];
 unsigned char ff_longname[260];
 unsigned char ff_shortname[14];
};

unsigned int pds_findfirst(char *path,int attrib,struct pds_find_t *ffblk)
{
 unsigned int result=1;
 ffblk->ff_data=NULL;
#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return result;
 pds_filehand_lock_entrance();
 funcbit_enable(mpxplay_signal_events,MPXPLAY_SIGNALTYPE_DISKACCESS);
 if(is_lfn_support && uselfn){
  struct rminfo RMI;
  struct lfn_find_t *flblk;
  //char sout[100];
  pds_dpmi_rmi_clear(&RMI);
  RMI.EAX=0x0000714E;
  RMI.ECX=attrib;
  RMI.ESI=0x0001;
  RMI.DS =dm_int2x_1.segment;
  RMI.ES =dm_int2x_2.segment;
  funcbit_enable(RMI.flags,RMINFO_FLAG_CARRY);
  pds_strcpy(dm_int2x_1.linearptr,path);
  pds_dpmi_realmodeint_call(0x21,&RMI);
  if(funcbit_test(RMI.flags,RMINFO_FLAG_CARRY)){
   result=RMI.EAX;
   goto ff_end;
  }
  flblk=(struct lfn_find_t *)dm_int2x_2.linearptr;
  ffblk->attrib =flblk->ff_attrib[0];
  ffblk->wr_time=flblk->ff_lmtime&0xffff; // ???
  ffblk->wr_date=flblk->ff_lmtime>>16;    // ???
  //sprintf(sout,"%8.8X %8.8X %4.4X %4.4X",flblk->ff_hmtime,flblk->ff_lmtime,ffblk->wr_date,ffblk->wr_time);
  //display_message(1,0,sout);
  ffblk->size   =flblk->ff_lsize; // | ((unsigned long long)flblk->ff_hsize<<32);
  pds_strcpy(ffblk->name,flblk->ff_longname);
  ffblk->ff_data=(void *)RMI.EAX;
  result=0;
 }else
#endif
 {
  struct find_t *fsblk=pds_calloc(1,sizeof(struct find_t));
  if(!fsblk){
   result=5; // ENOMEM
   goto ff_end;
  }
  result=_dos_findfirst(path,attrib,fsblk);
  if(result==0){
   ffblk->attrib =fsblk->attrib;
   ffblk->wr_time=fsblk->wr_time;
   ffblk->wr_date=fsblk->wr_date;
   ffblk->size   =fsblk->size;
   pds_strcpy(ffblk->name,fsblk->name);
  }else{
   pds_free(fsblk);
   fsblk=NULL;
  }
  ffblk->ff_data=fsblk;
 }
ff_end:
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
 return result;
}

unsigned int pds_findnext(struct pds_find_t *ffblk)
{
 unsigned int result=1;
#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return result;
 pds_filehand_lock_entrance();
 funcbit_enable(mpxplay_signal_events,MPXPLAY_SIGNALTYPE_DISKACCESS);
 if(is_lfn_support && uselfn){
  struct rminfo RMI;
  struct lfn_find_t *flblk;
  pds_dpmi_rmi_clear(&RMI);
  RMI.EAX=0x0000714F;
  RMI.EBX=(unsigned long)ffblk->ff_data;
  RMI.ESI=0x0001;
  RMI.ES =dm_int2x_2.segment;
  funcbit_enable(RMI.flags,RMINFO_FLAG_CARRY);
  pds_memset(dm_int2x_2.linearptr,0,sizeof(struct lfn_find_t));
  pds_dpmi_realmodeint_call(0x21,&RMI);
  if(funcbit_test(RMI.flags,RMINFO_FLAG_CARRY)){
   result=RMI.EAX;
   goto fn_end;
  }
  flblk=(struct lfn_find_t *)dm_int2x_2.linearptr;
  ffblk->attrib =flblk->ff_attrib[0];
  ffblk->wr_time=flblk->ff_lmtime&0xffff;  // ???
  ffblk->wr_date=flblk->ff_lmtime>>16;     // ???
  ffblk->size   =flblk->ff_lsize; // | ((unsigned long long)flblk->ff_hsize<<32);
  pds_strcpy(ffblk->name,flblk->ff_longname);
  result=0;
 }else
#endif
 {
  struct find_t *fsblk=(struct find_t *)ffblk->ff_data;
  result=_dos_findnext(fsblk);
  if(result==0){
   ffblk->attrib =fsblk->attrib;
   ffblk->wr_time=fsblk->wr_time;
   ffblk->wr_date=fsblk->wr_date;
   ffblk->size   =fsblk->size;
   pds_strcpy(ffblk->name,fsblk->name);
  }
 }
fn_end:
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
 return result;
}

void pds_findclose(struct pds_find_t *ffblk)
{
#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return;
 pds_filehand_lock_entrance();
 if(is_lfn_support && uselfn){
  struct rminfo RMI;
  pds_dpmi_rmi_clear(&RMI);
  RMI.EAX=0x000071A1;
  RMI.EBX=(unsigned long)ffblk->ff_data;
  pds_dpmi_realmodeint_call(0x21,&RMI);
 }else
#endif
  if(ffblk->ff_data){
   #ifdef __WATCOMC__
   _dos_findclose((struct find_t *)ffblk->ff_data);
   #endif
   pds_free(ffblk->ff_data);
  }
 ffblk->ff_data=NULL;
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
}

static void pds_truename_select(char *fullname,char *name,int mode)
{
#ifdef __DOS__
 struct rminfo RMI;
#endif
 char strtmp[300];
 if(fullname!=NULL){
  if(fullname==name){
   pds_strcpy(strtmp,name);
   name=&strtmp[0];
  }
#ifdef __DOS__
  if(pds_filehand_check_entrance()){
   *name=0;
   return;
  }
  pds_filehand_lock_entrance();
  fullname[0]=0;
  if(is_lfn_support){
   pds_dpmi_rmi_clear(&RMI);
   *((char *)(dm_int2x_2.linearptr))=0;
   RMI.EAX=0x00007160;
   RMI.ECX=mode;
   RMI.DS =dm_int2x_1.segment;
   RMI.ES =dm_int2x_2.segment;
   pds_strcpy(dm_int2x_1.linearptr,name);
   pds_dpmi_realmodeint_call(0x21,&RMI);
   if(!(funcbit_test(RMI.flags,RMINFO_FLAG_CARRY)))
    pds_strcpy(fullname,dm_int2x_2.linearptr);
  }
  if(fullname[0]==0)
#endif
   _fullpath(fullname,name,270);
#ifdef __DOS__
  pds_filehand_unlock_entrance();
#endif
 }
}

// get long filename
static void pds_truename_lfn(char *longname,char *name)
{
 pds_truename_select(longname,name,2);
}

// get short filename
void pds_truename_dos(char *shortname,char *name)
{
 pds_truename_select(shortname,name,1);
}

//we already have got the fullpath (not in LFN), we just want to convert it to LFN (if possible)
/*void pds_truename(char *longname,char *name)
{
 if(is_lfn_support && uselfn)
  pds_truename_lfn(longname,name);
 else
  pds_strcpy(longname,name);
}*/

//drive functions
void asm_getdrive(unsigned int *);

void pds_getdrive(unsigned int *drivenum)
{
#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return;
 pds_filehand_lock_entrance();
#endif
#if defined(__DOS__) && defined(NEWFUNC_ASM) && defined(__WATCOMC__)
 #pragma aux asm_getdrive=\
 "push eax"\
 "mov ax,1900h"\
 "int 21h"\
 "and eax,0x000000ff"\
 "pop ebx"\
 "mov dword ptr [ebx],eax"\
 parm[eax] modify[eax ebx ecx edx edi esi];
 asm_getdrive(drivenum);
#else
 *drivenum=_getdrive()-1;
#endif
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
}

void asm_setdrive(unsigned int);

void pds_setdrive(unsigned int drivenum)
{
#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return;
 pds_filehand_lock_entrance();
#endif
#if defined(__DOS__) && defined(NEWFUNC_ASM) && defined(__WATCOMC__)
 #pragma aux asm_setdrive=\
 "mov edx,eax"\
 "mov ax,0e00h"\
 "int 21h"\
 parm[eax] modify[eax ebx ecx edx edi esi];
 asm_setdrive(drivenum);
#else
 unsigned int lastdrive;
 _dos_setdrive(drivenum+1,&lastdrive);
#endif
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
}

void asm_drivesinfo(unsigned int *,unsigned int *);

void pds_drivesinfo(unsigned int *currdrive,unsigned int *lastdrive)
{
#ifdef __DOS__
 if(pds_filehand_check_entrance()){
  *currdrive=2;
  *lastdrive=0;
  return;
 }
 pds_filehand_lock_entrance();
#endif
#if defined(__DOS__) && defined(NEWFUNC_ASM) && defined(__WATCOMC__)
 #pragma aux asm_drivesinfo=\
 "push edx"\
 "push eax"\
 "mov ax,1900h"\
 "int 21h"\
 "and eax,0x000000ff"\
 "pop ebx"\
 "mov dword ptr [ebx],eax"\
 "mov edx,eax"\
 "mov ax,0e00h"\
 "int 21h"\
 "and eax,0x000000ff"\
 "pop edx"\
 "mov dword ptr [edx],eax"\
 parm[eax][edx] modify[eax ebx ecx edx edi esi];
 asm_drivesinfo(currdrive,lastdrive);
#else
 *currdrive=_getdrive()-1;
 _dos_setdrive(*currdrive+1,lastdrive);
#endif
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
}
