//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: definitions for DLL handling

#ifndef dll_load_h
#define dll_load_h

//#define MPXPLAY_LINK_DLLLOAD 1

#include "newfunc.h"

//current dll and module entry_structure_version
#define MPXPLAY_DLLENTRY_STRUCTURE_VERSION  0x0150
#define MPXPLAY_DLLENTRY_MAX_MODULES 16  // just for verifying. need more?

//moduletype_major values
#define MPXPLAY_DLLMODULETYPE_CONTROL_CMDLINE     0x0101 // extended command-line arguments
#define MPXPLAY_DLLMODULETYPE_CONTROL_KEYBOARD    0x0111
#define MPXPLAY_DLLMODULETYPE_CONTROL_SERIAL      0x0141 // serialhandler
#define MPXPLAY_DLLMODULETYPE_DISPLAY_VISUAL      0x0341 // visual-plugin
#define MPXPLAY_DLLMODULETYPE_DISPLAY_LCDLOWFUNC  0x03C1 // LCD hardware
#define MPXPLAY_DLLMODULETYPE_DRIVEHAND           0x0401
#define MPXPLAY_DLLMODULETYPE_FILEHAND_LOW        0x0411 // alternative file source (http,ftp)
#define MPXPLAY_DLLMODULETYPE_FILEIN_PLAYLIST     0x0501
#define MPXPLAY_DLLMODULETYPE_FILEIN_PARSER       0x0541 // stream
#define MPXPLAY_DLLMODULETYPE_FILEIN_CONTAINER    0x0542 // container
#define MPXPLAY_DLLMODULETYPE_DECODER_AUDIO       0x0601
#define MPXPLAY_DLLMODULETYPE_AUCARD              0x0801
#define MPXPLAY_DLLMODULETYPE_AUMIXER             0x0811

//current module (structure) versions
#define MPXPLAY_DLLMODULEVER_CONTROL_CMDLINE     0x0150
#define MPXPLAY_DLLMODULEVER_CONTROL_KEYBOARD    0x0150
#define MPXPLAY_DLLMODULEVER_CONTROL_SERIAL      0x0150
#define MPXPLAY_DLLMODULEVER_DISPLAY_LCDLOWFUNC  0x0150
#define MPXPLAY_DLLMODULEVER_DRIVEHAND           0x0150
#define MPXPLAY_DLLMODULEVER_FILEHAND_LOW        0x0150
#define MPXPLAY_DLLMODULEVER_FILEIN_PLAYLIST     0x0150
#define MPXPLAY_DLLMODULEVER_FILEIN_PARSER       0x0150
#define MPXPLAY_DLLMODULEVER_FILEIN_CONTAINER    0x0150
#define MPXPLAY_DLLMODULEVER_DECODER_AUDIO       0x0150
#define MPXPLAY_DLLMODULEVER_AUCARD              0x0150
#define MPXPLAY_DLLMODULEVER_AUMIXER             0x0150

typedef struct mpxplay_module_entry_v0150_s{
 unsigned long moduletype_major;
 unsigned long moduletype_minor;
 char         *modulename_minor;
 unsigned long module_structure_version;
 void         *module_callpoint;
}mpxplay_module_entry_v0150_s;

typedef struct mpxplay_dll_entry_v0150_s{
 unsigned long entry_structure_version;        // dll & module entry versions
 mpxplay_module_entry_v0150_s *module_entries[]; // closed with a NULL
}mpxplay_dll_entry_v0150_s;

// the current structures
typedef mpxplay_dll_entry_v0150_s    mpxplay_dll_entry_s;
typedef mpxplay_module_entry_v0150_s mpxplay_module_entry_s;

typedef struct dll_found_s{
 char *dllfilename;
 int prochandle;
 mpxplay_module_entry_s **module_entries; // copy of me_dll structure (closed with a NULL)
 mpxplay_module_entry_s **me_dll;         // direct pointer to dll    (closed with a NULL)
}dll_found_s;

typedef struct mpxplay_resource_s{
 struct mainvars *mvp;              // 0.
 char  *outfilepath;
 unsigned int *intsoundconfig;
 unsigned int *intsoundcontrol;
 unsigned long res4;
 unsigned long res5;
 unsigned long res6;
 unsigned long res7;
 unsigned long res8;
 unsigned long res9;

 //dpmi.c                           // 10.
 void far *(*pds_dpmi_getrmvect)(unsigned int intno);
 void (*pds_dpmi_setrmvect)(unsigned int intno, unsigned int segment,unsigned int offset);
 void far *(*pds_dpmi_getexcvect)(unsigned int intno);
 void  (*pds_dpmi_setexcvect)(unsigned int intno, void far *vect);
 void far *(*pds_dos_getvect)(unsigned int intno);
 void  (*pds_dos_setvect)(unsigned int intno, void far *vect);
 int   (*pds_dpmi_dos_allocmem)(dosmem_t *,unsigned int);
 void  (*pds_dpmi_dos_freemem)(dosmem_t *);
 void  (*pds_dpmi_realmodeint_call)(unsigned int intnum,struct rminfo *rmi);
 unsigned long res19;

 //drivehnd.c
 void  (*pds_fullpath)(char *fullname,char *name);
 void  (*pds_getcwd)(char *pathbuf); // pathbuf must be min. 300 chars long
 void  (*pds_getdcwd)(int drive,char *pathbuf); // pathbuf must be min. 300 chars long
 int   (*pds_chdir)(char *setdir);
 int   (*pds_mkdir)(char *newdirname);
 int   (*pds_rmdir)(char *dirname);
 int   (*pds_rename)(char *oldfilename,char *newfilename);
 int   (*pds_unlink)(char *filename);
 unsigned int (*pds_findfirst)(char *path,int attrib,struct pds_find_t *ffblk);
 unsigned int (*pds_findnext)(struct pds_find_t *ffblk);
 void  (*pds_findclose)(struct pds_find_t *ffblk);
 void  (*pds_truename_dos)(char *shortname,char *name);
 void  (*pds_getdrive)(unsigned int *currdrive);
 void  (*pds_setdrive)(unsigned int drivenum);
 void  (*pds_drivesinfo)(unsigned int *currdrive,unsigned int *lastdrive);
 unsigned long res35;
 unsigned long res36;
 unsigned long res37;
 unsigned long res38;
 unsigned long res39;

 //filehand.c
 int   (*pds_open_read)(char *filename,unsigned int mode);  // mode: O_RDONLY| O_BINARY|O_TEXT
 int   (*pds_open_write)(char *filename,unsigned int mode); //       O_RDWR| O_BINARY|O_TEXT
 int   (*pds_open_create)(char *filename,unsigned int mode); //      O_RDWR| O_BINARY|O_TEXT
 int   (*pds_dos_read)(int,char *,int);
 int   (*pds_dos_write)(int,char *,int);
 void  (*pds_close)(int);
 long  (*pds_lseek)(int,long,int);
 long  (*pds_tell)(int);
 int   (*pds_eof)(int);
 long  (*pds_filelength)(int);
 int   (*pds_chsize)(int filehand,long size);
 FILE *(*pds_fopen)(char *,char *);
 unsigned long res52;
 unsigned long res53;
 unsigned long res54;
 void  (*pds_copyfile)(char *targetfile,char *srcfile);
 unsigned long res56;
 unsigned long res57;
 unsigned long res58;
 unsigned long res59;

 //keyboard.c
 unsigned int (*pds_kbhit)(void);
 unsigned int (*pds_extgetch)(void);
 unsigned int (*pds_look_extgetch)(void);
 void  (*pds_pushkey)(unsigned int);
 unsigned long res64;
 unsigned long res65;
 unsigned long res66;
 unsigned long res67;
 unsigned long res68;
 unsigned long res69;

 //memory.c                         70.
 void  (*pds_memcpy)(void *,void *,unsigned int);
 void  (*pds_memset)(void *,int,unsigned int);
 void  (*pds_qmemreset)(void *,unsigned int);
 void  (*pds_qmemcpy)(void *,void *,unsigned int);
 void  (*pds_qmemcpyr)(void *,void *,unsigned int);
 void  (*pds_memxch)(char *,char *,unsigned int);
 void *(*pds_malloc)(unsigned int bufsize);
 void *(*pds_calloc)(unsigned int nitems,unsigned int itemsize);
 void *(*pds_realloc)(void *bufptr,unsigned int bufsize);
 void  (*pds_free)(void *bufptr);

 //string.c                         80.
 unsigned int (*pds_strcpy)(char *,char *); // returns the length of string!
 void  (*pds_strncpy)(char *dest,char *src,unsigned int maxlen);
 void  (*pds_strcat)(char *,char *);
 int   (*pds_strcmp)(char *strp1,char *strp2);
 int   (*pds_stricmp)(char *,char *);
 int   (*pds_strricmp)(char *,char *);
 int   (*pds_strlicmp)(char *,char *);
 int   (*pds_strncmp)(char *,char *,unsigned int);
 int   (*pds_strnicmp)(char *strp1,char *strp2,unsigned int counter);
 unsigned int (*pds_strlen)(char *);
 unsigned int (*pds_strlenc)(char *,char);
 char *(*pds_strchr)(char *,char);
 char *(*pds_strrchr)(char *,char);
 char *(*pds_strstri)(char *s1,char *s2);
 char *(*pds_strcutspc)(char *);
 void  (*pds_ltoa)(int,char *);
 void  (*pds_ltoa16)(int,char *);
 long  (*pds_atol)(char *);
 long  (*pds_atol16)(char *);
 char *(*pds_getfilename_from_fullname)(char *);
 void  (*pds_getfilename_noext_from_fullname)(char *strout,char *fullname);
 char *(*pds_getpath_from_fullname)(char *,char *);
 int   (*pds_getdrivenum_from_path)(char *);
 unsigned int (*pds_fullpath_check)(char *path);
 unsigned long res104;
 unsigned long res105;
 unsigned long res106;
 unsigned long res107;
 unsigned long res108;
 unsigned long res109;

 //textdisp.c                     110.
 void  (*pds_textdisplay_charxy)(unsigned int,unsigned int,unsigned int,char);
 unsigned int (*pds_textdisplay_textxy)(unsigned int,unsigned int,unsigned int,char *);
 void  (*pds_textdisplay_clrscr)(void);
 void  (*pds_textdisplay_scrollup)(unsigned int);
 void  (*pds_textdisplay_printf)(char *);
 unsigned int (*pds_textdisplay_getbkcolorxy)(unsigned int,unsigned int);
 void  (*pds_textdisplay_setcolorxy)(unsigned int,unsigned int,unsigned int);
 void  (*pds_textdisplay_setbkcolorxy)(unsigned int,unsigned int,unsigned int);
 void  (*pds_textdisplay_spacecxyn)(unsigned int,unsigned int,unsigned int,unsigned int);
 void  (*pds_textdisplay_vidmem_save)(void);
 void  (*pds_textdisplay_vidmem_restore)(void);
 void  (*pds_textdisplay_setresolution)(unsigned int lines);
 void  (*pds_textdisplay_getresolution)(void);
 unsigned int (*pds_textdisplay_getcursor_y)(void);
 void  (*pds_textdisplay_gotoxy)(unsigned int x,unsigned int y);
 unsigned long res125;
 unsigned long res126;
 unsigned long res127;
 unsigned long res128;
 unsigned long res129;

 //time.c                      130.
 unsigned long (*pds_gettimeh)(void);
 unsigned long (*pds_gettime)(void);
 unsigned long (*pds_getdate)(void);
 unsigned long (*pds_strtime_to_hextime)(char *timestr,unsigned int houralign);
 unsigned long (*pds_strtime_to_hexhtime)(char *timestr);
 void  (*pds_delay_10us)(unsigned int ticks);
 unsigned long res136;
 unsigned long res137;
 unsigned long res138;
 unsigned long res139;

 //timer.c                     140.
 unsigned long (*mpxplay_timer_secs_to_counternum)(unsigned long secs);
 unsigned int  (*mpxplay_timer_addfunc)(void *callback_func,void *callback_data,unsigned int flags,unsigned int refresh_delay);
 void (*mpxplay_timer_modifyfunc)(void *func,int flags,int refresh_delay);
 void (*mpxplay_timer_deletefunc)(void *callback_func);
 void (*mpxplay_timer_deletehandler)(void *func,int handlernum_index);
 unsigned long res145;
 unsigned long res146;
 unsigned long res147;
 unsigned long res148;
 unsigned long res149;

}mpxplay_resource_s;

#endif
