#ifndef mpxinbuf_h
#define mpxinbuf_h

#include "mpxplay.h"

//frp->prebuffertype
#define PREBUFTYPE_NONE      0 // -bn
#define PREBUFTYPE_SHORTRING 1 // normal (default) mode
#define PREBUFTYPE_LONGRING  2 // -bp
#define PREBUFTYPE_FULL      4 // -bl
#define PREBUFTYPE_RING      8
#define PREBUFTYPE_MASK      (PREBUFTYPE_SHORTRING|PREBUFTYPE_LONGRING|PREBUFTYPE_RING|PREBUFTYPE_FULL)

#define PREBUFTYPE_INT      16 // use intsound (-bp,-bl)
#define PREBUFTYPE_FILLED   32 // buffer is full
#define PREBUFTYPE_WRITEPROTECT 64 // don't write into buffer (only read)

#define PREBUFFERBLOCKSIZE_CHECK  512
#define PREBUFFERBLOCKSIZE_DECODE 32768

#define PREBUFFERBLOCKS_SHORTRING  4 // default number of blocks in normal (non -bp) mode
#define PREBUFFERBLOCKS_LONGRING  32 // default number of blocks in -bp mode

#define PREBUFFERSIZE_CHECK (PREBUFFERBLOCKS_SHORTRING*PREBUFFERBLOCKSIZE_DECODE)

extern void         mpxplay_mpxinbuf_init(struct mainvars *mvp);
extern void         mpxplay_mpxinbuf_prealloc(struct mainvars *mvp);
extern void         mpxplay_mpxinbuf_close(struct mainvars *mvp);
extern unsigned int mpxplay_mpxinbuf_alloc(struct mainvars *,struct frame *);
extern unsigned int mpxplay_mpxinbuf_buffer_check(struct frame *);
extern void         mpxplay_mpxinbuf_set_intsound(struct frame *frp,unsigned int intcfg);

extern struct frame *mpxplay_mpxinbuf_seekhelper_init(struct frame *frp);
extern void          mpxplay_mpxinbuf_seekhelper_close(struct frame *frp);

#endif
