//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: in-file routines

#ifndef in_funcs_h
#define in_funcs_h

#include "mpxplay.h"

#ifdef MPXPLAY_LINK_INFILE_AAC
extern struct mpxplay_infile_func_s IN_AAC_funcs;
#endif
#ifdef MPXPLAY_LINK_INFILE_MP4
extern struct mpxplay_infile_func_s IN_MP4_funcs;
#endif
#ifdef MPXPLAY_LINK_INFILE_AC3
extern struct mpxplay_infile_func_s IN_AC3_funcs;
#endif
#ifdef MPXPLAY_LINK_INFILE_APE
extern struct mpxplay_infile_func_s IN_APE_funcs;
#endif
#ifdef MPXPLAY_LINK_INFILE_ASF
extern struct mpxplay_infile_func_s IN_ASF_funcs;
#endif
#ifdef MPXPLAY_LINK_INFILE_CDW
extern struct mpxplay_infile_func_s IN_CDW_funcs;
#endif
#ifdef MPXPLAY_LINK_INFILE_DTS
extern struct mpxplay_infile_func_s IN_DTS_funcs;
#endif
#ifdef MPXPLAY_LINK_INFILE_FLAC
extern struct mpxplay_infile_func_s IN_FLAC_funcs;
#endif
#ifdef MPXPLAY_LINK_INFILE_MPX
extern struct mpxplay_infile_func_s IN_MP3_funcs;
#endif
#ifdef MPXPLAY_LINK_INFILE_MPC
extern struct mpxplay_infile_func_s IN_MPC_funcs;
#endif
#ifdef MPXPLAY_LINK_INFILE_OGG
extern struct mpxplay_infile_func_s IN_OGG_funcs;
#endif
#ifdef MPXPLAY_LINK_INFILE_WAV
extern struct mpxplay_infile_func_s IN_WAV_funcs;
#endif

//in_mp3.c
extern char *mpx_tag_id3v1_index_to_genre(unsigned int i);
extern unsigned int mpx_tag_check_id3v1(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds);
extern char *mpx_tag_read_id3v1(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,char **id3ip,char *id3p,struct mpxplay_textconv_func_s *mpxplay_textconv_funcs);
extern char *mpx_tag_read_id3v2(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,char **id3ip,char *id3p,struct mpxplay_textconv_func_s *mpxplay_textconv_funcs);
extern int  mpx_tag_write_id3v1(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,char **id3ip);

//in_ape.c
extern char *ape_tag_get(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,void *infile_data,char **id3ip,char *id3p,struct mpxplay_textconv_func_s *mpxplay_textconv_funcs);
extern int   ape_tag_put(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,char **id3ip);

//in_cdw.c
extern struct playlist_entry_info *cdw_get_allfiles(struct playlist_entry_info *,char **,int,char *);
extern unsigned int cdw_is_drive_cd(int);
extern void cdw_open_or_close_door(unsigned int drive);

#endif // in_funcs_h
