//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
// in-file and decoder definitions

#ifndef in_file_h
#define in_file_h

#include "newfunc\newfunc.h"
#include "mpxplay.h"

#ifdef MPXPLAY_LINK_FULL
 #define MPXPLAY_LINK_INFILE_AAC  1
 #define MPXPLAY_LINK_INFILE_MP4  1
 #define MPXPLAY_LINK_INFILE_AC3  1
 #define MPXPLAY_LINK_INFILE_APE  1
 #define MPXPLAY_LINK_INFILE_CDW  1
 #define MPXPLAY_LINK_INFILE_DTS  1
 #define MPXPLAY_LINK_INFILE_MPX  1
 #define MPXPLAY_LINK_INFILE_MPC  1
 #define MPXPLAY_LINK_INFILE_OGG  1
 #define MPXPLAY_LINK_INFILE_WAV  1
#else
 #define MPXPLAY_LINK_INFILE_AAC  1
 #define MPXPLAY_LINK_INFILE_MP4  1
 #define MPXPLAY_LINK_INFILE_CDW  1
 #define MPXPLAY_LINK_INFILE_MPX  1
 #define MPXPLAY_LINK_INFILE_MPC  1
 #define MPXPLAY_LINK_INFILE_OGG  1
 #define MPXPLAY_LINK_INFILE_WAV  1
#endif

typedef float MPXPLAY_PCMOUT_FLOAT_T;
typedef short MPXPLAY_PCMOUT_INT16_T;

// header filetypes in pei->mpheader and fr[].lay (decoder filetypes)
#define HFT_NULL      0x0
#define HFT_DFT       0x1  // directory & playlist
#define HFT_FILE_INT  0x2  // file handling (internal by Mpxplay)
#define HFT_FILE_DLL  0x3  // file handling (via DLL)

#define GET_HFT(mph) (mph>>28) // get HFT number from pei->entrytype

//adi->channelcfg (mp3,ogg)
#define CHM_LEFT    0  // -cl
#define CHM_STEREO  1  // normal (default)
#define CHM_DOWNMIX 2  // -cm

//frp->seektype
#define MPX_SEEKTYPE_NORM   1 // seek in file
#define MPX_SEEKTYPE_BOF    2 // seek to begin of file (reset buffers)
#define MPX_SEEKTYPE_PAUSE  4 // seek in pause mode (can be used with BOF and NORM type)

//adi->infobits
//info
#define ADI_FLAG_FLOATOUT        1 // float audio decoder output (else integer)
#define ADI_FLAG_FPUROUND_CHOP   2 // roundtype at float output (else round to nearest)
#define ADI_FLAG_OWN_SPECTANAL   4 // own spectrum analiser
#define ADI_FLAG_BITSTREAMOUT    8 // bitstream out is enabled/supported (controlled by ADI_CNTRLBIT_BITSTREAMOUT)
#define ADI_FLAG_BITSTREAMNOFRH 16 // bitstream out "no-frame-headers" is supported
#define ADI_FLAG_BITSTREAMHEAD  32 // write a header at the begin of file (ie: AAC,OGG) (controlled by ADI_CNTRLBIT_BITSTREAMOUT)
//control
#define ADI_CNTRLBIT_DECODERSPECINF 128 // bitstream (init) contains a decoder specific info
#define ADI_CNTRLBIT_BITSTREAMOUT   256 // bitstream out (don't decode) (write into file or soundcard decoding) (except: APE,CDW,MPC,WAV)
#define ADI_CNTRLBIT_BITSTREAMNOFRH 512 // cut frame headers (usually 4 bytes) with the frame (so don't cut it) (usually: file out with header, soundcard out without header)

// for displaying
#define MPXPLAY_ADITEXTSIZE_LONGNAME  8
#define MPXPLAY_ADITEXTSIZE_SHORTNAME 3
#define MPXPLAY_ADITEXTSIZE_BITRATE   8
#define MPXPLAY_ADITEXTSIZE_FREQ      7
#define MPXPLAY_ADITEXTSIZE_CHANNEL   8

// for channel matrix (adi->chanmatrix)
#define MPXPLAY_AUCHAN_UNKNOWN       0
#define MPXPLAY_AUCHAN_FRONT_LEFT    1
#define MPXPLAY_AUCHAN_FRONT_RIGHT   2
#define MPXPLAY_AUCHAN_FRONT_CENTER  3
#define MPXPLAY_AUCHAN_BACK_LEFT     4
#define MPXPLAY_AUCHAN_BACK_RIGHT    5
#define MPXPLAY_AUCHAN_BACK_CENTER   6
#define MPXPLAY_AUCHAN_SIDE_LEFT     7
#define MPXPLAY_AUCHAN_SIDE_RIGHT    8
#define MPXPLAY_AUCHAN_LFE           9
#define MPXPLAY_AUCHAN_MAX           9 // adi->chanmatrix[MPXPLAY_AUCHAN_MAX]

// infile/decoder error codes
#define MPXPLAY_ERROR_INFILE_OK        0
#define MPXPLAY_ERROR_INFILE_NODATA   -1 // no input data
#define MPXPLAY_ERROR_INFILE_EOF      -2 // end of file (finish playing)
#define MPXPLAY_ERROR_INFILE_SYNCLOST -3 // sync lost
#define MPXPLAY_ERROR_INFILE_SYNC_IN  -4 // decoder is in sync state (after seeking)
#define MPXPLAY_ERROR_INFILE_RESYNC   -5 // decoder needs resync (seek to next frame)(at wrong bitstream)
#define MPXPLAY_ERROR_INFILE_CANTOPEN -10
#define MPXPLAY_ERROR_INFILE_MEMORY   -11
#define MPXPLAY_ERROR_INFILE_WRITETAG_FILETYPE  -21 // not supported filetype (dts,wav)
#define MPXPLAY_ERROR_INFILE_WRITETAG_TAGTYPE   -22 // not supported tagtype (APEv2)
#define MPXPLAY_ERROR_INFILE_WRITETAG_UNKNOWN   -29 // unknown error

// for text (char) conversion
#define ID3TEXTCONV_CODEPAGE  1 // convert codepage to another (winchars/doschars)
#define ID3TEXTCONV_UTF16     2 // decode UTF-16 (unicode) strings
#define ID3TEXTCONV_UTF8      4 // decode UTF-8 strings (in every tags/filetypes)
#define ID3TEXTCONV_UTF_AUTO  8 // auto utf16 and utf8 decoding (ID3v2,Ogg,APEv2)
#define ID3TEXTCONV_UTF_ALL  (ID3TEXTCONV_UTF16|ID3TEXTCONV_UTF8)
#define ID3TEXTCONV_VALIDATE 16 // validate (use only) Winchars at UTF-8 decoding (if unicode>=128)
#define ID3TEXTCONV_FILENAME 32 // convert chars in filenames too (in playlists)

//low level file handling -> buffered file handling -> demux (infile) -> decoding

typedef struct mpxplay_filehand_low_data_s{
 int  filept;
 long filesize;
 long filepos;
}mpxplay_filehand_low_data_s;

//low level file handling (normal-file, cdw, ftp-file-source)
typedef struct mpxplay_filehand_low_func_s{
 int   (*check) (char *filename);     // true (1) or false (0) (check filename (ie:filename begins with "http:\\"), use these functions if 'true')
 void *(*open_read) (char *filename); // returns filehand_data
 void *(*open_write)(char *filename); // returns filehand_data
 void  (*close) (void *filehand_data);
 long  (*read)  (void *filehand_data,char *buf,unsigned int len);
 long  (*write) (void *filehand_data,char *buf,unsigned int len);
 long  (*seek)  (void *filehand_data,long offset,int fromwhere);
 long  (*tell)  (void *filehand_data);
 long  (*filelength)(void *filehand_data);
 int   (*eof)   (void *filehand_data);
 int   (*chsize)(void *filehand_data,long offset);
}mpxplay_filehand_low_func_s;

typedef struct mpxplay_drivehand_func_s{
 unsigned int (*drive_check)(char *pathname); // check pathname, return true (1) if 'path' is supported by this drive-handler
 void        *(*drive_mount)(char *pathname); // returns drivehand_data
 void         (*drive_unmount)(void *drivehand_data);
 unsigned int (*drive_getname_and_type)(void *drivehand_data,char **shortdrivename,char **typename); // returns 1 if drive is mounted, and puts a max. 13 chars long in shortdrivename (ie: C:) and a max. 9 chars long in typename (ie: <DRIVE>)
 unsigned int (*findfirst)(void *drivehand_data,char *pathname,unsigned int attrib,struct pds_find_t *ffblk);
 unsigned int (*findnext)(void *drivehand_data,struct pds_find_t *ffblk);
 void         (*findclose)(void *drivehand_data,struct pds_find_t *ffblk);
 char        *(*getcwd)(void *drivehand_data,char *buf,unsigned int buflen);
 int          (*chdir)(void *drivehand_data,char *path);
 int          (*mkdir)(void *drivehand_data,char *path);
 int          (*rmdir)(void *drivehand_data,char *path);
 int          (*rename)(void *drivehand_data,char *oldfilename,char *newfilename);
 int          (*unlink)(void *drivehand_data,char *filename);
 struct mpxplay_filehand_low_func_s *filehand_low_funcs;
}mpxplay_drivehand_func_s;

// buffered file handling and demux-functions structure
typedef struct mpxplay_filehand_buffered_func_s{
 unsigned int (*fopen_read)  (void *fbds,char *filename,unsigned long pb_blocksize);
 unsigned int (*fopen_write) (void *fbds,char *filename);
 void         (*fclose)      (void *fbds);
 unsigned long (*fread)(void *fbds,void *buf,unsigned long len);
 long  (*fwrite) (void *fbds,void *buf,unsigned long len);
 long  (*fseek) (void *fbds,long offset,int whence);
 long  (*ftell) (void *fbds);
 long  (*filelength)(void *fbds);
 int   (*eof)(void *fbds);
 int   (*chsize) (void *fbds,long offset);
}mpxplay_filehand_buffered_func_s;

#define demux_func_s mpxplay_filehand_buffered_func_s  // currently same

typedef struct mpxplay_audio_decoder_info_s{
 //info
 unsigned int infobits;      // flags
 unsigned int wave_id;       // audio type (wav:0x0001,mp3:0x0055,ac3:0x2000)
 unsigned int freq;          // frequency (44100,48000,...)
 unsigned int filechannels;  // number of channels in file
 unsigned int outchannels;   // decoded (used) channels, comes out from the decoder
 unsigned char *chanmatrix;  // output channel matrix (ie: 5.1) (not used yet)
 unsigned int bits;          // 8,16 ... (scalebits at float,filebits at integer output)
 unsigned int bitrate;       // in kbit/s (mp3,ogg,ac3)
 unsigned int bytespersample;// used in au_mixer
 unsigned long pcmdatalen;   // pcmbytes/(bytespersample*filechannels) (to store a more precise time-length) (!!! 27h limit at 44.1khz files, later use mpxp_int64_t)
 char *longname;             // set by decoder (8 chars), can static ("LayerIII","OgVorbis","DolbyAC3","WinMediA")
 char *shortname;            // set by decoder (3 chars), can static ("MP3","OGG","AC3","WMA")
 char *bitratetext;          // set by decoder (8 chars), else displays bitrate (if exists) or bits
 char *freqtext;             // set by decoder (7 chars), else displays freq
 char *channeltext;          // set by decoder (8 chars), can static ("msStereo","i-Stereo","DualChan","c-Stereo","5.1 chan") else displays 1ch->"mono",2ch->"stereo",Nch->"n-chan")

 //bitstream in
 //unsigned char *bitstreambuf;  // from demux/parser to decoder
 //unsigned int  bsbuf_size;     //
 //unsigned int  bs_sendbytes;   //
 //unsigned int  bs_usedbytes;   //
 //pcm out
 unsigned char *pcm_outdatabuf;   // static! don't clear!
 unsigned int  pcmoutdatabuf_size;// don't clear
 unsigned int  pcmsamplenum_frame;// ask for M samples
 unsigned int  pcmoutsamplenum;   // got back N samples (should be M==N, except eof)

 //control
 unsigned int  channelcfg;    // configure output channels
}mpxplay_audio_decoder_info_s;

typedef struct mpxplay_audio_decoder_type_s{
 unsigned int wave_id;  // 0x0055,????,0x2000,0x0160
 char *wave_name;       // "MP3","OGG","AC3","WMA"
}mpxplay_audio_decoder_type_s;

typedef struct mpxplay_audio_decoder_func_s{
 unsigned long flags;

 void  (*preinit)(void); // initialize static data fields (mp3)
 void  (*deinit) (void); // close audio decoder (cdw)

 void *(*detect) (struct mpxplay_audio_decoder_info_s *audio_decoder_infos,struct demux_func_s *demuxfuncs,void *demux_passinfo); // returns *audio_decoder_data
 void *(*check)  (struct mpxplay_audio_decoder_info_s *audio_decoder_infos,struct demux_func_s *demuxfuncs,void *demux_passinfo); // returns *audio_decoder_data
 void *(*open)   (struct mpxplay_audio_decoder_info_s *audio_decoder_infos,struct demux_func_s *demuxfuncs,void *demux_passinfo); // returns *audio_decoder_data
 void  (*close)  (void *audio_decoder_data);
 int   (*decode) (void *audio_decoder_data,void *audio_pcm_out,void *demux_passinfo);     // return number of pcm-samples or MPX_ADECODER_ERROR
 void  (*seek_set)(void *infile_data,unsigned int mpx_seektype);

 void  (*get_analiser_bands)(void *audio_decoder_data,long *bands);
 void  (*set_eq)(void *audio_decoder_data,long bandnum,long bands[]);

 unsigned int maxbsframesize;// max. size of input (bitstream) frames
 mpxplay_audio_decoder_type_s decodertype[];
}mpxplay_audio_decoder_func_s;

typedef struct mpxplay_textconv_func_s{
 unsigned int *control;
 unsigned int convdone;
 unsigned int (*utf16LE_to_char)(unsigned char *str,unsigned int datalen);
 unsigned int (*utf16BE_to_char)(unsigned char *str,unsigned int datalen);
 unsigned int (*utf8_to_char)(unsigned char *str,unsigned int datalen);
 unsigned int (*cp_to_cp_in)(unsigned char *str,unsigned int datalen);
 unsigned int (*all_to_char)(unsigned char *str,unsigned int datalen,unsigned int doneconv);
 void         (*char_to_utf8)(unsigned char *dest,unsigned char *src,unsigned int buflen);
 void         (*cp_to_cp_out)(char *dest,char *src);
}mpxplay_textconv_func_s;

typedef struct mpxplay_infile_info_s{
 long filesize;     //
 long timesec;      // length in secs
 long allframes;    // in mpxplay frames (1 sec = ca. 38 frames)

 //audio data/config (request for audio-decoder open)
 unsigned long pcmdatalen; // length in samples
 unsigned int  wave_id;    // audio type (wav:0x0001,mp3:0x0055,ac3:0x2000)
 char         *wave_name;  // audio name ("MP3","AC3")
 struct mpxplay_audio_decoder_info_s *audio_decoder_infos; // static! don't clear!
 struct mpxplay_audio_decoder_func_s *audio_decoder_funcs;
 void                                *audio_decoder_datas; // extra (private) decoder-datas
}mpxplay_infile_info_s;

typedef struct mpxplay_infile_func_s{
 unsigned long flags;

 void  (*preinit)(void); // initialize static data fields (mp3)
 void  (*deinit) (void); // close audio decoder (cdw)

 void *(*detect)(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,char *filename,struct mpxplay_infile_info_s *); // return *infile_data
 void *(*check) (struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,char *filename,struct mpxplay_infile_info_s *); // return *infile_data
 void *(*open)  (struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,char *filename,struct mpxplay_infile_info_s *); // return *infile_data
 void  (*close) (struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,void *infile_data,struct mpxplay_infile_info_s *);
 int   (*decode)(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,void *infile_data,struct mpxplay_infile_info_s *);// return MPXPLAY_ERROR_INFILE_xxx
 long  (*fseek) (struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,void *infile_data,struct mpxplay_infile_info_s *,long newmpxframenum); // return MPXPLAY_ERROR_INFILE_xxx
 int   (*seek_postprocess)(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,void *infile_data,struct mpxplay_infile_info_s *,unsigned int mpx_seektype);

 char *(*get_id3tag)(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,void *infile_data,char **id3ip,char *id3p,struct mpxplay_textconv_func_s *mpxplay_textconv_funcs); // return id3p
 int   (*write_id3tag)(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,char **id3ip); // return error code

 struct mpxplay_filehand_low_func_s *own_filehand_funcs; // to set an own low level file handling (CDW)

 char *file_extensions[]; // {"mp2","mp3",NULL} {"ogg",NULL} {"ac3",NULL}
}mpxplay_infile_func_s;


typedef struct frame {
 long frameNum;
 long allframes;
 long timesec;
 unsigned long framecounter;
 unsigned long pcmdatapos;   // (!!! 27h limit at 44.1khz files, later use mpxp_int64_t)

 unsigned int filetype;     // HFT_XXX
 unsigned int seektype;     // MPX_SEEKTYPE_

 //file/source infos
 int  mpxfilept;
 long filesize;
 long filepos;
 struct mpxplay_filehand_low_func_s *filehand_funcs;
 void *filehand_datas; // private datas of filehand_funcs

 //file-buffer variables
 unsigned int buffertype;
 char *prebufferbegin;
 long prebufferblocksize;
 long prebuffersize;   // frp->prebufferblocksize * prebufferblocks (4 or 32)
 long prebuffergetp;
 long prebufferputp;
 long prebufferbytes_rewind;
 long prebufferbytes_forward;
 struct mpxplay_filehand_buffered_func_s *filebuf_funcs; // static!

 //decoder infos
 struct mpxplay_infile_info_s *infile_infos; // !!! static! don't clear!
 struct mpxplay_infile_func_s *infile_funcs;
 void                         *infile_datas;

 struct frame *fro; // crosslink (fr[0]->fr[1],fr[1]->fr[0])
}frame;


//in_file.c
int infile_decode(struct audio_info *aui);
unsigned int infile_check_extension(char *filename);
unsigned long infile_get_header_by_ext(struct frame *frp,char *filename);
char *infile_get_id3tag(struct frame *frp,char **id3ip,char *id3p);
int  infile_write_id3tag(struct frame *frp,char *filename,char **id3ip);
long infile_fseek(struct frame *frp,long newframenum);

unsigned int infile_get_samplenum_per_frame(unsigned int freq);
void miis_to_frp(struct mpxplay_infile_info_s *miis,struct frame *frp);
int  infile_open(struct frame *frp,char *filename);
void infile_close(struct frame *frp);
void infile_reset(struct frame *frp);
unsigned int infile_realloc_pcmoutdata(struct mpxplay_audio_decoder_info_s *adi,struct audio_info *aui);

void infile_init(struct mainvars *mvp);
void infile_deinit(void);

#endif
