//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: AC3 file handling
//requires the dec_ac3\ac3dec.lib file (and include files)

#include "in_file.h"

#ifdef MPXPLAY_LINK_INFILE_AC3

#include "newfunc\newfunc.h"
#include "in_funcs.h"
#include "dec_ac3\ac3.h"
#include "dec_ac3\ac3decod.h"

static void ac3_infile_close(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,void *infile_data,struct mpxplay_infile_info_s *miis);
static void ac3_clearbuffs(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,void *infile_data,struct mpxplay_infile_info_s *miis,int cleartype);

static int ac3_assign_values(struct ac3_decoder_data *ac3i,struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,struct mpxplay_infile_info_s *miis)
{
 mpxplay_audio_decoder_info_s *adi=miis->audio_decoder_infos;

 miis->filesize=fbfs->filelength(fbds);
 if(miis->filesize<AC3_FRAMESIZE_MIN)
  return 0;

 adi->freq=ac3i->freq;
 adi->filechannels=ac3i->bsi->nfchans+ac3i->bsi->lfeon;
 adi->outchannels=AC3_OUTCHANNELS;
 adi->bitrate=ac3i->syncinfo->bit_rate;

 adi->bits=16;
 adi->infobits|=ADI_FLAG_FLOATOUT;
#ifdef AC3_SPECTRUM_ANALISER
 adi->infobits|=ADI_FLAG_OWN_SPECTANAL;
#endif
 adi->longname="DolbyAC3";

 //if(ac3i->bsi->nfchans>2 || ac3i->bsi->lfeon){
  adi->channeltext=malloc(MPXPLAY_ADITEXTSIZE_CHANNEL+8);
  if(!adi->channeltext)
   return 0;
  sprintf(adi->channeltext,"%d.%d chan",ac3i->bsi->nfchans,ac3i->bsi->lfeon);

 //}

 adi->wave_id=0x2000;
 adi->shortname="AC3";
 if(adi->infobits&ADI_CNTRLBIT_BITSTREAMOUT){
  adi->infobits|=(ADI_FLAG_BITSTREAMOUT|ADI_FLAG_BITSTREAMNOFRH);
  ac3i->outtype|=AC3_OUTTYPE_BITSTREAM;
  adi->pcmsamplenum_frame=AC3_BLOCKS_PER_FRAME*AC3_BLOCKSAMPLES;
 }

 return 1;
}

static void *ac3_check_header(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,char *filename,struct mpxplay_infile_info_s *miis)
{
 struct ac3_decoder_data *ac3i;

 if(!fbfs->fopen_read(fbds,filename,0))
  return NULL;

 ac3i=InitAc3(fbfs->fread,fbds);
 if(!ac3i)
  return ac3i;
 if(!ac3_assign_values(ac3i,fbfs,fbds,miis))
  goto err_out_chk;

 return ac3i;

err_out_chk:
 ac3_infile_close(fbfs,fbds,ac3i,miis);
 return NULL;
}

static void *ac3_infile_check(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,char *filename,struct mpxplay_infile_info_s *miis)
{
 return ac3_check_header(fbfs,fbds,filename,miis);
}

static void *ac3_infile_open(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,char *filename,struct mpxplay_infile_info_s *miis)
{
 struct ac3_decoder_data *ac3i;
 ac3i=ac3_check_header(fbfs,fbds,filename,miis);
 if(!ac3i)
  return ac3i;
 ac3_clearbuffs(fbfs,fbds,ac3i,miis,0);
 return ac3i;
}

static void ac3_infile_close(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,void *infile_data,struct mpxplay_infile_info_s *miis)
{
 struct ac3_decoder_data *ac3i=(struct ac3_decoder_data *)infile_data;
 mpxplay_audio_decoder_info_s *adi=miis->audio_decoder_infos;
 CloseAc3(ac3i);
 if(adi->channeltext)
  free(adi->channeltext);
 fbfs->fclose(fbds);
}

static int ac3_infile_decode(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,void *infile_data,struct mpxplay_infile_info_s *miis)
{
 struct ac3_decoder_data *ac3i=(struct ac3_decoder_data *)infile_data;
 mpxplay_audio_decoder_info_s *adi=miis->audio_decoder_infos;

 ac3i->readfunc_passinfo=fbds;// we always update it here

 if(adi->infobits&ADI_CNTRLBIT_BITSTREAMOUT){
  ac3i->outtype|=AC3_OUTTYPE_BITSTREAM;
  if(adi->infobits&ADI_CNTRLBIT_BITSTREAMNOFRH)
   ac3i->outtype|=AC3_OUTTYPE_BITSTRM_NOFRH;
  else
   ac3i->outtype&=~AC3_OUTTYPE_BITSTRM_NOFRH;
 }else
  ac3i->outtype&=~(AC3_OUTTYPE_BITSTREAM|AC3_OUTTYPE_BITSTRM_NOFRH);

 adi->pcmoutsamplenum=DecodeAc3(ac3i,(AC3_OUT_T *)adi->pcm_outdatabuf,adi->pcmsamplenum_frame);
 if(!adi->pcmoutsamplenum)
  return MPXPLAY_ERROR_INFILE_NODATA;

 return MPXPLAY_ERROR_INFILE_OK;
}

static void ac3_clearbuffs(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,void *infile_data,struct mpxplay_infile_info_s *miis,int cleartype)
{
 struct ac3_decoder_data *ac3i=(struct ac3_decoder_data *)infile_data;
 AC3reset(ac3i);
}

static long ac3_fseek(struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,void *infile_data,struct mpxplay_infile_info_s *miis,long newframenum)
{
 long newfilepos;
 pds_ftoi((float)newframenum*(float)miis->filesize/(float)miis->allframes,&newfilepos);
 if(fbfs->fseek(fbds,newfilepos,SEEK_SET)<0)
  return MPXPLAY_ERROR_INFILE_EOF;
 return newframenum;
}

struct mpxplay_infile_func_s IN_AC3_funcs={
 0,
 NULL,
 NULL,
 NULL,
 &ac3_infile_check,
 &ac3_infile_open,
 &ac3_infile_close,
 &ac3_infile_decode,
 &ac3_fseek,
 &ac3_clearbuffs,
 &ape_tag_get,
 &ape_tag_put,
 NULL,
 {"AC3",NULL}
};

#endif // MPXPLAY_LINK_INFILE_AC3
