//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: visual plugin API

#ifndef visualpi_h
#define visualpi_h

#include "newfunc\newfunc.h"

#define MPXPLAY_DLLMODULEVER_DISPLAY_VISUAL  0x0150

typedef struct display_visual_data_v0150_s{
 mpxp_int16_t *pcm_data;       // interlaced stereo (2ch), 16-bit samples
 unsigned long pcm_samplenum;  // number of samples in pcm_data (usually 1152*2=2304)
 unsigned int  channelnum;     // now it's 2 (PCM_MAX_CHANNELS) in Mpxplay
 unsigned long *soundvolumes;  // soundvolumes[channelnum]
 unsigned int  bandnum;        // now it's 32 in Mpxplay
 unsigned long *analbands;     // analbands[bandnum] (spectrum analiser bands)
 unsigned long anal_freq_range;// now it's 22050 (constant, it's correct at 44100Hz output only)
 unsigned int  displaymode;    // save (at start) and restore (at stop) its value
 //unsigned int  desktopmode;
 //unsigned int  refdisp;
 //unsigned int  timemode;
 //unsigned int  mouse_on;
}display_visual_data_v0150_s;

typedef display_visual_data_v0150_s display_visual_data_s;

typedef struct display_visual_func__v0150_s{
 void *(*init)(display_visual_data_s *vds); // returns private_data
 void  (*close)(void *private_data);
 void  (*start)(void *private_data); // note: currently init/start and stop/close are called together
 void  (*stop)(void *private_data);
 void  (*draw)(void *private_data);
 unsigned int fps; // refresh in 1 sec (call draw() N times/sec) (if it's 0, then a default built-in value is used (currently 18))
}display_visual_func_v0150_s;

typedef display_visual_func_v0150_s display_visual_func_s;

extern void display_visualpi_init(display_visual_data_s *vds);
extern void display_visualpi_close(void);

#endif // visualpi_h
