//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: display functions

#ifndef display_h
#define display_h

#include "mpxplay.h"
#include "control\control.h"

// refresh_display types (refdisp variable)
#define RDT_HEADER       1  // ID3,time/frame values,head infos
#define RDT_VOL          2  // only the volume modified (and displayed)
#define RDT_OPTIONS      4  // crossfade,swapchan,volume,surround,speed, etc.
#define RDT_EDITOR       8  // editor,LCD
#define RDT_BROWSER     16  // browser,mousepos
#define RDT_INIT_VALUES 64  // init values   (ie:alt-F9)
#define RDT_INIT_ANABRO 128 // init analiser ('a') and browser
#define RDT_INIT_BROWS  256 // init browser  ('a' or alt-up/down)
#define RDT_INIT_BTN    512 // init buttons  (shift-F9)
#define RDT_INIT_EDIT   1024// init editor   (alt-up/down)
#define RDT_RESET_EDIT  2048// reset editor  (currently for -idl only (new playlist/resize editor))
#define RDT_INIT_FULL   (RDT_INIT_VALUES|RDT_INIT_ANABRO|RDT_INIT_BTN|RDT_INIT_EDIT|RDT_RESET_EDIT)

// displaymodes
#define DISP_FRAMES     0x00000001  // only frames is displayed
#define DISP_TIMEPOS    0x00000002  // timepos is displayed
#define DISP_VERBOSE    0x00000004  // id3info & header are displayed
#define DISP_FULLSCREEN 0x00000008  // use fullscreen
#define DISP_NOFULLEDIT 0x00000010  // full editor not used
#define DISP_ANALISER   0x00000020  // spectrum analiser enabled
#define DISP_50LINES    0x00000040  // 50 lines display
#define DISP_TEXTMODES  0x000000ff  // mask
#define DISP_GRAPHICAL  0x00000100  // non-text mode used

// desktopmode flags
#define DTM_SONGPOS         0x00000001  // draw songpos line
#define DTM_LISTPOS         0x00000002  // draw listpos line
//                          0x00000004  // reserved
#define DTM_EDIT_ELEVATOR   0x00000008  // draw elevator
#define DTM_EDIT_VERTICAL   0x00000010  // playlist editor vertical border
#define DTM_EDIT_FULLPATH   0x00000020  // (long)filename with fullpath at the top of editor
#define DTM_EDIT_FULLTIME   0x00000040  // fulltime in editor (in the bottom-right corner)
#define DTM_EDIT_SONGTIME   0x00000080  // song times in editor (in every lines)
#define DTM_EDIT_SONGNUM    0x00000100  // song counter in editor (in every lines)
#define DTM_EDIT_DRIVES     0x00000200  // drive letters in editor
#define DTM_EDIT_FILENAMES  0x00000400  // always show filenames in editor (only ID3)
#define DTM_EDIT_FOLLOWBROWSER 0x00000800 // move editorhighline by songbrowser
#define DTM_EDIT_MOUSESONGSHIFT 0x00001000  // shift playlist entry or scroll editorside up or down by mouse (drag & move)
//#define DTM_EDIT_TOTALS   0x00002000  // total songnum & time

// display major positions (y=vertical)
#define POS_FILEINFO_FE   (dtp.timepos_fe-1)
#define POS_ID3INFO_FE    (dtp.timepos_fe-2)

#define EDITOR_SIDE_SIZE_DEFAULT  64
#define EDITOR_SIDE_SIZE_MIN      1 // 13

// button flags/types in structure desktop
#define BF_DISABLED    0   // temporary not used
#define BF_NONE        1   // no box, only mousepos
#define BF_LEFT        2   // left part of a box
#define BF_RGHT        4   // right part of a box
#define BF_FULL        8   // full box
#define BF_ONLY        16  // no info, only box
#define BF_UPTEXT      32  // write text to top of box
#define BF_PRESS       64  // 'press' button, otherwise 'click'
#define BF_BASE        256 // base position for buttons
#define BF_ENDOFBTN    512   // end of buttons
#define BF_BROWSER     1024  // button is a song-browser button
#define BF_END         65536 // end of browser
#define BF_MOUSEPOS    (BF_NONE|BF_LEFT|BF_RGHT|BF_FULL|BF_BROWSER)
#define BF_DRAWBOX     (BF_FULL|BF_ONLY)

//struct buttons dk[] (desktop keys) defs
#define DK_MAX_SIZE    350 // max number of buttons (control+browser)
#define DK_FILEINFO    1                 // fileinfo buttons begin
#define DK_ID3INFO     (DK_FILEINFO+ 7)  // id3info buttons begin
#define DK_TIMEPOS     (DK_ID3INFO+I3I_MAX+1)  // timepos buttons begin (currsong/allsongs ; curtime/alltime)
#define DK_BUFCPU      (DK_TIMEPOS + 4)  // buf/cpu
#define DK_FUNCTION    (DK_BUFCPU  + 1)  // function
#define DK_MOUSEPOS    (DK_FUNCTION+ 1)  // mousepos
#define DK_CONTROL     (DK_MOUSEPOS+ 1)  // control buttons begin
#define DK_OPTIONS     (DK_CONTROL + 8)  // options buttons begin (vol)
#define DK_SMALLBTNS   (DK_OPTIONS +23)  // swapchan,hq-mixer,autopause
#define DK_BROWSER     (DK_SMALLBTNS+5)  // browser buttons begin in dk[]

// color definitions
#define CL_BASE          7  // base color = gray
#define CLH_BASE        15  // base highlight color = white
#define CLB_BASE         0  // base background color = black
#define CL_BLINK       128  // flashing (as background color at any color settings)
#define CL_MOUSECURSOR   5  // mouse cursor

//tag info colors
#define CL_INFO_BASE   1               // info area base color
#define CLB_INFO_BASE  CLB_BASE        //
#define CL_INFOBORDER  CL_INFO_BASE    // info border
#define CLB_INFOBORDER CLB_INFO_BASE   // info border background
#define CL_INFOTEXT    10              // info text
#define CLH_INFOTEXT   14              // highlighted info text
#define CLH_INFOTEXTB  15              // mousepos shows button
#define CLB_INFOTEXT   CLB_INFO_BASE   // info text background
#define CL_ID3TEXT     7               // id3 text
#define CLH_ID3TEXT    15              // highlighted id3
#define CLB_ID3TEXT    CLB_INFO_BASE   // id3 background
#define CL_FUNCTION    12              // PAUSED,CrosFade, ...
#define CLB_FUNCTION   CLB_INFOTEXT    //

//button colors
#define CL_BTNBOX      CL_INFO_BASE    // buttonbox
#define CLB_BTNBOX     CLB_BASE        // buttonbox background
#define CLH_BTNBOX     9               // highlighted buttonbox (mousepos)
#define CLA_BTNBOX    15               // active button box
#define BTN_FLASHTIME  2               // button flash length

//button (in/up)text colors
#define CL_BTNTEXTCNTRL    15     // control button intext (skip,move,play)
#define CL_BTNTEXTOPTION    1     // option button intext (hq,rn,re,cf)
#define CL_BTNTEXTMIXER    10     // mixer button intext (vol,sur,spd)
#define CLA_BTNTEXTOPTION  11     // active button intext (enabled function)
#define CLB_BTNTEXT    CLB_BASE   // button intext background
//#define CLAB_BTNTEXT   CLB_BASE  // active button intext background
#define CL_BTNUPTEXT   CL_BTNBOX  // button uptext (headtext) (must be the same with CL_BTNBOX)
#define CLB_BTNUPTEXT  CLB_BTNBOX // button uptext background

//playlist editor colors
#define CL_EDITOR_BASE        CL_BASE          // base color
#define CLB_EDITOR_BASE       CLB_BASE         // background base color
#define CL_EDITOR_BORDER      CL_EDITOR_BASE   // border
#define CLB_EDITOR_BORDER     CLB_EDITOR_BASE  //
#define CL_EDITOR_FULLPATH    CL_EDITOR_BASE   //
#define CLB_EDITOR_FULLPATH   CLB_EDITOR_BASE  //
#define CL_EDITOR_FULLTIME    11               //
#define CLB_EDITOR_FULLTIME   CLB_EDITOR_BASE  //
#define CL_EDITOR_ELEVATOR    CL_EDITOR_BASE   //
#define CLB_EDITOR_ELEVATOR   CLB_EDITOR_BASE  //
#define CLB_EDITOR_HIGHLINE    1 // highline (bar) background    = blue
#define CL_EDITOR_NEWFILENUM  10 // newfile/nextfile (ctrl-enter)= lightgreen
#define CL_EDITOR_AKTFILENUM  14 // actual file                  = yellow
#define CL_EDITOR_PLAYED       7 //                              = gray
#define CL_EDITOR_NOTPLAYED   15 //                              = white
#define CL_EDITOR_AT_SEPARATOR 7 // ':' (artist:title)           = gray

//browser colors
#define CLB_BROWSER_BASE       CLB_BASE //
#define CL_BROWSER_AKTFILENUM 10        //
#define CL_BROWSER_PLAYED      1        //
#define CL_BROWSER_NOTPLAYED   2        //
#define CL_BROWSER_OVERENTRY   8        //

//songpos/listpos colors
#define CLB_SONGPOS       CLB_BASE   //
#define CL_SONGPOS_DOTS   CL_BASE    //
#define CL_SONGPOS_HEAD   CLH_BASE   //
#define CL_SONGPOS_ARROWS CLH_BASE   //
#define CLB_LISTPOS       CLB_BASE   //
#define CL_LISTPOS_DOTS   CL_BASE    //
#define CL_LISTPOS_HEAD   CLH_BASE   //
#define CL_LISTPOS_ARROWS CLH_BASE   //

//volume indicator colors
#define CLB_VOLUME          CLB_BASE //
#define CL_VOLUME_DOTS       1       // volume indicator dots
#define CL_VOLUME_LEVEL0    10       //
#define CL_VOLUME_LEVEL1    14       //
#define CL_VOLUME_LEVEL2    12       //
#define CL_VOLUME_SEPARATOR CL_VOLUME_LEVEL0  // "--"

//spectrum analiser
#define CLB_ANALISER        CLB_BASE //
#define CL_ANALISER_DOTS     1       // spectrum analiser dots
#define CL_ANALISER_LEVEL0  10       //
#define CL_ANALISER_LEVEL1  14       //
#define CL_ANALISER_LEVEL2  12       //

typedef struct desktoppos{
  int volline;
  int timepos_fe;
  int endofbuttonsy;
  int relative_songposline; // relative to endofbuttonsy
  int songposline_y;
  int listposline_y;
  int editorbegin;
  int editorend;
}desktoppos;

typedef struct buttons{
 unsigned int boxflag;
 unsigned int xpos;    // relative to base xpos (dk[0].xpos)
 unsigned int ypos;    // relative to base ypos (dk[0].ypos)
 unsigned int xsize;   // contains real xsize - 1
 unsigned int ysize;   // contains real ysize - 1
 unsigned int *keycode;
 unsigned int *keycode2;
 char *intext;
 char *mousepostext;
}buttons;

typedef struct editor{
  struct playlist_entry_info *from;
  struct playlist_entry_info *from_prev;
  int begincol;
  int lengthcol;
  int beginline;
  int lengthline;
};

//display.c
extern void mpxplay_display_init(struct mainvars *mvp);
extern void mpxplay_display_close(void);

extern char *get_playstatus_string(unsigned int *color);
extern void refresh_desktop(struct mainvars *);

extern void display_fileinfos(struct mainvars *mvp);

extern void clear_volnum(void);

extern void set_mousepos_on_elevator(struct mainvars *,unsigned int mousey);
extern void set_mousepos_on_editor(struct mainvars *,unsigned int,unsigned int);
extern void draweditor(struct mainvars *);

extern unsigned int display_editor_resize_x(struct mainvars *,int direction);
extern void display_editor_resize_y(int);
extern void scroll_editorside(struct mainvars *,struct playlist_entry_info *ehls);

extern void clear_mousepos_text(void);
extern void draw_mousepos_text(unsigned int,char *);
extern void draw_mouse_listpos(struct mainvars *,unsigned int);
extern void draw_mouse_desktoppos(struct mainvars *,unsigned int x,unsigned int y);
extern void draw_mouse_cursor_refresh(void);

extern void display_message(unsigned int,unsigned int,char *);
extern void clear_message(void);
extern void display_warning_message(char *message);
extern void display_bufpos_int08(struct mainvars *mvp);

//buttons.c
extern void mpxplay_display_buttons_init(void);
extern struct buttons *mpxplay_control_mouse_xy_to_dp(struct mainvars *,unsigned int,unsigned int);
extern void color_one_buttonbox(struct buttons *,unsigned int);
extern void recolor_lastbuttonbox_key(struct buttons *,unsigned int);
extern void recolor_lastbuttonbox_mousepos(struct mainvars *,struct buttons *);
extern void color_buttonbox_key(unsigned int);

extern void generate_browserboxes(void);
extern void drawbrowser(struct mainvars *);
extern void draw_browserbox(struct mainvars *,struct playlist_entry_info *);

//lcd.c
extern void mpxplay_display_lcd_loadini(mpxini_line_t *,struct mpxini_part_t *);
extern void mpxplay_display_lcd_init(void);
extern void mpxplay_display_lcd_close(void);

extern void LCD_refresh_once(unsigned int);
extern void LCD_refresh_timer(struct mainvars *);
extern void LCD_page_select(struct mainvars *,int select);

#endif
