//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2004 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function:mp2,mp3 decoder definitions

#ifndef mp3dec_h
#define mp3dec_h

#define MPXDEC_CHANNELS_MAX  2
#define MPXDEC_GRANULES_MAX  2
//#define MPXDEC_INTEGER_OUTPUT 1 // with synthio.asm

#define SBLIMIT 32
#define SSLIMIT 18

#define MPXDEC_FRAMEBUFFER_SIZE 4096 // 2*4096 (fsize+fsizeold)
#define MPXDEC_BACKSTEP_MAX      512 // 2^9 (main_data_begin)

#define MPG_MD_STEREO       0
#define MPG_MD_JOINT_STEREO 1
#define MPG_MD_DUALCHAN     2
#define MPG_MD_MONO         3

#define MPXDEC_HEAD_RESYNC_RETRY    50000
#define MPXDEC_FRAME_RESYNC_RETRY   16
#define MPXDEC_FRAME_HEADSYNC_COUNT 3

#define MPXDEC_SKIP_BITSTREAM_BUGS 1
//#define MPXDEC_ENABLE_CRC_CHECK  1
//#define MPXDEC_ENABLE_FREEFORMAT 1

#ifdef MPXDEC_ENABLE_FREEFORMAT
 #define MPXDEC_FRAMESIZE_MAX  (MPXDEC_FRAMEBUFFER_SIZE-MPXDEC_BACKSTEP_MAX-16) // framebuffer_size - max_backstep - protection
 #define MPXDEC_HEADMASK_FREEFORMAT 0xfffffc03
#else
 #define MPXDEC_FRAMESIZE_MAX  1792
#endif

#define MPXDEC_HEADMASK_STANDARD 0xffff0c03

//decoding error codes
#define MPXDEC_ERROR_OK        0 // have to be zero! (others have to be non-zero)
#define MPXDEC_ERROR_NODATA    1 // eof
#define MPXDEC_ERROR_BITSTREAM 2 // hole or bad data/value
#define MPXDEC_ERROR_DATABEGIN 3 // main_data_begin

//mp3_decoder_info->infobits
#define MP3DI_INFOBIT_ID3V2_PRESENT   1
#define MP3DI_INFOBIT_RIFFWAVEHEAD    2
#define MP3DI_INFOBIT_VBR             4
#define MP3DI_INFOBIT_FREEFORMAT      8
#define MP3DI_INFOBIT_RESYNC         16

//#define USE_64_ALL 1   // 64-bit l3_deq, mdct, synth
#ifdef USE_64_ALL
 #define FLOAT double
 #define USE_64_DEQ 1
#else
 #define FLOAT float
#endif

//#define USE_64_DEQ 1
#ifdef USE_64_DEQ
 #define FLOAT_Q double
 #define MAPSHIFT 3
 #ifndef USE_64_ALL
  #define USE_64_CONV 1
 #endif
#else
 #define FLOAT_Q float
 #define MAPSHIFT 2
#endif

#define DEQ_SBLIMIT (SBLIMIT)

#ifndef M_PI
 #define M_PI    3.14159265358979323846264338327950288
#endif
#ifndef M_SQRT2
 #define M_SQRT2 1.41421356237
#endif

typedef struct mpxsynth_data_s{
 FLOAT *hybridp;              // mp3i->hybridp
 unsigned int granules;
 unsigned int outchannels;
 float *synth_rollbuff;       // [MPXDEC_CHANNELS_MAX][2][256+16]
 unsigned int synth_bo;       // block-offset of rollbuff
 unsigned int eq_sync_counter;
 FLOAT *eq_mdct_save;         // [MPXDEC_CHANNELS_MAX][FIR_BANDS][EQ_MDCTSAVE_SIZE]
}mpxsynth_data_s;

typedef struct mp3_decoder_data{
 unsigned char granules;
 unsigned char lay;
 unsigned char filechannels;
 unsigned char lsf;

 unsigned char bitrate_index;
 unsigned char frequency_index;
 unsigned char mpg_chmode;
 unsigned char mpg_chmode_ext;

 unsigned int  ssize;
 unsigned int  fsize;
 unsigned int  bsnum;
 unsigned int  fsizeold;

 unsigned long firsthead;
 unsigned char *bsbuf;
 unsigned char *bsbufold;
 unsigned int  freq;

 unsigned short pcm_samplenum;
 unsigned short syncretry_counter;

 unsigned int  infobits;

 unsigned char error_protection;
 unsigned char padding;
 unsigned char ms_stereo;
 unsigned char i_stereo;

 unsigned char outchannels;
 unsigned char gr;
 unsigned int  part2begin;

 //dynamic data fields (allocated to every file separately)
 unsigned char *bitstream_a; // alloc ptr [2][MPXDEC_FRAMEBUFFER_SIZE]
 unsigned char *bitstreamp;  // work ptr
 FLOAT *block_a;        // alloc-ptr and block-select-switch (blc)
 FLOAT *blockptr;       // [2][MPXDEC_CHANNELS_MAX][SBLIMIT][SSLIMIT]
 struct mpxsynth_data_s *synthdata;

 //static (temp) data fields (all files use the same memory field(s))
 struct gr_info_s *gr_info;
 FLOAT *deq_outdata;
 unsigned char *scalefacs;
 FLOAT *hybridp; // [MPXDEC_GRANULES_MAX][MPXDEC_CHANNELS_MAX][SSLIMIT][SBLIMIT]

 unsigned char *buf_p;
 unsigned int  buffer_bytes;

 unsigned long framesize;      // average
 unsigned long allframes;      // at Xing header
 unsigned long filedatabegin;  // at any extra header
 unsigned long filedatalen;    // at wav header

 unsigned int resync_counter;
}mp3_decoder_data;

typedef struct gr_info_s{
 int scfsi;
 unsigned int part2_3_length;
 unsigned int scalefac_compress;
 unsigned int block_type;
 unsigned int mixed_block_flag;
 unsigned int table_select[3];
 unsigned int subblock_gain[3];
 unsigned int maxband[3];
 unsigned int maxbandl;
 unsigned int maxb;
 unsigned int regions[4];
 unsigned int preflag;
 unsigned int scalefac_scale;
 unsigned int count1table_select;
 unsigned int full_gain[3];
 FLOAT_Q *pow2gain;
 FLOAT_Q *ispow32_base;
 int *mapp;
}gr_info_s;

//layer2.c
extern void mpxdec_layer2_init(void);
extern void mpxdec_layer2_getstuff(struct mp3_decoder_data *);
extern void mpxdec_layer2_decode_part1(struct mp3_decoder_data *);

//layer3.c
extern void mpxdec_layer3_init(void);
extern unsigned int mpxdec_bitstream_init(struct mp3_decoder_data *mp3i);
extern void mpxdec_bitstream_close(struct mp3_decoder_data *mp3i);
extern void mpxdec_bitstream_reset(struct mp3_decoder_data *mp3i);
extern unsigned int mpxdec_layer3_datafields_alloc(struct mp3_decoder_data *mp3i);
extern void mpxdec_layer3_datafields_close(struct mp3_decoder_data *mp3i);
extern void mpxdec_layer3_datafields_reset(struct mp3_decoder_data *mp3i);
extern unsigned int mpxdec_readframe(struct mp3_decoder_data *mp3i,struct mpxplay_filehand_buffered_func_s *fbfs,void *fbds,unsigned int do_resync);
extern unsigned int mpxdec_layer3_decode_part1(struct mp3_decoder_data *,unsigned int chan_mode);

extern struct mpxsynth_data_s *mpxdec_layer3_synth_alloc(FLOAT *hybridp);
extern void mpxdec_layer3_synth_close(struct mpxsynth_data_s *synthdata);
extern void mpxdec_layer3_synth_clear(struct mpxsynth_data_s *synthdata);
extern void mpxdec_decode_part2(struct mpxsynth_data_s *synthdata,unsigned char *pcm_mpxout_p);

//extern void mpxdec_layer3_clear_eq(void);
extern unsigned int mpxdec_layer3_eq_init(struct mpxsynth_data_s *synthdata);
extern void mpxdec_layer3_eq_close(struct mpxsynth_data_s *synthdata);
extern void mpxdec_layer3_eq_clear(struct mpxsynth_data_s *synthdata);

//l3_deq.asm
extern void mpxdec_l3deq_init(void);
extern void mpxdec_l3deq_dequantize(FLOAT_Q *,unsigned char *,struct gr_info_s *,int);
extern void mpxdec_l3deq_dequantize_ms(FLOAT_Q *,unsigned char *,struct gr_info_s *,int);
extern void mpxdec_l3deq_dequantize_bt2(FLOAT_Q *,unsigned char *,struct gr_info_s *,int);
extern void mpxdec_l3deq_dequantize_ms_bt2(FLOAT_Q *,unsigned char *,struct gr_info_s *,int);
extern void mpxdec_l3deq_dequantize_bt2_js(FLOAT_Q *,unsigned char *,struct gr_info_s *,int);
extern void mpxdec_l3deq_dequantize_ms_bt2_js(FLOAT_Q *,unsigned char *,struct gr_info_s *,int);

//l3_mdct.asm
extern void mpxdec_l3mdct_init(void);
extern void mpxdec_l3mdct_hybrid(FLOAT_Q *,FLOAT *,FLOAT *,struct gr_info_s *);

//synth.asm
#ifdef MPXDEC_INTEGER_OUTPUT
extern short *mpxdec_synth_granule(FLOAT *bandPtr,unsigned int bo8_channels,short *pcm_out,float *synth_rollbuff);
#else
extern float *mpxdec_synth_granule(FLOAT *bandPtr,unsigned int bo8_channels,float *pcm_out,float *synth_rollbuff);
#endif
extern void mpxdec_synth_init(int scale);

//layer3.c
extern int   mpxdec_tabsel_123[2][3][16];
extern long  mpxdec_freqs[10];

#endif // mp3dec_h
