//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: fastlist - load list/file with one key

#include "newfunc\newfunc.h"
#include "control.h"
#include "cntfuncs.h"
#include "playlist\playlist.h"
#include "display\display.h"

#define FASTLIST_MAX_FUNCS 16

typedef struct{
 unsigned int keycode;
 char filename[MAX_PATHNAMELEN];
}fastlist_func_t;

extern unsigned int playlistload,refdisp;
extern int playstartlist;

static fastlist_func_t fastlist_funcs[FASTLIST_MAX_FUNCS];
static unsigned int fastlistnum;

void mpxplay_control_fastlist_loadini(mpxini_line_t *mpxini_lines,struct mpxini_part_t *mpxini_partp)
{
 unsigned int i,funccount;
 mpxini_line_t *linep;
 fastlist_func_t *listfuncp;

 linep=mpxini_lines+mpxini_partp->partbegin_linenum;
 listfuncp=&fastlist_funcs[0];

 funccount=0;
 for(i=0;(i<mpxini_partp->partlinenum) && (funccount<FASTLIST_MAX_FUNCS);i++,linep++){
  if(linep->varnamep){
   if(pds_strlicmp(linep->varnamep,"fastlist")==0){
    char *fnamep=pds_strchr(linep->valuep,','); // begin of filename after ','
    if(!fnamep)
     continue;
    fnamep++;
    if(fnamep[0]=='\"')                         // filename begins with '"' (maybe)
     pds_strcpy(listfuncp->filename,fnamep+1);
    else
     pds_strcpy(listfuncp->filename,fnamep);
    fnamep=pds_strchr(listfuncp->filename,'\"');// filename ends with '"' (maybe)
    if(fnamep)
     *fnamep=0;
    listfuncp->keycode=pds_atol16(linep->valuep);
    listfuncp++;
    funccount++;
   }
  }
 }
 fastlistnum=funccount;
}

void mpxplay_control_fastlist_searchfilename(char *filename)
{
 if(fastlistnum){
  if(playstartlist<0 && filename){ // non-cmos search
   fastlist_func_t *listfuncp=&fastlist_funcs[0];
   do{
    if(pds_stricmp(filename,listfuncp->filename)==0){
     playstartlist=listfuncp-&fastlist_funcs[0];
     break;
    }
    listfuncp++;
   }while(listfuncp->filename[0] || listfuncp->keycode);
  }
  //verify CMOS and/or fastlist search result
  if(playstartlist<0)
   playstartlist=0;              // first
  if(playstartlist>=fastlistnum)
   playstartlist=fastlistnum-1;  // last
  funcbit_enable(playlistload,PLL_FASTLIST);
  playlist_loadsub_setnewinputfile(fastlist_funcs[playstartlist].filename);
 }
}

static void load_fastlist(char *listname,mainvars *mvp)
{
 funcbit_disable(playlistload,PLL_LISTS_CMDL);
 playlist_loadsub_sublist_clear();
 playlist_loadsub_setnewinputfile(listname);
 playlist_clear_side(mvp->psil);
 playlist_buildlist_one(mvp->psil,listname,0,NULL);
 playlist_chkfile_start_norm(mvp->psil,0);
 if(mvp->psil->editsidetype&PLT_ENABLED)
  funcbit_enable(playlistload,PLL_FASTLIST);
 refdisp|=RDT_EDITOR;
}

unsigned int mpxplay_control_fastlist_keycheck(unsigned int extkey,mainvars *mvp)
{
 if(fastlistnum){
  fastlist_func_t *listfuncp=&fastlist_funcs[0];
  do{
   if(extkey==listfuncp->keycode){
    playstartlist=listfuncp-&fastlist_funcs[0];
    load_fastlist(listfuncp->filename,mvp);
    return 1;
   }
   listfuncp++;
  }while(listfuncp->filename[0] || listfuncp->keycode);
 }
 return 0;
}

void mpxplay_control_fastlist_step(mainvars *mvp,int direction)
{
 if(fastlistnum){
  playstartlist+=direction;
  if(playstartlist<0)
   playstartlist=fastlistnum-1;
  if(playstartlist>=fastlistnum)
   playstartlist=0;
  load_fastlist(fastlist_funcs[playstartlist].filename,mvp);
 }
}
