//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: WAV-file output handling

#include "au_cards.h"
#include "newfunc\newfunc.h"
#include "control\control.h"

#define WAVID_RIFF   0x46464952 // RIFF (FIRR)
#define WAVID_WAVE   0x45564157 // WAVE (EVAW)
#define WAVID_fmt    0x20746d66 // fmt  ( tmf)
#define WAVID_data   0x61746164 // data (atad)

static int outfile_hand;
static unsigned long outfile_bytecount;
static char outfile_path[300];

static void wavout_open(struct audio_info *aui)
{
 char fullname[300],s[300];
 int drive,len;

 if(!outfile_path[0]){
  if(freeopts[OPT_OUTPUTFILE]){ // output directory or file
   pds_strcpy(outfile_path,freeopts[OPT_OUTPUTFILE]);

   drive=pds_getdrivenum_from_path(outfile_path);
   if(drive>=0){
    pds_getdcwd(drive+1,s);    // save current working dir
    if(outfile_path[1]==':' && outfile_path[2]==0){ // drive letter (d:)
     pds_strcpy(outfile_path,s);
     goto outfile_addbackslash;
    }
   }else
    pds_getcwd(s);             // -"-

   len=pds_strlen(outfile_path);
   if(((drive<0 && len>1) || (drive>=0 && len>3)) && outfile_path[len-1]=='\\') // it's not d:\ or \ and ends with a '\'
    outfile_path[len-1]=0;                // cut the '\' from the end

   if(pds_chdir(outfile_path)==0){ // argument is a dir
    if(drive>=0)
     pds_getdcwd(drive+1,outfile_path); // get the new working dir
    else
     pds_getcwd(outfile_path);          // -"-
    pds_chdir(s);              // restore previous working dir
   }else{                      // argument is a file
    outfile_path[0]=0;
    if(!pds_fullpath_check(freeopts[OPT_OUTPUTFILE])){
     pds_getcwd(s);
     if(s[pds_strlen(s)-1]!='\\')
      pds_strcat(s,"\\");
     pds_strcat(s,freeopts[OPT_OUTPUTFILE]);
     pds_fullpath(fullname,s);
    }else
     pds_fullpath(fullname,freeopts[OPT_OUTPUTFILE]);
    goto outfile_open;
   }
  }else{
   pds_getcwd(outfile_path);
  }

outfile_addbackslash:

  if(outfile_path[pds_strlen(outfile_path)-1]!='\\')
   pds_strcat(outfile_path,"\\");
 }

 pds_strcpy(fullname,outfile_path);

 pds_getfilename_noext_from_fullname(s,aui->mvp->pei0->filename);
 if((aui->card_infobits&AUINFOS_CARDINFOBIT_BITSTREAMOUT) && aui->card_wave_name){
  pds_strcat(s,".");
  pds_strcat(s,aui->card_wave_name);
 }else
  pds_strcat(s,".WAV");

 pds_strcat(fullname,s);

outfile_open:

 if(pds_stricmp(fullname,aui->mvp->pei0->filename)!=0) // input and output filename must be different
  outfile_hand=pds_open_create(fullname,O_RDWR|O_BINARY);
 else
  outfile_hand=0;
 if(!outfile_hand)
  mpxplay_close_program(MPXERROR_CANTWRITEFILE);
}

static void wavout_write_header(struct audio_info *aui)
{
 struct RIFF{
  unsigned long riffID;
  unsigned long rLen;
 }riff;
 struct WAVE{
  unsigned long waveID;
 }wave;
 struct FORMAT{
  unsigned long fmtID;
  unsigned long fLen;
  unsigned short wTag;
  unsigned short wChannel;
  unsigned long nSample;
  unsigned long nByte;
  unsigned short align;
  unsigned short sample;
 }fmt;
 struct DATA{
  unsigned long dataID;
  unsigned long dLen;
 }data;

 unsigned long filelen=pds_filelength(outfile_hand);
 unsigned int bytespersample;

 if(aui->card_wave_id==0x0003){
  bytespersample=4;
  aui->bits_card=1; // output scale (-1.0 - +1.0)
 }else
  bytespersample=(aui->bits_card+7)/8;

 outfile_bytecount=filelen;

 if(filelen<44)
  filelen=44;

 riff.riffID=WAVID_RIFF;
 riff.rLen  =filelen-sizeof(struct RIFF);

 wave.waveID=WAVID_WAVE;

 fmt.fmtID   =WAVID_fmt;
 fmt.fLen    =sizeof(struct FORMAT)-8;
 fmt.wTag    =aui->card_wave_id;
 fmt.wChannel=aui->chan_card;
 fmt.nSample =aui->freq_card;
 fmt.nByte   =aui->freq_card*aui->chan_card*bytespersample;
 fmt.align   =aui->chan_card*bytespersample;
 fmt.sample  =aui->bits_card;

 data.dataID=WAVID_data;
 data.dLen  =riff.rLen-(sizeof(struct WAVE)+sizeof(struct FORMAT)+sizeof(struct DATA));

 pds_dos_write(outfile_hand,(void *)&riff,sizeof(struct RIFF));
 pds_dos_write(outfile_hand,(void *)&wave,sizeof(struct WAVE));
 pds_dos_write(outfile_hand,(void *)&fmt ,sizeof(struct FORMAT));
 pds_dos_write(outfile_hand,(void *)&data,sizeof(struct DATA));
}

//------------------------------------------------------------------------
static int WAV_init(struct audio_info *aui)
{
 aui->card_port=aui->card_isa_dma=aui->card_irq=aui->card_isa_hidma=aui->card_type=0;
 return 1;
}

static int WAV_detect(struct audio_info *aui)
{
 aui->card_port=aui->card_isa_dma=aui->card_irq=aui->card_isa_hidma=aui->card_type=0;
 return 1;
}

static void WAV_card_info(struct audio_info *aui)
{
 pds_textdisplay_printf("WAV : pcm WAV file output (disk writer)");
}

static void WAV_stop(struct audio_info *aui)
{
 if(outfile_hand && !(aui->card_infobits&AUINFOS_CARDINFOBIT_BITSTREAMOUT)){
  long filepos=pds_tell(outfile_hand);
  pds_lseek(outfile_hand,0,SEEK_SET);
  wavout_write_header(aui);
  pds_lseek(outfile_hand,filepos,SEEK_SET);
 }
}

static void WAV_close(struct audio_info *aui)
{
 if(outfile_hand){
  pds_close(outfile_hand);
  outfile_hand=0;
 }
}

static void WAV_setrate(struct audio_info *aui) // new file
{
 WAV_close(aui);
 if(aui->card_controlbits&AUINFOS_CARDCNTRLBIT_BITSTREAMOUT)
  funcbit_enable(aui->card_infobits,AUINFOS_CARDINFOBIT_BITSTREAMOUT);
 wavout_open(aui);
 if(!(aui->card_infobits&AUINFOS_CARDINFOBIT_BITSTREAMOUT))
  wavout_write_header(aui);
}

static void WAV_writedata(struct audio_info *aui,char *pcm_sample,unsigned int outbytes)
{
 if(outfile_hand){
  if(outfile_bytecount<(0x7fffffffUL-outbytes)){
   if(pds_dos_write(outfile_hand,pcm_sample,outbytes)!=outbytes)
    mpxplay_close_program(MPXERROR_CANTWRITEFILE);
   outfile_bytecount+=outbytes;
  }else{
   WAV_stop(aui);
   WAV_close(aui);
  }
 }
}

one_sndcard_info WAV_sndcard_info={
 "WAV",
 SNDCARD_FLAGS_DISKWRITER,

 &WAV_init,       // card_init
 &WAV_detect,     // card_detect
 &WAV_card_info,  // card_info
 NULL,            // card_start
 &WAV_stop,       // card_stop
 &WAV_close,      // card_close
 &WAV_setrate,    // card_setrate

 NULL,            // cardbuf_init
 &WAV_writedata,  // cardbuf_writedata
 NULL,            // cardbuf_pos
 NULL,            // cardbuf_clear
 NULL,            // cardbuf_int_monitor
 NULL,            // irq_routine

 NULL,            // card_writemixer
 NULL,            // card_readmixer
 NULL             // card_mixerchans
};
