; #############################################################################
;
;    NECPINW V2.01 DOS .CPI printer codepage file for NEC Pinwriter series
;
;    Copyright (C) 1996-2000 by Matthias Paul  
;                               Ubierstrae 28
;                               D-50321 Brhl
;                               GERMANY
;
;    All rights reserved (except those detailed below).
;
;    EMail: <Matthias.Paul@post.rwth-aachen.de>
;    Web:   http://www.rhrz.uni-bonn.de/~uzs180/mpdokeng.html
;
;    Other distribution points (not currently up to date):
;
;    ftp://ftp.rhrz.uni-bonn.de/pub/pc/dos/misc/necpinw.zip
;                                           .../country.zip
;                                           .../mpdostip.zip
;    ftp://ftp.uni-stuttgart.de/pub/systems/msdos/util/system/mpdostip.zip
;                                                         .../cpi???.zip
;                                                        .../country.zip
;                                                    .../printers/necpinw.zip
;    http://www.leo.org/pub/comp/platforms/pc/msdos/utils/printutils/
;                                               .../utils/sysutils/
;                                               .../doc/
;    ftp://ftp.leo.org/...
;                ...pub/comp/platforms/pc/msdos/utils/printutils/necpinw.zip
;                                           .../utils/sysutils/country.zip
;                                           .../doc/mpdostip.zip
;
;    Last edit: 2000-09-28 MPAUL
;
; #############################################################################
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program (LICENSE.TXT); if not, write to the
;    Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
; #############################################################################
;
;    History:
;    ========
;
;    1996       MPAUL 1.00 Initial experimental release for my NEC Pinwriter
;                          P5300 (P7plus) 24 dot color printer based on my
;                          research on .CPI file formats, NLS stuff, and
;                          DOS internals.
;    1996       MPAUL 1.01-1.05 Various changes and additions not filed.
;    1997-03-17 MPAUL 1.06 Added support for the whole NEC Pinwriter series
;                          where applicable.
;                          (Thanks to NEC Deutschland GmbH, Ismaning (Germany)
;                          in particular Ferdinand Klement and Klaus Ulsamer
;                          at the NEC Hotline for their unbureaucratic support
;                          (01/1997-03/1997) in regard to my various questions
;                          on several NEC Pinwriters not being in my
;                          possession.  They have also provided free of charge
;                          a number of manuals for other Pinwriter models.)
;    1997-05-13 MPAUL 1.07 Final version based on new NEC manuals.
;    1999       MPAUL 1.08 Changes not filed.
;    2000-09-08 MPAUL 1.09 Added support for PTS-DOS codepage 667 ("Mazovia").
;                          (Thanks to Michal Tyc, Institute of Physics,
;                          Wroclaw University of Technology (Poland) for
;                          the hint that codepage 667 is in fact "Mazovia"!)
;    2000-09-20 MPAUL 1.10 Fixed a number of bugs.
;    2000-09-28 MPAUL 2.00 Almost complete rewrite to restructure the source.
;                          Thereby introduction of macros to ease future
;                          maintenance.
;                          Removed my obsolete codepage proposals 0 and 646.
;                          Added codepage 991 ("Mazovia") as alias to 667.
;                          (Again, thanks to Michal Tyc who pointed me to
;                          Marcin Gryszkalis' Polish text converter PLC.)
;                          Added download codepage 8501 ("Multilingual with
;                          Eurocurrency") as a variant of codepage 850 with
;                          the Eurocurrency symbol at codepoint D5h.  This is
;                          compatible with PC DOS 7 - PC DOS 2000 codepage 850.
;                          In lack of any better assignment for this new
;                          variant by one of the "Big Players" I propose
;                          to use ID 8501 for this codepage, which is not
;                          currently in use by IBM CDRA level 2.
;                          Added "private use" codepages 58194, 65280,
;                          65281..65294, 65296..65299, 65300..65305,
;                          65392..65398, 65401..65405, 65408..65410,
;                          65424..65428, 65440, 65446, 65452, 65455, 65456,
;                          65458, 65459, 65474, 65490, 65491, 65492, and
;                          65493 in the CDRA user definable ranges for CCSIDs
;                          and CPGIDs.  These allow direct access to various
;                          char sets (without offical codepage assignments)
;                          available on the NEC Pinwriters.
;                          These are provided mainly for test purposes and
;                          not for general use.
;                          Changed NECPINW license to GPL version 2.
;    2000-09-28 MPAUL 2.01 Cosmetical fixes.
;
; #############################################################################
;
;    DOS Compatibility:
;    ==================
;
;    NECPINW.CPI is a DOS printer codepage file designed for usage with
;    DR DOS 6.0, DR DOS "Panther" & DR DOS "StarTrek", Novell DOS 7,
;    Caldera OpenDOS 7.01, DR-OpenDOS 7.02, and DR-DOS 7.02 - 7.05.
;    Of course, it will also work under DR PalmDOS when using the
;    PRINTER.SYS from one of the other DR DOS releases (DR PalmDOS
;    itself does not ship with PRINTER.SYS).
;
;    It has *not* currently been tested with other DOS issues than those
;    listed above.  Older issues of DR DOS or MS-DOS/PC DOS may need some
;    adaptations or may not work at all.  At the time of this writing,
;    FreeDOS does not support any .CPI files, but hopefully this will be
;    added at a later stage and probably NECPINW.CPI will than also work
;    with FreeDOS.  Reports are welcome.
;
; #############################################################################
;
;    Printer compatibility:
;    ======================
;
;    The range of supported codepages provided by NECPINW.CPI depends on
;    the used NEC Pinwriter model and its configuration.
;
;    NECPINW has been tested with a NEC P5300 (P7plus) color 24 dot matrix
;    printer only.  Reports with other printers are most welcome...
;
;    Since the shipping NECPINW.CPI file is designed for generic use with
;    any of the supported printers, it may allow to switch to codepages not
;    available with your device.  Please do not select codepages not supported
;    by your model, as this may lead to unpredictable results.
;
;    Overview on available codepage support with the various NEC Pinwriters:
;    -----------------------------------------------------------------------
;
;    hex     CP   Name                                    P2/P3   P5/P5XL P6/P7   P5200   P2200   P2200XE P6200   P3200   P7200     P1200 P8000
;                                                         CP2/CP3 P9XL    CP6/CP7 P5300           P2plus  P6300   P3300   P7300     P1300 P72X
;                                                                                 P6plus                  P9300   P20     P3800     P2000
;                                                                                 P7plus                  P60     P30     P3900     P2Q
;                                                                                                         P70     P22Q    P62/P72   P3Q
;                                                                                                         P90     P32Q    P42Q/P52Q P2X
;
;    016Fh   367  ISO-646 (US) 7-bit                      yes     yes     yes     yes     yes     yes     yes     yes     yes       yes   yes
;    01B5h   437  Standard, IBM-2, PC-8, World Trade Set  yes     yes     yes     yes     yes     yes     yes     yes     yes       yes   yes
;    029Bh   667  Polish (Mazovia)                        no      no      no      no      no      no      8       8       8         ???   ???
;   (02E1h) (737) Greek                                   no      no      no      no      no      no      3 [1]   3 [1]   3 [1]     ???   ???
;    0352h   850  Multilingual, Latin I                   no      no      no      yes     no      no      yes     yes     yes       ???   ???
;    0354h   852  Slavic, Eastern Europe (Latin II)       no      no      no      no      no      no      2,6,7,8 2,6,7,8 2,6,7,8   ???   ???
;   (0355h) (853) Turkish (Latin II)                      no      no      no      no      no      no      4 [1]   4 [1]   4 [1]     ???   ???
;    0357h   855  Cyrillic I                              no      no      no      no      no      no      1,5,6   1,5,6   1,5,6     ???   ???
;   (0359h) (857) Turkish                                 no      no      no      no      no      no      4 [1]   4 [1]   4 [1]     ???   ???
;    035Ch   860  Portuguese                              no      no      no      yes     no      no      yes     yes     yes       ???   ???
;    035Fh   863  French Canadian                         no      no      no      yes     no      no      yes     yes     yes       ???   ???
;    0361h   865  Nordic, Norway II, Danish               no      no      no      yes     no      no      yes     yes     yes       ???   ???
;    0362h   866  Russian, Cyrillic II                    no      no      no      no      no      no      1,5,6   1,5,6   1,5,6     ???   ???
;    0363h   867  Czech??? (Kamenicky???)                 no      no      no      no      no      no      2 [2]   2 [2]   2 [2]     ???   ???
;    03DFh   991  Polish (Mazovia)                        no      no      no      no      no      no      8       8       8         ???   ???
;    2135h  8501  Multilingual, Latin I with Eurocurrency no      no???   no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;
;    E352h 58194  (same as CP 8501)                       no      no???   no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;
;    FF00h 65280  (0) 7-bit USA (same as CP 367)          yes     yes     yes     yes     yes     yes     yes     yes     yes       yes   yes
;    FF01h 65281  (1) 7-bit France                        yes     yes     yes     yes     yes     yes     yes     yes     yes       yes   yes
;    FF02h 65282  (2) 7-bit Germany                       yes     yes     yes     yes     yes     yes     yes     yes     yes       yes   yes
;    FF03h 65283  (3) 7-bit UK                            yes     yes     yes     yes     yes     yes     yes     yes     yes       yes   yes
;    FF04h 65284  (4) 7-bit Denmark I                     yes     yes     yes     yes     yes     yes     yes     yes     yes       yes   yes
;    FF05h 65285  (5) 7-bit Sweden                        yes     yes     yes     yes     yes     yes     yes     yes     yes       yes   yes
;    FF06h 65286  (6) 7-bit Italy                         yes     yes     yes     yes     yes     yes     yes     yes     yes       yes   yes
;    FF07h 65287  (7) 7-bit Spain I                       yes     yes     yes     yes     yes     yes     yes     yes     yes       yes   yes
;    FF08h 65288  (8) 7-bit Japan                         yes     yes     yes     yes     yes     yes     yes     yes     yes       yes   yes
;    FF09h 65289  (9) 7-bit Norway I                      no      ???     ???     yes     yes     yes     yes     yes     yes       yes   yes
;    FF0Ah 65290  (10) 7-bit Denmark II                   no      ???     ???     yes     yes     yes     yes     yes     yes       yes   yes
;    FF0Bh 65291  (11) 7-bit Netherlands                  no      ???     ???     yes     yes     yes     yes     yes     yes       yes   yes
;    FF0Ch 65292  (12) 7-bit Turkey                       no      ???     ???     yes     yes     yes     yes     yes     yes       yes   yes
;    FF0Dh 65293  (13) 7-bit Spain II                     no      ???     ???     yes     yes     yes     yes     yes     yes       yes   yes
;    FF0Eh 65294  (14) 7-bit Latin America                no      ???     ???     yes     yes     yes     yes     yes     yes       yes   yes
;    FF10h 65296  (16) Multilingual (same as CP 850)      no      ???     ???     yes     no      no      yes     yes     yes       yes   yes
;    FF11h 65297  (17) Portugual (same as CP 860)         no      ???     ???     yes     no      no      yes     yes     yes       yes   yes
;    FF12h 65298  (18) French Canada (same as CP 863)     no      ???     ???     yes     no      no      yes     yes     yes       yes   yes
;    FF13h 65299  (19) Norway II (same as CP 865)         no      ???     ???     yes     no      no      yes     yes     yes       yes   yes
;    FF14h 65300  (20) EPROMs (e.g. CP 852, ca. CP 737,853,857) no no     no      no      no      no      opt.    opt.    opt.      opt.  opt.
;    FF15h 65301  (21) EPROMs (e.g. CP 866, CP 667/991)   no      no      no      no      no      no      opt.    opt.    opt.      opt.  opt.
;    FF16h 65302  (22) EPROMs (e.g. CP 855, CP 866)       no      no      no      no      no      no      opt.    opt.    opt.      opt.  opt.
;    FF17h 65303  (23) EPROMs (e.g. CP 867)               no      no      no      no      no      no      opt.    opt.    opt.      opt.  opt.
;    FF18h 65304  (24) EPROMs (e.g. CP 855)               no      no      no      no      no      no      opt.    opt.    opt.      opt.  opt.
;    FF19h 65305  (25) EPROMs (var.)                      no      no      no      no      no      no      opt.    opt.    opt.      opt.  opt.
;
;    FF70h 65392  Euro DL font (universal, but ugly)      no      no???   no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF71h 65393  Euro DL font (Draft 10 cpi)             no      no???   no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF72h 65394  Euro DL font (Draft 12 cpi)             no      no???   no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF73h 65395  Euro DL font (Draft 12 cpi HS)          no      no???   no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF74h 65396  Euro DL font (Draft 15 cpi)             no      no???   no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF75h 65397  Euro DL font (Draft 17 cpi)             no      no???   no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF76h 65398  Euro DL font (Draft 20 cpi)             no      no???   no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF79h 65401  Euro DL font (LQ 10 cpi)                no      no???   no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF7Ah 65402  Euro DL font (LQ 12 cpi)                no      no???   no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF7Bh 65403  Euro DL font (LQ 15 cpi)                no      no???   no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF7Ch 65404  Euro DL font (LQ 17 cpi)                no      no???   no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;    FF7Dh 65405  Euro DL font (LQ 20 cpi)                no      no???   no???   yes [3] no      no      yes [3] no      yes [3]   no??? yes???
;
;    FF80h 65408  Download font (default)                 128     128     128     yes     128     128     yes     96      yes       yes   yes
;    FF81h 65409  Download font 1                         no      yes???  yes???  128/256 no      no      128/256 no      128/256   yes   yes
;    FF82h 65410  Download font 2                         no      yes???  yes???  128     no      no      128     no      128       yes   yes
;
;    FF90h 65424  Internal fonts (default)
;    FF90h 65425  External font cardridge 1               ???     yes     yes     yes     yes     yes     yes     no
;    FF91h 65426  External font cardridge 2               ???     yes???  yes???  yes     no???   no???   yes     no
;    FF92h 65427  External font cardridge 3               ???     ???     ???     yes     no???   no???   yes     no
;    FF93h 65428  External font cardridge 4               ???     ???     ???     yes     no???   no???   yes     no
;
;    FFA0h 65440  Internal font  0 (Courier 10)           ???     no [4]  no      yes     yes     yes     yes     yes     yes       yes??? yes???
;    FFA6h 65446  Internal font  6 (Super Focus)          no???   no      no      no      yes     no      no      no      no???     no???  no???
;    FFACh 65452  Internal font 12 (OCR-B)                no???   no      no      no      yes     no      no      no      no???     no???  no???
;    FFAFh 65455  Internal font 15 (ITC Souvenir 10)      ???     no      no      yes     yes     yes     yes     yes???  yes       yes??? yes???
;    FFB0h 65456  Internal font 16 (Helvette 10 PT etc.)  ???     no      no      yes     no      yes     yes     yes???  yes       yes    yes???
;    FFB2h 65458  Internal font 18 (Times 10 PT)          ???     no      no [4]  yes     no      yes     yes     yes???  yes       yes    yes???
;    FFB3h 65459  Internal font 19 (New Prestige Elite 12 WP) ??? no      no      yes     no      yes     yes     yes???  yes       yes    yes???
;    FFC2h 65474  Internal font 34 (Bold PS)              no      no      no      no      no      yes     yes     no???   yes       ???    ???
;    FFD2h 65490  Internal font 50 (Fast Focus 10)        no      no      no      no      no      yes     no      no???   no        ???    ???
;    FFD3h 65491  Internal font 51 (Fast Focus 12)        no      no      no      no      no      yes     no      no???   no        ???    ???
;    FFD4h 65492  Internal font 52 (Quick Gothic 10)      no      no      no      no      no      no      yes     yes     yes       ???    ???
;    FFD5h 65493  Internal font 53 (Quick Gothic 12)      no      no      no      no      no      no      yes???  yes???  yes       ???    ???
;
;    Notes:
;
;    [1] These codepages are not actually supported with EPROMs #3/#4,
;        but only a small number of codepoints differ between the
;        EPROM fonts and the official codepages.  Hence I decided to at
;        least add partial support for these codepages.
;
;        CP:  Differences compared to the EPROM implementation:
;
;        737  EEh, F0h, F1h, F4h, F5h, FCh.
;        853  86h, 8Fh, 91h, 92h, 9Bh, 9Dh, A8h, A9h, ACh, ADh,
;             B5h..B8h, BDh, BEh, C6h, C7h, CFh..D8h, DDh, DEh, ...
;        857  9Bh, 9Dh, A9h, B5h..B8h, BDh, BEh, C6h, C7h, CFh..D8h,
;             DDh, DEh, ...
;
;    [2] I assigned codepage 867 to Kamenicky, because some original NEC
;        advertisment flyers mentioned, that codepage 867 would be supported
;        by one of the optional EPROMs (they said nothing about the supported
;        language, though).  From other sources I have hints that codepage
;        867 is Czech, hence it seems a good assumption for codepage 867
;        is Kamenicky.  Info wanted...
;
;    [3] Codepages 8501 and 58194 are variants of codepage 850, but with the
;        Eurocurrency symbol at code point D5h.  PC DOS 7 - 2000 provides
;        this revised codepage under the name 850, but I decided to
;        leave the traditional codepage 850 alone as the old definition
;        is still in use in most of the other DOS operating systems.
;        My proposal for the Euro-variant of codepage 850 is codepage 8501,
;        while the IBM CDRA level 2 standard reserves the range E000h..EFFFh
;        for user definable CCSIDs (that is, "codepages" here).  NECPINW.CPI
;        provides the codepage under both IDs.  Please note, that both
;        assignments are subject to change in the case this codepage would
;        get an offical codepage number in the future.
;        The printer must be set up to accept a 256 character download
;        font (check print buffer settings etc.).
;        Unfortunately download fonts are bound to specific printer modes,
;        and it is not possible to properly define a character for all
;        possible resolutions at the same time.
;        For now ("EURO_STYLE EQU 9"), the Eurocurrency symbol is defined
;        for Letter Quality (LQ), 10 cpi (Pica) which seems to be the
;        most commonly used setting.
;        Alternatively this char set is available in Draft 10..20 cpi under
;        IDs 65393..65398 and in LQ 10..20 cpi under IDs 65401..65405, whereby
;        ID 65401 is again LQ 10 cpi (Pica).  Under ID 65392 you can use the
;        download data for Draft in any mode, including all the LQ modes.
;        In contrast to the above said, this allows to have *one* definition
;        that will be printed in *any* resolution, however, it looks very ugly
;        in LQ modes, and columns are no longer aligned, too.  If you still
;        want this universal setting to become the default, please edit this
;        to "EURO_STYE EQU 0".  This will change the default for codepages
;        8501 and 58194.
;
;    [4] Because the corresponding printer supports only the mentioned
;        type face (in LQ mode), it is not selectable.
;
;      - An EPROM-number instead of just 'yes' indicates that these codepages
;        are only supported with the corresponding additional EPROM installed
;        to the NEC Pinwriter (see table below).
;        Unfortunately codepages 852, 855, and 866 are not supported by all
;        available EPROMs, and codepages 855 and 866 have different selection
;        IDs with different EPROMs.
;        By default NECPINW.CPI supports the EPROMs #5/#6 "Code Tables"
;        ("EPROM_NO EQU 6"). Support for the other EPROMs, however, is
;        selectable at compilation time (EPROM_NO).  Note, that not all fonts
;        may be supported in these extra codepages (see tables below).
;
;      - The IBM CDRA level 2 standard reserves codepage IDs FF00h..FFFEh
;        for user definable "private use" assignments.  Hence I introduced
;        a number of pseudo-codepages to directly address all code sets
;        available with the various NEC Pinwriters.  Just add the NEC char set
;        selection IDs in the range 0..14, 16..19, and 20..25 (decimal)
;        to the FF00h base resulting in 65280..65305.  This allows to use
;        code sets not even assigned to one of the offical codepage IDs,
;        e.g. the "7-bit German" char set (2) is available under ID 65282
;        (FF02h) or - provided the proper EPROM installed to your printer -
;        the "CWI" code set (EPROM #7 "Hungary") can be found under ID 65301
;        (FF15h).
;        While these must not necessarily reflect actual different code sets,
;        65392..65405 selects the Eurocurrency char set in different resolu-
;        tions, codepage assignments 65408..65410 allow to select one of the
;        download fonts (default, 1, or 2), 65424..65448 allow to switch
;        between internal fonts and one of the four external cardridge fonts,
;        and 65440, 65446, 65452, 65455, 65456, 65458, 65459, 65474, 65490,
;        65491, 65492, or 65493 activate one of the internal fonts (e.g.
;        65459 selects "New Prestige Elite 12 WP" which significantly differs
;        in the supported range of characters).  These are mainly provided for
;        test purposes and not for general use.
;        Please note, that these numbers are NECPINW.CPI and printer specific
;        and are not supported by other devices or software.  Furthermore,
;        by definitionem other software may use these numbers for other
;        purposes, so you must not assume to get the same results elsewhere.
;
;      - For codepage support fully meeting the official specifications, the
;        printer must not be set to the internal font "Prestige Elite 12 WP"
;        nor to any other incompatible download or cardridge font (see above),
;        since these fonts use a code set with major differences compared to
;        IBM-2 (which is codepage 437 in this respect).
;        Speaking of "Prestige Elite 12 WP": While the lower half of the
;        code set is identical, this font has many special symbols in the
;        upper half, which cannot be found in codepage 437 nor in any other
;        codepage (some can be found in Epson's ISO-646 country specific
;        subset of "US Legal", but at different code points).  Codepage
;        switching is still functional when using this font, but only
;        those code points are replaced with the correct shapes, which
;        differ between the country specific code set to be set and
;        codepage 437.
;        In other words, you can think of the printer 'assuming' the
;        font's base plane (the setting assigned to codepage 437) would
;        actually be codepage 437; so, when switching codepages, it has
;        to replace only those characters, which differ between these
;        codepages.  However, for unknown reasons the font's base plane
;        is very different from codepage 437 and any other codepage.
;        As a matter of this fact, you will get better results in any
;        codepage other than 437 (since more code points are matching),
;        but still many shapes differ from the codepage to be set.
;        NECPINW.CPI could have been designed to avoid this by switching
;        back to a default font (most often "Courier" or "DRAFT Gothic")
;        each time a new codepage is set or refreshed.  The obvious backdraw
;        would be, that users usually printing in fonts other than the
;        default font would need to re-select their alternative font
;        after each and any codepage switch.  Currently, NECPINW.CPI does
;        not change the active font selection (with the exception of
;        codepage 8501).
;
;      - You should not use NECPINW.CPI with the first three generations of
;        NEC Pinwriters (P2/P3, CP2/CP3, P5/P5XL, P9XL, P6/P7, CP6/CP7),
;        because these printers do not support codepage switching at all.
;        Only download fonts would help to get rid of this restriction.
;        (The P5/P5XL, P9XL, P6/P7 and CP6/CP7 may at least support the
;        download codepage 8501, and probably also some of the entries in
;        the user definable range, but since I don't have any detailed info
;        on these early printers, and the later NEC manuals are somewhat
;        ambiguous in regard to which printers support which control
;        sequences, I am not completely sure about this.  Info wanted.)
;
;      - Also, I have no further information regarding the latest generation
;        of NEC Pinwriters P1200/P1300 (P2Q/P3Q), P2000 (P2X), and
;        P8000 (P72X), but I assume, that they can be compared best with
;        their pre-decessors.
;
;      - Internal font 16 ("Helvette 10 PT") is named "S. Helvetica" for
;        the P20/P30, P60/P70, P90.
;
;    Overview on available optional EPROMs for various NEC Pinwriters:
;    -----------------------------------------------------------------
;
;     No Name       Rev kBit  Selection ID                                          Supported by models      Supported in fonts
;                             20       21      22       23        24     25
;     #1 Russian     R5  512  Russian  Extruss 866      Baltic    855    --         all Pinwriters           Courier, Draft, Bold PS
;     #2 East Europe R4  512  852      Balkan  Hungary  Kamenicky Polish Yugoslavia all Pinwriters           all resident fonts (except Prestige Elite WP)
;     #3 Greek       R4  512  Greek    --      --       --        --     --         all Pinwriters           Courier, Draft, Bold PS, Times PS, Helvetica PS
;     #4 Turkey      R1  512  Turkey   --      --       --        --     --         all Pinwriters           all resident fonts (except Prestige Elite WP)
;     #5 Code Tables R3  512  852      866     855      --        --     --         all Pinwriters           Courier, Draft, Bold PS, Times PS, Helvetica PS,
;                                                                                                            ITC Souvenir, Quick Gothic, LQ S/S, Draft S/S
;     #6 Code Tables R3 1024  852      866     855      --        --     --         P62, P72, P42Q, P52Q     all resident fonts (except Prestige Elite WP)
;     #7 Hungary     R1  512  852      CWI     --       --        --     --         all Pinwriters           all resident fonts (except Prestige Elite WP)
;     #8 Polish      R1  512  852      Mazovia Polish_7 --        --     --         all Pinwriters           all resident fonts (except Prestige Elite WP)
;     #9 ORC-BDR     R2  512  ORC-BDR  --      --       --        --     --         P20, P30, P60, P70, P90, Courier (P20, P30, P22Q, P32Q, P42Q, P52Q),
;                                                                                   P22Q, P32Q, P42Q, P52Q   ITC Souvenir (P60, P70, P90)
;    #10 Bank        R1  512  USA_Bank --      --       --        --     --         all Pinwriters           all resident fonts (except Prestige Elite WP)
;
;    Notes:
;
;      - EPROM #7 "Hungary" and ID 22 "Hungary" in EPROM #1 "Russian"
;        are named "Hungaria" in the original NEC manuals.
;
;      - Fonts for EPROM #2 ID 24 "Polish" and EPROM #8 ID 22 "Polish_7"
;        are identical.  BTW, the fonts differ from codepage 437 only in
;        chars below 80h.
;
;      - Codepage #8 ID 21 "Mazovia" is Codepage 667 under PTS-DOS & S/DOS.
;        It is named Codepage 991 by PLC author Marcin Gryszkalis
;        (PLC is a Polish text converter).  Both assignments don't seem
;        to be codepage assignments approved by IBM or Microsoft.
;
;    Overview on NEC Pinwriter EPROM support:
;    ----------------------------------------
;
;    Printer model           kBit      PCB Revision                   Firmware
;
;    P3200/P3300, P20/P30    512       all                            since FW17
;                                      (until C5 in 1024 kBit socket)
;    P6200/P6300, P60/P70    512       since B8                       since FW20.04
;    P9300, P90              512       since A2                       since FW13.01
;    P7200/P7300, P62/P72    1024/512  cp: all                        cp: all
;                                      font: new version 1993         font: FW 12
;    P22Q/P32Q               512       all                            all
;    P3800/P3900, P42Q/P52Q  1024/512  cp: all                        cp: all
;                                      font: all                      font: since June 1993
;
;    Notes:
;
;      - The NEC Pinwriters P2/P3, CP2/CP3, P5/P5XL, P9XL, P6/P7, CP6/CP7,
;        P2200, P2200XE (P2plus), and P5200/P5300 (P6plus/P7plus) don't
;        provide any special EPROM support.
;
; #############################################################################
;
;    Installation under DOS:
;    =======================
;
;    Example:
;
;        CONFIG.SYS:
;
;          COUNTRY=49,437,c:\drdos\country.sys
;          DEVICE|HIDEVICE|DEVICEHIGH=...\printer.sys prn=(1050,999,2)
;
;        AUTOEXEC.BAT:
;
;          MODE prn: CODEPAGE PREPARE=((437,850) ...\necpinw.cpi)
;          [LH] NLSFUNC c:\drdos\country.sys
;          CHCP 437
;
;    Notes:
;
;      - In this example we use country code 49 (Germany) and corresponding
;        codepages 437 and 850.  Please change this to your requirements.
;
;      - We use a dummy hardware codepage 999 here to force PRINTER.SYS
;        to actually send the control sequences from the NECPINW.CPI file
;        for *both* codepages 437 and 850, rather then using an internally
;        fixed control sequence for the hardware codepage when switching
;        to 437.  This sequence would be valid for the Epson FX1050 printer,
;        but not for the NEC Pinwriters.
;
;      - If your COUNTRY.SYS file, as it is used by NLSFUNC, supports
;        codepage {cpid} for your country (normally 437 and 850 for
;        Germany = 49), you are now able to change the codepage for the
;        system and all devices with codepage support installed by issuing
;
;          CHCP {cpid}
;
;        However, this way you cannot switch to the other codepages
;        supported by NECPINW.CPI (but not supported by COUNTRY.SYS for
;        your country).  To select a random codepage supported by your
;        printer and by NECPINW.CPI, you have to use somewhat more complex
;        DOS commands instead:
;
;          MODE prn: CODEPAGE PREPARE=(({cpid}) ...\necpinw.cpi)
;          MODE prn: CODEPAGE SELECT={cpid}
;
;        This will replace the 1st slot (which has been assigned to 437
;        before) by the new codepage {cpid}.  If you would like to replace
;        the 2nd slot, just add a comma in front of {cpid}.  Note, that
;        these commands do not change the active codepage for other
;        devices nor the display.
;
;      - For additional information on how to install DOS codepage support,
;        please refer to DOS user manuals (HELP, DOSBOOK, etc.) or consult
;        my comprehensive NWDOSTIP.TXT document from my tips & tricks
;        package MPDOSTIP.ZIP (available in German language only).
;
; #############################################################################
;
;    Implementation details:
;    =======================
;
;    Notes:
;
;      - For details on DOS codepage support, codepage ID references,
;        and .CPI file formats, have a look at my DOS .CPI and Linux
;        .CP file analyzer and decompiler package (CPI???.ZIP), also
;        part of FreeDOS.  For details on DOS country support, country
;        ID references, and COUNTRY.SYS file formats, have a look at
;        my COUNTRY.ZIP package.
;
;      - I wished I could have designed NECPINW.CPI as a native codepage
;        switching printer .CPI file (PRINTER_TYPE 2), as this would consume
;        less memory in the resident PRINTER.SYS driver.  Unfortunately,
;        PRINTER.SYS seems to use hardwired escape sequences for
;        PRINTER_TYPE 2, so that they are not available for redefinition
;        in a .CPI file.  This is why NECPINW.CPI is implemented as a
;        download printer .CPI file (PRINTER_TYPE 1), although with one
;        exception the sent data is not font data, but just control
;        sequences for codepage switching between ROM fonts.  The exception
;        is codepage 8501 (and the other Euro variants), which actually makes
;        use of the RAM font feature to define the shape for the Eurocurrency.
;        DR DOS supports two model variants for PRINTER_TYPE 1, "4201" for
;        the IBM Proprinters II & III Model 4201 and IBM Proprinters II & III
;        XL Model 4202, and "1050" for the Epson printers FX-850/FX-1050.
;        I used "1050" instead of "4201" to take advantage of the smaller
;        resident size for the buffer occupied by PRINTER.SYS for download
;        data (ca. 2.3 Kb in contrast to ca. 7 Kb per codepage).  Due to
;        this fixed allocation, a ca. 2-2.5 Kb data area is still wasted
;        for each prepared codepage (typically two).  This problem could
;        be solved only by adding a user definable printer type to
;        PRINTER.SYS (Idea: loading the escape sequences in XMS, EMS,
;        or directly from harddisk; and a PRINTER.SYS parameter to define
;        the size of download data)...  Something to do for FreeDOS and
;        a possibly future "open" DR-DOS...
;
;    How to build:
;    -------------
;
;        1. Select appropriate conditional assembly switches in NECPINW.ASM.
;        2. Run MAKENEC.BAT, that is:
;           TASM necpinw.asm, necpinw.obj, nul, nul
;           LINK necpinw.obj; necpinw.exe; nul; nul
;           EXE2BIN necpinw.exe necpinw.cpi
;
;        Tested with TASM 3.1 and MASM 5.1 only.  MASM 4.0 needs adaptations.
;        Reports with other versions are welcome.
;
;    ToDo list:
;    ----------
;
;      - More testing with other printer models and DOS versions.
;
;      - Make specific printer models selectable at compilation time to
;        allow creation of .CPI files which strictly support features of
;        a particular model only.  Thereby revise all the model specific
;        control sequences to be actually valid for the corresponding
;        printers (unfortunately the NEC manuals are somewhat ambiguous
;        in regard to this question).
;        If you own one of the following NEC Pinwriter models (P2/P3,
;        CP2/CP3, P5/P5XL, P9XL, P6/P7, CP6/CP7, P2200 (not P2200XE),
;        P6200/P6300 (P60/P70), P9300 (P90), P22Q/P32Q, P3800/P3900
;        (P42Q/P52Q), P1200/P1300 (P2Q/P3Q), P2000 (P2X), or P8000 (P72X))
;        it would be great, if you could get into contact with me, so
;        that I can verify some of the assumptions I had to make when
;        developing NECPINW.CPI by checking them with your manuals.
;
;      - Do we need to take special precautions for printers on 7-bit only
;        serial connections? Do we have to use "ESC_,'>'", "ESC_,'='", and
;        "ESC_,'#'" for them?
;
;      - Support for other codepages by download fonts and improving support
;        for codepages 737, 853, 857.  (Problem would be the large size of
;        the download data and different formats of download data in different
;        printer modes.)  We'd have to do alot of case decisions and cannot
;        create a generic .CPI file (see codepage 8501 and its variants).
;        Please send me your Freeware or Public Domain download fonts.
;
;      - Similar .CPI files for other printers to be added (an implementation
;        for the Epson LQ-570+/LQ-1070+ dot matrix printers already exists)...
;
;      - Please send all corrections, changes, fixes, or enhancements to me,
;        rather than distributing modified versions of this software.
;
; #############################################################################


VERSION_MSG     equ <"2.01">            ; file version
DATE_MSG        equ <"000929">          ; date (ISO 28601/ISO 8601 "yymmdd")

EPROM_NO        equ    6                ;  0 = none
                                        ;  1 = Russian
                                        ;  2 = East Europe
                                        ;  3 = Greek
                                        ;  4 = Turkey
                                        ;  5 = Code Tables (512 Kb)
                                        ; <6>= Code Tables (1 Mb)
                                        ;  7 = Hungaria
                                        ;  8 = Polish
                                        ;  9 = ORC-BDR
                                        ; 10 = BANK

EURO_STYLE      equ     9               ;  0 = Universal (any mode, but ugly)
                                        ;  1 = Draft 10 cpi (Pica)
                                        ;  2 = Draft 12 cpi (Elite)
                                        ;  3 = Draft 12 cpi HS (Elite)
                                        ;  4 = Draft 15 cpi (Micro)
                                        ;  5 = Draft 17 cpi (Pica+Condensed)
                                        ;  6 = Draft 20 cpi (Elite+Condensed)
                                        ; <9>= LQ 10 cpi (Pica)
                                        ; 10 = LQ 12 cpi (Elite)
                                        ; 11 = LQ 15 cpi (Micro)
                                        ; 12 = LQ 17 cpi (Pica+Condensed)
                                        ; 13 = LQ 20 cpi (Elite+Condensed)

DEBUG           equ     0               ; 0 = generate distribution .CPI file
                                        ; 1 = include a few more test codes

; #############################################################################

NUL             equ     00h             ; special characters
LF              equ     0Ah             ;
CR              equ     0Dh             ;
SI_             equ     0Fh             ; "shift in"
DC2             equ     12h             ; "device control" condensed script on
CtrlZ           equ     1Ah             ;
ESC_            equ     1Bh             ; escape sequence (ESC/P, IBM, NEC)
FS_             equ     1Ch             ; escape sequence lead-in (NEC)
SPACE           equ     20h             ;
LTERM           equ     24h             ;

CP667           equ     667             ; unofficial codepage assignments
CP867           equ     867             ; for easier redefinition...
CP991           equ     991             ;
CP8501          equ     8501            ;

DEVICE_TYPE     equ     2               ; 1 = display, 2 = printer
DEVICE_NAME     equ     <"1050", SPACE, SPACE, SPACE, SPACE>

FONT_TYPE       equ     1               ;
PRINTER_TYPE    equ     1               ; 1 = download printer

NO_FONTS        equ     1               ; count of fonts

ITALICS         equ     0               ; use Italics for chars > 127
GRAPHICS        equ     1               ; use IBM graphics for chars > 127

                                        ; Standard charset selection IDs:
ID_0            equ     0               ; "7-bit US"
ID_1            equ     1               ; "7-bit France"
ID_2            equ     2               ; "7-bit Germany"
ID_3            equ     3               ; "7-bit United Kingdom"
ID_4            equ     4               ; "7-bit Denmark I"
ID_5            equ     5               ; "7-bit Sweden"
ID_6            equ     6               ; "7-bit Italy"
ID_7            equ     7               ; "7-bit Spain I"
                                        ; Extended charset selection IDs:
ID_8            equ     8               ; "7-bit Japan"
ID_9            equ     9               ; "7-bit Norway I"
ID_10           equ    10               ; "7-bit Denmark II"
                                        ; NEC specific charset selection IDs:
ID_11           equ    11               ; "7-bit Netherlands" (11 = "Spain II" with Epson!!!)
ID_12           equ    12               ; "7-bit Turkey"      (12 = "Latin America" with Epson!!!)
ID_13           equ    13               ; "7-bit Spain II"    (13 = "Korea" with Epson!!!)
ID_14           equ    14               ; "7-bit Latin America"
IF DEBUG EQ 1
ID_15           equ    15               ; (not used)         
ENDIF
                                        ; NEC specific codepage selection IDs:
ID_16           equ    16               ; "Multilingual" (CP 850)
ID_17           equ    17               ; "Portugual" (CP 860)
ID_18           equ    18               ; "French Canada" (CP 863)
ID_19           equ    19               ; "Norway II" (CP 865)
                                        ; NEC specific EPROM char set selection IDs:
ID_20           equ    20               ; CP 852,
                                        ; ca. CPs 853 and 857 (#4 "Turkish"),
                                        ; ca. CP 737 (#3 "Greek").
ID_21           equ    21               ; CPs 667/991 "Mazovia" (#8 "Polish"),
                                        ; CP 866 (#5/#6 "Code Tables").
ID_22           equ    22               ; CP 855 (#5/#6 "Code Tables"),
                                        ; CP 866 (#1 "Russian").
ID_23           equ    23               ; CP 867 (#2 "East Europe")
ID_24           equ    24               ; CP 855 (#1 "Russian")
ID_25           equ    25               ;
IF DEBUG EQ 1
ID_26           equ    26               ; (not used)
ID_64           equ    64               ; (64 = "Legal" with Epson!!!)
ENDIF
                                        ; Script family type face selector
TF_COURIER_10   equ     0               ; 0 = Courier 10
TF_SUPERFOCUS   equ     6               ; 6 = Super Focus (P2200 only)
TF_OCR_B        equ    12               ; 12= OCR-B (P2200 only)
TF_ITCSOUVENIER_10 equ 15               ; 15= ITC Souvenir 10
TF_HELVETTE_10PT equ   16               ; 16= Helvette 10 PT
TF_TIMES_10PT   equ    18               ; 18= Times 10 PT
TF_NEWPRESTIGEELITE_12WP equ 19         ; 19= New Prestige Elite 12 WP
TF_BOLD_PS      equ    34               ; 34= Bold PS
TF_FASTFOCUS_10 equ    50               ; 50= Fast Focus 10
TF_FASTFOCUS_12 equ    51               ; 51= Fast Focus 12
TF_QUICKGOTHIC_10 equ  52               ; 52= Quick Gothic 10
TF_QUICKGOTHIC_12 equ  53               ; 53= Quick Gothic 12

BUFFER_NO       equ    0                ; since we need a 256 byte buffer, only
                                        ; buffer 1 (BUFFER_NO = 0) is valid

EURO_CHR        equ    0D5h             ; Code point for Euro (PC DOS 7 CP 850)

LAST            equ     1               ; for use with CPEntry macro
NOTLAST         equ     0               ;


CPEntry macro   start,next,codepage,data,flag
        ENTRY_COUNTER = ENTRY_COUNTER + 1
start   dw      (offset next - offset start)
IF flag EQ LAST
        ;;dd    0                       ; Last code page
        dw      0, 0                    ; End of List marker
ELSE
        ;;dd    offset next             ; File offset of next list entry
        dw      offset next             ;
        dw      0                       ; (segment always zero)
ENDIF
        dw      DEVICE_TYPE             ; Device number
        db      DEVICE_NAME             ; Device name
        dw      codepage                ; Code page number
        dw      3 dup (0)               ; Reserved

        ;;dd    offset data             ; File offset of data-header for this
        dw      offset data             ;
        dw      0                       ; (segment always zero)

IF flag EQ LAST
ELSE
next    label   word                    ; to avoid improper use of the macro...
ENDIF
        endm


SelCP   macro mode,selector             ; used for codepage selection
                                        ; BEWARE: This must be 12 bytes long!!!
        db      ESC_,'t',mode           ; choose "Italics" or "Graphics" table
                                        ; NB. The previous is probably not
                                        ; supported by P5XL,P9XL,P6/P7/CP6/CP7!
                                        ;
        db      FS_,'I',mode            ; same as above (NEC only)
                                        ; NB. The previous is probably not
                                        ; supported by P5XL,P9XL,P6/P7/CP6/CP7!
                                        ;
        db      ESC_,'R',selector       ; select character set
        db      NUL                     ; dummy filler
        db      ESC_,'6'                ; codes 128-159 are printable
                                        ; NB. The previous is probably not
                                        ; supported by P5XL,P9XL,P6/P7/CP6/CP7!
        endm


CPData  macro   start,next,mode,selector,fontdata
start   dw      FONT_TYPE               ; type of font (1=FONT)
        dw      NO_FONTS                ; count of fonts
        dw      (offset next - offset fontdata) ; Length of font definitions
fontdata label  BYTE
        dw      PRINTER_TYPE
        dw      12                      ; length of sequences
                                        ; NB. Apparently, DR DOS PRINTER.SYS
                                        ; uses the second half of the 1st
                                        ; sequence as lead out sequence???
                                        ; For proper results, you may not
                                        ; move the starting points of these
                                        ; sequences.
        SelCP   mode,selector           ; init sequence 1 (ROM???)
        SelCP   mode,selector           ; init sequence 2 (RAM???)
        ; more control sequences immediately following the CPData macro...
        endm

; #############################################################################

Code Segment
        ASSUME CS:Code, DS:Code
        org     0

NECPINW_CPI:

; #############################################################################

FontFileHeader:
        db      0FFh
        db      "FONT", SPACE, SPACE, SPACE
        db      8 DUP (0)
        dw      1                       ; count of pointers in header
        db      1                       ; type of info pointer
                                        ;
;;      dd      offset FontInfoHeader   ; pointer to start of list
        dw      offset FontInfoHeader   ;
        dw      0                       ; (offset always zero)

; #############################################################################

FontInfoHeader:
        dw      CP_COUNT                ; count of codepages in file

; #############################################################################

        ENTRY_COUNTER = 0

;CPEntryHeader:
        CPEntry prn367, prn437,  367, data367, NOTLAST ; ANSI X3.4 ASCII, ISO-646-US
        CPEntry prn437, prn667,  437, data437, NOTLAST ; CP 437
        CPEntry prn667, prn737,CP667, data667, NOTLAST ; PTS-DOS CP 667
        CPEntry prn737, prn850,  737, data737, NOTLAST ;
        CPEntry prn850, prn852,  850, data850, NOTLAST ; CP 850
        CPEntry prn852, prn853,  852, data852, NOTLAST ; CP 852
        CPEntry prn853, prn855,  853, data853, NOTLAST ;
        CPEntry prn855, prn857,  855, data855, NOTLAST ; CP 855
        CPEntry prn857, prn860,  857, data857, NOTLAST ;
        CPEntry prn860, prn863,  860, data860, NOTLAST ; CP 860
        CPEntry prn863, prn865,  863, data863, NOTLAST ; CP 863
        CPEntry prn865, prn866,  865, data865, NOTLAST ; CP 865
        CPEntry prn866, prn867,  866, data866, NOTLAST ; CP 866
        CPEntry prn867, prn991,CP867, data867, NOTLAST ;
        CPEntry prn991,prn8501,CP991, data991, NOTLAST ; PLC CP 991
IF 0
        ; NB. These entries are not currently enabled, because I'm not
        ;     sure if these would be actually the correct numbers. I would
        ;     need to have access to the IBM CDRA level 2 CD-ROM to verify
        ;     this. For now use "user definable" numbers in the range
        ;     FF00h..FFFEh instead.
        CPEntry prn1009,prn1010,1009,data1009, NOTLAST ; ISO-7 IRV (prior 1992)
        CPEntry prn1010,prn1011,1010,data1010, NOTLAST ; ISO-7 France
        CPEntry prn1011,prn1012,1011,data1011, NOTLAST ; ISO-7 Germany
        CPEntry prn1012,prn1013,1012,data1012, NOTLAST ; ISO-7 Italy
        CPEntry prn1013,prn1014,1013,data1013, NOTLAST ; ISO-7 United Kingdom
        CPEntry prn1014,prn1015,1014,data1014, NOTLAST ; ISO-7 Spain
        ;CPEntry prn1015,prn1016,1015,data1015,NOTLAST ; ISO-7 Portugal
        CPEntry prn1016,prn1017,1016,data1016, NOTLAST ; ISO-7 Norway
        CPEntry prn1017,prn1018,1017,data1017, NOTLAST ; ISO-7 Denmark
        CPEntry prn1018,prn1019,1018,data1018, NOTLAST ; ISO-7 Finland, Sweden
        CPEntry prn1019,prn1020,1019,data1019, NOTLAST ; ISO-7 Belgium, Netherlands
        ;CPEntry prn1020,prn1021,1020,data1020,NOTLAST ; ISO-7 French Canadia variant
        ;CPEntry prn1021,prn1023,1021,data1021,NOTLAST ; ISO-7 Switzerland variant
        CPEntry prn1023,prn1101,1023,data1023, NOTLAST ; ISO-7 Spain variant
        ;CPEntry prn1101,prn1102,1101,data1101,NOTLAST ; ISO-7 British NRC Set
        ;CPEntry prn1102,prn1103,1102,data1102,NOTLAST ; ISO-7 Dutch NRC Set
        ;CPEntry prn1103,prn1104,1103,data1103,NOTLAST ; ISO-7 Finnish NRC Set
        ;CPEntry prn1104,prn1105,1104,data1104,NOTLAST ; ISO-7 French NRC Set
        ;CPEntry prn1105,prn1106,1105,data1105,NOTLAST ; ISO-7 Norwegian/Danish NRC Set
        ;CPEntry prn1106,prn1107,1106,data1106,NOTLAST ; ISO-7 Swedisch NRC Set
        ;CPEntry prn1107,prn8501,1107,data1107,NOTLAST ; ISO-7 Norwegian/Danish NRC Set (Alternate)
ENDIF
        ; NB. 8501 is just my proposal for the CP 850 variant with Eurocurrency.
        CPEntry prn8501,prn58194,CP8501,data8501,NOTLAST

        ; IBM CDRA level 2 user definable range E000h..EFFFh for CCSIDs:
        ;
        ; NB. IBM CDRA compatible definition for a private variant of CP 850:
        ;     CP 850 = 0352h => E352h = 58194 to be used.
        ;     We use it as an alias to our 8501 codepage here...

        CPEntry prn58194,prn65280,58194,data58194,NOTLAST ; Euro

        ; IBM CDRA level 2 user definable range FF00h..FFFEh for CPGIDs:
        ;
        ; NB. The user definable range of CPGIDs allows to define private
        ;     "codepages" to directly address all selection IDs 0..25
        ;     available on the NEC Pinwriters under a specific number
        ;     regardless of any offical codepage assignments in existance.
        ;     Also added are values to select any of the download or cardridge
        ;     fonts as well as internal type face fonts.
        ;     Please note, that these numbers are specific to NECPINW.CPI
        ;     and the results depend on the model and configuration of the
        ;     NEC Pinwriter controlled by PRINTER.SYS + NECPINW.CPI.
        ;     You must *not* assume that the use of these IDs will produce
        ;     similar char sets on other devices or with other software,
        ;     it may even change with future issues of NECPINW.CPI.

        CPEntry prn65280,prn65281,65280,data65280,NOTLAST ; 7-bit USA (0)
        CPEntry prn65281,prn65282,65281,data65281,NOTLAST ; 7-bit France (1)
        CPEntry prn65282,prn65283,65282,data65282,NOTLAST ; 7-bit Germany (2)
        CPEntry prn65283,prn65284,65283,data65283,NOTLAST ; 7-bit UK (3)
        CPEntry prn65284,prn65285,65284,data65284,NOTLAST ; 7-bit Denmark I (4)
        CPEntry prn65285,prn65286,65285,data65285,NOTLAST ; 7-bit Sweden (5)
        CPEntry prn65286,prn65287,65286,data65286,NOTLAST ; 7-bit Italy (6)
        CPEntry prn65287,prn65288,65287,data65287,NOTLAST ; 7-bit Spain I (7)
        CPEntry prn65288,prn65289,65288,data65288,NOTLAST ; 7-bit Japan (8)
        CPEntry prn65289,prn65290,65289,data65289,NOTLAST ; 7-bit Norway I (9)
        CPEntry prn65290,prn65291,65290,data65290,NOTLAST ; 7-bit Denmark II (10)
        CPEntry prn65291,prn65292,65291,data65291,NOTLAST ; 7-bit Netherlands (11)
        CPEntry prn65292,prn65293,65292,data65292,NOTLAST ; 7-bit Turkey (12)
        CPEntry prn65293,prn65294,65293,data65293,NOTLAST ; 7-bit Spain II (13)
IF DEBUG EQ 1
        CPEntry prn65294,prn65295,65294,data65294,NOTLAST ; 7-bit Latin America (14)
        CPEntry prn65295,prn65296,65295,data65295,NOTLAST ; undefined??? (15)
ELSE
        CPEntry prn65294,prn65296,65294,data65294,NOTLAST ; 7-bit Latin America (14)
ENDIF
        CPEntry prn65296,prn65297,65296,data65296,NOTLAST ; Multilingual 850 (16)
        CPEntry prn65297,prn65298,65297,data65297,NOTLAST ; Portugual 860 (17)
        CPEntry prn65298,prn65299,65298,data65298,NOTLAST ; French Canada 863 (18)
        CPEntry prn65299,prn65300,65299,data65299,NOTLAST ; Norway II 865 (19)
                                                          ;
        CPEntry prn65300,prn65301,65300,data65300,NOTLAST ; EPROM (20)
        CPEntry prn65301,prn65302,65301,data65301,NOTLAST ; EPROM (21)
        CPEntry prn65302,prn65303,65302,data65302,NOTLAST ; EPROM (22)
        CPEntry prn65303,prn65304,65303,data65303,NOTLAST ; EPROM (23)
        CPEntry prn65304,prn65305,65304,data65304,NOTLAST ; EPROM (24)
     
IF DEBUG EQ 1
        CPEntry prn65305,prn65306,65305,data65305,NOTLAST ; EPROM (25)
        CPEntry prn65306,prn65344,65306,data65306,NOTLAST ; EPROM (26)
        CPEntry prn65344,prn65392,65344,data65344,NOTLAST ; EPROM (64)
ELSE
        CPEntry prn65305,prn65392,65305,data65305,NOTLAST ; EPROM (25)
ENDIF
        CPEntry prn65392,prn65393,65392,data65392,NOTLAST ; Euro universal
        CPEntry prn65393,prn65394,65393,data65393,NOTLAST ; Euro Draft 10 cpi
        CPEntry prn65394,prn65395,65394,data65394,NOTLAST ; Euro Draft 12 cpi
        CPEntry prn65395,prn65396,65395,data65395,NOTLAST ; Euro Draft HS 12 cpi
        CPEntry prn65396,prn65397,65396,data65396,NOTLAST ; Euro Draft 15
        CPEntry prn65397,prn65398,65397,data65397,NOTLAST ; Euro Draft 17
        CPEntry prn65398,prn65401,65398,data65398,NOTLAST ; Euro Draft 20
        CPEntry prn65401,prn65402,65401,data65401,NOTLAST ; Euro LQ 10 cpi
        CPEntry prn65402,prn65403,65402,data65402,NOTLAST ; Euro LQ 12 cpi
        CPEntry prn65403,prn65404,65403,data65403,NOTLAST ; Euro LQ 15 cpi
        CPEntry prn65404,prn65405,65404,data65404,NOTLAST ; Euro LQ 17
        CPEntry prn65405,prn65408,65405,data65405,NOTLAST ; Euro LQ 20

        CPEntry prn65408,prn65409,65408,data65408,NOTLAST ; Download (default)
        CPEntry prn65409,prn65410,65409,data65409,NOTLAST ; Download 1
        CPEntry prn65410,prn65424,65410,data65410,NOTLAST ; Download 2
                                                          ;
        CPEntry prn65424,prn65425,65424,data65424,NOTLAST ; internal fonts (default)
        CPEntry prn65425,prn65426,65425,data65425,NOTLAST ; external font 1
        CPEntry prn65426,prn65427,65426,data65426,NOTLAST ; external font 2
        CPEntry prn65427,prn65428,65427,data65427,NOTLAST ; external font 3
        CPEntry prn65428,prn65440,65428,data65428,NOTLAST ; external font 4
                                                          ;
        CPEntry prn65440,prn65446,65440,data65440,NOTLAST ; internal font 0
        CPEntry prn65446,prn65452,65446,data65446,NOTLAST ; internal font 6
        CPEntry prn65452,prn65455,65452,data65452,NOTLAST ; internal font 12
        CPEntry prn65455,prn65456,65455,data65455,NOTLAST ; internal font 15
        CPEntry prn65456,prn65458,65456,data65456,NOTLAST ; internal font 16
        CPEntry prn65458,prn65459,65458,data65458,NOTLAST ; internal font 18
        CPEntry prn65459,prn65474,65459,data65459,NOTLAST ; internal font 19
        CPEntry prn65474,prn65490,65474,data65474,NOTLAST ; internal font 34
        CPEntry prn65490,prn65491,65490,data65490,NOTLAST ; internal font 50
        CPEntry prn65491,prn65492,65491,data65491,NOTLAST ; internal font 51
        CPEntry prn65492,prn65493,65492,data65492,NOTLAST ; internal font 52
        CPEntry prn65493,FontDataHeader,65493,data65493,LAST; internal font 53

        CP_COUNT = ENTRY_COUNTER

; #############################################################################

FontDataHeader:

        CPData  data437,data65280,GRAPHICS,ID_0,seq437

        ; IBM CDRA level 2 user definable range E000h..EFFFh for CCSIDs:

                ; (for CP 58194 see CP 65392..CP65405 below)
        
        ; IBM CDRA level 2 user definable range FF00h..FFFEh for CPGIDs:

data367:        ; ISO-646 7-bit ASCII (US)
;data1009:
        CPData  data65280,data65281,ITALICS,ID_0,seq65280  ; 7-bit USA (0)
;data1010:
        CPData  data65281,data65282,ITALICS,ID_1,seq65281  ; 7-bit France (1)
;data1011:
        CPData  data65282,data65283,ITALICS,ID_2,seq65282  ; 7-bit Germany (2)
;data1013:
        CPData  data65283,data65284,ITALICS,ID_3,seq65283  ; 7-bit UK (3)
;data1017:
        CPData  data65284,data65285,ITALICS,ID_4,seq65284  ; 7-bit Denmark I (4)
;data1018:
        CPData  data65285,data65286,ITALICS,ID_5,seq65285  ; 7-bit Sweden (5)
;data1012:
        CPData  data65286,data65287,ITALICS,ID_6,seq65286  ; 7-bit Italy (6)
;data1014:
        CPData  data65287,data65288,ITALICS,ID_7,seq65287  ; 7-bit Spain I (7)
        CPData  data65288,data65289,ITALICS,ID_8,seq65288  ; 7-bit Japan (8)
;data1016:
        CPData  data65289,data65290,ITALICS,ID_9,seq65289  ; 7-bit Norway I (9)
        CPData  data65290,data65291,ITALICS,ID_10,seq65290 ; 7-bit Denmark II (10)
;data1019:
        CPData  data65291,data65292,ITALICS,ID_11,seq65291 ; 7-bit Netherlands (11)
        CPData  data65292,data65293,ITALICS,ID_12,seq65292 ; 7-bit Turkey (12)
;data1023:
        CPData  data65293,data65294,ITALICS,ID_13,seq65293 ; 7-bit Spain II (13)

IF DEBUG EQ 1
        CPData  data65294,data65295,ITALICS,ID_14,seq65294  ; 7-bit Latin America (14)
        CPData  data65295,data65296,GRAPHICS,ID_15,seq65295 ; not used??? (15)
ELSE
        CPData  data65294,data65296,ITALICS,ID_14,seq65294  ; 7-bit Latin America (14)
ENDIF

data850:        ; CP 850
        CPData  data65296,data65297,GRAPHICS,ID_16,seq65296 ; Multilingual (16)

data860:        ; CP 860
        CPData  data65297,data65298,GRAPHICS,ID_17,seq65297 ; Portugual (17)

data863:        ; CP 863
        CPData  data65298,data65299,GRAPHICS,ID_18,seq65298 ; French Canada (18)

data865:        ; CP 865
        CPData  data65299,data65300,GRAPHICS,ID_19,seq65299 ; Norway II (19)

data737:        ; (Similar to CP 737 with EPROM #3 "Greek" only)
data852:        ; CP 852 with EPROMs #2 "East Europe", #5/#6 "Code Tables", #7 "Hungaria", #8 "Polish"
data853:        ; (Similar to CP 853 with EPROM #4 "Turkey"/"CT Turkey" only)
data857:        ; (Similar to CP 857 with EPROM #4 "Turkey"/"CT Turkey" only)
        CPData  data65300,data65301,GRAPHICS,ID_20,seq65300 ; EPROM (20)

data667:        ; CP 667 "Mazovia" with EPROM #8 "Polish" only
IF NOT EPROM_NO EQ 1
data866:        ; CP 866 with EPROMs #5/#6 "Code Tables" only
ENDIF
data991:        ; CP 991 "Mazovia" with EPROM #8 "Polish" only
        CPData  data65301,data65302,GRAPHICS,ID_21,seq65301 ; EPROM (21)

IF EPROM_NO EQ 1
data866:        ; CP 866 with EPROM #1 "Russian" only
ELSE
data855:        ; CP 855 with EPROMs #5/#6 "Code Tables" only
ENDIF
        CPData  data65302,data65303,GRAPHICS,ID_22,seq65302 ; EPROM (22)

data867:        ; (Probably CP 867 "Czech/Kamenicky" with EPROM #2 "East Europe" only)
        CPData  data65303,data65304,GRAPHICS,ID_23,seq65303 ; EPROM (23)

IF EPROM_NO EQ 1
data855:        ; CP 855 with EPROM #1 "Russian" only
ENDIF
        CPData  data65304,data65305,GRAPHICS,ID_24,seq65304 ; EPROM (24)

IF DEBUG EQ 1
        CPData  data65305,data65306,GRAPHICS,ID_25,seq65305 ; EPROM (25)
        CPData  data65306,data65344,GRAPHICS,ID_26,seq65306 ; not used??? (26)
        CPData  data65344,data65392,GRAPHICS,ID_64,seq65344 ; not used??? (64)
ELSE
        CPData  data65305,data65392,GRAPHICS,ID_25,seq65305 ; EPROM (25)
ENDIF

IF EURO_STYLE EQ 0
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65392,data65393,GRAPHICS,ID_16,seq65392 ; Euro Universal
        db      FS_,'W',1               ; select 256 user definable chrs
                                        ; NB. The previous is probably not
                                        ; supported by P5XL, P9XL, P6/P7/
                                        ; CP6/CP7, P2200, P2plus, P20/P30,
                                        ; P22Q/P32Q.
        SelCP   GRAPHICS,ID_16          ; init sequence (again)
        db      ESC_,'%',0              ; select internal char set
        ;db     ESC_,'p',0              ; Proportional off
        db      ESC_,'5'                ; Italics off
        db      ESC_,'T'                ; super-/sub-script off
        db      ESC_,':',NUL,NUL,NUL    ; copy ROM into RAM buffer 1
;
;       Definition of the Eurocurrency symbol for Universal (same as Draft):
;
;           123456789012            LEAD_IN+BOX_SIZE+LEAD_OUT=12 (!)
;             123456789             BOX_SIZE=9 here (9 max.)
;           12         1            LEAD_IN=2, LEAD_OUT=1 here
;       1   ..000000000.    1   MSB
;       2   ..000000000.    2    |
;       3   ..000000000.    3    |
;       4 vv..000000000.vv  4    |  1st byte
;       5   ..000000000.         |
;       6   ..000010100.         |
;       7   ..000101010.         |
;       8   ..001000001.        LSB
;       9   ..010000000.        MSB
;      10   ..101010100.         |
;      11   ..101010000.         |
;      12   ..010000000.         |  2nd byte
;      13   ..010000000.         |
;      14   ..101010100.         |
;      15   ..101010000.         |
;      16   ..010000000.        LSB
;      17   ..001000001.        MSB
;      18   ..000101010.         |
;      19   ..000010100.         |
;      20 ^^..000000000.^^ 4     |
;      21   ..000000000.   3     |  3rd byte
;      22   ..000000000.   2     |
;      23   ..000000000.   1     |
;      24 __..000000000.__      LSB

        db      ESC_,'&',BUFFER_NO,EURO_CHR,EURO_CHR,2,9,1
                ; RAM data for Eurocurrency character (3*9 bytes)
        db      00h, 66h, 00h,  00h, 99h, 00h,  01h, 66h, 80h,  02h, 00h, 40h ; 1..4
        db      04h, 66h, 20h,  02h, 00h, 40h,  04h, 44h, 20h,  02h, 00h, 40h ; 5..8
        db      01h, 00h, 80h                                                 ; 9
        db      ESC_,'%',1              ; select RAM char set
        ;db     FS_,'X',BUFFER_NO

IF EURO_STYLE EQ 1
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65393,data65394,GRAPHICS,ID_16,seq65393 ; Euro in Draft 10 cpi
        db      FS_,'W',1               ; select 256 user definable chrs
                                        ; NB. The previous is probably not
                                        ; supported by P5XL, P9XL, P6/P7/
                                        ; CP6/CP7, P2200, P2plus, P20/P30,
                                        ; P22Q/P32Q.
        SelCP   GRAPHICS,ID_16          ; init sequence (again)
        db      ESC_,'%',0              ; select internal char set
        db      ESC_,'p',0              ; Proportional off
        db      ESC_,'x',0              ; select Draft
        db      ESC_,'5'                ; Italics off
        db      ESC_,'T'                ; super-/sub-script off
        db      DC2                     ; condensed script off
        ;db     ESC_,'!',0              ; deselect all (including condensed off)
        db      ESC_,'P'                ; select 10 cpi (Pica)
        db      ESC_,':',NUL,NUL,NUL    ; copy ROM into RAM buffer 1
;
;       Definition of the Eurocurrency symbol for Draft 10 cpi (Pica):
;
;           123456789012            LEAD_IN+BOX_SIZE+LEAD_OUT=12 (!)
;             123456789             BOX_SIZE=9 here (9 max.)
;           12         1            LEAD_IN=2, LEAD_OUT=1 here
;       1   ..000000000.    1   MSB
;       2   ..000000000.    2    |
;       3   ..000000000.    3    |
;       4 vv..000000000.vv  4    |  1st byte
;       5   ..000000000.         |
;       6   ..000010100.         |
;       7   ..000101010.         |
;       8   ..001000001.        LSB
;       9   ..010000000.        MSB
;      10   ..101010100.         |
;      11   ..101010000.         |
;      12   ..010000000.         |  2nd byte
;      13   ..010000000.         |
;      14   ..101010100.         |
;      15   ..101010000.         |
;      16   ..010000000.        LSB
;      17   ..001000001.        MSB
;      18   ..000101010.         |
;      19   ..000010100.         |
;      20 ^^..000000000.^^ 4     |
;      21   ..000000000.   3     |  3rd byte
;      22   ..000000000.   2     |
;      23   ..000000000.   1     |
;      24 __..000000000.__      LSB

        db      ESC_,'&',BUFFER_NO,EURO_CHR,EURO_CHR,2,9,1
                ; RAM data for Eurocurrency character (3*9 bytes)
        db      00h, 66h, 00h,  00h, 99h, 00h,  01h, 66h, 80h,  02h, 00h, 40h ; 1..4
        db      04h, 66h, 20h,  02h, 00h, 40h,  04h, 44h, 20h,  02h, 00h, 40h ; 5..8
        db      01h, 00h, 80h                                                 ; 9
        db      ESC_,'%',1              ; select RAM char set
        ;db     FS_,'X',BUFFER_NO

IF EURO_STYLE EQ 2
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65394,data65395,GRAPHICS,ID_16,seq65394 ; Euro in Draft 12 cpi
        db      FS_,'W',1               ; select 256 user definable chrs
                                        ; NB. The previous is probably not
                                        ; supported by P5XL, P9XL, P6/P7/
                                        ; CP6/CP7, P2200, P2plus, P20/P30,
                                        ; P22Q/P32Q.
        SelCP   GRAPHICS,ID_16          ; init sequence (again)
        db      ESC_,'%',0              ; select internal char set
        db      ESC_,'p',0              ; Proportional off
        db      ESC_,'x',0              ; select Draft
        db      ESC_,'5'                ; Italics off
        db      ESC_,'T'                ; super-/sub-script off
        db      DC2                     ; condensed script off
        ;db     ESC_,'!',0              ; deselect all (including condensed off)
        db      ESC_,'M'                ; select 12 cpi (Elite)
        db      FS_,'S',0               ; select DRAFT 12 (normal speed)
        db      ESC_,':',NUL,NUL,NUL    ; copy ROM into RAM buffer 1
;
;       Definition of the Eurocurrency symbol for Draft 12 cpi (Elite):
;
;           123456789012345        LEAD_IN+BOX_SIZE+LEAD_OUT=15 (!)
;              123456789           BOX_SIZE=9 here (9 max.)
;           123         123        LEAD_IN=3, LEAD_OUT=3 here
;       1   ...000000000...    1   MSB
;       2   ...000000000...    2    |
;       3   ...000000000...    3    |
;       4 vv...000000000...vv  4    |  1st byte
;       5   ...000000000...         |
;       6   ...000010100...         |
;       7   ...000101010...         |
;       8   ...001000001...        LSB
;       9   ...010000000...        MSB
;      10   ...101010100...         |
;      11   ...101010000...         |
;      12   ...010000000...         |  2nd byte
;      13   ...010000000...         |
;      14   ...101010100...         |
;      15   ...101010000...         |
;      16   ...010000000...        LSB
;      17   ...001000001...        MSB
;      18   ...000101010...         |
;      19   ...000010100...         |
;      20 ^^...000000000...^^ 4     |
;      21   ...000000000...   3     |  3rd byte
;      22   ...000000000...   2     |
;      23   ...000000000...   1     |
;      24 __...000000000...__      LSB

        db      ESC_,'&',BUFFER_NO,EURO_CHR,EURO_CHR,3,9,3
                ; RAM data for Eurocurrency character (3*9 bytes)
        db      00h, 66h, 00h,  00h, 99h, 00h,  01h, 66h, 80h,  02h, 00h, 40h ; 1..4
        db      04h, 66h, 20h,  02h, 00h, 40h,  04h, 44h, 20h,  02h, 00h, 40h ; 5..8
        db      01h, 00h, 80h                                                 ; 9
        db      ESC_,'%',1              ; select RAM char set
        ;db     FS_,'X',BUFFER_NO

IF EURO_STYLE EQ 3
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65395,data65396,GRAPHICS,ID_16,seq65395 ; Euro in Draft HS 12 cpi
        db      FS_,'W',1               ; select 256 user definable chrs
                                        ; NB. The previous is probably not
                                        ; supported by P5XL, P9XL, P6/P7/
                                        ; CP6/CP7, P2200, P2plus, P20/P30,
                                        ; P22Q/P32Q.
        SelCP   GRAPHICS,ID_16          ; init sequence (again)
        db      ESC_,'%',0              ; select internal char set
        db      ESC_,'p',0              ; Proportional off
        db      ESC_,'x',0              ; select Draft
        db      ESC_,'5'                ; Italics off
        db      ESC_,'T'                ; super-/sub-script off
        db      DC2                     ; condensed script off
        ;db     ESC_,'!',0              ; deselect all (including condensed off)
        db      ESC_,'M'                ; select 12 cpi (Elite)
        db      FS_,'S',1               ; select HS 12
        db      ESC_,':',NUL,NUL,NUL    ; copy ROM into RAM buffer 1
;
;       Definition of the Eurocurrency symbol for Draft HS 12 cpi (Elite):
;
;           12345678901       LEAD_IN+BOX_SIZE+LEAD_OUT=10 (!)
;            123456789        BOX_SIZE=9 here (9 max.)
;           1                 LEAD_IN=1, LEAD_OUT=0 here
;       1   .000000000    1   MSB
;       2   .000000000    2    |
;       3   .000000000    3    |
;       4 vv.000000000vv  4    |  1st byte
;       5   .000000000         |
;       6   .000010100         |
;       7   .000101010         |
;       8   .001000001        LSB
;       9   .010000000        MSB
;      10   .101010100         |
;      11   .101010000         |
;      12   .010000000         |  2nd byte
;      13   .010000000         |
;      14   .101010100         |
;      15   .101010000         |
;      16   .010000000        LSB
;      17   .001000001        MSB
;      18   .000101010         |
;      19   .000010100         |
;      20 ^^.000000000^^ 4     |
;      21   .000000000   3     |  3rd byte
;      22   .000000000   2     |
;      23   .000000000   1     |
;      24 __.000000000__      LSB

        db      ESC_,'&',BUFFER_NO,EURO_CHR,EURO_CHR,1,9,0
                ; RAM data for Eurocurrency character (3*9 bytes)
        db      00h, 66h, 00h,  00h, 99h, 00h,  01h, 66h, 80h,  02h, 00h, 40h ; 1..4
        db      04h, 66h, 20h,  02h, 00h, 40h,  04h, 44h, 20h,  02h, 00h, 40h ; 5..8
        db      01h, 00h, 80h                                                 ; 9
        db      ESC_,'%',1              ; select RAM char set
        ;db     FS_,'X',BUFFER_NO

IF EURO_STYLE EQ 4
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65396,data65397,GRAPHICS,ID_16,seq65396 ; Euro in Draft 15 cpi
        db      FS_,'W',1               ; select 256 user definable chrs
                                        ; NB. The previous is probably not
                                        ; supported by P5XL, P9XL, P6/P7/
                                        ; CP6/CP7, P2200, P2plus, P20/P30,
                                        ; P22Q/P32Q.
        SelCP   GRAPHICS,ID_16          ; init sequence (again)
        db      ESC_,'%',0              ; select internal char set
        db      ESC_,'p',0              ; Proportional off
        db      ESC_,'x',0              ; select Draft
        db      ESC_,'5'                ; Italics off
        db      ESC_,'T'                ; super-/sub-script off
        db      DC2                     ; condensed script off
                                        ; NB. 15 cpi consensed results in the
                                        ; same resolution as 12 cpi condensed,
                                        ; that is 20 cpi. However, there's some
                                        ; fuzz with the spacing of RAM chars,
                                        ; hence we force condensed scripting to
                                        ; be off.
        ;db     ESC_,'!',0              ; deselect all (including condensed off)
        db      ESC_,'g'                ; select 15 cpi (Micro)

        db      ESC_,':',NUL,NUL,NUL    ; copy ROM into RAM buffer 1
;
;       Definition of the Eurocurrency symbol for Draft 15 cpi (Micro):
;
;           1234567890123456              LEAD_IN+BOX_SIZE+LEAD_OUT=16 (!)
;               123456789                 BOX_SIZE=9 here (9 max.)
;           1234         123              LEAD_IN=4, LEAD_OUT=3 here
;       1   ....000000000...    1   MSB
;       2   ....000000000...    2    |
;       3   ....000000000...    3    |
;       4 vv....000000000...vv  4    |  1st byte
;       5   ....000000000...         |
;       6   ....000010100...         |
;       7   ....000101010...         |
;       8   ....001000001...        LSB
;       9   ....010000000...        MSB
;      10   ....101010100...         |
;      11   ....101010000...         |
;      12   ....010000000...         |  2nd byte
;      13   ....010000000...         |
;      14   ....101010100...         |
;      15   ....101010000...         |
;      16   ....010000000...        LSB
;      17   ....001000001...        MSB
;      18   ....000101010...         |
;      19   ....000010100...         |
;      20 ^^....000000000...^^ 4     |
;      21   ....000000000...   3     |  3rd byte
;      22   ....000000000...   2     |
;      23   ....000000000...   1     |
;      24 __....000000000...__      LSB

        db      ESC_,'&',BUFFER_NO,EURO_CHR,EURO_CHR,4,9,3
                ; RAM data for Eurocurrency character (3*9 bytes)
        db      00h, 66h, 00h,  00h, 99h, 00h,  01h, 66h, 80h,  02h, 00h, 40h ; 1..4
        db      04h, 66h, 20h,  02h, 00h, 40h,  04h, 44h, 20h,  02h, 00h, 40h ; 5..8
        db      01h, 00h, 80h                                                 ; 9
        db      ESC_,'%',1              ; select RAM char set
        ;db     FS_,'X',BUFFER_NO

IF EURO_STYLE EQ 5
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65397,data65398,GRAPHICS,ID_16,seq65397 ; Euro in Draft 17 cpi
        db      FS_,'W',1               ; select 256 user definable chrs
                                        ; NB. The previous is probably not
                                        ; supported by P5XL, P9XL, P6/P7/
                                        ; CP6/CP7, P2200, P2plus, P20/P30,
                                        ; P22Q/P32Q.
        SelCP   GRAPHICS,ID_16          ; init sequence (again)
        db      ESC_,'%',0              ; select internal char set
        db      ESC_,'p',0              ; Proportional off
        db      ESC_,'x',0              ; select Draft
        db      ESC_,'5'                ; Italics off
        db      ESC_,'T'                ; super-/sub-script off
        db      ESC_,'P'                ; select 10 cpi (Pica)
        db      SI_                     ; condensed script on -> 17 cpi
        ;db     ESC_,'!',4              ; select 10 cpi and condensed
        db      ESC_,':',NUL,NUL,NUL    ; copy ROM into RAM buffer 1
;
;       Definition of the Eurocurrency symbol for Draft 17 cpi (Pica+Condensed):
;
;           12345678901234        LEAD_IN+BOX_SIZE+LEAD_OUT=14 (!)
;              123456789          BOX_SIZE=9 here (9 max.)
;           123         12        LEAD_IN=3, LEAD_OUT=2 here
;       1   ...000000000..    1   MSB
;       2   ...000000000..    2    |
;       3   ...000000000..    3    |
;       4 vv...000000000..vv  4    |  1st byte
;       5   ...000000000..         |
;       6   ...000010100..         |
;       7   ...000101010..         |
;       8   ...001000001..        LSB
;       9   ...010000000..        MSB
;      10   ...101010100..         |
;      11   ...101010000..         |
;      12   ...010000000..         |  2nd byte
;      13   ...010000000..         |
;      14   ...101010100..         |
;      15   ...101010000..         |
;      16   ...010000000..        LSB
;      17   ...001000001..        MSB
;      18   ...000101010..         |
;      19   ...000010100..         |
;      20 ^^...000000000..^^ 4     |
;      21   ...000000000..   3     |  3rd byte
;      22   ...000000000..   2     |
;      23   ...000000000..   1     |
;      24 __...000000000..__      LSB

        db      ESC_,'&',BUFFER_NO,EURO_CHR,EURO_CHR,3,9,2
                ; RAM data for Eurocurrency character (3*9 bytes)
        db      00h, 66h, 00h,  00h, 99h, 00h,  01h, 66h, 80h,  02h, 00h, 40h ; 1..4
        db      04h, 66h, 20h,  02h, 00h, 40h,  04h, 44h, 20h,  02h, 00h, 40h ; 5..8
        db      01h, 00h, 80h                                                 ; 9
        db      ESC_,'%',1              ; select RAM char set
        ;db     FS_,'X',BUFFER_NO

IF EURO_STYLE EQ 6
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65398,data65401,GRAPHICS,ID_16,seq65398 ; Euro in Draft 20 cpi
        db      FS_,'W',1               ; select 256 user definable chrs
                                        ; NB. The previous is probably not
                                        ; supported by P5XL, P9XL, P6/P7/
                                        ; CP6/CP7, P2200, P2plus, P20/P30,
                                        ; P22Q/P32Q.
        SelCP   GRAPHICS,ID_16          ; init sequence (again)
        db      ESC_,'%',0              ; select internal char set
        db      ESC_,'p',0              ; Proportional off
        db      ESC_,'x',0              ; select Draft
        db      ESC_,'5'                ; Italics off
        db      ESC_,'T'                ; super-/sub-script off
        db      ESC_,'M'                ; select 12 cpi (Elite)
        ;db     FS_,'S',0               ; select DRAFT 12 (normal speed)
        db      SI_                     ; condensed script on -> 20 cpi
        ;db     ESC_,'!',5              ; select 12 cpi and condensed
        db      ESC_,':',NUL,NUL,NUL    ; copy ROM into RAM buffer 1
;
;       Definition of the Eurocurrency symbol for Draft 20 cpi (Elite+Condensed):
;
;           123456789012            LEAD_IN+BOX_SIZE+LEAD_OUT=12 (!)
;             123456789             BOX_SIZE=9 here (9 max.)
;           12         1            LEAD_IN=2, LEAD_OUT=1 here
;       1   ..000000000.    1   MSB
;       2   ..000000000.    2    |
;       3   ..000000000.    3    |
;       4 vv..000000000.vv  4    |  1st byte
;       5   ..000000000.         |
;       6   ..000010100.         |
;       7   ..000101010.         |
;       8   ..001000001.        LSB
;       9   ..010000000.        MSB
;      10   ..101010100.         |
;      11   ..101010000.         |
;      12   ..010000000.         |  2nd byte
;      13   ..010000000.         |
;      14   ..101010100.         |
;      15   ..101010000.         |
;      16   ..010000000.        LSB
;      17   ..001000001.        MSB
;      18   ..000101010.         |
;      19   ..000010100.         |
;      20 ^^..000000000.^^ 4     |
;      21   ..000000000.   3     |  3rd byte
;      22   ..000000000.   2     |
;      23   ..000000000.   1     |
;      24 __..000000000.__      LSB

        db      ESC_,'&',BUFFER_NO,EURO_CHR,EURO_CHR,2,9,1
                ; RAM data for Eurocurrency character (3*9 bytes)
        db      00h, 66h, 00h,  00h, 99h, 00h,  01h, 66h, 80h,  02h, 00h, 40h ; 1..4
        db      04h, 66h, 20h,  02h, 00h, 40h,  04h, 44h, 20h,  02h, 00h, 40h ; 5..8
        db      01h, 00h, 80h                                                 ; 9
        db      ESC_,'%',1              ; select RAM char set
        ;db     FS_,'X',BUFFER_NO

IF EURO_STYLE EQ 9
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65401,data65402,GRAPHICS,ID_16,seq65401 ; Euro in LQ 10 cpi
        db      FS_,'W',1               ; select 256 user definable chrs
                                        ; NB. The previous is probably not
                                        ; supported by P5XL, P9XL, P6/P7/
                                        ; CP6/CP7, P2200, P2plus, P20/P30,
                                        ; P22Q/P32Q.
        SelCP   GRAPHICS,ID_16          ; init sequence (again)
        db      ESC_,'%',0              ; select internal char set
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'5'                ; Italics off
        db      ESC_,'T'                ; super-/sub-script off
        ;db     ESC_,'p',0              ; Proportional off
        db      DC2                     ; condensed script off
        ;db     ESC_,'!',0              ; deselect all (including condensed off)
        db      ESC_,'P'                ; select 10 cpi (Pica)
        db      ESC_,':',NUL,NUL,NUL    ; copy ROM into RAM buffer 1

;       Definition of the Eurocurrency symbol for LQ 10 cpi (Pica):
;
;           123456789012345678901234567890123456    LEAD_IN+BOX_SIZE+LEAD_OUT=36 (!)
;               1234567890123456789012345678        BOX_SIZE=28 here (29 max.)
;           1234                            1234    LEAD_IN=4, LEAD_OUT=4 here
;       1   ....0000000000000000000000000000....    1   MSB
;       2   ....0000000000000000000000000000....    2    |
;       3   ....0000000000000000000000000000....    3    |
;       4 vv....0000000000000000000000000000....vv  4    |  1st byte
;       5   ....0000000000000000000000000000....         |
;       6   ....0000000000001010101010000000....         |
;       7   ....0000000001010101010101010000....         |
;       8   ....0000000101000000000000010100....        LSB
;       9   ....0000010100000000000000000101....        MSB
;      10   ....1010101010101010101000000000....         |
;      11   ....0101010101010101000000000000....         |
;      12   ....0001010000000000000000000000....         |  2nd byte
;      13   ....0001010000000000000000000000....         |
;      14   ....1010101010101010100000000000....         |
;      15   ....0101010101010100000000000000....         |
;      16   ....0000010100000000000000000101....        LSB
;      17   ....0000000101000000000000010100....        MSB
;      18   ....0000000001010101010101010000....         |
;      19   ....0000000000001010101010000000....         |
;      20 ^^....0000000000000000000000000000....^^ 4     |
;      21   ....0000000000000000000000000000....   3     |  3rd byte
;      22   ....0000000000000000000000000000....   2     |
;      23   ....0000000000000000000000000000....   1     |
;      24 __....0000000000000000000000000000....__      LSB

        db      ESC_,'&',BUFFER_NO,EURO_CHR,EURO_CHR,4,28,4
                ; RAM data for Eurocurrency character (3*28 bytes)
        db      00h, 44h, 00h,  00h, 22h, 00h,  00h, 44h, 00h,  00h, 3Ah, 00h  ;  1.. 4
        db      00h, 44h, 00h,  00h,0BBh, 00h,  00h, 44h, 00h,  01h,0A3h, 80h  ;  5.. 8
        db      00h, 44h, 00h,  03h, 22h,0C0h,  00h, 44h, 00h,  02h, 22h, 40h  ;  9..12
        db      04h, 44h, 20h,  02h, 22h, 40h,  04h, 44h, 20h,  02h, 20h, 40h  ; 13..16
        db      04h, 44h, 20h,  02h, 00h, 40h,  04h, 40h, 20h,  02h, 00h, 40h  ; 17..20
        db      04h, 00h, 20h,  02h, 00h, 40h,  00h, 00h, 00h,  03h, 00h,0C0h  ; 21..24
        db      00h, 00h, 00h,  01h, 81h, 80h,  00h, 00h, 00h,  00h, 81h, 00h  ; 25..28
        db      ESC_,'%',1              ; select RAM char set
        ;db     FS_,'X',BUFFER_NO

IF EURO_STYLE EQ 10
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65402,data65403,GRAPHICS,ID_16,seq65402 ; Euro in LQ 12 cpi
        db      FS_,'W',1               ; select 256 user definable chrs
                                        ; NB. The previous is probably not
                                        ; supported by P5XL, P9XL, P6/P7/
                                        ; CP6/CP7, P2200, P2plus, P20/P30,
                                        ; P22Q/P32Q.
        SelCP   GRAPHICS,ID_16          ; init sequence (again)
        db      ESC_,'%',0              ; select internal char set
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'5'                ; Italics off
        db      ESC_,'T'                ; super-/sub-script off
        ;db     ESC_,'p',0              ; Proportional off
        db      DC2                     ; condensed script off
        ;db     ESC_,'!',0              ; deselect all (including condensed off)
        ;db     FS_,'S',0               ; (select normal 12)
        db      ESC_,'M'                ; select 12 cpi (Elite)
        db      ESC_,':',NUL,NUL,NUL    ; copy ROM into RAM buffer 1
;
;       Definition of the Eurocurrency symbol for LQ 12 cpi (Elite):
;
;           123456789012345678901234567890    LEAD_IN+BOX_SIZE+LEAD_OUT=30 (!)
;               1234567890123456789012        BOX_SIZE=22 here (23 max.)
;           1234                      1234    LEAD_IN=4, LEAD_OUT=4 here
;       1   ....0000000000000000000000....    1   MSB
;       2   ....0000000000000000000000....    2    |
;       3   ....0000000000000000000000....    3    |
;       4 vv....0000000000000000000000....vv  4    |  1st byte
;       5   ....0000000000000000000000....         |
;       6   ....0000000000101010000000....         |
;       7   ....0000000101010101010000....         |
;       8   ....0000010100000000010100....        LSB
;       9   ....0000101000000000000101....        MSB
;      10   ....1010101010101010000000....         |
;      11   ....0101010101010000000000....         |
;      12   ....0010100000000000000000....         |  2nd byte
;      13   ....0010100000000000000000....         |
;      14   ....1010101010101000000000....         |
;      15   ....0101010101000000000000....         |
;      16   ....0000101000000000000101....        LSB
;      17   ....0000010100000000010100....        MSB
;      18   ....0000000101010101010000....         |
;      19   ....0000000000101010000000....         |
;      20 ^^....0000000000000000000000....^^ 4     |
;      21   ....0000000000000000000000....   3     |  3rd byte
;      22   ....0000000000000000000000....   2     |
;      23   ....0000000000000000000000....   1     |
;      24 __....0000000000000000000000....__      LSB

        db      ESC_,'&',BUFFER_NO,EURO_CHR,EURO_CHR,4,22,4;
                ; RAM data for Eurocurrency character (3*22 bytes)
        db      00h, 44h, 00h,  00h, 22h, 00h,  00h, 5Ch, 00h,  00h, 22h, 00h ; 1..4
        db      00h,0DDh, 00h,  01h, 22h, 80h,  00h,0C5h, 00h,  03h, 22h,0C0h ; 5..8
        db      00h, 44h, 00h,  02h, 22h, 40h,  04h, 44h, 20h,  02h, 20h, 40h ; 9..12
        db      04h, 44h, 20h,  02h, 00h, 40h,  04h, 40h, 20h,  02h, 00h, 40h ; 13..16
        db      00h, 00h, 00h,  03h, 00h,0C0h,  00h, 00h, 00h,  01h, 81h, 80h ; 17..20
        db      00h, 00h, 00h,  00h, 81h, 00h                                 ; 21..22
        db      ESC_,'%',1              ; select RAM char set
        ;db     FS_,'X',BUFFER_NO

IF EURO_STYLE EQ 11
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65403,data65404,GRAPHICS,ID_16,seq65403 ; Euro in LQ 15 cpi
        db      FS_,'W',1               ; select 256 user definable chrs
                                        ; NB. The previous is probably not
                                        ; supported by P5XL, P9XL, P6/P7/
                                        ; CP6/CP7, P2200, P2plus, P20/P30,
                                        ; P22Q/P32Q.
        SelCP   GRAPHICS,ID_16          ; init sequence (again)
        db      ESC_,'%',0              ; select internal char set
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'5'                ; Italics off
        db      ESC_,'T'                ; super-/sub-script off
        ;db     ESC_,'p',0              ; Proportional off
        db      DC2                     ; condensed script off
                                        ; NB. 15 cpi consensed results in the
                                        ; same resolution as 12 cpi condensed,
                                        ; that is 20 cpi. However, there's some
                                        ; fuzz with the spacing of RAM chars,
                                        ; hence we force condensed scripting to
                                        ; be off.
        ;db     ESC_,'!',0              ; deselect all (including condensed off)
        db      ESC_,'g'                ; select 15 cpi (Micro)
        db      ESC_,':',NUL,NUL,NUL    ; copy ROM into RAM buffer 1
;
;       Definition of the Eurocurrency symbol for LQ 15 cpi (Micro):
;
;           123456789012345678901234    LEAD_IN+BOX_SIZE+LEAD_OUT=24 (!)
;            1234567890123456789012     BOX_SIZE=22 here
;           1                      1    LEAD_IN=1, LEAD_OUT=1 here
;       1   .0000000000000000000000.    1   MSB
;       2   .0000000000000000000000.    2    |
;       3   .0000000000000000000000.    3    |
;       4 vv.0000000000000000000000.vv  4    |  1st byte
;       5   .0000000000000000000000.         |
;       6   .0000000000101010000000.         |
;       7   .0000000101010101010000.         |
;       8   .0000010100000000010100.        LSB
;       9   .0000101000000000000101.        MSB
;      10   .1010101010101010000000.         |
;      11   .0101010101010000000000.         |
;      12   .0010100000000000000000.         |  2nd byte
;      13   .0010100000000000000000.         |
;      14   .1010101010101000000000.         |
;      15   .0101010101000000000000.         |
;      16   .0000101000000000000101.        LSB
;      17   .0000010100000000010100.        MSB
;      18   .0000000101010101010000.         |
;      19   .0000000000101010000000.         |
;      20 ^^.0000000000000000000000.^^ 4     |
;      21   .0000000000000000000000.   3     |  3rd byte
;      22   .0000000000000000000000.   2     |
;      23   .0000000000000000000000.   1     |
;      24 __.0000000000000000000000.__      LSB

        db      ESC_,'&',BUFFER_NO,EURO_CHR,EURO_CHR,1,22,1;
                ; RAM data for Eurocurrency character (3*22 bytes)
        db      00h, 44h, 00h,  00h, 22h, 00h,  00h, 5Ch, 00h,  00h, 22h, 00h ; 1..4
        db      00h,0DDh, 00h,  01h, 22h, 80h,  00h,0C5h, 00h,  03h, 22h,0C0h ; 5..8
        db      00h, 44h, 00h,  02h, 22h, 40h,  04h, 44h, 20h,  02h, 20h, 40h ; 9..12
        db      04h, 44h, 20h,  02h, 00h, 40h,  04h, 40h, 20h,  02h, 00h, 40h ; 13..16
        db      00h, 00h, 00h,  03h, 00h,0C0h,  00h, 00h, 00h,  01h, 81h, 80h ; 17..20
        db      00h, 00h, 00h,  00h, 81h, 00h                                 ; 21..22
        db      ESC_,'%',1              ; select RAM char set
        ;db     FS_,'X',BUFFER_NO

IF EURO_STYLE EQ 12
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65404,data65405,GRAPHICS,ID_16,seq65404 ; Euro in LQ 17 cpi
        db      FS_,'W',1               ; select 256 user definable chrs
                                        ; NB. The previous is probably not
                                        ; supported by P5XL, P9XL, P6/P7/
                                        ; CP6/CP7, P2200, P2plus, P20/P30,
                                        ; P22Q/P32Q.
        SelCP   GRAPHICS,ID_16          ; init sequence (again)
        db      ESC_,'%',0              ; select internal char set
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'5'                ; Italics off
        db      ESC_,'T'                ; super-/sub-script off
        ;db     ESC_,'p',0              ; Proportional off
        db      ESC_,'P'                ; select 10 cpi (Pica)
        db      SI_                     ; condensed script on -> 17 cpi
        ;db     ESC_,'!',4              ; select 10 cpi + condensed
        db      ESC_,':',NUL,NUL,NUL    ; copy ROM into RAM buffer 1

;       Definition of the Eurocurrency symbol for LQ 17 cpi (Pica+Condensed):
;
;           123456789012345678901234567890123456    LEAD_IN+BOX_SIZE+LEAD_OUT=36 (!)
;               1234567890123456789012345678        BOX_SIZE=28 here (29 max.)
;           1234                            1234    LEAD_IN=4, LEAD_OUT=4 here
;       1   ....0000000000000000000000000000....    1   MSB
;       2   ....0000000000000000000000000000....    2    |
;       3   ....0000000000000000000000000000....    3    |
;       4 vv....0000000000000000000000000000....vv  4    |  1st byte
;       5   ....0000000000000000000000000000....         |
;       6   ....0000000000001010101010000000....         |
;       7   ....0000000001010101010101010000....         |
;       8   ....0000000101000000000000010100....        LSB
;       9   ....0000010100000000000000000101....        MSB
;      10   ....1010101010101010101000000000....         |
;      11   ....0101010101010101000000000000....         |
;      12   ....0001010000000000000000000000....         |  2nd byte
;      13   ....0001010000000000000000000000....         |
;      14   ....1010101010101010100000000000....         |
;      15   ....0101010101010100000000000000....         |
;      16   ....0000010100000000000000000101....        LSB
;      17   ....0000000101000000000000010100....        MSB
;      18   ....0000000001010101010101010000....         |
;      19   ....0000000000001010101010000000....         |
;      20 ^^....0000000000000000000000000000....^^ 4     |
;      21   ....0000000000000000000000000000....   3     |  3rd byte
;      22   ....0000000000000000000000000000....   2     |
;      23   ....0000000000000000000000000000....   1     |
;      24 __....0000000000000000000000000000....__      LSB

        db      ESC_,'&',BUFFER_NO,EURO_CHR,EURO_CHR,4,28,4
                ; RAM data for Eurocurrency character (3*28 bytes)
        db      00h, 44h, 00h,  00h, 22h, 00h,  00h, 44h, 00h,  00h, 3Ah, 00h  ;  1.. 4
        db      00h, 44h, 00h,  00h,0BBh, 00h,  00h, 44h, 00h,  01h,0A3h, 80h  ;  5.. 8
        db      00h, 44h, 00h,  03h, 22h,0C0h,  00h, 44h, 00h,  02h, 22h, 40h  ;  9..12
        db      04h, 44h, 20h,  02h, 22h, 40h,  04h, 44h, 20h,  02h, 20h, 40h  ; 13..16
        db      04h, 44h, 20h,  02h, 00h, 40h,  04h, 40h, 20h,  02h, 00h, 40h  ; 17..20
        db      04h, 00h, 20h,  02h, 00h, 40h,  00h, 00h, 00h,  03h, 00h,0C0h  ; 21..24
        db      00h, 00h, 00h,  01h, 81h, 80h,  00h, 00h, 00h,  00h, 81h, 00h  ; 25..28
        db      ESC_,'%',1              ; select RAM char set
        ;db     FS_,'X',BUFFER_NO

IF EURO_STYLE EQ 13
data8501:       ; Multilingual, Latin I with Eurocurrency
data58194:      ; alternative code in the user definable CCSID range
ENDIF
        CPData  data65405,data65408,GRAPHICS,ID_16,seq65405 ; Euro in LQ 20 cpi
        db      FS_,'W',1               ; select 256 user definable chrs
                                        ; NB. The previous is probably not
                                        ; supported by P5XL, P9XL, P6/P7/
                                        ; CP6/CP7, P2200, P2plus, P20/P30,
                                        ; P22Q/P32Q.
        SelCP   GRAPHICS,ID_16          ; init sequence (again)
        db      ESC_,'%',0              ; select internal char set
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'5'                ; Italics off
        db      ESC_,'T'                ; super-/sub-script off
        ;db     ESC_,'p',0              ; Proportional off
        db      ESC_,'M'                ; select 12 cpi (Elite)
        db      SI_                     ; condensed script on -> 20 cpi
        ;db     ESC_,'!',5              ; select 12 cpi + condensed
        db      ESC_,':',NUL,NUL,NUL    ; copy ROM into RAM buffer 1
;
;       Definition of the Eurocurrency symbol for LQ 20 cpi (Elite+Condensed):
;
;           123456789012345678901234567890    LEAD_IN+BOX_SIZE+LEAD_OUT=30 (!)
;               1234567890123456789012        BOX_SIZE=22 here (23 max.)
;           1234                      1234    LEAD_IN=4, LEAD_OUT=4 here
;       1   ....0000000000000000000000....    1   MSB
;       2   ....0000000000000000000000....    2    |
;       3   ....0000000000000000000000....    3    |
;       4 vv....0000000000000000000000....vv  4    |  1st byte
;       5   ....0000000000000000000000....         |
;       6   ....0000000000101010000000....         |
;       7   ....0000000101010101010000....         |
;       8   ....0000010100000000010100....        LSB
;       9   ....0000101000000000000101....        MSB
;      10   ....1010101010101010000000....         |
;      11   ....0101010101010000000000....         |
;      12   ....0010100000000000000000....         |  2nd byte
;      13   ....0010100000000000000000....         |
;      14   ....1010101010101000000000....         |
;      15   ....0101010101000000000000....         |
;      16   ....0000101000000000000101....        LSB
;      17   ....0000010100000000010100....        MSB
;      18   ....0000000101010101010000....         |
;      19   ....0000000000101010000000....         |
;      20 ^^....0000000000000000000000....^^ 4     |
;      21   ....0000000000000000000000....   3     |  3rd byte
;      22   ....0000000000000000000000....   2     |
;      23   ....0000000000000000000000....   1     |
;      24 __....0000000000000000000000....__      LSB

        db      ESC_,'&',BUFFER_NO,EURO_CHR,EURO_CHR,4,22,4;
                ; RAM data for Eurocurrency character (3*22 bytes)
        db      00h, 44h, 00h,  00h, 22h, 00h,  00h, 5Ch, 00h,  00h, 22h, 00h ; 1..4
        db      00h,0DDh, 00h,  01h, 22h, 80h,  00h,0C5h, 00h,  03h, 22h,0C0h ; 5..8
        db      00h, 44h, 00h,  02h, 22h, 40h,  04h, 44h, 20h,  02h, 20h, 40h ; 9..12
        db      04h, 44h, 20h,  02h, 00h, 40h,  04h, 40h, 20h,  02h, 00h, 40h ; 13..16
        db      00h, 00h, 00h,  03h, 00h,0C0h,  00h, 00h, 00h,  01h, 81h, 80h ; 17..20
        db      00h, 00h, 00h,  00h, 81h, 00h                                 ; 21..22
        db      ESC_,'%',1              ; select RAM char set
        ;db     FS_,'X',BUFFER_NO

        CPData  data65408,data65409,GRAPHICS,ID_0,seq65408  ; Download
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'%',1              ; select (last) download char set

        CPData  data65409,data65410,GRAPHICS,ID_0,seq65409  ; Download 1
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'%',1              ; select download char set
        db      FS_,'X',0               ; select download char set 1
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7, P2200,
                                        ; P2plus, P20/P30, P22Q/P32Q.

        CPData  data65410,data65424,GRAPHICS,ID_0,seq65410  ; Download 2
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'%',1              ; select download char set
        ;db     FS_,'W',0               ; select 2*128 instead of 1*256
        db      FS_,'X',1               ; select download char set 2
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7, P2200,
                                        ; P2plus, P20/P30, P22Q/P32Q.

        CPData  data65424,data65425,GRAPHICS,ID_0,seq65424  ; Internal fonts
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.

        CPData  data65425,data65426,GRAPHICS,ID_0,seq65425  ; Cardridge font 1
        db      FS_,'C',1               ; select external font 1
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.

        CPData  data65426,data65427,GRAPHICS,ID_0,seq65426  ; Cardridge font 2
        db      FS_,'C',2               ; select external font 2
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.

        CPData  data65427,data65428,GRAPHICS,ID_0,seq65427  ; Cardridge font 3
        db      FS_,'C',3               ; select external font 3
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.

        CPData  data65428,data65440,GRAPHICS,ID_0,seq65428  ; Cardridge font 4
        db      FS_,'C',4               ; select external font 4
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.

        CPData  data65440,data65446,GRAPHICS,ID_0,seq65440 ; Internal font 0
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_COURIER_10  ; select "Courier 10"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.

        CPData  data65446,data65452,GRAPHICS,ID_0,seq65446 ; Internal font 6
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_SUPERFOCUS  ; select "Super Focus"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.

        CPData  data65452,data65455,GRAPHICS,ID_0,seq65452 ; Internal font 12
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_OCR_B       ; select "OCR-B"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.

        CPData  data65455,data65456,GRAPHICS,ID_0,seq65455 ; Internal font 15
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_ITCSOUVENIER_10; select "ITC Souvenir 10"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.

        CPData  data65456,data65458,GRAPHICS,ID_0,seq65456 ; Internal font 16
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_HELVETTE_10PT; select "Helvette 10 PT"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.
        ;db     ESC_,'p',1              ; Proportional on

        CPData  data65458,data65459,GRAPHICS,ID_0,seq65458 ; Internal font 18
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_TIMES_10PT  ; select "Times 10 PT"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.
        ;db     ESC_,'p',1              ; Proportional on

        CPData  data65459,data65474,GRAPHICS,ID_0,seq65459 ; Internal font 19
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_NEWPRESTIGEELITE_12WP; select "New Prestige Elite 12 WP"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.
        ;db     ESC_,'p',1              ; Proportional on

        CPData  data65474,data65490,GRAPHICS,ID_0,seq65474 ; Internal font 34
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_BOLD_PS     ; select "Bold PS"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.

        CPData  data65490,data65491,GRAPHICS,ID_0,seq65490 ; Internal font 50
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_FASTFOCUS_10; select "Fast Focus 10"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.

        CPData  data65491,data65492,GRAPHICS,ID_0,seq65491 ; Internal font 51
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_FASTFOCUS_12; select "Fast Focus 12"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.

        CPData  data65492,data65493,GRAPHICS,ID_0,seq65492 ; Internal font 52
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_QUICKGOTHIC_10; select "Quick Gothic 10"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.

        CPData  data65493,Footer,GRAPHICS,ID_0,seq65493 ; Internal font 53
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. The previous is not supported
                                        ; by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_QUICKGOTHIC_12; select "Quick Gothic 12"
                                        ; NB. The previous is not supported
                                        ; by P5XL, P9XL, P6/P7/CP6/CP7.

; #############################################################################

Footer:

db CR,LF
db "------------------------------------------------------------------------------",CR,LF
db "NECPINW.CPI VeRsIoN=", VERSION_MSG
db                 " (", DATE_MSG, ")                                             ",0,CR,LF
db "CoPyRiGhT=(C) 1996-2000 by Matthias Paul, Ubierstrasse 28, D-50321 Bruehl     ",0,CR,LF
db 'NaMe SeRvIcE=DOS codepage file (PRINTER.SYS "1050") for NEC Pinwriter series  ',0,CR,LF
db "LaNgUaGe=International (1)                                                    ",0,CR,LF
db "LiCeNsE=GNU General Public License 2 (or at your option any later version):   ",CR,LF
db "This is free software that comes with ABSOLUTELY NO WARRANTY. You are welcome ",CR,LF
db "to redistribute it under certain conditions. Refer to the GNU GPL license file",CR,LF
db "you should have received along with NECPINW.CPI.                              ",0,CR,LF
db "------------------------------------------------------------------------------",CR,LF
db "EMail: <Matthias.Paul@post.rwth-aachen.de>                                    ",CR,LF
db "Web: http://www.rhrz.uni-bonn.de/~uzs180/mpdokeng.html                        ",CR,LF
db "------------------------------------------------------------------------------",CR,LF
db "For compatibility reasons this printer codepage file pretends to be a codepage",CR,LF
db "file for the Epson FX850/FX1050 printers, while it actually supports the NEC  ",CR,LF
db "Pinwriter series by replacing the original 1050.CPI file shipping with DR DOS.",CR,LF
db "It is designed for use with PRINTER.SYS of DR DOS 6.0, (DR PalmDOS), DR DOS   ",CR,LF
db '"Panther" & "StarTrek", Novell DOS 7, Caldera OpenDOS 7.01, DR-OpenDOS 7.02,  ',CR,LF
db "and DR-DOS 7.02-7.05. You may need to patch the file for use with MS-DOS or   ",CR,LF
db "PC DOS or with older issues of DR DOS. NECPINW.CPI provides codepage switching",CR,LF
db "support for the IBM codepages 367 (7-bit ISO-646-US, ASCII), 437 (Standard,   ",CR,LF
db "Western Europe, IBM-2, PC-8, World Trade Set), 850 (Multilingual, Latin I),   ",CR,LF
db "860 (Portuguese), 863 (French Canadian), and 865 (Nordic, Norway II) with the ",CR,LF
db "NEC Pinwriters P5200/P5300 (P6plus/P7plus), P3200/P3300 (P20/P30), P6200/P6300",CR,LF
db "(P60/P70), P9300 (P90), P22Q/P32Q, P7200/P7300 (P62/P72), P3800/P3900         ",CR,LF
db "(P42Q/P52Q), P8000 (P72X), and other compatible models. Except for the        ",CR,LF
db "Pinwriters P5200/P5300 (P6plus/P7plus), these printers additionally support   ",CR,LF
db "codepages 667/991 (Polish, Mazovia), 852 (Slavic, Eastern Europe, Latin II),  ",CR,LF
db "855 (Cyrillic I), 866 (Russian, Cyrillic II), and 867 (Czech, Kamenicky)      ",CR,LF
db "if they have the appropriate font EPROM option installed. Printers configured ",CR,LF
db "to support a 256 char download font can also make use of codepage 8501/58194  ",CR,LF
db "(Multilingual with Eurocurrency) in LQ 10 cpi (Pica) mode. For a large set    ",CR,LF
db "of other available character sets please refer to the NECPINW documentation.  ",CR,LF
db "The Pinwriters P2200 and P2200XE (P2plus) do not support codepage switching,  ",CR,LF
db "they are supported for codepages 367 and 437 only. Pinwriters P2/P3/CP2/CP3,  ",CR,LF
db "P5/P5XL, P9XL, and P6/P7/CP6/CP7 are not supported.                           ",CR,LF
db "------------------------------------------------------------------------------",CR,LF
db "Installation (for country 49 (Germany), codepages 437 and 850, here):         ",CR,LF
db "                                                                              ",CR,LF
db "  CONFIG.SYS:                                                                 ",CR,LF
db "    COUNTRY=49,437,...\country.sys                                            ",CR,LF
db "    DEVICE|HIDEVICE|DEVICEHIGH=...\printer.sys prn=(1050,999,2)               ",CR,LF
db "                                                                              ",CR,LF
db "  AUTOEXEC.BAT:                                                               ",CR,LF
db "    MODE prn: CODEPAGE PREPARE=((437,850) ...\necpinw.cpi)                    ",CR,LF
db "    [LH] NLSFUNC ...\country.sys                                              ",CR,LF
db "    CHCP 437                                                                  ",CR,LF
db "    REM MODE prn: CODEPAGE SELECT=850                                         ",CR,LF
db "                                                                              ",CR,LF
db "Please refer to DOS user manuals (or my NWDOSTIP.TXT documentation - part of  ",CR,LF
db "my MPDOSTIP.ZIP tips & tricks collection) for more info on how to install     ",CR,LF
db "codepage support. Also, look out for CPI???.ZIP for my .CPI file decompiler.  ",CR,LF
db "------------------------------------------------------------------------------",CR,LF
db CtrlZ

; #############################################################################

Code Ends
END NECPINW_CPI

; End of file
