       PAGE    ,136; P COLUMNS=129 CODEPAGES=437,850,852,853,857,858,860,865
; #############################################################################
;
;    NECPINW V2.08 DOS .CPI Code Page file for NEC Pinwriter series printers
;
;    Copyright (C) 1996-2001 by Matthias Paul
;                               Ubierstrae 28
;                               D-50321 Brhl
;                               GERMANY
;
;    All rights reserved (except those detailed below).
;
;    Registered trademarks and tradenames mentioned inhere are owned
;    by their respective owners.
;
;    mailto:<Matthias.Paul@post.rwth-aachen.de>
;    mailto:<mrpaul@epost.de>
;    mailto:<mpaul@drdos.org>
;
;    Main distribution points (NECPI???.ZIP):
;
;    http://www.uni-bonn.de/~uzs180/mpdokeng.html
;    http://www.ibiblio.org/pub/micro/pc-stuff/freedos/files/util/print/cpi/
;    http://www.freedos.org/
;    http://mpaul.drdos.org/
;
;    Other distribution points (NECPINW.ZIP - not currently up to date):
;
;    ftp://ftp.rhrz.uni-bonn.de/pub/pc/dos/misc/
;    ftp://ftp.uni-stuttgart.de/pub/systems/msdos/util/printers/
;    http://www.leo.org/pub/comp/platforms/pc/msdos/utils/printutils/
;    ftp://ftp.leo.org/pub/comp/platforms/pc/msdos/utils/printutils/
;
;    Last edit: 2001-02-26 MPAUL
;
; #############################################################################
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program (see LICENSE.TXT, http://www.gnu.org,
;    or http://www.fsf.org/copyleft/gpl.htm); if not, write to the
;    Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
; #############################################################################
;
;    History log:
;    ============
;
;    NECPINW.ASM 2.08 2001-02-26 MPAUL
;    Updated compatibility info to reflect what is provided in the original
;    printer documentation of the full range of the NEC Pinwriter series.
;    (Thanks to Axel C. Frinke, Rsberg (Germany) for downloading most of
;    the missing .PDF files for me.)
;    Since it grew way too large, moved the specification and reference part
;    of the documentation, previously located in the NECPINW.ASM file header,
;    into a separate file named FILESPEC.TXT.
;    Modified the 2000-10-08 change in the SelCP macro, so that we use the
;    NEC specific "FS_,'I'" control sequence now (this is still supported by
;    the current generation of Pinwriters, the P2X and P72X).  Early NEC
;    Pinwriters such as the P5XL, P9XL, P6/P7, CP6/CP7 etc. did not support
;    the Epson compatible "ESC_,'t'" control sequence.
;    Added CP 1011 "ISO-7 Germany" as alias to CP 65282, because according
;    to NEC manuals their German 7-bit char set is compliant with the standard.
;
;    NECPINW.ASM 2.08 2001-02-06 MPAUL
;    According to NEC's PARAMENU/PINWR_SW utilities all printers with
;    optional EPROM support provide twelve EPROM selection IDs 26..31.
;    Hence added them as 65306..65311.
;
;    NECPINW.ASM 2.08 2001-01-19 MPAUL
;    Added support for IBM Code Page PC-858 (this is the new offical ID
;    for the traditional PC 850 Code Page variant with EURO SIGN at D5h).
;    This makes my previous proposals CP 8501/58194 obsolete, but as long
;    as they are not conflicting with something else, I still left them
;    in for backward compatibility.  They may vanish at any later stage
;    (EURO_8501 EQ 0).
;
;    NECPINW.ASM 2.08 2001-01-11 MPAUL
;    This file is not for Epson printers at all, but for troubleshooting
;    purposes I added some comments on Epson GQ/EPJ/EPL printers with
;    Epson FX/LQ emulation.  (Many thanks to Werner Blume, Bonn (Germany)
;    for donating an Epson EPL-4300 laser printer with complete manuals.)
;
;    NECPINW.ASM 2.08 2001-01-03 MPAUL
;    Updated copyright header.  Renamed some of the constants.
;
;    NECPINW.ASM 2.07 2000-12-13 MPAUL
;    Added the EURO SIGN to Code Page 857 at Code Point D5h to reflect the
;    IBM OS/2 Warp FixPak definition (at least since 1999-03-11).
;    Also, I made this Code Page available under CP 58201 in the IBM CDRA user
;    definable range.  Note, that the character set provided by NECPINW.CPI
;    still does not fully match the offical definition, but at least one
;    more (previously undefined) character (in the offical definition)
;    matches now... ;-)
;
;    NECPINW.ASM 2.06 2000-11-09 MPAUL
;    Added CP 895 as an alias to CP 867, since WordPerfect (for DOS), Arachne,
;    and KEYBCS use this ID for "Kamenicti", that is "Czech (Kamenicky)".
;    This is, however, conflictive with IBM CDRA level 2, which assigns this
;    ID to "CM/Group 2: 7-bit Latin SBCS: Japanese (EUC-JP JIS-Roman)"!
;
;    NECPINW.ASM 2.05 2000-11-06 MPAUL
;    Changes in EUROFONT.INC for 1.02.
;    Horizontal character box alignments for better look of the EURO SIGN
;    shape in expanded Draft modes.  No alignments were necessary for LQ
;    modes (tested with P5300 (P7plus) and P9300 (P90)).
;
;    NECPINW.ASM 2.04 2000-10-30 MPAUL
;    Cosmetics.
;
;    NECPINW.ASM 2.04 2000-10-25 MPAUL
;    Moved the EURO SIGN macros to separate EUROFONT.INC include
;    file to make exchange with other fonts easier.  For reference
;    and identification purposes this file also contains a number of
;    (printer and display) shapes *not* used by NECPINW.CPI.
;
;    NECPINW.ASM 2.04 2000-10-15 MPAUL
;    Added 'hidden' control sequences to make printing this file easier
;    (currently it has 129 columns maximum, so with 17 cpi this file
;    should be printable on any Pinwriter).
;
;    NECPINW.ASM 2.03 2000-10-13 MPAUL
;    Removed the SPACE padding in the footer because it saves ca. 1 Kb of
;    disk storage space and was not of much use, anyway.  PNW VERSION and
;    reports by my CPI.EXE will still display the info properly.
;
;    NECPINW.ASM 2.03 2000-10-10 MPAUL
;    Corrected some typos.
;    Added EURO_850 conditional to allow Code Page 850 to provide the
;    EURO SIGN as well.
;
;    NECPINW.ASM 2.02 2000-10-08 MPAUL
;    More cosmetical changes.
;    Added conditional define CPI_STYLE for use as EPS.CPI or 4201.CPI under
;    MS-DOS/PC DOS - still needs more work and is currently unfinished...
;    Moved EURO SIGN matrix definitions into macros.
;    Added Code Pages 58805, 59035, 59218, 59231, 59233, 59359 in the
;    IBM CDRA level 2 user definable range.  These are variants of traditional
;    Code Pages 437, 667, 850, 863, 865, and 991, but with the "French Franc"/
;    "Dutch Gulden" symbol at Code Point 9Fh replaced by the EURO SIGN.
;    This is just to provide some form of support to the FreeDOS EUROTSR
;    utility by Aitor Santamara Merino.
;    Fixed a bug visible with all the traditional Code Pages, where
;    NECPINW.CPI would not switch back to the internal character set
;    after a download font has been activated.  The change in the SelCP
;    macro required the removal of a NEC specific control sequence in there
;    (for size reasons).  This should not cause problems on old Pinwriters
;    which all seem to support the equivalent Epson control sequence as well.
;    Initial release for FreeDOS.
;
;    NECPINW.ASM 2.01 2000-09-29 MPAUL
;    Cosmetical changes.
;
;    NECPINW.ASM 2.00 2000-09-28 MPAUL
;    Almost complete rewrite to restructure the source.  Thereby introduction
;    of macros to ease future maintenance.
;    Removed my obsolete Code Page proposals 0 and 646.
;    Added Code Page 991 ("Mazovia") as alias to 667.  (Again, thanks to Michal
;    Tyc who pointed me to Marcin Gryszkalis' Polish text converter PLC.)
;    Added download Code Page 8501 ("Multilingual with EURO SIGN") as a
;    variant of Code Page 850 with the EURO SIGN at Code Point D5h.
;    This is compatible with PC DOS 7 / 2000 Code Page 850.  In lack of any
;    better assignment for this new variant by one of the "Big Players"
;    I propose to use ID 8501 for this Code Page, which is not currently
;    in use by IBM "Character Data Representation Architecture Reference
;    and Registry" (CDRA) level 2.
;    Added "private use" Code Pages 58194, 65280, 65281..65294, 65296..65299,
;    65300..65311, 65392..65398, 65401..65405, 65408..65410, 65424..65428,
;    65440, 65446, 65452, 65455, 65456, 65458, 65459, 65474, 65490, 65491,
;    65492, and 65493 in the CDRA user definable ranges for CCSIDs and CPGIDs.
;    These allow direct access to various char sets (without offical Code Page
;    assignments) available on the NEC Pinwriters.  They are provided mainly
;    for test purposes and not for general use.
;    Changed NECPINW license to GPL version 2.
;
;    NECPINW.ASM 1.10 2000-09-20 MPAUL
;    Fixed a number of bugs.
;
;    NECPINW.ASM 1.09 2000-09-08 MPAUL
;    Added support for PTS-DOS Code Page 667 ("Mazovia").  (Thanks to
;    Michal Tyc, Institute of Physics, Wroclaw University of Technology
;    (Poland) for the hint that Code Page 667 is in fact "Mazovia"!)
;
;    NECPINW.ASM 1.08 1999 MPAUL
;    Changes not filed.
;
;    NECPINW.ASM 1.07 1997-05-13 MPAUL
;    Final version based on new NEC manuals.
;
;    NECPINW.ASM 1.06 1997-03-17 MPAUL
;    Added support for the whole NEC Pinwriter series where applicable.
;    (Thanks to Ferdinand Klement and Klaus Ulsamer, NEC Deutschland GmbH,
;    Ismaning (Germany) at the NEC Hotline for their unbureaucratic support
;    (1997-01/1997-03) in regard to my various questions on several NEC
;    Pinwriters not being in my possession.  They have also provided free
;    of charge a number of printed manuals for other Pinwriter models.)
;
;    NECPINW.ASM 1.01-1.05 1996 MPAUL
;    Various changes and additions not filed.
;
;    NECPINW.ASM 1.00 1996 MPAUL
;    Initial experimental release for my color NEC Pinwriter P5300 (P7plus)
;    24 wire dot matrix printer based on my research in .CPI file formats,
;    NLS stuff, and DOS internals.
;
; #############################################################################
;
;    Implementation details:
;    =======================
;
;    Notes:
;    ------
;
;    - Details on the NEC Pinwriter series, NECPINW's supported range of
;      features on the various models, and further NECPINW.CPI related
;      implementation related notes can be found in the FILESPEC.TXT
;      shipping with the distribution.
;
;    - For details on DOS Code Page support, Code Page ID references,
;      and .CPI file formats, have a look at my DOS .CPI and Linux
;      .CP file analyzer and decompiler package CPI???.ZIP, also
;      part of FreeDOS.  For details on DOS country support, country
;      ID references, and COUNTRY.SYS file formats, have a look at
;      my COUNTRY.ZIP/CHCC???.ZIP package.  (The most current previews
;      on future versions are available on email request.)
;
;    - I wished I could have designed NECPINW.CPI as a native Code Page
;      switching printer .CPI file (PRINTER_TYPE 2), as this would consume
;      less memory in the resident PRINTER.SYS driver.  Unfortunately,
;      PRINTER.SYS partially uses hardwired escape sequences for
;      PRINTER_TYPE 2, so that they are not available for redefinition
;      in a .CPI file (this holds true at least for DR DOS, but probably
;      also for MS-DOS/PC DOS).  This is why NECPINW.CPI is implemented as
;      a download printer .CPI file (PRINTER_TYPE 1), although with a few
;      exceptions the sent data is not font data, but just control
;      sequences for Code Page switching between ROM fonts.  The exceptions
;      are download Code Pages like 858/8501 (and the other variants with
;      EURO SIGN), which actually make use of the RAM font feature to
;      define the shape for the EURO SIGN.
;      DR DOS supports two original model variants for PRINTER_TYPE 1,
;      "4201" for the IBM Proprinters II & III Model 4201 and
;      IBM Proprinters II & III XL Model 4202, and "1050" for the
;      Epson printers FX-850/FX-1050.
;      I used "1050" instead of "4201" to take advantage of the smaller
;      resident size for the buffer occupied by PRINTER.SYS for download
;      data (ca. 2.3 Kb in contrast to ca. 7 Kb per Code Page, respectively).
;      Due to this fixed allocation, a ca. 2-2.5 Kb data area is still
;      wasted for each prepared Code Page (typically two).  This problem
;      could be eliminated only by adding a user definable printer type
;      to PRINTER.SYS (Idea: loading the escape sequences in XMS, EMS,
;      or directly from harddisk; and a new PRINTER.SYS parameter to define
;      the size of download data)...  Something to do for FreeDOS and
;      a possibly future "open" DR-DOS...
;      Another reason for not using the "4201" type is the fact, that
;      some of the escape sequences (in the CPData macro) are stored
;      in yet another sub-format, which I have not completely decoded
;      at present.
;
;    How to build:
;    -------------
;
;      1. Select appropriate conditional assembly switches in NECPINW.ASM.
;      2. Run MAKENEC.BAT, that is:
;
;         TASM NECPINW.ASM, NECPINW.OBJ, NUL, NUL
;         LINK NECPINW.OBJ; NECPINW.EXE; NUL; NUL
;         EXE2BIN NECPINW.EXE NECPINW.CPI
;
;      Tested with TASM 3.1 and MASM 5.1 only.  MASM 4.0 needs adaptations.
;      Reports with other assembler and linker versions are welcome.
;
;    To Do list:
;    -----------
;
;    - More testing with other printer models and DOS versions!!!
;      (Please ask, if you need further instructions what to do...)
;
;    - Finish CPI_STYLE conditional define for non-DR DOS styles.
;
;    - Make specific printer models selectable at compilation time to
;      allow creation of .CPI files which strictly support features of
;      a particular model only (PRINTER_MODEL & EPROM_STYLE).  Thereby
;      revise all the model specific control sequences to be actually
;      valid for the corresponding printers (unfortunately the NEC manuals
;      are somewhat ambiguous in regard to this question).
;
;      If you own one of the following NEC Pinwriter models (P2/P3,
;      CP2/CP3, P5 (P530, P550, P560), P5XL (P530XL/P535XL, P550XL/P555XL,
;      P5 Coax), P9XL) it would be really great, if you could get into
;      contact with me, so that I can verify some of the assumptions
;      I had to make when developing NECPINW.CPI by checking them with
;      your manuals.  Additionally, if you own a P6/P7 (P660/P760, P665/P765),
;      CP6/CP7 (CP660/CP760, CP665/CP765), P2200, P22Q/P32Q, P3800/P3900
;      (P42Q/P52Q), P1200/P1300 (P2Q/P3Q), P2000 (P2X), or P8000 (P72X),
;      I would like to test two potentially better methods to define
;      download characters on these printers.
;
;    - It seems some Epson printers allow to re-define characters above
;      128 even though the DL font buffer can hold only up to 128 chars.
;      Presumably the 128 (or less) available RAM slots for character
;      redefinition are allocated dynamically as they are needed.
;      As far as I know, the NEC Pinwriters do not have any such facility,
;      forcing us to use a 256 char DL font buffer, if we want to redefine
;      characters above 127 (even if we need to redefine a single character
;      only).  (At least this is my assumption after several attempts to
;      define characters above 127 while using a 128 DL buffer on a P5300
;      (P7plus) - they were either ignored or mapped downto 0..127.
;      There's still a possibility, that newer printer models would
;      support this feature...)
;      If there would be a method to use only a 128 char DL buffer even
;      for chars above 127, we should switch to this method because it
;      would reduce NECPINW.CPI's dependencies on the printers'
;      configuration and would allow coexistence with other download
;      fonts.  Does anybody know?
;
;    - Do we need to take special precautions for printers on 7-bit-only
;      serial connections?  Do we have to use "ESC_,'>'", "ESC_,'='", and
;      "ESC_,'#'" for them?
;
;    - Support for other Code Pages by download fonts and improving support
;      for Code Pages 737, 853, 857.  (Problem would be the large size of
;      the download data and different formats of download data in different
;      printer modes.)  We'd have to do alot of case decisions and could not
;      create a generic .CPI file (see Code Page 8501 and its variants).
;      Please send me your FreeWare or Public Domain download fonts.
;
;    - Currently the various entries are manually linked into chains via
;      numbered labels.  As a nice sideeffect, this hardwiring ensures that
;      no data can be erroneously placed in between these entries.
;      On the other hand, dynamically built chains at assembly time (using
;      for example local labels as supported by MASM 5.1+/TASM 3.2+) would
;      make the file more readable and could ease maintenance.  Any opinions?
;
;    - Is anyone able to tell me the data format of the contents of the
;      optional font EPROMs?  Either a specification or the contents of
;      a sample EPROM would be most helpful to build new fonts containing
;      the EURO SIGN.  This would allow to support up to 12 additional
;      codepages.
;
;    - The P6200/P6300 (P60/P70), P9300 (P90), P3200/P3300 (P20/P30),
;      P22Q/P32Q, P7200/P7300 (P62/P72), P3800/P3900 (P42Q/P52Q),
;      P1200/P1300 (P2Q/P3Q), P2000 (P2X), and P8000 (P72X) clearly
;      support special control sequences to fully remote configure the
;      printer.  Anyone knowing these undocumented sequences?
;
;    - Similar .CPI files for other printers to be added (an implementation
;      for the Epson LQ-570+/LQ-1070+ dot matrix printers already exists)...
;
;    - Please send all corrections, changes, fixes, or enhancements to me,
;      rather than distributing modified versions of this software.
;
; #############################################################################


VERSION_MSG     equ     <"2.08">        ; file version
ISO_DATE_MSG    equ     <"010226">      ; 6 digit date (ISO 28601/ISO 8601 "yymmdd")
                                        ; NB. This is compatible with the date tag
                                        ;     used by Novell, Caldera, and Lineo.
LONG_YEAR_MSG   equ     <"2001">        ; current 4 digit year

;PRINTER_MODEL  equ     0    NYI!!!     ; <0>= generic file for all possible models
                                        ;  1..xx = support specific model only

;EPROM_STYLE    equ     0    NYI!!!     ; <0>= support as much as possible, but
                                        ;      take EPROM_NO into account
                                        ;  1 = support *only* EPROM_NO
                                        ;  2 = support as much as possible, but
                                        ;      don't take EPROM_NO into account
                                        ;      (that is, provide only Code Page
                                        ;      IDs in the user definable range)

EPROM_NO        equ     6               ;  0 = none
                                        ;  1 = Russian
                                        ;  2 = East Europe
                                        ;  3 = Greek
                                        ;  4 = Turkey
                                        ;  5 = Code Tables (512 Kb)
                                        ; <6>= Code Tables (1 Mb)
                                        ;  7 = Hungaria
                                        ;  8 = Polish
                                        ;  9 = ORC-BDR
                                        ; 10 = BANK

EURO_STYLE      equ     9               ;  0 = Universal (any mode, but ugly)
                                        ;  1 = Draft 10 cpi (Pica)
                                        ;  2 = Draft 12 cpi (Elite)
                                        ;  3 = Draft 12 cpi HS (Elite)
                                        ;  4 = Draft 15 cpi (Micro)
                                        ;  5 = Draft 17 cpi (Pica+Condensed)
                                        ;  6 = Draft 20 cpi (Elite+Condensed)
                                        ; <9>= LQ 10 cpi (Pica)
                                        ; 10 = LQ 12 cpi (Elite)
                                        ; 11 = LQ 15 cpi (Micro)
                                        ; 12 = LQ 17 cpi (Pica+Condensed)
                                        ; 13 = LQ 20 cpi (Elite+Condensed)

;TYPE_FACE      equ     255  NYI!!!     ; 0  = Courier 10
                                        ; 6  = Super Focus (P2200 only)
                                        ; 12 = OCR-B (P2200 only)
                                        ; 15 = ITC Souvenir 10
                                        ; 16 = Helvetica/Helvette 10 PT
                                        ; 18 = Times 10 PT
                                        ; 19 = New Prestige Elite 12 WP
                                        ; 34 = Bold PS
                                        ; 50 = Fast Focus 10
                                        ; 51 = Fast Focus 12
                                        ; 52 = Quick Gothic 10
                                        ; 53 = Quick Gothic 12
                                        ;<255>= no forced type face

;QUAL_STYLE     equ     0    NYI!!!     ; <0>= no forced quality
                                        ;  1 = force Draft quality
                                        ;  2 = force LQ

CPI_STYLE       equ     0               ; <0>= DR DOS 6.0+ 1050.CPI file
                                        ;  1 = PC DOS 6.1+ EPS.CPI file (NYI!!!)
                                        ;  2 = MS-DOS/PC DOS 3.3+ 4201.CPI (NYI!!!)
                                        ;  3 = future DR-DOS 7+ NECPINW.CPI file
                                        ;      may also be used for FreeDOS (NYI!!!)

EURO_850        equ     0               ; <0>= CP 850 without EURO SIGN, use CP 858 instead
                                        ;  1 = CP 850 is same as CP 858

EURO_857        equ     1               ;  0 = CP 857 without EURO SIGN, use CP 58201 instead
                                        ; <1>= CP 857 is same as CP 58201

EURO_8501       equ     1               ; <0>= don't support obsolete CP 8501 proposal
                                        ;  1 = still support the CP 8501 proposal

DEBUG           equ     0               ; <0>= generate distribution .CPI file
                                        ;  1 = include a few more test codes

; #############################################################################

        include eurofont.inc

        PAGE    ,136

; #############################################################################

FILE_NAME_MSG   equ     <"NECPINW.CPI"> ; .CPI filename

                                        ; Special characters
NUL             equ     00h             ; null (ignored by printer)
LF              equ     0Ah             ; line feed
CR              equ     0Dh             ; carriage return
SI_             equ     0Fh             ; "shift in" condensed script on
DC2             equ     12h             ; "device control" condensed script off
CTLZ            equ     1Ah             ; end of file, ^Z
ESC_            equ     1Bh             ; escape seq. lead-in (ESC/P, IBM, NEC)
FS_             equ     1Ch             ; escape sequence lead-in (NEC)
SPACE           equ     20h             ; white space
LTERM           equ     24h             ; line terminator

CP667           equ     667             ; unofficial Code Page assignments
CP867           equ     867             ; for easier redefinition...
CP895           equ     895             ;
CP991           equ     991             ;
IF EURO_8501 EQ 1                       ;
CP8501          equ     8501            ; obsolete
ENDIF

DEVICE_TYPE     equ     2               ; 1 = display, 2 = printer
IF CPI_STYLE EQ 1                       ; NB. Must be SPACE padded to 8 chars!
DEVICE_NAME     equ     <"EPS",SPACE,SPACE,SPACE,SPACE,SPACE> ; PC DOS 6.1+
ELSEIF CPI_STYLE EQ 2
DEVICE_NAME     equ     <"4201",SPACE,SPACE,SPACE,SPACE>      ; MS-DOS/PC DOS
ELSEIF CPI_STYLE EQ 3
DEVICE_NAME     equ     <"NECPINW",SPACE> ; reserved: future DR-DOS 7+ / FreeDOS
ELSE
DEVICE_NAME     equ     <"1050",SPACE,SPACE,SPACE,SPACE>      ; DR DOS 6.0+
ENDIF

FONT_TYPE       equ     1               ;

PRINTER_TYPE    equ     1               ; 1 = download printer

NO_FONTS        equ     1               ; count of fonts

ITALICS         equ     0               ; use Italics for chars > 127
GRAPHICS        equ     1               ; use IBM graphics for chars > 127

                                        ; Standard Char Set selection IDs:
ID_0            equ     0               ; "7-bit US"
ID_1            equ     1               ; "7-bit France"
ID_2            equ     2               ; "7-bit Germany"
ID_3            equ     3               ; "7-bit United Kingdom"
ID_4            equ     4               ; "7-bit Denmark I"
ID_5            equ     5               ; "7-bit Sweden"
ID_6            equ     6               ; "7-bit Italy"
ID_7            equ     7               ; "7-bit Spain I"
                                        ; Extended Char Set selection IDs:
ID_8            equ     8               ; "7-bit Japan"
ID_9            equ     9               ; "7-bit Norway I"
ID_10           equ    10               ; "7-bit Denmark II"
                                        ; NEC specific Char Set selection IDs:
ID_11           equ    11               ; "7-bit Netherlands" ("Spain II" with Epson!!!)
ID_12           equ    12               ; "7-bit Turkey"      ("Latin America" with Epson!!!)
ID_13           equ    13               ; "7-bit Spain II"    ("Korea" with Epson FX!!!)
ID_14           equ    14               ; "7-bit Latin America"
IF DEBUG EQ 1
ID_15           equ    15               ; (not used)         
ENDIF
                                        ; NEC specific Code Page selection IDs:
ID_16           equ    16               ; "Multilingual" (CP 850)
ID_17           equ    17               ; "Portugal" (CP 860)
ID_18           equ    18               ; "French Canada" (CP 863)
ID_19           equ    19               ; "Norway II" (CP 865)
                                        ; NEC specific EPROM char set selection IDs:
ID_20           equ    20               ; CP 852,
                                        ; ca. CPs 853 and 857 (#4 "Turkish"),
                                        ; ca. CP 737 (#3 "Greek").
ID_21           equ    21               ; CPs 667/991 "Mazovia" (#8 "Polish"),
                                        ; CP 866 (#5/#6 "Code Tables").
ID_22           equ    22               ; CP 855 (#5/#6 "Code Tables"),
                                        ; CP 866 (#1 "Russian").
ID_23           equ    23               ; CP 867/895 (#2 "East Europe")
ID_24           equ    24               ; CP 855 (#1 "Russian")
ID_25           equ    25               ;
ID_26           equ    26               ; (reserved for EPROMs by NEC)
ID_27           equ    27               ; (reserved for EPROMs by NEC)
                                        ; (Epson GQ/EPJ/EPL: IDs 0..12 / 16..28 used
ID_28           equ    28               ; (reserved for EPROMs by NEC)
                                        ; for graphical / character symbol sets)
ID_29           equ    29               ; (reserved for EPROMs by NEC)
ID_30           equ    30               ; (reserved for EPROMs by NEC)
ID_31           equ    31               ; (reserved for EPROMs by NEC)
IF DEBUG EQ 1
ID_32           equ    32               ; (Epson GQ-5000: "Norway/Denmark"; Epson EPJ/EPL: "PC Nordic" (CP 865))
ID_33           equ    33               ; (Epson GQ/EPJ/EPL: "PC Portuguese" (CP 860))
ID_34           equ    34               ; (Epson GQ-5000: "Icelandic" (almost CP 861); Epson EPJ/EPL: "PC Multilingual" (CP 850))
ID_35           equ    35               ; (Epson EPJ/EPL: "PC CanFrench" (CP 863))
ID_36           equ    36               ; (Epson EPL-4300/EPL-8100: "PC Turk1" (CP 853))
ID_37           equ    37               ; (Epson EPL-4300/EPL-8100: "PC Turk2" (CP 857))
ID_48           equ    48               ; (Epson GQ/EPJ/EPL: "ECMA 94 (Latin 1)")
ID_64           equ    64               ; (Epson FX/LQ: "Legal"; Epson GQ/EPJ/EPL: "PC Set/PC USA" (CP 437))
ID_112          equ    112              ; (Epson GQ/EPJ/EPL: optional "OCR-B")
ID_113          equ    113              ; (Epson GQ/EPJ/EPL: optional "OCR-A")
ID_114          equ    114              ; (Epson GQ/EPJ/EPL: optional "Code 3-9")
ID_115          equ    115              ; (Epson GQ/EPJ/EPL: optional "EAN/UPC")
ID_126          equ    126              ; (Epson EPL-4100/EPL-7100: opt. "ITC Zapf Dingbats")
ID_127          equ    127              ; (Epson GQ/EPJ/EPL: "Symbolic")
                                        ; 128..254 (Epson GQ/EPJ/EPL: "user defined")
ENDIF
                                        ; Script family type face selector
TF_COURIER_10   equ     0               ;  0= Courier 10
TF_SUPERFOCUS   equ     6               ;  6= Super Focus
TF_OCR_B        equ    12               ; 12= OCR-B
TF_ITCSOUVENIR_10 equ  15               ; 15= ITC Souvenir 10
TF_HELVETICA_10PT equ  16               ; 16= Helvetica/Helvette 10 PT
TF_TIMES_10PT   equ    18               ; 18= Times 10 PT
TF_NEWPRESTIGEELITE_12WP equ 19         ; 19= New Prestige Elite 12 WP
TF_BOLD_PS      equ    34               ; 34= Bold PS
TF_FASTFOCUS_10 equ    50               ; 50= Fast Focus 10
TF_FASTFOCUS_12 equ    51               ; 51= Fast Focus 12
TF_QUICKGOTHIC_10 equ  52               ; 52= Quick Gothic 10
TF_QUICKGOTHIC_12 equ  53               ; 53= Quick Gothic 12

BUFFER_NO       equ     0               ; since we need a 256 byte buffer, only
                                        ; buffer 1 (BUFFER_NO = 0) is valid

SUB_LENGTH      equ     5

EURO_CHR_FD     equ     9Fh             ; Code Point for EURO SIGN (FreeDOS EUROTSR)
EURO_CHR_850    equ    0D5h             ; Code Point for EURO SIGN (PC DOS 7 CP 850)
EURO_CHR_857    equ    0D5h             ; NB. A number of other Code Pages,
EURO_CHR_858    equ    0D5h             ;     which, however, are not supported
                                        ;     by NECPINW.CPI have the EURO SIGN
                                        ;     at Code Points 80h or 88h.

QUAL_ANY        equ     0               ; for use with SelCPI macro
QUAL_DRAFT      equ     1               ;
QUAL_LQ         equ     2               ;
                                        ;
IF EURO_STYLE GE 9                      ; defines quality of
QUAL_FD         equ     QUAL_LQ         ; FreeDOS EUROTSR EURO SIGN support
ELSEIF EURO_STYLE LE 6                  ;
QUAL_FD         equ     QUAL_DRAFT      ;
ELSE                                    ;
QUAL_FD         equ     QUAL_ANY        ;
ENDIF                                   ;

CPI_ANY         equ     0               ; for use with SelCPI macro
CPI_10          equ    10               ;
CPI_12          equ    12               ;
CPI_12HS        equ   255               ;
CPI_15          equ    15               ;
CPI_17          equ    17               ;
CPI_20          equ    20               ;
                                        ;
IF EURO_STYLE EQ 1                      ; defines resolution of
CPI_FD          equ     CPI_10          ; FreeDOS EUROTSR EURO SIGN support
ELSEIF EURO_STYLE EQ 2                  ;
CPI_FD          equ     CPI_12          ;
ELSEIF EURO_STYLE EQ 3                  ;
CPI_FD          equ     CPI_12HS        ;
ELSEIF EURO_STYLE EQ 4                  ;
CPI_FD          equ     CPI_15          ;
ELSEIF EURO_STYLE EQ 5                  ;
CPI_FD          equ     CPI_17          ;
ELSEIF EURO_STYLE EQ 6                  ;
CPI_FD          equ     CPI_20          ;
ELSEIF EURO_STYLE EQ 9                  ;
CPI_FD          equ     CPI_10          ;
ELSEIF EURO_STYLE EQ 10                 ;
CPI_FD          equ     CPI_12          ;
ELSEIF EURO_STYLE EQ 11                 ;
CPI_FD          equ     CPI_15          ;
ELSEIF EURO_STYLE EQ 12                 ;
CPI_FD          equ     CPI_17          ;
ELSEIF EURO_STYLE EQ 13                 ;
CPI_FD          equ     CPI_20          ;
ELSE                                    ;
CPI_FD          equ     CPI_ANY         ;
ENDIF                                   ;

LAST            equ     1               ; for use with CPEntry macro
NOTLAST         equ     0               ;

CPEntry macro   start,next,codepage,data,flag
        ENTRY_COUNTER = ENTRY_COUNTER + 1
start   dw      (offset next - offset start)
IF flag EQ LAST
        ;;dd    0                       ; Last Code Page
        dw      0, 0                    ; End of List marker
ELSE
        ;;dd    offset next             ; File offset of next list entry
        dw      offset next             ;
        dw      0                       ; (segment always zero)
ENDIF
        dw      DEVICE_TYPE             ; Device number
        db      DEVICE_NAME             ; Device name
        dw      codepage                ; Code Page number
        dw      3 dup (0)               ; Reserved

        ;;dd    offset data             ; File offset of data-header for this
        dw      offset data             ;
        dw      0                       ; (segment always zero)

IF flag EQ LAST
ELSE
next    label   word                    ; to avoid improper use of the macro...
ENDIF
        endm


SelCP   macro   mode,selector           ; used for Code Page selection
                                        ; BEWARE: This must be 12 bytes long!!!
        db      ESC_,'%',0              ; select internal char set
                                        ;
        ;db     ESC_,'t',mode           ; choose "Italics" or "Graphics" table
        ;                               ; NB. Not supported by P5XL, P9XL,
        ;                               ;     P6/P7, CP6/CP7! Probably also not
        ;                               ;     supported by P2/P3, CP2/CP3, P5!
                                        ;
        db      FS_,'I',mode            ; same as above (NEC only)
                                        ; NB. Supported by P5XL, P9XL, P6/P7,
                                        ;     CP6/CP7, P2200, ..., P2X, P72X!
                                        ;
        db      ESC_,'R',selector       ; select character set
        db      NUL                     ; dummy filler
        db      ESC_,'6'                ; codes 128-159 are printable
                                        ; NB. Not supported by P5XL, P9XL,
                                        ;     P6/P7, CP6/CP7!
        endm


CPData  macro   start,next,mode,selector,fontdata
start   dw      FONT_TYPE               ; type of font (1=FONT)
        dw      NO_FONTS                ; count of fonts
        dw      (offset next - offset fontdata) ; Length of font definitions
fontdata label  BYTE
        dw      PRINTER_TYPE
        dw      12                      ; length of sequences
                                        ; NB. Apparently, DR DOS PRINTER.SYS
                                        ;     uses the second half of the 1st
                                        ;     sequence as lead out sequence???
                                        ;     For proper results, you may not
                                        ;     move the starting points of these
                                        ;     sequences.

IF CPI_STYLE EQ 1                       ; PC DOS 6.1+ EPS.CPI (NYI!!!)

        db      SUB_LENGTH              ; length of sub-sequence 1
        db      ESC_,'%',0              ; init sequence 1
        db      ESC_,6                  ;
        db      SUB_LENGTH              ; length of sub-sequence 2
        db      ESC_,'%',1              ; init sequence 2
        db      ESC_,6                  ;
        ; more control sequences immediately following the CPData macro...
        SelCP   mode,selector           ; actual init sequence (RAM)

ELSEIF CPI_STYLE EQ 2                   ; MS-DOS/PC DOS 4201.CPI (NYI!!!)

        db      SUB_LENGTH              ; length of sub-sequence 1
        db      SUB_LENGTH dup (NUL)    ; dummy for init sequence 1
        db      SUB_LENGTH              ; length of sub-sequence 2
        db      SUB_LENGTH dup (NUL)    ; dummy for init sequence 2
        ; more control sequences immediately following the CPData macro...
        ;db     32-2*SUB_LENGTH dup (NUL); dummy
        SelCP   mode,selector           ; actual init sequence (RAM)

ELSE                                    ; DR DOS 6.0+ 1050.CPI (and future
                                        ; DR-DOS 7+/FreeDOS NECPINW.CPI)
        SelCP   mode,selector           ; init sequence 1 (ROM)
        SelCP   mode,selector           ; init sequence 2 (RAM)
        ; more control sequences immediately following the CPData macro...

ENDIF
        endm


EuroDraft10     macro euro_sym
        ;       Definition of the EURO SIGN for Draft 10 cpi (Pica):
        ;       (currently same as Universal):
        ;
        ;       123456789012            LEAD_IN+BOX_SIZE+LEAD_OUT=12 (!)
        ;       123456789               BOX_SIZE=9 here (9 max.)
        ;                123            LEAD_IN=0, LEAD_OUT=3 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,0,9,3
        EURO_PRN_24x9_Draft             ; RAM data for character (3*9 bytes)
        endm


EuroDraft12     macro euro_sym
        ;       Definition of the EURO SIGN for Draft 12 cpi (Elite):
        ;
        ;       123456789012345         LEAD_IN+BOX_SIZE+LEAD_OUT=15 (!)
        ;        123456789              BOX_SIZE=9 here (9 max.)
        ;       1         12345         LEAD_IN=1, LEAD_OUT=5 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,1,9,5
        EURO_PRN_24x9_Draft             ; RAM data for character (3*9 bytes)
        endm


EuroDraft12HS   macro euro_sym
        ;       Definition of the EURO SIGN for Draft HS 12 cpi (Elite):
        ;
        ;       1234567890              LEAD_IN+BOX_SIZE+LEAD_OUT=10 (!)
        ;       123456789               BOX_SIZE=9 here (9 max.)
        ;                1              LEAD_IN=0, LEAD_OUT=1 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,0,9,1
        EURO_PRN_24x9_Draft             ; RAM data for character (3*9 bytes)
        endm


EuroDraft15     macro euro_sym
        ;       Definition of the EURO SIGN for Draft 15 cpi (Micro):
        ;
        ;       1234567890123456        LEAD_IN+BOX_SIZE+LEAD_OUT=16 (!)
        ;        123456789              BOX_SIZE=9 here (9 max.)
        ;       1         123456        LEAD_IN=1, LEAD_OUT=6 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,1,9,6
        EURO_PRN_24x9_Draft             ; RAM data for character (3*9 bytes)
        endm


EuroDraft17     macro euro_sym
        ;       Definition of the EURO SIGN for Draft 17 cpi (Pica+Condensed):
        ;
        ;       12345678901234          LEAD_IN+BOX_SIZE+LEAD_OUT=14 (!)
        ;        123456789              BOX_SIZE=9 here (9 max.)
        ;       1         1234          LEAD_IN=1, LEAD_OUT=4 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,1,9,4
        EURO_PRN_24x9_Draft             ; RAM data for character (3*9 bytes)
        endm


EuroDraft20     macro euro_sym
        ;       Definition of the EURO SIGN for Draft 20 cpi (Elite+Condensed):
        ;
        ;       123456789012            LEAD_IN+BOX_SIZE+LEAD_OUT=12 (!)
        ;       123456789               BOX_SIZE=9 here (9 max.)
        ;                123            LEAD_IN=0, LEAD_OUT=3 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,0,9,3
        EURO_PRN_24x9_Draft             ; RAM data for character (3*9 bytes)
        endm


EuroLQ10        macro euro_sym
        ;       Definition of the EURO SIGN for LQ 10 cpi (Pica):
        ;
        ;       123456789012345678901234567890123456 LEAD_IN+BOX_SIZE+LEAD_OUT=36 (!)
        ;           1234567890123456789012345678     BOX_SIZE=28 here (29 max.)
        ;       1234                            1234 LEAD_IN=4, LEAD_OUT=4 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,4,28,4
        EURO_PRN_24x28_LQ               ; RAM data for character (3*28 bytes)
        endm


EuroLQ12        macro euro_sym
        ;       Definition of the EURO SIGN for LQ 12 cpi (Elite):
        ;
        ;       123456789012345678901234567890 LEAD_IN+BOX_SIZE+LEAD_OUT=30 (!)
        ;           1234567890123456789012     BOX_SIZE=22 here (23 max.)
        ;       1234                      1234 LEAD_IN=4, LEAD_OUT=4 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,4,22,4;
        EURO_PRN_24x22_LQ               ; RAM data for character (3*22 bytes)
        endm


EuroLQ15        macro euro_sym
        ;       Definition of the EURO SIGN for LQ 15 cpi (Micro):
        ;
        ;       123456789012345678901234 LEAD_IN+BOX_SIZE+LEAD_OUT=24 (!)
        ;        1234567890123456789012  BOX_SIZE=22 here
        ;       1                      1 LEAD_IN=1, LEAD_OUT=1 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,1,22,1;
        EURO_PRN_24x22_LQ               ; RAM data for character (3*22 bytes)
        endm


EuroLQ17        macro euro_sym
        ;       Definition of the EURO SIGN for LQ 17 cpi (Pica+Condensed):
        ;
        ;       123456789012345678901234567890123456 LEAD_IN+BOX_SIZE+LEAD_OUT=36 (!)
        ;           1234567890123456789012345678     BOX_SIZE=28 here (29 max.)
        ;       1234                            1234 LEAD_IN=4, LEAD_OUT=4 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,4,28,4
        EURO_PRN_24x28_LQ               ; RAM data for character (3*28 bytes)
        endm


EuroLQ20        macro euro_sym
        ;       Definition of the EURO SIGN for LQ 20 cpi (Elite+Condensed):
        ;
        ;       123456789012345678901234567890 LEAD_IN+BOX_SIZE+LEAD_OUT=30 (!)
        ;           1234567890123456789012     BOX_SIZE=22 here (23 max.)
        ;       1234                      1234 LEAD_IN=4, LEAD_OUT=4 here

        db      ESC_,'&',BUFFER_NO,euro_sym,euro_sym,4,22,4;
        EURO_PRN_24x22_LQ               ; RAM data for character (3*22 bytes)
        endm


SelCPI  macro   quality, cpi
        db      ESC_,'%',0              ; select internal char set
IF quality EQ QUAL_DRAFT
        db      ESC_,'p',0              ; Proportional off
        db      ESC_,'x',0              ; select Draft
ELSEIF quality EQ QUAL_LQ
        db      ESC_,'x',1              ; select LQ
        ;db     ESC_,'p',0              ; Proportional off
ELSEIF ; QUAL_ANY
        ;db     ESC_,'p',0              ; Proportional off
ENDIF
        db      ESC_,'5'                ; Italics off
        db      ESC_,'T'                ; super-/sub-script off

;IF 1HSLQ equ 1
        ;db      FS_,'C',0               ; select internal fonts
        ;db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_QUICKGOTHIC_10; select "Quick Gothic 10" DEBUG!!!
;ENDIF

IF cpi EQ CPI_10
        db      DC2                     ; condensed script off
        ;db     ESC_,'!',0              ; deselect all (including condensed off)
        db      ESC_,'P'                ; select 10 cpi (Pica)
        db      ESC_,'k',TF_QUICKGOTHIC_10; select "Quick Gothic 10" DEBUG!!!
ELSEIF cpi EQ CPI_12
        db      DC2                     ; condensed script off
        ;db     ESC_,'!',0              ; deselect all (including condensed off)
        db      ESC_,'M'                ; select 12 cpi (Elite)
IF quality EQ QUAL_DRAFT
        db      FS_,'S',0               ; select DRAFT 12 (normal speed)
ENDIF
        db      ESC_,'k',TF_QUICKGOTHIC_12; select "Quick Gothic 12" DEBUG!!!
ELSEIF cpi EQ CPI_12HS
        db      DC2                     ; condensed script off
        ;db     ESC_,'!',0              ; deselect all (including condensed off)
        db      ESC_,'M'                ; select 12 cpi (Elite)
IF quality EQ QUAL_DRAFT
        db      FS_,'S',1               ; select HS 12
ENDIF
ELSEIF cpi EQ CPI_15
        db      DC2                     ; condensed script off
                                        ; NB. 15 cpi condensed results in the
                                        ;     same resolution as 12 cpi
                                        ;     condensed, that is 20 cpi.
                                        ;     However, there's some fuzz with
                                        ;     the spacing of RAM chars, hence
                                        ;     we force condensed scripting to
                                        ;     be off.
        ;db     ESC_,'!',0              ; deselect all (including condensed off)
        db      ESC_,'g'                ; select 15 cpi (Micro)
ELSEIF cpi EQ CPI_17
        db      ESC_,'P'                ; select 10 cpi (Pica)
        db      ESC_,'k',TF_QUICKGOTHIC_10; select "Quick Gothic 10" DEBUG!!!
        db      SI_                     ; condensed script on -> 17 cpi
        ;db     ESC_,'!',4              ; select 10 cpi and condensed
ELSEIF cpi EQ CPI_20
        db      ESC_,'M'                ; select 12 cpi (Elite)
        db      ESC_,'k',TF_QUICKGOTHIC_12; select "Quick Gothic 12" DEBUG!!!
IF quality EQ QUAL_DRAFT
        ;db     FS_,'S',0               ; select DRAFT 12 (normal speed)
ENDIF
        db      SI_                     ; condensed script on -> 20 cpi
        ;db     ESC_,'!',5              ; select 12 cpi and condensed
ENDIF
        endm


SetupEuro       macro mode, selector, quality, cpi, euro_sym
        db      FS_,'W',1               ; select 256 user definable chrs
                                        ; NB. Not supported by P5XL, P9XL,
                                        ;     P6/P7, CP6/CP7, P2200, P2200XE,
                                        ;     P20/P30, P22Q/P32Q, P42Q/P52Q,
                                        ;     P2Q/P3Q, P2X
        SelCP   mode,selector           ; init sequence (again)
        SelCPI  quality,cpi             ;
        db      ESC_,':',NUL,NUL,NUL    ; copy ROM into RAM buffer 1
IF quality EQ QUAL_DRAFT
IF cpi EQ CPI_10
        EuroDraft10 euro_sym            ; EURO SIGN in Draft 10 cpi (Pica)
ELSEIF cpi EQ CPI_12
        EuroDraft12 euro_sym            ; EURO SIGN in Draft 12 cpi (Elite)
ELSEIF cpi EQ CPI_12HS
        EuroDraft12HS euro_sym          ; EURO SIGN in Draft HS 12 cpi (Elite)
ELSEIF cpi EQ CPI_15
        EuroDraft15 euro_sym            ; EURO SIGN in Draft 15 cpi (Micro)
ELSEIF cpi EQ CPI_17
        EuroDraft17 euro_sym            ; EURO SIGN in Draft 17 cpi (Pica+Condensed)
ELSEIF cpi EQ CPI_20
        EuroDraft20 euro_sym            ; EURO SIGN in Draft 20 cpi (Elite+Condensed)
ELSE ; CPI_ANY         ; DEBUG: This shouldn't happen!!!
        .ERR "SetupEuro: Unusual combination of parameters: QUAL_DRAFT+CPI_ANY"
        ;EuroDraft10 euro_sym           ; EURO SIGN in Draft
ENDIF ; cpi
ELSEIF quality EQ QUAL_LQ
IF cpi EQ CPI_10
        EuroLQ10 euro_sym               ; EURO SIGN in LQ 10 cpi (Pica)
ELSEIF cpi EQ CPI_12
        EuroLQ12 euro_sym               ; EURO SIGN in LQ 12 cpi (Elite)
ELSEIF cpi EQ CPI_12HS ; DEBUG: This must not happen!!!
        .ERR "SetupEuro: Invalid combination of parameters: QUAL_LQ+CPI_12HS"
        ;EuroLQ12 euro_sym              ; EURO SIGN in LQ
ELSEIF cpi EQ CPI_15
        EuroLQ15 euro_sym               ; EURO SIGN in LQ 15 cpi (Micro)
ELSEIF cpi EQ CPI_17
        EuroLQ17 euro_sym               ; EURO SIGN in LQ 17 cpi (Pica+Condensed)
ELSEIF cpi EQ CPI_20
        EuroLQ20 euro_sym               ; EURO SIGN in LQ 20 cpi (Elite+Condensed)
ELSE ; CPI_ANY         ; DEBUG: This should not happen!!!
       .ERR "SetupEuro: Unusual combination of parameters: QUAL_LQ+CPI_ANY"
        ;EuroLQ10 euro_sym              ; EURO SIGN in LQ
ENDIF ; cpi
ELSE ; QUAL_ANY
IF cpi EQ CPI_10       ; DEBUG: This should not happen!!!
        .ERR "SetupEuro: Unusual combination of parameters: QUAL_ANY+CPI_10"
        ;EuroDraft10 euro_sym           ; EURO SIGN in Universal (as Draft)
ELSEIF cpi EQ CPI_12   ; DEBUG: This should not happen!!!
        .ERR "SetupEuro: Unusual combination of parameters: QUAL_ANY+CPI_12"
        ;EuroDraft12 euro_sym           ; EURO SIGN in Universal (as Draft)
ELSEIF cpi EQ CPI_12HS ; DEBUG: This should not happen!!!
        .ERR "SetupEuro: Unusual combination of parameters: QUAL_ANY+CPI_12HS"
        ;EuroDraft12HS euro_sym         ; EURO SIGN in Universal (as Draft)
ELSEIF cpi EQ CPI_15   ; DEBUG: This should not happen!!!
        .ERR "SetupEuro: Unusual combination of parameters: QUAL_ANY+CPI_15"
        ;EuroDraft15 euro_sym           ; EURO SIGN in Universal (as Draft)
ELSEIF cpi EQ CPI_17   ; DEBUG: This should not happen!!!
        .ERR "SetupEuro: Unusual combination of parameters: QUAL_ANY+CPI_17"
        ;EuroDraft17 euro_sym           ; EURO SIGN in Universal (as Draft)
ELSEIF cpi EQ CPI_20   ; DEBUG: This should not happen!!!
        .ERR "SetupEuro: Unusual combination of parameters: QUAL_ANY+CPI_20"
        ;EuroDraft20 euro_sym           ; EURO SIGN in Universal (as Draft)
ELSE ; CPI_ANY
        EuroDraft10 euro_sym            ; EURO SIGN in Universal (as Draft)
ENDIF ; cpi
ENDIF ; quality
        db      ESC_,'%',1              ; select RAM char set
        ;db     FS_,'X',BUFFER_NO
        endm


; #############################################################################

Code Segment
        ASSUME CS:Code, DS:Code
        org     0

NECPINW_CPI:

; #############################################################################

FontFileHeader:
        db      0FFh
        db      "FONT",SPACE,SPACE,SPACE
        db      8 DUP (NUL)
        dw      1                       ; count of pointers in header
        db      1                       ; type of info pointer
                                        ;
;;      dd      offset FontInfoHeader   ; pointer to start of list
        dw      offset FontInfoHeader   ;
        dw      0                       ; (offset always zero)

; #############################################################################

FontInfoHeader:
        dw      CP_COUNT                ; count of Code Pages in file

; #############################################################################

        ENTRY_COUNTER = 0

;CPEntryHeader:
        CPEntry prn367, prn437,  367, data367, NOTLAST ; ANSI X3.4 ASCII, ISO-646-US
        CPEntry prn437, prn667,  437, data437, NOTLAST ; CP 437
        CPEntry prn667, prn737,CP667, data667, NOTLAST ; PTS-DOS CP 667
        CPEntry prn737, prn850,  737, data737, NOTLAST ;
        CPEntry prn850, prn852,  850, data850, NOTLAST ; CP 850
        CPEntry prn852, prn853,  852, data852, NOTLAST ; CP 852
        CPEntry prn853, prn855,  853, data853, NOTLAST ;
        CPEntry prn855, prn857,  855, data855, NOTLAST ; CP 855
        CPEntry prn857, prn858,  857, data857, NOTLAST ;
        CPEntry prn858, prn860,  858, data858, NOTLAST ; CP 858
        CPEntry prn860, prn863,  860, data860, NOTLAST ; CP 860
        CPEntry prn863, prn865,  863, data863, NOTLAST ; CP 863
        CPEntry prn865, prn866,  865, data865, NOTLAST ; CP 865
        CPEntry prn866, prn867,  866, data866, NOTLAST ; CP 866
        CPEntry prn867, prn895,CP867, data867, NOTLAST ;
        CPEntry prn895, prn991,CP895, data895, NOTLAST ;
        CPEntry prn991,prn1011,CP991, data991, NOTLAST ; PLC CP 991

IF 0
        ; NB. These entries are not currently enabled, because I'm not
        ;     sure if these would be actually the correct numbers.  I would
        ;     need to have access to the IBM CDRA level 2 CD-ROM to verify
        ;     this.  For now use "user definable" numbers in the range
        ;     FF00h..FFFEh instead.
        CPEntry prn1009,prn1010,1009,data1009, NOTLAST ; ISO-7 IRV (prior 1992)
        CPEntry prn1010,prn1011,1010,data1010, NOTLAST ; ISO-7 France
ENDIF

IF EURO_8501 EQ 1
        CPEntry prn1011,prn8501,1011,data1011, NOTLAST ; ISO-7 Germany
ELSE
        CPEntry prn1011,prn58201,1011,data1011,NOTLAST ; ISO-7 Germany
ENDIF

IF 0
        CPEntry prn1012,prn1013,1012,data1012, NOTLAST ; ISO-7 Italy
        CPEntry prn1013,prn1014,1013,data1013, NOTLAST ; ISO-7 United Kingdom
        CPEntry prn1014,prn1015,1014,data1014, NOTLAST ; ISO-7 Spain
        ;CPEntry prn1015,prn1016,1015,data1015,NOTLAST ; ISO-7 Portugal
        CPEntry prn1016,prn1017,1016,data1016, NOTLAST ; ISO-7 Norway
        CPEntry prn1017,prn1018,1017,data1017, NOTLAST ; ISO-7 Denmark
        CPEntry prn1018,prn1019,1018,data1018, NOTLAST ; ISO-7 Finland, Sweden
        CPEntry prn1019,prn1020,1019,data1019, NOTLAST ; ISO-7 Belgium, Netherlands
        ;CPEntry prn1020,prn1021,1020,data1020,NOTLAST ; ISO-7 French Canadia variant
        ;CPEntry prn1021,prn1023,1021,data1021,NOTLAST ; ISO-7 Switzerland variant
        CPEntry prn1023,prn1101,1023,data1023, NOTLAST ; ISO-7 Spain variant
        ;CPEntry prn1101,prn1102,1101,data1101,NOTLAST ; ISO-7 British NRC Set
        ;CPEntry prn1102,prn1103,1102,data1102,NOTLAST ; ISO-7 Dutch NRC Set
        ;CPEntry prn1103,prn1104,1103,data1103,NOTLAST ; ISO-7 Finnish NRC Set
        ;CPEntry prn1104,prn1105,1104,data1104,NOTLAST ; ISO-7 French NRC Set
        ;CPEntry prn1105,prn1106,1105,data1105,NOTLAST ; ISO-7 Norwegian/Danish NRC Set
        ;CPEntry prn1106,prn1107,1106,data1106,NOTLAST ; ISO-7 Swedish NRC Set
IF EURO_8501 EQ 1
        ;CPEntry prn1107,prn8501,1107,data1107,NOTLAST ; ISO-7 Norwegian/Danish NRC Set (Alternate)
ELSE
        ;CPEntry prn1107,prn58201,1107,data1107,NOTLAST ; ISO-7 Norwegian/Danish NRC Set (Alternate)
ENDIF
ENDIF

IF EURO_8501 EQ 1
        ; NB. 8501 was just my proposal for the CP 850 variant with EURO SIGN.
        ;     Use CP 858 instead!
        CPEntry prn8501,prn58194,CP8501,data8501,NOTLAST

        ; IBM CDRA level 2 user definable range E000h..EFFFh for CCSIDs:
        ;
        ; NB. IBM CDRA compatible definition for a private variant of CP 850:
        ;     CP 850 = 0352h => E352h = 58194 to be used.
        ;     We use it as an alias to our 8501 Code Page here...

        CPEntry prn58194,prn58201,58194,data58194,NOTLAST ; EURO SIGN at D5h
ENDIF

        ; NB. IBM CDRA compatible definition for the new variant of CP 857:

        CPEntry prn58201,prn58805,58201,data58201,NOTLAST ; EURO SIGN at D5h

        ; NB. IBM CDRA compatible definition for private variants of
        ;     CP 437, 667, 850, 863, 865, 991:
        ;     CP 437 = 01B5h => E1B5h+0400h = E5B5h = 58805
        ;     CP 850 = 0352h => E352h+0400h = E69Bh = 59035 etc.
        ;     We add +0400h for our FreeDOS EUROTSR compatible definitions
        ;     since we better leave the range E000h..E3FFh alone for future
        ;     "official" Code Page variants 0..999 (3E7h).

        CPEntry prn58805,prn59035,58805,data58805,NOTLAST ; 437 with EURO SIGN at 9Fh
        CPEntry prn59035,prn59218,59035,data59035,NOTLAST ; 667 with EURO SIGN at 9Fh
        CPEntry prn59218,prn59231,59218,data59218,NOTLAST ; 850 with EURO SIGN at 9Fh
        CPEntry prn59231,prn59233,59231,data59231,NOTLAST ; 863 with EURO SIGN at 9Fh
        CPEntry prn59233,prn59359,59233,data59233,NOTLAST ; 865 with EURO SIGN at 9Fh
        CPEntry prn59359,prn65280,59359,data59359,NOTLAST ; 991 with EURO SIGN at 9Fh

        ; IBM CDRA level 2 user definable range FF00h..FFFEh for CPGIDs:
        ;
        ; NB. The user definable range of CPGIDs allows to define private
        ;     "Code Pages" to directly address all selection IDs 0..25
        ;     available on the NEC Pinwriters under a specific number
        ;     regardless of any offical Code Page assignments in existence.
        ;     Also added are values to select any of the download or cardridge
        ;     fonts as well as internal type face fonts.
        ;     Please note, that these numbers are specific to NECPINW.CPI
        ;     and the results depend on the model and configuration of the
        ;     NEC Pinwriter controlled by PRINTER.SYS + NECPINW.CPI.
        ;     You must *not* assume that the use of these IDs will produce
        ;     similar char sets on other devices or with other software,
        ;     it may even change with future issues of NECPINW.CPI.

        CPEntry prn65280,prn65281,65280,data65280,NOTLAST ; 7-bit USA (0)
        CPEntry prn65281,prn65282,65281,data65281,NOTLAST ; 7-bit France (1)
        CPEntry prn65282,prn65283,65282,data65282,NOTLAST ; 7-bit Germany (2)
        CPEntry prn65283,prn65284,65283,data65283,NOTLAST ; 7-bit UK (3)
        CPEntry prn65284,prn65285,65284,data65284,NOTLAST ; 7-bit Denmark I (4)
        CPEntry prn65285,prn65286,65285,data65285,NOTLAST ; 7-bit Sweden (5)
        CPEntry prn65286,prn65287,65286,data65286,NOTLAST ; 7-bit Italy (6)
        CPEntry prn65287,prn65288,65287,data65287,NOTLAST ; 7-bit Spain I (7)
        CPEntry prn65288,prn65289,65288,data65288,NOTLAST ; 7-bit Japan (8)
        CPEntry prn65289,prn65290,65289,data65289,NOTLAST ; 7-bit Norway I (9)
        CPEntry prn65290,prn65291,65290,data65290,NOTLAST ; 7-bit Denmark II (10)
        CPEntry prn65291,prn65292,65291,data65291,NOTLAST ; 7-bit Netherlands (11)
        CPEntry prn65292,prn65293,65292,data65292,NOTLAST ; 7-bit Turkey (12)
        CPEntry prn65293,prn65294,65293,data65293,NOTLAST ; 7-bit Spain II (13)
IF DEBUG EQ 1
        CPEntry prn65294,prn65295,65294,data65294,NOTLAST ; 7-bit Latin America (14)
        CPEntry prn65295,prn65296,65295,data65295,NOTLAST ; undefined??? (15)
ELSE
        CPEntry prn65294,prn65296,65294,data65294,NOTLAST ; 7-bit Latin America (14)
ENDIF
        CPEntry prn65296,prn65297,65296,data65296,NOTLAST ; Multilingual 850 (16)
        CPEntry prn65297,prn65298,65297,data65297,NOTLAST ; Portugal 860 (17)
        CPEntry prn65298,prn65299,65298,data65298,NOTLAST ; French Canada 863 (18)
        CPEntry prn65299,prn65300,65299,data65299,NOTLAST ; Norway II 865 (19)
                                                          ;
        CPEntry prn65300,prn65301,65300,data65300,NOTLAST ; EPROM (20)
        CPEntry prn65301,prn65302,65301,data65301,NOTLAST ; EPROM (21)
        CPEntry prn65302,prn65303,65302,data65302,NOTLAST ; EPROM (22)
        CPEntry prn65303,prn65304,65303,data65303,NOTLAST ; EPROM (23)
        CPEntry prn65304,prn65305,65304,data65304,NOTLAST ; EPROM (24)
        CPEntry prn65305,prn65306,65305,data65305,NOTLAST ; EPROM (25)
                                                          ;
        CPEntry prn65306,prn65307,65306,data65306,NOTLAST ; reserved EPROM (26)
        CPEntry prn65307,prn65308,65307,data65307,NOTLAST ; reserved EPROM (27)
        CPEntry prn65308,prn65309,65308,data65308,NOTLAST ; reserved EPROM (28)
        CPEntry prn65309,prn65310,65309,data65309,NOTLAST ; reserved EPROM (29)
        CPEntry prn65310,prn65311,65310,data65310,NOTLAST ; reserved EPROM (30)

IF DEBUG EQ 1
        CPEntry prn65311,prn65344,65311,data65311,NOTLAST ; reserved EPROM (31)
        CPEntry prn65344,prn65392,65344,data65344,NOTLAST ; EPROM (64)
ELSE
        CPEntry prn65311,prn65392,65311,data65311,NOTLAST ; reserved (31)
ENDIF ; DEBUG

        CPEntry prn65392,prn65393,65392,data65392,NOTLAST ; Euro universal
        CPEntry prn65393,prn65394,65393,data65393,NOTLAST ; Euro Draft 10 cpi
        CPEntry prn65394,prn65395,65394,data65394,NOTLAST ; Euro Draft 12 cpi
        CPEntry prn65395,prn65396,65395,data65395,NOTLAST ; Euro Draft HS 12 cpi
        CPEntry prn65396,prn65397,65396,data65396,NOTLAST ; Euro Draft 15
        CPEntry prn65397,prn65398,65397,data65397,NOTLAST ; Euro Draft 17
        CPEntry prn65398,prn65401,65398,data65398,NOTLAST ; Euro Draft 20
        CPEntry prn65401,prn65402,65401,data65401,NOTLAST ; Euro LQ 10 cpi
        CPEntry prn65402,prn65403,65402,data65402,NOTLAST ; Euro LQ 12 cpi
        CPEntry prn65403,prn65404,65403,data65403,NOTLAST ; Euro LQ 15 cpi
        CPEntry prn65404,prn65405,65404,data65404,NOTLAST ; Euro LQ 17
        CPEntry prn65405,prn65408,65405,data65405,NOTLAST ; Euro LQ 20

        CPEntry prn65408,prn65409,65408,data65408,NOTLAST ; Download (default)
        CPEntry prn65409,prn65410,65409,data65409,NOTLAST ; Download 1
        CPEntry prn65410,prn65424,65410,data65410,NOTLAST ; Download 2
                                                          ;
        CPEntry prn65424,prn65425,65424,data65424,NOTLAST ; internal fonts (default)
        CPEntry prn65425,prn65426,65425,data65425,NOTLAST ; external font 1
        CPEntry prn65426,prn65427,65426,data65426,NOTLAST ; external font 2
        CPEntry prn65427,prn65428,65427,data65427,NOTLAST ; external font 3
        CPEntry prn65428,prn65440,65428,data65428,NOTLAST ; external font 4
                                                          ;
        CPEntry prn65440,prn65446,65440,data65440,NOTLAST ; internal font 0
        CPEntry prn65446,prn65452,65446,data65446,NOTLAST ; internal font 6
        CPEntry prn65452,prn65455,65452,data65452,NOTLAST ; internal font 12
        CPEntry prn65455,prn65456,65455,data65455,NOTLAST ; internal font 15
        CPEntry prn65456,prn65458,65456,data65456,NOTLAST ; internal font 16
        CPEntry prn65458,prn65459,65458,data65458,NOTLAST ; internal font 18
        CPEntry prn65459,prn65474,65459,data65459,NOTLAST ; internal font 19
        CPEntry prn65474,prn65490,65474,data65474,NOTLAST ; internal font 34
        CPEntry prn65490,prn65491,65490,data65490,NOTLAST ; internal font 50
        CPEntry prn65491,prn65492,65491,data65491,NOTLAST ; internal font 51
        CPEntry prn65492,prn65493,65492,data65492,NOTLAST ; internal font 52
        CPEntry prn65493,FontDataHeader,65493,data65493,LAST; internal font 53

        CP_COUNT = ENTRY_COUNTER

; #############################################################################

FontDataHeader:

        CPData  data437,data58201,GRAPHICS,ID_0,seq437

        ; IBM CDRA level 2 user definable range E000h..EFFFh for CCSIDs:

                ; (for CP 58194 see CP 65392..CP65405 below)
IF EURO_857 EQ 1
data857:        ; (Similar to CP 857 with EPROM #4 "Turkey"/"CT Turkey" only)
ENDIF
        CPData  data58201,data58805,GRAPHICS,ID_20,seq58201 ; EURO SIGN at D5h Universal
        SetupEuro GRAPHICS,ID_20,QUAL_ANY,CPI_ANY,EURO_CHR_857 ; (same as Draft)

        CPData  data58805,data59035,GRAPHICS,ID_16,seq58805 ; CP 437 variant
        SetupEuro GRAPHICS,ID_0, QUAL_FD,CPI_FD,EURO_CHR_FD ; with EURO SIGN at 9Fh

data59359:                                     ; (with EPROM #8 "Polish" only)
        CPData  data59035,data59218,GRAPHICS,ID_16,seq59035 ; CP 667/991 variant
        SetupEuro GRAPHICS,ID_21,QUAL_FD,CPI_FD,EURO_CHR_FD ; with EURO SIGN at 9Fh

        CPData  data59218,data59231,GRAPHICS,ID_16,seq59218 ; CP 850 variant
        SetupEuro GRAPHICS,ID_16,QUAL_FD,CPI_FD,EURO_CHR_FD ; with EURO SIGN at 9Fh

        CPData  data59231,data59233,GRAPHICS,ID_16,seq59231 ; CP 863 variant
        SetupEuro GRAPHICS,ID_18,QUAL_FD,CPI_FD,EURO_CHR_FD ; with EURO SIGN at 9Fh

        CPData  data59233,data65280,GRAPHICS,ID_16,seq59233 ; CP 865 variant
        SetupEuro GRAPHICS,ID_19,QUAL_FD,CPI_FD,EURO_CHR_FD ; with EURO SIGN at 9Fh

        ; IBM CDRA level 2 user definable range FF00h..FFFEh for CPGIDs:

data367:        ; ISO-646 7-bit ASCII (US)
;data1009:
        CPData  data65280,data65281,ITALICS,ID_0,seq65280  ; 7-bit USA (0)
;data1010:
        CPData  data65281,data65282,ITALICS,ID_1,seq65281  ; 7-bit France (1)
data1011:
        CPData  data65282,data65283,ITALICS,ID_2,seq65282  ; 7-bit Germany (2)
;data1013:
        CPData  data65283,data65284,ITALICS,ID_3,seq65283  ; 7-bit UK (3)
;data1017:
        CPData  data65284,data65285,ITALICS,ID_4,seq65284  ; 7-bit Denmark I (4)
;data1018:
        CPData  data65285,data65286,ITALICS,ID_5,seq65285  ; 7-bit Sweden (5)
;data1012:
        CPData  data65286,data65287,ITALICS,ID_6,seq65286  ; 7-bit Italy (6)
;data1014:
        CPData  data65287,data65288,ITALICS,ID_7,seq65287  ; 7-bit Spain I (7)
        CPData  data65288,data65289,ITALICS,ID_8,seq65288  ; 7-bit Japan (8)
;data1016:
        CPData  data65289,data65290,ITALICS,ID_9,seq65289  ; 7-bit Norway I (9)
        CPData  data65290,data65291,ITALICS,ID_10,seq65290 ; 7-bit Denmark II (10)
;data1019:
        CPData  data65291,data65292,ITALICS,ID_11,seq65291 ; 7-bit Netherlands (11)
        CPData  data65292,data65293,ITALICS,ID_12,seq65292 ; 7-bit Turkey (12)
;data1023:
        CPData  data65293,data65294,ITALICS,ID_13,seq65293 ; 7-bit Spain II (13)

IF DEBUG EQ 1
        CPData  data65294,data65295,ITALICS,ID_14,seq65294  ; 7-bit Latin America (14)
        CPData  data65295,data65296,GRAPHICS,ID_15,seq65295 ; not used??? (15)
ELSE
        CPData  data65294,data65296,ITALICS,ID_14,seq65294  ; 7-bit Latin America (14)
ENDIF

IF NOT EURO_850 EQ 1
data850:        ; CP 850
ENDIF
        CPData  data65296,data65297,GRAPHICS,ID_16,seq65296 ; Multilingual (16)

data860:        ; CP 860
        CPData  data65297,data65298,GRAPHICS,ID_17,seq65297 ; Portugal (17)

data863:        ; CP 863
        CPData  data65298,data65299,GRAPHICS,ID_18,seq65298 ; French Canada (18)

data865:        ; CP 865
        CPData  data65299,data65300,GRAPHICS,ID_19,seq65299 ; Norway II (19)

data737:        ; (Similar to CP 737 with EPROM #3 "Greek" only)
data852:        ; CP 852 with EPROMs #2 "East Europe", #5/#6 "Code Tables",
                ; #7 "Hungaria", #8 "Polish"
data853:        ; (Similar to CP 853 with EPROM #4 "Turkey"/"CT Turkey" only)
IF NOT EURO_857 EQ 1
data857:       ; (Similar to CP 857 with EPROM #4 "Turkey"/"CT Turkey" only)
ENDIF
        CPData  data65300,data65301,GRAPHICS,ID_20,seq65300 ; EPROM (20)

data667:        ; CP 667 "Mazovia" with EPROM #8 "Polish" only
IF NOT EPROM_NO EQ 1
data866:        ; CP 866 with EPROMs #5/#6 "Code Tables" only
ENDIF
data991:        ; CP 991 "Mazovia" with EPROM #8 "Polish" only
        CPData  data65301,data65302,GRAPHICS,ID_21,seq65301 ; EPROM (21)

IF EPROM_NO EQ 1
data866:        ; CP 866 with EPROM #1 "Russian" only
ELSE
data855:        ; CP 855 with EPROMs #5/#6 "Code Tables" only
ENDIF
        CPData  data65302,data65303,GRAPHICS,ID_22,seq65302 ; EPROM (22)

data867:        ; (Probably CP 867 "Czech/Kamenicky" with EPROM #2 "East Europe" only)
data895:        ; (CP 896 used by Wordperfect, Arachne, KEYBCS, although conflictive
                ; with IBM CDRA level 2!)
        CPData  data65303,data65304,GRAPHICS,ID_23,seq65303 ; EPROM (23)

IF EPROM_NO EQ 1
data855:        ; CP 855 with EPROM #1 "Russian" only
ENDIF
        CPData  data65304,data65305,GRAPHICS,ID_24,seq65304 ; EPROM (24)
        CPData  data65305,data65306,GRAPHICS,ID_25,seq65305 ; EPROM (25)
                                                            ;
        CPData  data65306,data65307,GRAPHICS,ID_26,seq65306 ; reserved EPROM (26)
        CPData  data65307,data65308,GRAPHICS,ID_27,seq65307 ; reserved EPROM (27)
        CPData  data65308,data65309,GRAPHICS,ID_28,seq65308 ; reserved EPROM (28)
        CPData  data65309,data65310,GRAPHICS,ID_29,seq65309 ; reserved EPROM (29)
        CPData  data65310,data65311,GRAPHICS,ID_30,seq65310 ; reserved EPROM (30)

IF DEBUG EQ 1
        CPData  data65311,data65344,GRAPHICS,ID_31,seq65311 ; reserved EPROM (31)
        CPData  data65344,data65392,GRAPHICS,ID_64,seq65344 ; not used??? (64)
ELSE
        CPData  data65311,data65392,GRAPHICS,ID_31,seq65311 ; reserved EPROM (31)
ENDIF

IF EURO_STYLE EQ 0
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data858:        ; CP 858
IF EURO_8501 EQ 1
data8501:       ; Multilingual, Latin I with EURO SIGN
data58194:      ; alternative code in the user definable CCSID range
ENDIF
ENDIF
        CPData  data65392,data65393,GRAPHICS,ID_16,seq65392 ; EURO SIGN at D5h Universal
        SetupEuro GRAPHICS,ID_16,QUAL_ANY,CPI_ANY,EURO_CHR_850 ; (same as Draft)

IF EURO_STYLE EQ 1
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data858:        ; CP 858
IF EURO_8501 EQ 1
data8501:       ; Multilingual, Latin I with EURO SIGN
data58194:      ; alternative code in the user definable CCSID range
ENDIF
ENDIF
        CPData  data65393,data65394,GRAPHICS,ID_16,seq65393 ; EURo SIGN at D5h in Draft
        SetupEuro GRAPHICS,ID_16,QUAL_DRAFT,CPI_10,EURO_CHR_850 ; 10 cpi (Pica)

IF EURO_STYLE EQ 2
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data858:        ; CP 858
IF EURO_8501 EQ 1
data8501:       ; Multilingual, Latin I with EURO SIGN
data58194:      ; alternative code in the user definable CCSID range
ENDIF
ENDIF
        CPData  data65394,data65395,GRAPHICS,ID_16,seq65394 ; EURO SIGN at D5h in Draft
        SetupEuro GRAPHICS,ID_16,QUAL_DRAFT,CPI_12,EURO_CHR_850 ; 12 cpi (Elite)

IF EURO_STYLE EQ 3
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data858:        ; CP 858
IF EURO_8501 EQ 1
data8501:       ; Multilingual, Latin I with EURO SIGN
data58194:      ; alternative code in the user definable CCSID range
ENDIF
ENDIF
        CPData  data65395,data65396,GRAPHICS,ID_16,seq65395 ; EURO SIGN at D5h in Draft HS
        SetupEuro GRAPHICS,ID_16,QUAL_DRAFT,CPI_12HS,EURO_CHR_850 ; 12 cpi (Elite)

IF EURO_STYLE EQ 4
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data858:        ; CP 858
IF EURO_8501 EQ 1
data8501:       ; Multilingual, Latin I with EURO SIGN
data58194:      ; alternative code in the user definable CCSID range
ENDIF
ENDIF
        CPData  data65396,data65397,GRAPHICS,ID_16,seq65396 ; EURO SIGN at D5h in Draft
        SetupEuro GRAPHICS,ID_16,QUAL_DRAFT,CPI_15,EURO_CHR_850 ; 15 cpi (Micro)

IF EURO_STYLE EQ 5
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data858:        ; CP 858
IF EURO_8501 EQ 1
data8501:       ; Multilingual, Latin I with EURO SIGN
data58194:      ; alternative code in the user definable CCSID range
ENDIF
ENDIF
        CPData  data65397,data65398,GRAPHICS,ID_16,seq65397 ; EURO SIGN at D5h in Draft
        SetupEuro GRAPHICS,ID_16,QUAL_DRAFT,CPI_17,EURO_CHR_850 ; 17 cpi (Pica+Condensed)

IF EURO_STYLE EQ 6
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data858:        ; CP 858
IF EURO_8501 EQ 1
data8501:       ; Multilingual, Latin I with EURO SIGN
data58194:      ; alternative code in the user definable CCSID range
ENDIF
ENDIF
        CPData  data65398,data65401,GRAPHICS,ID_16,seq65398 ; EURO SIGN at D5h in Draft
        SetupEuro GRAPHICS,ID_16,QUAL_DRAFT,CPI_20,EURO_CHR_850 ; 20 cpi (Elite+Condensed)

IF EURO_STYLE EQ 9
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data858:        ; CP 858
IF EURO_8501 EQ 1
data8501:       ; Multilingual, Latin I with EURO SIGN
data58194:      ; alternative code in the user definable CCSID range
ENDIF
ENDIF
        CPData  data65401,data65402,GRAPHICS,ID_16,seq65401 ; EURO SIGN at D5h in LQ
        SetupEuro GRAPHICS,ID_16,QUAL_LQ,CPI_10,EURO_CHR_850; 10 cpi (Pica)

IF EURO_STYLE EQ 10
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data858:        ; CP 858
IF EURO_8501 EQ 1
data8501:       ; Multilingual, Latin I with EURO SIGN
data58194:      ; alternative code in the user definable CCSID range
ENDIF
ENDIF
        CPData  data65402,data65403,GRAPHICS,ID_16,seq65402 ; EURO SIGN at D5h in LQ
        SetupEuro GRAPHICS,ID_16,QUAL_LQ,CPI_12,EURO_CHR_850; 12 cpi (Elite)

IF EURO_STYLE EQ 11
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data858:        ; CP 858
IF EURO_8501 EQ 1
data8501:       ; Multilingual, Latin I with EURO SIGN
data58194:      ; alternative code in the user definable CCSID range
ENDIF
ENDIF
        CPData  data65403,data65404,GRAPHICS,ID_16,seq65403 ; EURO SIGN at D5h in LQ
        SetupEuro GRAPHICS,ID_16,QUAL_LQ,CPI_15,EURO_CHR_850; 15 cpi (Micro)

IF EURO_STYLE EQ 12
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data858:        ; CP 858
IF EURO_8501 EQ 1
data8501:       ; Multilingual, Latin I with EURO SIGN
data58194:      ; alternative code in the user definable CCSID range
ENDIF
ENDIF
        CPData  data65404,data65405,GRAPHICS,ID_16,seq65404 ; EURO SIGN at D5h in LQ
        SetupEuro GRAPHICS,ID_16,QUAL_LQ,CPI_17,EURO_CHR_850; 17 cpi (Pica+Condensed)

IF EURO_STYLE EQ 13
IF EURO_850 EQ 1
data850:        ; CP 850
ENDIF
data858:        ; CP 858
IF EURO_8501 EQ 1
data8501:       ; Multilingual, Latin I with EURO SIGN
data58194:      ; alternative code in the user definable CCSID range
ENDIF
ENDIF
        CPData  data65405,data65408,GRAPHICS,ID_16,seq65405 ; EURO SIGN at D5h in LQ
        SetupEuro GRAPHICS,ID_16,QUAL_LQ,CPI_20,EURO_CHR_850; 20 cpi (Elite+Condensed)

        CPData  data65408,data65409,GRAPHICS,ID_0,seq65408  ; Download
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. Not supported by P20/P30, P22Q/P32Q.
        db      ESC_,'%',1              ; select (last) download char set

        CPData  data65409,data65410,GRAPHICS,ID_0,seq65409  ; Download 1
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. Not supported by P20/P30, P22Q/P32Q.
        db      ESC_,'%',1              ; select download char set
        db      FS_,'X',0               ; select download char set 1
                                        ; NB. Not supported by P5XL, P9XL,
                                        ;     P6/P7, CP6/CP7, P2200, P2plus,
                                        ;     P20/P30, P22Q/P32Q.

        CPData  data65410,data65424,GRAPHICS,ID_0,seq65410  ; Download 2
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. Not supported by P20/P30,
                                        ;     P22Q/P32Q.
        db      ESC_,'%',1              ; select download char set
        ;db     FS_,'W',0               ; select 2*128 instead of 1*256
                                        ; NB. I disabled this because I
                                        ;     haven't tested yet, if this would
                                        ;     delete the DL buffer, if we're
                                        ;     already in 2*128 mode.  If not,
                                        ;     we should put it back in...
        db      FS_,'X',1               ; select download char set 2
                                        ; NB. Not supported by P5XL, P9XL,
                                        ;     P6/P7, CP6/CP7, P2200, P2plus,
                                        ;     P20/P30, P22Q/P32Q.

        CPData  data65424,data65425,GRAPHICS,ID_0,seq65424  ; Internal fonts
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. Not supported by P20/P30, P22Q/P32Q.

        CPData  data65425,data65426,GRAPHICS,ID_0,seq65425  ; Cardridge font 1
        db      FS_,'C',1               ; select external font 1
                                        ; NB. Not supported by P20/P30, P22Q/P32Q.

        CPData  data65426,data65427,GRAPHICS,ID_0,seq65426  ; Cardridge font 2
        db      FS_,'C',2               ; select external font 2
                                        ; NB. Not supported by P20/P30, P22Q/P32Q.

        CPData  data65427,data65428,GRAPHICS,ID_0,seq65427  ; Cardridge font 3
        db      FS_,'C',3               ; select external font 3
                                        ; NB. Not supported by P20/P30, P22Q/P32Q.

        CPData  data65428,data65440,GRAPHICS,ID_0,seq65428  ; Cardridge font 4
        db      FS_,'C',4               ; select external font 4
                                        ; NB. Not supported by P20/P30, P22Q/P32Q.

        CPData  data65440,data65446,GRAPHICS,ID_0,seq65440 ; Internal font 0
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. Not supported by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_COURIER_10  ; select "Courier 10"
                                        ; NB. Not supported by P5XL, P9XL,
                                        ;     P6/P7, CP6/CP7.

        CPData  data65446,data65452,GRAPHICS,ID_0,seq65446 ; Internal font 6
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. Not supported by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_SUPERFOCUS  ; select "Super Focus"
                                        ; NB. Not supported by P5XL, P9XL,
                                        ;     P6/P7, CP6/CP7.

        CPData  data65452,data65455,GRAPHICS,ID_0,seq65452 ; Internal font 12
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. Not supported by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_OCR_B       ; select "OCR-B"
                                        ; NB. Not supported by P5XL, P9XL,
                                        ;     P6/P7, CP6/CP7.

        CPData  data65455,data65456,GRAPHICS,ID_0,seq65455 ; Internal font 15
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. Not supported by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_ITCSOUVENIR_10; select "ITC Souvenir 10"
                                        ; NB. Not supported by P5XL, P9XL,
                                        ;     P6/P7, CP6/CP7.

        CPData  data65456,data65458,GRAPHICS,ID_0,seq65456 ; Internal font 16
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. Not supported by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_HELVETICA_10PT; select "Helvetica/Helvette 10 PT"
                                        ; NB. Not supported by P5XL, P9XL,
                                        ;     P6/P7, CP6/CP7.
        ;db     ESC_,'p',1              ; Proportional on

        CPData  data65458,data65459,GRAPHICS,ID_0,seq65458 ; Internal font 18
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. Not supported by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_TIMES_10PT  ; select "Times 10 PT"
                                        ; NB. Not supported by P5XL, P9XL,
                                        ;     P6/P7, CP6/CP7.
        ;db     ESC_,'p',1              ; Proportional on

        CPData  data65459,data65474,GRAPHICS,ID_0,seq65459 ; Internal font 19
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. Not supported by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_NEWPRESTIGEELITE_12WP; select "New Prestige Elite 12 WP"
                                        ; NB. Not supported by P5XL, P9XL,
                                        ;     P6/P7, CP6/CP7.
        ;db     ESC_,'p',1              ; Proportional on

        CPData  data65474,data65490,GRAPHICS,ID_0,seq65474 ; Internal font 34
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. Not supported by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_BOLD_PS     ; select "Bold PS"
                                        ; NB. Not supported by P5XL, P9XL,
                                        ;     P6/P7, CP6/CP7.

        CPData  data65490,data65491,GRAPHICS,ID_0,seq65490 ; Internal font 50
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. Not supported by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_FASTFOCUS_10; select "Fast Focus 10"
                                        ; NB. Not supported by P5XL, P9XL,
                                        ;     P6/P7, CP6/CP7.

        CPData  data65491,data65492,GRAPHICS,ID_0,seq65491 ; Internal font 51
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. Not supported by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_FASTFOCUS_12; select "Fast Focus 12"
                                        ; NB. Not supported by P5XL, P9XL,
                                        ;     P6/P7, CP6/CP7.

        CPData  data65492,data65493,GRAPHICS,ID_0,seq65492 ; Internal font 52
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. Not supported by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_QUICKGOTHIC_10; select "Quick Gothic 10"
                                        ; NB. Not supported by P5XL, P9XL,
                                        ;     P6/P7, CP6/CP7.

        CPData  data65493,Footer,GRAPHICS,ID_0,seq65493 ; Internal font 53
        db      FS_,'C',0               ; select internal fonts
                                        ; NB. Not supported by P20/P30, P22Q/P32Q.
        db      ESC_,'x',1              ; select LQ
        db      ESC_,'k',TF_QUICKGOTHIC_12; select "Quick Gothic 12"
                                        ; NB. Not supported by P5XL, P9XL, P6/P7, CP6/CP7.

; #############################################################################

Footer:

; NB. The VeRsIoN=, CoPyRiGhT=, NaMe SeRvIcE=, and VeRsIoN#= tags are
; compatible with the Novell / Caldera / Lineo VERSION utility.  (Novell
; also uses a number of other tags.)  The LaNgUaGe=, SeRiAlNuMbEr=,
; LiCeNsE=, and AuThOrS= tags are my own proposals, but at least the first
; two are already used in some of the DR-DOS files.  Do not change the
; standardized format of these strings.

        db      CR,LF
        db      "------------------------------------------------------------------------------",CR,LF
        db      FILE_NAME_MSG, " VeRsIoN=", VERSION_MSG, " (", ISO_DATE_MSG, ")",NUL,CR,LF
        ;db     "VeRsIoN#=", followed by 3 DWORDs for mainver,subver, and revision
        db      "CoPyRiGhT=(C) 1996-", LONG_YEAR_MSG, " by Matthias Paul, Ubierstrasse 28, D-50321 Bruehl",NUL,CR,LF
IF CPI_STYLE EQ 1
        db      "NaMe SeRvIcE=",FILE_NAME_MSG,' DOS Code Page Information file ("EPS") for',CR,LF
ELSEIF CPI_STYLE EQ 2
        db      "NaMe SeRvIcE=",FILE_NAME_MSG,' DOS Code Page Information file ("4201") for',CR,LF
ELSEIF CPI_STYLE EQ 3
        db      "NaMe SeRvIcE=",FILE_NAME_MSG,' DOS Code Page Information file ("NECPINW") for',CR,LF
ELSE
        db      "NaMe SeRvIcE=",FILE_NAME_MSG,' DR-DOS Code Page Information file ("1050") for',CR,LF
ENDIF
        db      "NEC Pinwriter series",NUL,CR,LF
        db      "LaNgUaGe=International (1)",NUL,CR,LF
        db      "LiCeNsE=GNU General Public License 2 (or at your option any later version):",CR,LF
        db      "This is free software that comes with ABSOLUTELY NO WARRANTY. You are welcome",CR,LF
        db      "to redistribute it under certain conditions. Refer to the GNU GPL license file",CR,LF
        db      "you should have received along with ",FILE_NAME_MSG," (see also http://www.gnu.org",CR,LF
        db      "or http://www.fsf.org/copyleft/gpl.htm).",NUL,CR,LF
        ;db     "SeRiAlNuMbEr=XXXX-0000-654321",NUL,CR,LF
        ;db     "AuThOrS=Matthias Paul, ...",NUL,CR,LF
        db      "------------------------------------------------------------------------------",CR,LF
        db      "mailto:<Matthias.Paul@post.rwth-aachen.de>,<mrpaul@epost.de>,<mpaul@drdos.org>",CR,LF
        db      "http://www.uni-bonn.de/~uzs180/mpdokeng.html,http://mpaul.drdos.org/",CR,LF
        db      "------------------------------------------------------------------------------",CR,LF
        db      FILE_NAME_MSG, " provides Code Page switching support for the IBM Code Pages",CR,LF
        db      "367 (7-bit ISO-646-US, ASCII), 437 (International, Western Europe, IBM-2,",CR,LF
        db      "PC-8, World Trade Set), 850 (Multilingual, Latin I), 860 (Portuguese),",CR,LF
        db      "863 (French Canadian), 865 (Nordic, Norway II), and 1011 (7-bit ISO-7 German)",CR,LF
        db      "with the NEC Pinwriters P5200/P5300 (P6plus/P7plus), P3200/P3300 (P20/P30),",CR,LF
        db      "P6200/P6300 (P60/P70), P9300 (P90), P22Q/P32Q, P7200/P7300 (P62/P72), P3800/",CR,LF
        db      "P3900 (P42Q/P52Q), P8000 (P72X), and other compatible printer models.",CR,LF
        db      "Except for the Pinwriters P5200/P5300 (P6plus/P7plus), they optionally support",CR,LF
        db      "Code Pages 667/991 (Polish, Mazovia), 852 (Slavic, Eastern Europe, Latin II),",CR,LF
        db      "855 (Cyrillic I), 866 (Russian, Cyrillic II), and 867/895 (Czech, Kamenicky),",CR,LF
        db      "if the appropriate font EPROM is installed. Printers configured to support a",CR,LF
        db      "256 char download font can also make use of Code Page 858/8501 (Multilingual",CR,LF
        db      "with EURO SIGN) in LQ 10 cpi (Pica) mode. Please refer to the documentation",CR,LF
        db      "to learn about a large set of other character sets available with ",FILE_NAME_MSG,".",CR,LF
        db      "The Pinwriters P2200 and P2200XE (P2plus) do not support Code Page switching,",CR,LF
        db      "therefore are supported for Code Pages 367, 437, and 1011 only. The Pinwriters",CR,LF
        db      "P2/P3, CP2/CP3, P5 (P530, P560, P565), P5XL (P530XL/P535XL, P550XL/P555XL,",CR,LF
        db      "P560XL/P565XL, P5 Coax), P9XL, P6/P7 (P660/P760, P665/P765), and CP6/CP7",CR,LF
        db      "(CP660/CP760, CP665/CP765) are not supported at all.",CR,LF
IF CPI_STYLE EQ 1
        db      'For compatibility reasons this file pretends to be an "EPS" style file for',CR,LF
        db      "Epson ESC/P printers, while it actually supports the range of NEC Pinwriter by",CR,LF
        db      "replacing the original EPS.CPI file shipping with PC DOS 6.1 and 6.3. It is",CR,LF
        db      "designed for use with PRINTER.SYS of PC DOS 6.1+. You may need to patch the",CR,LF
        db      "file for use with MS-DOS. An issue for DR DOS 6.0+ is available.",CR,LF
ELSEIF CPI_STYLE EQ 2
        db      'For compatibility reasons this file pretends to be an "4201" style file for',CR,LF
        db      "IBM Proprinter II & III Model 4201 & XL Model 4202 printers, while it actually",CR,LF
        db      "supports the NEC Pinwriter series by replacing the original 4201.CPI file",CR,LF
        db      "shipping with MS-DOS/PC DOS or DR DOS. An issue optimized for DR DOS 6.0+ is",CR,LF
        db      "also available.",CR,LF
ELSEIF CPI_STYLE EQ 3
        db      "This file is designed to be used under a future DR-DOS 7+ and/or FreeDOS.",CR,LF
        db      "It is not supported by any currently available DOS. An optimized issue for",CR,LF
        db      "DR DOS 6.0+ is also available.",CR,LF
ELSE
        db      'For compatibility reasons this printer Code Page file pretends to be a "1050"',CR,LF
        db      "style file for the Epson FX-850/FX-1050 printers, while it actually supports",CR,LF
        db      "the NEC Pinwriter series by replacing the original 1050.CPI file. It is",CR,LF
        db      'designed for use with PRINTER.SYS of DR DOS 6.0, (DR PalmDOS), "Panther" &',CR,LF
        db      '"StarTrek", Novell DOS 7, Caldera OpenDOS 7.01, DR-OpenDOS 7.02, and DR-DOS',CR,LF
        db      "7.02-7.05. You need to patch the file for use with MS-DOS or PC DOS or with",CR,LF
        db      "older issues of DR DOS.",CR,LF
ENDIF
        db      "------------------------------------------------------------------------------",CR,LF
        db      "Installation (for country 49 (Germany), Code Pages 437 and 850, here):",CR,LF
        db      CR,LF
        db      "  CONFIG.SYS:",CR,LF
IF CPI_STYLE EQ 1
        db      "    COUNTRY=49,437,...\COUNTRY.SYS",CR,LF
        db      "    DEVICE|DEVICEHIGH=...\PRINTER.SYS PRN=(EPS,999,2)",CR,LF
ELSEIF CPI_STYLE EQ 2
        db      "    COUNTRY=49,437,...\COUNTRY.SYS",CR,LF
        db      "    DEVICE|DEVICEHIGH=...\PRINTER.SYS PRN=(4201,999,2)",CR,LF
ELSEIF CPI_STYLE EQ 3
        db      "    COUNTRY=49,437,...\COUNTRY.SYS",CR,LF
        db      "    DEVICE|DEVICEHIGH|HIDEVICE=...\PRINTER.SYS PRN=(1050,999,2)",CR,LF
ELSE
        db      "    COUNTRY=49,437,C:\DRDOS\COUNTRY.SYS",CR,LF
        db      "    DEVICE|HIDEVICE|DEVICEHIGH=C:\DRDOS\PRINTER.SYS PRN=(1050,999,2)",CR,LF
ENDIF
        db      CR,LF
        db      "  AUTOEXEC.BAT:",CR,LF
IF CPI_STYLE EQ 0
        db      "    MODE PRN: CODEPAGE PREPARE=((437,850) C:\DRDOS\",FILE_NAME_MSG,")",CR,LF
        db      "    [HILOAD|LH] NLSFUNC C:\DRDOS\COUNTRY.SYS",CR,LF
ELSE
        db      "    MODE PRN: CODEPAGE PREPARE=((437,850) ...\",FILE_NAME_MSG,")",CR,LF
        db      "    [LH] NLSFUNC ...\COUNTRY.SYS",CR,LF
ENDIF
        db      "    CHCP 437",CR,LF
        db      "    REM MODE PRN: CODEPAGE SELECT=850",CR,LF
        db      CR,LF
        db      "Please refer to DOS user manuals (or my NWDOSTIP.TXT documentation - part of",CR,LF
        db      "my MPDOSTIP.ZIP tips & tricks collection) for more info on how to install",CR,LF
        db      "Code Page support. Also, look out for CPI???.ZIP for my .CPI file decompiler.",CR,LF
        db      "------------------------------------------------------------------------------",CR,LF
        db      CTLZ

; #############################################################################

Code Ends
END NECPINW_CPI

; End of file                           ; P
