/*
    JPC: A x86 PC Hardware Emulator for a pure Java Virtual Machine
    Release Version 2.0

    A project from the Physics Dept, The University of Oxford

    Copyright (C) 2007 Isis Innovation Limited

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 as published by
    the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 
    Details (including contact information) can be found at: 

    www.physics.ox.ac.uk/jpc
*/

package org.jpc.sourcecompiler;

 public interface RealModeUBlockSource { 
static final String MEM_RESET = "{ addr0 = 0; seg0 = null; }";
static final String ADDR_MASK16 = "{ addr0 &= 0xffff; }";
static final String EIP_UPDATE = "{ if (!eipUpdated) {eipUpdated = true; cpu.eip += getX86Length(); } }"  ;
static final String ADDR_IB = "{ addr0 += ((byte)microcodes[position++]); }";
static final String PUSH_O16_A16 = "{ {	if (((cpu.esp & 0xffff) < 2) && ((cpu.esp & 0xffff) > 0))	    throw exceptionSS;		int offset = (cpu.esp - 2) & 0xffff;	cpu.ss.setWord(offset, ((short)reg0));	cpu.esp = (cpu.esp & ~0xffff) | offset;      }}";
static final String LOAD_SEG_SS = "{ seg0 = cpu.ss; }";
static final String LOAD0_AX = "{ reg0 = cpu.eax & 0xffff; }";
static final String ADDR_BP = "{ addr0 += ((short)cpu.ebp); }";
static final String LOAD0_IB = "{ reg0 = microcodes[position++] & 0xff; }";
static final String LOAD0_MEM_WORD = "{  reg0 = 0xffff & seg0.getWord(addr0); }";
static final String STORE1_ESP = "{ cpu.esp = reg1; }";
static final String POP_O16_A16 = "{		reg1 = (cpu.esp & ~0xffff) | ((cpu.esp + 2) & 0xffff);				if ((microcodes[position] == STORE0_SS)) 			    cpu.eflagsInterruptEnable = false;			reg0 = cpu.ss.getWord(cpu.esp & 0xffff); 		}";
static final String STORE0_AX = "{ cpu.eax = (cpu.eax & ~0xffff) | (reg0 & 0xffff); }";
static final String LOAD0_IW = "{ reg0 = microcodes[position++] & 0xffff; }";
static final String LOAD_SEG_DS = "{ seg0 = cpu.ds; }";
static final String STORE0_BX = "{ cpu.ebx = (cpu.ebx & ~0xffff) | (reg0 & 0xffff); }";
static final String SUB = "{ reg2 = reg0; reg0 = reg2 - reg1; }";
static final String STORE0_BP = "{ cpu.ebp = (cpu.ebp & ~0xffff) | (reg0 & 0xffff); }";
static final String ADDR_BX = "{ addr0 += ((short)cpu.ebx); }";
static final String LOAD0_SP = "{ reg0 = cpu.esp & 0xffff; }";
static final String ADD = "{ reg2 = reg0; reg0 = reg2 + reg1; }";
static final String STORE0_MEM_WORD = "{  seg0.setWord(addr0, (short)reg0); }";
static final String LOAD0_MEM_BYTE = "{  reg0 = 0xff & seg0.getByte(addr0); }";
static final String JNZ_O8 = "{ {	if (!cpu.getZeroFlag()) {	cpu.eip += (((byte)reg0));	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= (((byte)reg0));            throw exceptionGP;        }}}}";
static final String STORE0_AL = "{ cpu.eax = (cpu.eax & ~0xff) | (reg0 & 0xff); }";
static final String LOAD0_BX = "{ reg0 = cpu.ebx & 0xffff; }";
static final String LOAD1_IB = "{ reg1 = microcodes[position++] & 0xff; }";
static final String LOAD1_IW = "{ reg1 = microcodes[position++] & 0xffff; }";
static final String CALL_O16_A16 = "{ {	if (((cpu.esp & 0xffff) < 2) && ((cpu.esp & 0xffff) > 0))	    throw exceptionSS;	int offset = (cpu.esp - 2) & 0xffff;	cpu.ss.setWord(offset, (short)cpu.eip);	cpu.esp = (cpu.esp & 0xffff0000) | offset;	cpu.eip = (cpu.eip + ((short)reg0)) & 0xffff;}}";
static final String STORE0_CX = "{ cpu.ecx = (cpu.ecx & ~0xffff) | (reg0 & 0xffff); }";
static final String LOAD0_CX = "{ reg0 = cpu.ecx & 0xffff; }";
static final String LOAD0_BP = "{ reg0 = cpu.ebp & 0xffff; }";
static final String RET_O16_A16 = "{ {	/* TODO:  supposed to throw SS exception*/	/* \"if top 6 bytes of stack not within stack limits\"*/	cpu.eip = cpu.ss.getWord(cpu.esp & 0xffff) & 0xffff;	cpu.esp = (cpu.esp & ~0xffff) | ((cpu.esp + 2) & 0xffff);}}";
static final String STORE0_SP = "{ cpu.esp = (cpu.esp & ~0xffff) | (reg0 & 0xffff); }";
static final String LOAD0_AL = "{ reg0 = cpu.eax & 0xff; }";
static final String ADD_O16_FLAGS = "{ {	{        cpu.setZeroFlag((short)((reg0)));        cpu.setParityFlag(((reg0)));	cpu.setSignFlag((short)((reg0)));	cpu.setCarryFlag(((reg0)), Processor.CY_TWIDDLE_FFFF);	cpu.setAuxiliaryCarryFlag(( ( reg2)), ( ( reg1)), ((reg0)), Processor.AC_XOR);}	cpu.setOverflowFlag((reg0), ( reg2) , ( reg1), Processor.OF_ADDSUB_SHORT);}}";
static final String SUB_O16_FLAGS = "{ {	{        cpu.setZeroFlag((short)((reg0)));        cpu.setParityFlag(((reg0)));	cpu.setSignFlag((short)((reg0)));	cpu.setCarryFlag(((reg0)), Processor.CY_TWIDDLE_FFFF);	cpu.setAuxiliaryCarryFlag(( ( reg2)), ( ( reg1)), ((reg0)), Processor.AC_XOR);}	cpu.setOverflowFlag(( reg2), (reg0), ( reg1), Processor.OF_ADDSUB_SHORT);}}";
static final String STORE0_DS = "{ cpu.ds.setSelector(0xffff & reg0); }";
static final String LOAD0_DX = "{ reg0 = cpu.edx & 0xffff; }";
static final String BITWISE_FLAGS_O8 = "{ {        cpu.setOverflowFlag(false);        cpu.setCarryFlag(false);        cpu.setZeroFlag(((byte)reg0));        cpu.setParityFlag(((byte)reg0));	cpu.setSignFlag(((byte)reg0));}}";
static final String STORE0_SI = "{ cpu.esi = (cpu.esi & ~0xffff) | (reg0 & 0xffff); }";
static final String XOR = "{ reg0 ^= reg1; }";
static final String STORE0_DX = "{ cpu.edx = (cpu.edx & ~0xffff) | (reg0 & 0xffff); }";
static final String ADDR_SI = "{ addr0 += ((short)cpu.esi); }";
static final String SUB_O8_FLAGS = "{  {	{        cpu.setZeroFlag((byte)((reg0)));        cpu.setParityFlag(((reg0)));	cpu.setSignFlag((byte)((reg0)));	cpu.setCarryFlag(((reg0)), Processor.CY_TWIDDLE_FF);	cpu.setAuxiliaryCarryFlag(( ( reg2)), ( ( reg1)), ((reg0)), Processor.AC_XOR);}	cpu.setOverflowFlag(( reg2), (reg0), ( reg1), Processor.OF_ADDSUB_BYTE);}}";
static final String JZ_O8 = "{  {	if (cpu.getZeroFlag()) {	cpu.eip += (((byte)reg0));	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= (((byte)reg0));            throw exceptionGP;        }}}}";
static final String LOAD0_AH = "{ reg0 = (cpu.eax >> 8) & 0xff; }";
static final String STORE0_DI = "{ cpu.edi = (cpu.edi & ~0xffff) | (reg0 & 0xffff); }";
static final String LOAD0_SI = "{ reg0 = cpu.esi & 0xffff; }";
static final String ADDR_IW = "{ addr0 += ((short)microcodes[position++]); }";
static final String BITWISE_FLAGS_O16 = "{ {        cpu.setOverflowFlag(false);        cpu.setCarryFlag(false);        cpu.setZeroFlag(((short)reg0));        cpu.setParityFlag(((short)reg0));	cpu.setSignFlag(((short)reg0));}}";
static final String LOAD0_DS = "{ reg0 = 0xffff & cpu.ds.getSelector(); }";
static final String LOAD1_MEM_WORD = "{  reg1 = 0xffff & seg0.getWord(addr0); }";
static final String LOAD0_DI = "{ reg0 = cpu.edi & 0xffff; }";
static final String INC = "{ reg0++; }";
static final String STORE0_ES = "{ cpu.es.setSelector(0xffff & reg0); }";
static final String INC_O16_FLAGS = "{ {        cpu.setZeroFlag(((short)reg0));        cpu.setParityFlag(((short)reg0));	cpu.setSignFlag(((short)reg0));        cpu.setOverflowFlag(((short)reg0), Processor.OF_MIN_INT);        cpu.setAuxiliaryCarryFlag(((short)reg0), Processor.AC_LNIBBLE_ZERO);}}";
static final String AND = "{ reg0 &= reg1; }";
static final String STORE0_BH = "{ cpu.ebx = (cpu.ebx & ~0xff00) | ((reg0 << 8) & 0xff00); }";
static final String LOAD_SEG_ES = "{ seg0 = cpu.es; }";
static final String STORE0_AH = "{ cpu.eax = (cpu.eax & ~0xff00) | ((reg0 << 8) & 0xff00); }";
static final String LOAD1_CX = "{ reg1 = cpu.ecx & 0xffff; }";
static final String ADD_O8_FLAGS = "{  {	{        cpu.setZeroFlag((byte)((reg0)));        cpu.setParityFlag(((reg0)));	cpu.setSignFlag((byte)((reg0)));	cpu.setCarryFlag(((reg0)), Processor.CY_TWIDDLE_FF);	cpu.setAuxiliaryCarryFlag(( ( reg2)), ( ( reg1)), ((reg0)), Processor.AC_XOR);}	cpu.setOverflowFlag((reg0), ( reg2), ( reg1), Processor.OF_ADDSUB_BYTE);}}";
static final String LOAD1_AX = "{ reg1 = cpu.eax & 0xffff; }";
static final String LOAD1_BH = "{ reg1 = (cpu.ebx >> 8) & 0xff; }";
static final String LOAD0_BH = "{ reg0 = (cpu.ebx >> 8) & 0xff; }";
static final String STORE0_MEM_BYTE = "{  seg0.setByte(addr0, (byte)reg0); }";
static final String LOAD0_ES = "{ reg0 = 0xffff & cpu.es.getSelector(); }";
static final String LOAD1_AH = "{ reg1 = (cpu.eax >> 8) & 0xff; }";
static final String ADC = "{ reg2 = reg0; reg0 = reg2 + reg1 + (cpu.getCarryFlag() ? 1 : 0); }";
static final String JUMP_O8 = "{ {	cpu.eip += ((byte)reg0);	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((byte)reg0);            throw exceptionGP;        }}}";
static final String JNC_O8 = "{ {	if (!cpu.getCarryFlag()) {	cpu.eip += (((byte)reg0));	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= (((byte)reg0));            throw exceptionGP;        }}}}";
static final String JC_O8 = "{  {	if (cpu.getCarryFlag()) {	cpu.eip += (((byte)reg0));	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= (((byte)reg0));            throw exceptionGP;        }}}}";
static final String LOAD1_AL = "{ reg1 = cpu.eax & 0xff; }";
static final String ADC_O16_FLAGS = "{ {	if (cpu.getCarryFlag() && (( reg1) == 0xffff)) {	    {        cpu.setZeroFlag((short)((reg0)));        cpu.setParityFlag(((reg0)));	cpu.setSignFlag((short)((reg0)));	cpu.setCarryFlag(((reg0)), Processor.CY_TWIDDLE_FFFF);	cpu.setAuxiliaryCarryFlag(( ( reg2)), ( ( reg1)), ((reg0)), Processor.AC_XOR);}	    cpu.setOverflowFlag(false);	    cpu.setCarryFlag(true);	} else {	    cpu.setOverflowFlag((reg0), ( reg2), ( reg1) + (cpu.getCarryFlag() ? 1 : 0), Processor.OF_ADDSUB_SHORT);	    {        cpu.setZeroFlag((short)((reg0)));        cpu.setParityFlag(((reg0)));	cpu.setSignFlag((short)((reg0)));	cpu.setCarryFlag(((reg0)), Processor.CY_TWIDDLE_FFFF);	cpu.setAuxiliaryCarryFlag(( ( reg2)), ( ( reg1)), ((reg0)), Processor.AC_XOR);}	}}}";
static final String JUMP_O16 = "{ {	cpu.eip = (cpu.eip + ((short)reg0)) & 0xffff;}}";
static final String LOAD_SEG_CS = "{ seg0 = cpu.cs; }";
static final String DEC = "{ reg0--; }";
static final String DEC_O16_FLAGS = "{ {        cpu.setZeroFlag(((short)reg0));        cpu.setParityFlag(((short)reg0));	cpu.setSignFlag(((short)reg0));        cpu.setOverflowFlag(((short)reg0), Processor.OF_MAX_INT);        cpu.setAuxiliaryCarryFlag(((short)reg0), Processor.AC_LNIBBLE_MAX);}}";
static final String LOAD0_ADDR = "{ reg0 = addr0; }";
static final String SHL = "{ reg2 = reg0; reg0 <<= reg1; }";
static final String STORE0_BL = "{ cpu.ebx = (cpu.ebx & ~0xff) | (reg0 & 0xff); }";
static final String SHL_O16_FLAGS = "{ {        if (( reg1) > 0) {	    cpu.setCarryFlag(( (short)reg2), ( reg1), Processor.CY_SHL_OUTBIT_SHORT);            if (( reg1) == 1)                cpu.setOverflowFlag(((short)reg0), Processor.OF_BIT15_XOR_CARRY);	    cpu.setZeroFlag(((short)reg0));	    cpu.setParityFlag(((short)reg0));	    cpu.setSignFlag(((short)reg0));	}}}";
static final String LOAD1_BX = "{ reg1 = cpu.ebx & 0xffff; }";
static final String OR = "{  reg0 |= reg1; }";
static final String STORE1_ES = "{ cpu.es.setSelector(0xffff & reg1); }";
static final String STORE1_AX = "{ cpu.eax = (cpu.eax & ~0xffff) | (reg1 & 0xffff); }";
static final String LOAD1_DI = "{ reg1 = cpu.edi & 0xffff; }";
static final String LOAD1_MEM_BYTE = "{  reg1 = 0xff & seg0.getByte(addr0); }";
static final String JCXZ = "{ {	if ((cpu.ecx & 0xffff) == 0) {	cpu.eip += (((byte)reg0));	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= (((byte)reg0));            throw exceptionGP;        }}}}";
static final String LOAD1_SI = "{ reg1 = cpu.esi & 0xffff; }";
static final String STORE1_DS = "{ cpu.ds.setSelector(0xffff & reg1); }";
static final String LOAD1_CL = "{ reg1 = cpu.ecx & 0xff; }";
static final String JUMP_ABS_O16 = "{ cpu.eip = reg0; }";
static final String STORE0_CL = "{ cpu.ecx = (cpu.ecx & ~0xff) | (reg0 & 0xff); }";
static final String ADDR_DI = "{ addr0 += ((short)cpu.edi); }";
static final String SHR = "{ reg2 = reg0; reg0 >>>= reg1; }";
static final String SHR_O16_FLAGS = "{ {        if (( reg1) > 0) {	    	    cpu.setCarryFlag(( reg2), ( reg1), Processor.CY_SHR_OUTBIT);            if (( reg1) == 1)                cpu.setOverflowFlag(((short)reg0), ( reg2), Processor.OF_BIT15_DIFFERENT);	    cpu.setZeroFlag(((short)reg0));	    cpu.setParityFlag(((short)reg0));	    cpu.setSignFlag(((short)reg0));	}}}";
static final String JA_O8 = "{  {	if ((!cpu.getCarryFlag()) && (!cpu.getZeroFlag())) {	cpu.eip += (((byte)reg0));	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= (((byte)reg0));            throw exceptionGP;        }}}}";
static final String JNA_O8 = "{ {	if (cpu.getCarryFlag() || cpu.getZeroFlag()) {	cpu.eip += (((byte)reg0));	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= (((byte)reg0));            throw exceptionGP;        }}}}";
static final String INT_O16_A16 = "{ {	if ((reg0) == 0)	    throw new IllegalStateException(\"INT 0 allowed?\");        if (((cpu.esp & 0xffff) < 6) && ((cpu.esp & 0xffff) > 0)) {	    throw new IllegalStateException(\"SS Processor Exception Thrown in \\\"handleInterrupt(\"+(reg0)+\")\\\"\");            /*throw exceptionSS; //?*/	    /*maybe just change (reg0) value*/	}        cpu.esp = (cpu.esp & 0xffff0000) | (0xffff & (cpu.esp - 2));        int eflags = cpu.getEFlags() & 0xffff;        cpu.ss.setWord(cpu.esp & 0xffff, (short)eflags);        cpu.eflagsInterruptEnable = false;	cpu.eflagsInterruptEnableSoon = false;        cpu.eflagsTrap = false;        cpu.eflagsAlignmentCheck = false;        cpu.esp = (cpu.esp & 0xffff0000) | (0xffff & (cpu.esp - 2));        cpu.ss.setWord(cpu.esp & 0xffff, (short)cpu.cs.getSelector());        cpu.esp = (cpu.esp & 0xffff0000) | (0xffff & (cpu.esp - 2));        cpu.ss.setWord(cpu.esp & 0xffff, (short)cpu.eip);        /* read interrupt (reg0)*/        cpu.eip = 0xffff & cpu.idtr.getWord(4*(reg0));        cpu.cs.setSelector(0xffff & cpu.idtr.getWord(4*(reg0)+2));}}";
static final String STI = "{ cpu.eflagsInterruptEnable = cpu.eflagsInterruptEnableSoon = true; }";
static final String ADC_O8_FLAGS = "{  {	if (cpu.getCarryFlag() && (( reg1) == 0xff)) {	    {        cpu.setZeroFlag((byte)((reg0)));        cpu.setParityFlag(((reg0)));	cpu.setSignFlag((byte)((reg0)));	cpu.setCarryFlag(((reg0)), Processor.CY_TWIDDLE_FF);	cpu.setAuxiliaryCarryFlag(( ( reg2)), ( ( reg1)), ((reg0)), Processor.AC_XOR);}	    cpu.setOverflowFlag(false);	    cpu.setCarryFlag(true);	} else {	    cpu.setOverflowFlag((reg0), ( reg2), ( reg1) + (cpu.getCarryFlag() ? 1 : 0), Processor.OF_ADDSUB_BYTE);	    {        cpu.setZeroFlag((byte)((reg0)));        cpu.setParityFlag(((reg0)));	cpu.setSignFlag((byte)((reg0)));	cpu.setCarryFlag(((reg0)), Processor.CY_TWIDDLE_FF);	cpu.setAuxiliaryCarryFlag(( ( reg2)), ( ( reg1)), ((reg0)), Processor.AC_XOR);}	}}}";
static final String OUT_O8 = "{  cpu.ioports.ioPortWriteByte(reg0, reg1); }";
static final String JZ_O16 = "{  {	if (cpu.getZeroFlag()) {	cpu.eip = (cpu.eip + (((short)reg0))) & 0xffff;}}}";
static final String JL_O8 = "{  {	if (cpu.getSignFlag() != cpu.getOverflowFlag()) {	cpu.eip += (((byte)reg0));	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= (((byte)reg0));            throw exceptionGP;        }}}}";
static final String IRET_O16_A16 = "{ {	/* TODO:  supposed to throw SS exception*/	/* \"if top 6 bytes of stack not within stack limits\"*/	cpu.eip = cpu.ss.getWord(cpu.esp & 0xffff) & 0xffff;	cpu.esp = (cpu.esp & 0xffff0000) | ((cpu.esp + 2) & 0xffff);	cpu.cs.setSelector(cpu.ss.getWord(cpu.esp & 0xffff) & 0xffff);	cpu.esp = (cpu.esp & 0xffff0000) | ((cpu.esp + 2) & 0xffff);	int temp = cpu.ss.getWord(cpu.esp & 0xffff);	cpu.esp = (cpu.esp & 0xffff0000) | ((cpu.esp + 2) & 0xffff);	int w = cpu.getEFlags() & ~0xffff;	cpu.setEFlags(w | (temp & 0xffff));}}";
static final String PUSHF_O16_A16 = "{ {	if (((cpu.esp & 0xffff) < 2) && ((cpu.esp & 0xffff) > 0))	    throw exceptionSS;	short w = (short)cpu.getEFlags();	int offset = (cpu.esp - 2) & 0xffff;	cpu.ss.setWord(offset, w);	cpu.esp = (cpu.esp & ~0xffff) | offset;}}";
static final String IMULA_O16 = "{ {        short ax = (short)cpu.eax;        	int result = ax * ((short)reg0);        cpu.eax = (cpu.eax & ~0xffff) | (result & 0xffff);	cpu.edx = (cpu.edx & ~0xffff) | (result >>> 16);	/*answer too wide for 16-bits?*/	cpu.setOverflowFlag(result, Processor.OF_NOT_SHORT);	cpu.setCarryFlag(result, Processor.CY_NOT_SHORT);}}";
static final String LOAD1_DX = "{ reg1 = cpu.edx & 0xffff; }";
static final String CLD = "{ cpu.eflagsDirection = false; }";
static final String LOAD0_DL = "{ reg0 = cpu.edx & 0xff; }";
static final String SIGN_EXTEND_8_16 = "{ reg0 = 0xffff & ((byte)reg0); }";
static final String MOVSB_A16 = "{ {	int inAddr = cpu.edi & 0xffff;	int outAddr = cpu.esi & 0xffff;	cpu.es.setByte(inAddr, (seg0).getByte(outAddr));			if (cpu.eflagsDirection) {	    outAddr -= 1;	    inAddr -= 1;	} else {	    outAddr += 1;	    inAddr += 1;	}	cpu.edi = (cpu.edi & ~0xffff) | (inAddr & 0xffff);	cpu.esi = (cpu.esi & ~0xffff) | (outAddr & 0xffff);}}";
static final String LOOP_CX = "{ cpu.ecx = (cpu.ecx & ~0xffff) | ((cpu.ecx - 1) & 0xffff); if ((0xffff & cpu.ecx) != 0) {	cpu.eip += ((byte)reg0);	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((byte)reg0);            throw exceptionGP;        }}}";
static final String RET_IW_O16_A16 = "{ {	{	/* TODO:  supposed to throw SS exception*/	/* \"if top 6 bytes of stack not within stack limits\"*/	cpu.eip = cpu.ss.getWord(cpu.esp & 0xffff) & 0xffff;	cpu.esp = (cpu.esp & ~0xffff) | ((cpu.esp + 2) & 0xffff);}	cpu.esp = (cpu.esp & ~0xffff) | ((cpu.esp + ((short)reg0)) & 0xffff);}}";
static final String STORE0_DL = "{ cpu.edx = (cpu.edx & ~0xff) | (reg0 & 0xff); }";
static final String IN_O8 = "{  reg0 = 0xff & cpu.ioports.ioPortReadByte(reg0); }";
static final String SBB = "{ reg2 = reg0; reg0 = reg2 - (reg1 + (cpu.getCarryFlag() ? 1 : 0)); }";
static final String POPF_O16_A16 = "{ {	/*SS exception?*/	int w = 0xffff & cpu.ss.getWord(cpu.esp & 0xffff);	/*cpu.esp += 2;*/	cpu.esp = (cpu.esp & ~0xffff) | ((cpu.esp + 2) & 0xffff);	int temp = cpu.getEFlags() & ~0xffff;	temp |= w;	cpu.setEFlags(temp);}}";
static final String SBB_O16_FLAGS = "{ {	cpu.setOverflowFlag(( reg2), (reg0), ( reg1) + (cpu.getCarryFlag() ? 1 : 0), Processor.OF_ADDSUB_SHORT);	{        cpu.setZeroFlag((short)((reg0)));        cpu.setParityFlag(((reg0)));	cpu.setSignFlag((short)((reg0)));	cpu.setCarryFlag(((reg0)), Processor.CY_TWIDDLE_FFFF);	cpu.setAuxiliaryCarryFlag(( ( reg2)), ( ( reg1)), ((reg0)), Processor.AC_XOR);}}}";
static final String LODSB_A16 = "{ {	int addr = cpu.esi & 0xffff;	cpu.eax = (cpu.eax & ~0xff) | (0xff & (seg0).getByte(addr));	if (cpu.eflagsDirection)	    addr -= 1;	else	    addr += 1;		cpu.esi = (cpu.esi & ~0xffff) | (addr & 0xffff);}}";
static final String POPA_A16 = "{ {	int offset = 0xffff & cpu.esp;	/*Bochs claims no checking need on POPs*/	/*if (offset + 16 >= cpu.ss.limit)*/	/*    throw exceptionSS;*/	cpu.edi = (cpu.edi & ~0xffff) | (0xffff & cpu.ss.getWord(0xffff & offset));	offset += 2;	cpu.esi = (cpu.esi & ~0xffff) | (0xffff & cpu.ss.getWord(0xffff & offset));	offset += 2;	cpu.ebp = (cpu.ebp & ~0xffff) | (0xffff & cpu.ss.getWord(0xffff & offset));	offset += 4;/* yes - skip 2 bytes in order to skip SP	*/	cpu.ebx = (cpu.ebx & ~0xffff) | (0xffff & cpu.ss.getWord(0xffff & offset));	offset += 2;	cpu.edx = (cpu.edx & ~0xffff) | (0xffff & cpu.ss.getWord(0xffff & offset));	offset += 2;	cpu.ecx = (cpu.ecx & ~0xffff) | (0xffff & cpu.ss.getWord(0xffff & offset));	offset += 2;	cpu.eax = (cpu.eax & ~0xffff) | (0xffff & cpu.ss.getWord(0xffff & offset));	offset += 2;			cpu.esp = (cpu.esp & ~0xffff) | (offset & 0xffff);}}";
static final String PUSHA_A16 = "{ {	int offset = cpu.esp & 0xffff;	/*it seems that it checks at every push (we will simulate this)*/	if ((offset < 16) && ((offset & 0x1) == 0x1)) {	    if (offset < 6)		System.err.println(\"Should shutdown machine (PUSHA with small ESP\");	    throw exceptionGP;	}	int temp = cpu.esp;	offset -= 2;	cpu.ss.setWord(offset & 0xffff, (short) cpu.eax);	offset -= 2;	cpu.ss.setWord(offset & 0xffff, (short) cpu.ecx);	offset -= 2;	cpu.ss.setWord(offset & 0xffff, (short) cpu.edx);	offset -= 2;	cpu.ss.setWord(offset & 0xffff, (short) cpu.ebx);	offset -= 2;	cpu.ss.setWord(offset & 0xffff, (short) temp);	offset -= 2;	cpu.ss.setWord(offset & 0xffff, (short) cpu.ebp);	offset -= 2;	cpu.ss.setWord(offset & 0xffff, (short) cpu.esi);	offset -= 2;	cpu.ss.setWord(offset & 0xffff, (short) cpu.edi);        	cpu.esp = (cpu.esp & ~0xffff) | (offset & 0xffff);}}";
static final String LOAD1_DL = "{ reg1 = cpu.edx & 0xff; }";
static final String REP_MOVSB_A16 = "{ {	int count = cpu.ecx & 0xffff;	int inAddr = cpu.edi & 0xffff;	int outAddr = cpu.esi & 0xffff;	executeCount += count;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setByte(inAddr & 0xffff, (seg0).getByte(outAddr & 0xffff));				    count--;		    outAddr -= 1;		    inAddr -= 1;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setByte(inAddr & 0xffff, (seg0).getByte(outAddr & 0xffff));				    count--;		    outAddr += 1;		    inAddr += 1;		}	    }	}	finally {	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.edi = (cpu.edi & ~0xffff) | (inAddr & 0xffff);	    cpu.esi = (cpu.esi & ~0xffff) | (outAddr & 0xffff);	}}}";
static final String NOT = "{ reg0 = ~reg0; }";
static final String LOAD1_BP = "{ reg1 = cpu.ebp & 0xffff; }";
static final String REP_MOVSW_A16 = "{ {	int count = cpu.ecx & 0xffff;	int inAddr = cpu.edi & 0xffff;	int outAddr = cpu.esi & 0xffff;	executeCount += count;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setWord(inAddr & 0xffff, (seg0).getWord(outAddr & 0xffff));				    count--;		    outAddr -= 2;		    inAddr -= 2;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setWord(inAddr & 0xffff, (seg0).getWord(outAddr & 0xffff));				    count--;		    outAddr += 2;		    inAddr += 2;		}	    }	}	finally {	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.edi = (cpu.edi & ~0xffff) | (inAddr & 0xffff);	    cpu.esi = (cpu.esi & ~0xffff) | (outAddr & 0xffff);	}}}";
static final String LOAD0_BL = "{ reg0 = cpu.ebx & 0xff; }";
static final String DIV_O16 = "{ {	if ((reg0) == 0)	    throw exceptionDE;	long x = (cpu.edx & 0xffffl);	x <<= 16;	x |= (cpu.eax & 0xffffl);	long result = x / (reg0);	if (result > 0xffffl)	    throw exceptionDE;	long remainder = x % (reg0);	cpu.eax = (cpu.eax & ~0xffff) | (int)(result & 0xffff);	cpu.edx = (cpu.edx & ~0xffff) | (int)(remainder & 0xffff);}}";
static final String MUL_O16 = "{ {	int x = cpu.eax & 0xffff;        int result = x * (reg0);        cpu.eax = (cpu.eax & 0xffff0000) | (0xffff & result);	result = result >> 16;        cpu.edx = (cpu.edx & 0xffff0000) | (0xffff & result);        cpu.setOverflowFlag(result, Processor.OF_LOW_WORD_NZ);	cpu.setCarryFlag(result, Processor.CY_LOW_WORD_NZ);}}";
static final String LOAD0_SS = "{ reg0 = 0xffff & cpu.ss.getSelector(); }";
static final String CLI = "{ cpu.eflagsInterruptEnable = cpu.eflagsInterruptEnableSoon = false; }";
static final String JNZ_O16 = "{ {	if (!cpu.getZeroFlag()) {	cpu.eip = (cpu.eip + (((short)reg0))) & 0xffff;}}}";
static final String LOAD0_CL = "{ reg0 = cpu.ecx & 0xff; }";
static final String JG_O8 = "{  {	if ((!cpu.getZeroFlag()) && (cpu.getSignFlag() == cpu.getOverflowFlag())) {	cpu.eip += (((byte)reg0));	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= (((byte)reg0));            throw exceptionGP;        }}}}";
static final String CALL_FAR_O16_A16 = "{ {	if (((cpu.esp & 0xffff) < 4) && ((cpu.esp & 0xffff) > 0))	    throw exceptionSS;	cpu.ss.setWord((cpu.esp - 2) & 0xffff, (short)cpu.cs.getSelector());	cpu.ss.setWord((cpu.esp - 4) & 0xffff, (short)cpu.eip);	cpu.esp = (cpu.esp & ~0xffff) | ((cpu.esp - 4) & 0xffff);		cpu.eip = (reg0);        cpu.cs.setSelector(( reg1));}}";
static final String RET_FAR_O16_A16 = "{ {	/* TODO:  supposed to throw SS exception*/	/* \"if top 6 bytes of stack not within stack limits\"*/	cpu.eip = cpu.ss.getWord(cpu.esp & 0xffff) & 0xffff;	cpu.cs.setSelector(cpu.ss.getWord((cpu.esp + 2) & 0xffff) & 0xffff);	cpu.esp = (cpu.esp & ~0xffff) | ((cpu.esp + 4) & 0xffff);}}";
static final String STORE0_SS = "{ cpu.ss.setSelector(0xffff & reg0); }";
static final String JUMP_FAR_O16 = "{ {	cpu.eip = (reg0);	cpu.cs.setSelector(( reg1));}}";
static final String CWD = "{ if ((cpu.eax & 0x8000) == 0) cpu.edx &= 0xffff0000; else cpu.edx |= 0x0000ffff; }";
static final String STORE0_CH = "{ cpu.ecx = (cpu.ecx & ~0xff00) | ((reg0 << 8) & 0xff00); }";
static final String LOAD1_CH = "{ reg1 = (cpu.ecx >> 8) & 0xff; }";
static final String LOAD0_CH = "{ reg0 = (cpu.ecx >> 8) & 0xff; }";
static final String IDIV_O16 = "{ {        if (((short)reg0) == 0) {	    throw exceptionDE;        }        int temp = (cpu.edx << 16) | (cpu.eax & 0xffff);        int result = temp / (int)((short)reg0);        int remainder = temp % ((short)reg0);        if ((result > Short.MAX_VALUE) || (result < Short.MIN_VALUE))	    throw exceptionDE;		        cpu.eax = (cpu.eax & ~0xffff) | (0xffff & result); /*AX is result*/        cpu.edx = (cpu.edx & ~0xffff) | (0xffff & remainder);    /*DX is remainder*/}}";
static final String STOSB_A16 = "{ {	int addr = cpu.edi & 0xffff;	cpu.es.setByte(addr, (byte)(reg0));			if (cpu.eflagsDirection)	    addr -= 1;	else	    addr += 1;		cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);}}";
static final String JNL_O8 = "{ {	if (cpu.getSignFlag() == cpu.getOverflowFlag()) {	cpu.eip += (((byte)reg0));	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= (((byte)reg0));            throw exceptionGP;        }}}}";
static final String DEC_O8_FLAGS = "{  {        cpu.setZeroFlag(((byte)reg0));        cpu.setParityFlag(((byte)reg0));	cpu.setSignFlag(((byte)reg0));        cpu.setOverflowFlag(((byte)reg0), Processor.OF_MAX_INT);        cpu.setAuxiliaryCarryFlag(((byte)reg0), Processor.AC_LNIBBLE_MAX);}}";
static final String INC_O8_FLAGS = "{  {        cpu.setZeroFlag(((byte)reg0));        cpu.setParityFlag(((byte)reg0));	cpu.setSignFlag(((byte)reg0));        cpu.setOverflowFlag(((byte)reg0), Processor.OF_MIN_INT);        cpu.setAuxiliaryCarryFlag(((byte)reg0), Processor.AC_LNIBBLE_ZERO);}}";
static final String LOAD0_EAX = "{ reg0 = cpu.eax; }";
static final String RET_FAR_IW_O16_A16 = "{ {	/* TODO:  supposed to throw SS exception*/	/* \"if top 6 bytes of stack not within stack limits\"*/	{	/* TODO:  supposed to throw SS exception*/	/* \"if top 6 bytes of stack not within stack limits\"*/	cpu.eip = cpu.ss.getWord(cpu.esp & 0xffff) & 0xffff;	cpu.cs.setSelector(cpu.ss.getWord((cpu.esp + 2) & 0xffff) & 0xffff);	cpu.esp = (cpu.esp & ~0xffff) | ((cpu.esp + 4) & 0xffff);}	cpu.esp = (cpu.esp & ~0xffff) | ((cpu.esp + ((short)reg0)) & 0xffff);}}";
static final String LOAD1_BL = "{ reg1 = cpu.ebx & 0xff; }";
static final String STORE0_EAX = "{ cpu.eax = reg0; }";
static final String JNG_O8 = "{ {	if (cpu.getZeroFlag() || (cpu.getSignFlag() != cpu.getOverflowFlag())) {	cpu.eip += (((byte)reg0));	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= (((byte)reg0));            throw exceptionGP;        }}}}";
static final String LODSW_A16 = "{ {	int addr = cpu.esi & 0xffff;	cpu.eax = (cpu.eax & ~0xffff) | (0xffff & (seg0).getWord(addr));	if (cpu.eflagsDirection)	    addr -= 2;	else	    addr += 2;		cpu.esi = (cpu.esi & ~0xffff) | (addr & 0xffff);}}";
static final String REPE_CMPSB_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addrOne = cpu.esi & 0xffff;	int addrTwo = cpu.edi & 0xffff;	boolean used = count != 0;	int dataOne = 0;	int dataTwo = 0;		try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    dataOne = 0xff & (seg0).getByte(addrOne);		    dataTwo = 0xff & cpu.es.getByte(addrTwo);		    count--;		    addrOne -= 1;		    addrTwo -= 1;		    if (dataOne != dataTwo) break;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    dataOne = 0xff & (seg0).getByte(addrOne);		    dataTwo = 0xff & cpu.es.getByte(addrTwo);		    count--;		    addrOne += 1;		    addrTwo += 1;		    if (dataOne != dataTwo) break;		}	    }	}	finally {	    executeCount += ((cpu.ecx & 0xffff) - count);	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.esi = (cpu.esi & ~0xffff) | (addrOne & 0xffff);	    cpu.edi = (cpu.edi & ~0xffff) | (addrTwo & 0xffff);	    if (used)		{	{        cpu.setZeroFlag((byte)((dataOne - dataTwo)));        cpu.setParityFlag(((dataOne - dataTwo)));	cpu.setSignFlag((byte)((dataOne - dataTwo)));	cpu.setCarryFlag(((dataOne - dataTwo)), Processor.CY_TWIDDLE_FF);	cpu.setAuxiliaryCarryFlag(( ( dataOne)), ( ( dataTwo)), ((dataOne - dataTwo)), Processor.AC_XOR);}	cpu.setOverflowFlag(( dataOne), (dataOne - dataTwo), ( dataTwo), Processor.OF_ADDSUB_BYTE);}	}}}";
static final String ENTER_O16_A16 = "{ {	( reg1) %= 32;	int tempESP = cpu.esp;	int tempEBP = cpu.ebp;	tempESP = (tempESP & ~0xffff) | ((tempESP - 2) & 0xffff);	cpu.ss.setWord(tempESP & 0xffff, (short)tempEBP);        int frameTemp = tempESP & 0xffff;	if (( reg1) != 0) {	    while (--( reg1) != 0) {		tempEBP = (tempEBP & ~0xffff) | ((tempEBP - 2) & 0xffff);		tempESP = (tempESP & ~0xffff) | ((tempESP - 2) & 0xffff);		cpu.ss.setWord(tempESP & 0xffff, cpu.ss.getWord(tempEBP & 0xffff));	    }	    	    tempESP = (tempESP & ~0xffff) | ((tempESP - 2) & 0xffff);	    cpu.ss.setWord(tempESP & 0xffff, (short)frameTemp);	}		cpu.ebp = (tempEBP & ~0xffff) | (frameTemp & 0xffff);	        cpu.esp = (tempESP & ~0xffff) | ((tempESP - (reg0)) & 0xffff);}}";
static final String LEAVE_O16_A16 = "{ {	try {	    cpu.ss.checkAddress(cpu.ebp & 0xffff);	} catch (ProcessorException e) {	    throw exceptionSS;	}	int tempESP = (cpu.esp & ~0xffff) | (cpu.ebp & 0xffff);	int tempEBP = (cpu.ebp & ~0xffff) | (cpu.ss.getWord(tempESP & 0xffff) & 0xffff);	if (((tempESP & 0xffff) > 0xffff) | ((tempESP & 0xffff) < 0)) {	    System.out.println(\"Throwing dodgy leave exception\");	    throw exceptionGP;		}	cpu.esp = (tempESP & ~0xffff) | ((tempESP + 2) & 0xffff);	cpu.ebp = tempEBP;}}";
static final String STORE0_MEM_DWORD = "{ seg0.setDoubleWord(addr0, reg0); }";
static final String ROR_O8_FLAGS = "{  {	if (( reg1) > 0) {	    cpu.setCarryFlag(((byte)reg0), Processor.CY_HIGHBIT_BYTE);	    if (( reg1) == 1)		cpu.setOverflowFlag(((byte)reg0), Processor.OF_BIT6_XOR_CARRY);	}}}";
static final String ROR_O8 = "{  reg1 &= 0x7;  reg0 = (reg0 >>> reg1) | (reg0 << (8 - reg1));  }";
static final String POP_O32_A16 = "{		reg1 = (cpu.esp & ~0xffff) | ((cpu.esp + 4) & 0xffff);		if ((microcodes[position] == STORE0_SS)) 		    cpu.eflagsInterruptEnable = false;		reg0 = cpu.ss.getDoubleWord(cpu.esp & 0xffff);		}";
static final String PUSH_O32_A16 = "{ {	if (((cpu.esp & 0xffff) < 4) && ((cpu.esp & 0xffff) > 0))	    throw exceptionSS;	int offset = (cpu.esp - 4) & 0xffff;	cpu.ss.setDoubleWord(offset, (reg0));	cpu.esp = (cpu.esp & ~0xffff) | offset;}}";
static final String REPNE_SCASB_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addr = cpu.edi & 0xffff;        boolean used = count != 0;	int input = 0;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    input = 0xff & cpu.es.getByte(addr);		    count--;		    addr -= 1;		    if ((reg0) == input) break;		}	    } else {		while (count != 0) {		    input = 0xff & cpu.es.getByte(addr);		    count--;		    addr += 1;		    if ((reg0) == input) break;		}	    }	} finally {	    executeCount += ((cpu.ecx & 0xffff) - count);	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);	    if (used)		{	{        cpu.setZeroFlag((byte)(((reg0) - input)));        cpu.setParityFlag((((reg0) - input)));	cpu.setSignFlag((byte)(((reg0) - input)));	cpu.setCarryFlag((((reg0) - input)), Processor.CY_TWIDDLE_FF);	cpu.setAuxiliaryCarryFlag(( ( (reg0))), ( ( input)), (((reg0) - input)), Processor.AC_XOR);}	cpu.setOverflowFlag(( (reg0)), ((reg0) - input), ( input), Processor.OF_ADDSUB_BYTE);}	}}}";
static final String SUB_O32_FLAGS = "{ {	(reg0l) = (0xffffffffl & ( reg2)) - (0xffffffffl & ( reg1));	{        cpu.setZeroFlag((int)((reg0l)));	cpu.setParityFlag((int)((reg0l)));	cpu.setSignFlag((int)((reg0l)));	cpu.setCarryFlag(((reg0l)), Processor.CY_TWIDDLE_FFFFFFFF);	cpu.setAuxiliaryCarryFlag(( ( reg2)), ( ( reg1)), (int)((reg0l)), Processor.AC_XOR);}	cpu.setOverflowFlag(( reg2), (int)(reg0l), ( reg1), Processor.OF_ADDSUB_INT);}}";
static final String LOAD1_ID = "{ reg1 = microcodes[position++]; }";
static final String LOAD0_MEM_DWORD = "{ reg0 = seg0.getDoubleWord(addr0); }";
static final String INC_O32_FLAGS = "{ {        cpu.setZeroFlag((reg0));        cpu.setParityFlag((reg0));	cpu.setSignFlag((reg0));        cpu.setOverflowFlag((reg0), Processor.OF_MIN_INT);        cpu.setAuxiliaryCarryFlag((reg0), Processor.AC_LNIBBLE_ZERO);}}";
static final String LOAD0_CS = "{ reg0 = 0xffff & cpu.cs.getSelector(); }";
static final String STORE1_DI = "{ cpu.edi = (cpu.edi & ~0xffff) | (reg1 & 0xffff); }";
static final String LAHF = "{ {        int result = 0x0200;        if (cpu.getSignFlag()) result |= 0x8000;        if (cpu.getZeroFlag()) result |= 0x4000;        if (cpu.getAuxiliaryCarryFlag()) result |= 0x1000;        if (cpu.getParityFlag()) result |= 0x0400;        if (cpu.getCarryFlag()) result |= 0x0100;        cpu.eax &= 0xffff00ff;        cpu.eax |= result;}}";
static final String STORE0_DH = "{ cpu.edx = (cpu.edx & ~0xff00) | ((reg0 << 8) & 0xff00); }";
static final String LOAD0_DH = "{ reg0 = (cpu.edx >> 8) & 0xff; }";
static final String LOAD1_DH = "{ reg1 = (cpu.edx >> 8) & 0xff; }";
static final String CPUID = "{	switch (cpu.eax) {case 0x00:	    cpu.eax = 0x02;     cpu.ebx = 0x756e6547;   cpu.edx = 0x49656e69;     cpu.ecx = 0x6c65746e;	    return;	case 0x01:	    cpu.eax = 0x00000633;   cpu.ebx = 8 << 8;  cpu.ecx = 0;   int features = 0;	    features |= 0x01; 	    features |= (1<< 8); 	    features |= (1<< 4); 	    features |= (1<< 5); 	   features |= (1<<15);      features |= (1<< 3);  	    features |= (1<<13);  	    features |= (1<<11);  	    cpu.edx = features;	    return;	default:	case 0x02:	    cpu.eax = 0x410601;	    cpu.ebx = 0;	    cpu.ecx = 0;	    cpu.edx = 0;	    return;}";
static final String CALL_ABS_O16_A16 = "{ {	if (((cpu.esp & 0xffff) < 2) && ((cpu.esp & 0xffff) > 0))	    throw exceptionSS;	cpu.ss.setWord((cpu.esp - 2) & 0xffff, (short)cpu.eip);	cpu.esp = (cpu.esp & 0xffff0000) | ((cpu.esp - 2) & 0xffff);	cpu.eip = (reg0);}}";
static final String JC_O16 = "{  {	if (cpu.getCarryFlag()) {	cpu.eip = (cpu.eip + (((short)reg0))) & 0xffff;}}}";
static final String REP_STOSW_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addr = cpu.edi & 0xffff;	executeCount += count;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setWord(addr & 0xffff, (short)(reg0));				    count--;		    addr -= 2;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setWord(addr & 0xffff, (short)(reg0));				    count--;		    addr += 2;		}	    }	}	finally {	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);	}}}";
static final String STORE1_CL = "{ cpu.ecx = (cpu.ecx & ~0xff) | (reg1 & 0xff); }";
static final String SBB_O8_FLAGS = "{  {	cpu.setOverflowFlag(( reg2), (reg0), ( reg1) + (cpu.getCarryFlag() ? 1 : 0), Processor.OF_ADDSUB_BYTE);		{        cpu.setZeroFlag((byte)((reg0)));        cpu.setParityFlag(((reg0)));	cpu.setSignFlag((byte)((reg0)));	cpu.setCarryFlag(((reg0)), Processor.CY_TWIDDLE_FF);	cpu.setAuxiliaryCarryFlag(( ( reg2)), ( ( reg1)), ((reg0)), Processor.AC_XOR);}}}";
static final String NEG = "{ reg0 = -reg0; }";
static final String NEG_O16_FLAGS = "{ {	cpu.setCarryFlag(((short)reg0), Processor.CY_NZ);	cpu.setOverflowFlag(((short)reg0), Processor.OF_MIN_BYTE);        cpu.setAuxiliaryCarryFlag(((short)reg0), Processor.AC_LNIBBLE_NZERO);        cpu.setZeroFlag(((short)reg0));        cpu.setParityFlag(((short)reg0));	cpu.setSignFlag(((short)reg0));}}";
static final String SHL_O8_FLAGS = "{ {        if (( reg1) > 0) {	    cpu.setCarryFlag(( (byte)reg2), ( reg1), Processor.CY_SHL_OUTBIT_BYTE);            if (( reg1) == 1)                cpu.setOverflowFlag(((byte)reg0), Processor.OF_BIT7_XOR_CARRY);	    cpu.setZeroFlag(((byte)reg0));	    cpu.setParityFlag(((byte)reg0));	    cpu.setSignFlag(((byte)reg0));	}}}";
static final String JNC_O16 = "{ {	if (!cpu.getCarryFlag()) {	cpu.eip = (cpu.eip + (((short)reg0))) & 0xffff;}}}";
static final String STOSW_A16 = "{ {	int addr = cpu.edi & 0xffff;	cpu.es.setWord(addr, (short)(reg0));			if (cpu.eflagsDirection)	    addr -= 2;	else	    addr += 2;		cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);}}";
static final String MUL_O8 = "{ {	int x = cpu.eax & 0xff;        int result = x * (reg0);        cpu.eax &= 0xffff0000;	cpu.eax |= (result & 0xffff);	cpu.setOverflowFlag(result, Processor.OF_HIGH_BYTE_NZ);	cpu.setCarryFlag(result, Processor.CY_HIGH_BYTE_NZ);}}";
static final String DIV_O8 = "{ {	if ((reg0) == 0)	    throw exceptionDE;	int x = (cpu.eax & 0xffff);	int result = x / (reg0);	if (result > 0xff)	    throw exceptionDE;	int remainder = (x % (reg0)) << 8;	cpu.eax = (cpu.eax & ~0xffff) | (0xff & result) | (0xff00 & remainder);}}";
static final String LOAD1_SP = "{ reg1 = cpu.esp & 0xffff; }";
static final String STORE1_MEM_WORD = "{  seg0.setWord(addr0, (short)reg1); }";
static final String BITWISE_FLAGS_O32 = "{ {        cpu.setOverflowFlag(false);        cpu.setCarryFlag(false);        cpu.setZeroFlag((reg0));        cpu.setParityFlag((reg0));	cpu.setSignFlag((reg0));}}";
static final String LOAD1_EAX = "{ reg1 = cpu.eax; }";
static final String STC = "{ cpu.setCarryFlag(true); }";
static final String CLC = "{ cpu.setCarryFlag(false); }";
static final String LOOPZ_CX = "{ cpu.ecx = (cpu.ecx & ~0xffff) | ((cpu.ecx - 1) & 0xffff); if (((0xffff & cpu.ecx) != 0) && cpu.getZeroFlag()) {	cpu.eip += ((byte)reg0);	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((byte)reg0);            throw exceptionGP;        }}}";
static final String SAR_O16_FLAGS = "{ {        if (( reg1) > 0) {	    cpu.setCarryFlag(( (short)reg2), ( reg1), Processor.CY_SHR_OUTBIT);            if (( reg1) == 1) cpu.setOverflowFlag(false);            cpu.setSignFlag(((short)reg0));            cpu.setZeroFlag(((short)reg0));            cpu.setParityFlag(((short)reg0));        }      }}";
static final String SAR_O16 = "{ reg2 = reg0; reg0 = ((short)reg0) >> reg1; }";
static final String LOAD0_EBX = "{ reg0 = cpu.ebx; }";
static final String STORE0_EBX = "{ cpu.ebx = reg0; }";
static final String JNS_O8 = "{ {	if (!cpu.getSignFlag()) {	cpu.eip += (((byte)reg0));	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= (((byte)reg0));            throw exceptionGP;        }}}}";
static final String ADD_O32_FLAGS = "{ {	(reg0l) = (0xffffffffl & ( reg2)) + (0xffffffffl & ( reg1));	{        cpu.setZeroFlag((int)((reg0l)));	cpu.setParityFlag((int)((reg0l)));	cpu.setSignFlag((int)((reg0l)));	cpu.setCarryFlag(((reg0l)), Processor.CY_TWIDDLE_FFFFFFFF);	cpu.setAuxiliaryCarryFlag(( ( reg2)), ( ( reg1)), (int)((reg0l)), Processor.AC_XOR);}	cpu.setOverflowFlag((int)(reg0l), ( reg2) , ( reg1), Processor.OF_ADDSUB_INT);}}";
static final String LOAD0_ECX = "{ reg0 = cpu.ecx; }";
static final String LOAD0_ESI = "{ reg0 = cpu.esi; }";
static final String STORE0_ECX = "{ cpu.ecx = reg0; }";
static final String STORE0_EDI = "{ cpu.edi = reg0; }";
static final String STORE0_ESI = "{ cpu.esi = reg0; }";
static final String LOAD0_EDI = "{ reg0 = cpu.edi; }";
static final String STORE0_EDX = "{ cpu.edx = reg0; }";
static final String SHR_O32_FLAGS = "{ {        if (( reg1) > 0) {	    	    cpu.setCarryFlag(( reg2), ( reg1), Processor.CY_SHR_OUTBIT);            if (( reg1) == 1)                cpu.setOverflowFlag((reg0), ( reg2), Processor.OF_BIT31_DIFFERENT);	    cpu.setZeroFlag((reg0));	    cpu.setParityFlag((reg0));	    cpu.setSignFlag((reg0));	}}}";
static final String SHR_O8_FLAGS = "{ {        if (( reg1) > 0) {	    	    cpu.setCarryFlag(( reg2), ( reg1), Processor.CY_SHR_OUTBIT);            if (( reg1) == 1)                cpu.setOverflowFlag(((byte)reg0), ( reg2), Processor.OF_BIT7_DIFFERENT);	    cpu.setZeroFlag(((byte)reg0));	    cpu.setParityFlag(((byte)reg0));	    cpu.setSignFlag(((byte)reg0));	}}}";
static final String RCL_O16_FLAGS = "{ {	if (( reg1) > 0) {	    cpu.setCarryFlag((reg0), Processor.CY_OFFENDBIT_SHORT);            if (( reg1) == 1)		cpu.setOverflowFlag((reg0), Processor.OF_BIT15_XOR_CARRY);	}}}";
static final String RCL_O16 = "{ reg1 &= 0x1f; reg1 %= 17; reg0 |= (cpu.getCarryFlag() ? 0x10000 : 0);		reg0 = (reg0 << reg1) | (reg0 >>> (17 - reg1)); }";
static final String JA_O16 = "{  {	if ((!cpu.getCarryFlag()) && (!cpu.getZeroFlag())) {	cpu.eip = (cpu.eip + (((short)reg0))) & 0xffff;}}}";
static final String LOAD1_MEM_DWORD = "{ reg1 = seg0.getDoubleWord(addr0); }";
static final String SHL_O32_FLAGS = "{ {        if (( reg1) > 0) {	    cpu.setCarryFlag(( reg2), ( reg1), Processor.CY_SHL_OUTBIT_INT);            if (( reg1) == 1)                cpu.setOverflowFlag((reg0), Processor.OF_BIT31_XOR_CARRY);	    cpu.setZeroFlag((reg0));	    cpu.setParityFlag((reg0));	    cpu.setSignFlag((reg0));	}}}";
static final String LOAD1_EDX = "{ reg1 = cpu.edx; }";
static final String STORE1_AL = "{ cpu.eax = (cpu.eax & ~0xff) | (reg1 & 0xff); }";
static final String LOAD1_ECX = "{ reg1 = cpu.ecx; }";
static final String LOAD0_EDX = "{ reg0 = cpu.edx; }";
static final String MOVSW_A16 = "{ {	int inAddr = cpu.edi & 0xffff;	int outAddr = cpu.esi & 0xffff;	cpu.es.setWord(inAddr, (seg0).getWord(outAddr));			if (cpu.eflagsDirection) {	    outAddr -= 2;	    inAddr -= 2;	} else {	    outAddr += 2;	    inAddr += 2;	}	cpu.edi = (cpu.edi & ~0xffff) | (inAddr & 0xffff);	cpu.esi = (cpu.esi & ~0xffff) | (outAddr & 0xffff);}}";
static final String LOAD1_EBX = "{ reg1 = cpu.ebx; }";
static final String LOAD1_EDI = "{ reg1 = cpu.edi; }";
static final String LOAD0_CR0 = "{ reg0 = cpu.getCR0(); }";
static final String STORE0_CR0 = "{ cpu.setCR0(reg0); }";
static final String NEG_O8_FLAGS = "{  {	cpu.setCarryFlag(((byte)reg0), Processor.CY_NZ);	cpu.setOverflowFlag(((byte)reg0), Processor.OF_MIN_BYTE);        cpu.setAuxiliaryCarryFlag(((byte)reg0), Processor.AC_LNIBBLE_NZERO);        cpu.setZeroFlag(((byte)reg0));        cpu.setParityFlag(((byte)reg0));	cpu.setSignFlag(((byte)reg0));}}";
static final String LGDT_O16 = "{ cpu.gdtr = cpu.createDescriptorTableSegment(reg1 & 0x00ffffff, reg0); }";
static final String SMSW = "{ reg0 = cpu.getCR0() & 0xffff; }";
static final String ADDR_ID = "{ addr0 += microcodes[position++]; }";
static final String OUT_O16 = "{ cpu.ioports.ioPortWriteWord(reg0, reg1); }";
static final String POPAD_A16 = "{ {	int offset = 0xffff & cpu.esp;	/*Bochs claims no checking need on POPs*/	/*if (offset + 16 >= cpu.ss.limit)*/	/*    throw exceptionSS;*/	cpu.edi = cpu.ss.getDoubleWord(0xffff & offset);	offset += 4;	cpu.esi = cpu.ss.getDoubleWord(0xffff & offset);	offset += 4;	cpu.ebp = cpu.ss.getDoubleWord(0xffff & offset);	offset += 8;/* yes - skip an extra 4 bytes in order to skip SP*/	cpu.ebx = cpu.ss.getDoubleWord(0xffff & offset);	offset += 4;	cpu.edx = cpu.ss.getDoubleWord(0xffff & offset);	offset += 4;	cpu.ecx = cpu.ss.getDoubleWord(0xffff & offset);	offset += 4;	cpu.eax = cpu.ss.getDoubleWord(0xffff & offset);	offset += 4;		cpu.esp = (cpu.esp & ~0xffff) | (offset & 0xffff);}}";
static final String PUSHAD_A16 = "{ {	int offset = cpu.esp & 0xffff;	int temp = cpu.esp;	if ((offset < 32) && (offset > 0)) {	    System.err.println(\"Throwing dodgy PUSHAD exception, must check!\");	    throw exceptionGP;	}		offset -= 4;	cpu.ss.setDoubleWord(offset, cpu.eax);	offset -= 4;	cpu.ss.setDoubleWord(offset, cpu.ecx);	offset -= 4;	cpu.ss.setDoubleWord(offset, cpu.edx);	offset -= 4;	cpu.ss.setDoubleWord(offset, cpu.ebx);	offset -= 4;	cpu.ss.setDoubleWord(offset, temp);	offset -= 4;	cpu.ss.setDoubleWord(offset, cpu.ebp);	offset -= 4;	cpu.ss.setDoubleWord(offset, cpu.esi);	offset -= 4;	cpu.ss.setDoubleWord(offset, cpu.edi);        	cpu.esp = (cpu.esp & ~0xffff) | offset;}}";
static final String STORE1_SI = "{ cpu.esi = (cpu.esi & ~0xffff) | (reg1 & 0xffff); }";
static final String STORE1_MEM_BYTE = "{  seg0.setByte(addr0, (byte)reg1); }";
static final String MUL_O32 = "{ {	long x = cpu.eax & 0xffffffffl;	long y = 0xffffffffl & (reg0);        long result = x * y;        cpu.eax = (int)result;	result = result >>> 32;	cpu.edx = (int)result;	cpu.setOverflowFlag((int)result, Processor.OF_NZ);        cpu.setCarryFlag((int)result, Processor.CY_NZ);}}";
static final String SETC = "{  reg0 = cpu.getCarryFlag() ? 1 : 0; }";
static final String LOAD0_ESP = "{ reg0 = cpu.esp; }";
static final String LOAD0_EBP = "{ reg0 = cpu.ebp; }";
static final String LOAD0_FS = "{ reg0 = 0xffff & cpu.fs.getSelector(); }";
static final String LOAD0_GS = "{ reg0 = 0xffff & cpu.gs.getSelector(); }";
static final String LOAD0_CR2 = "{ reg0 = cpu.getCR2(); }";
static final String LOAD0_CR3 = "{ reg0 = cpu.getCR3(); }";
static final String LOAD0_CR4 = "{ reg0 = cpu.getCR4(); }";
static final String LOAD0_ID = "{ reg0 = microcodes[position++]; }";
static final String STORE0_ESP = "{ cpu.esp = reg0; }";
static final String STORE0_EBP = "{ cpu.ebp = reg0; }";
static final String STORE0_CS = "{ cpu.cs.setSelector(0xffff & reg0); }";
static final String STORE0_FS = "{ cpu.fs.setSelector(0xffff & reg0); }";
static final String STORE0_GS = "{ cpu.gs.setSelector(0xffff & reg0); }";
static final String STORE0_CR2 = "{ cpu.setCR2(reg0); }";
static final String STORE0_CR3 = "{ cpu.setCR3(reg0); }";
static final String STORE0_CR4 = "{ cpu.setCR4(reg0); }";
static final String LOAD1_ESP = "{ reg1 = cpu.esp; }";
static final String LOAD1_EBP = "{ reg1 = cpu.ebp; }";
static final String LOAD1_ESI = "{ reg1 = cpu.esi; }";
static final String STORE1_EAX = "{ cpu.eax = reg1; }";
static final String STORE1_ECX = "{ cpu.ecx = reg1; }";
static final String STORE1_EDX = "{ cpu.edx = reg1; }";
static final String STORE1_EBX = "{ cpu.ebx = reg1; }";
static final String STORE1_EBP = "{ cpu.ebp = reg1; }";
static final String STORE1_ESI = "{ cpu.esi = reg1; }";
static final String STORE1_EDI = "{ cpu.edi = reg1; }";
static final String STORE1_CX = "{ cpu.ecx = (cpu.ecx & ~0xffff) | (reg1 & 0xffff); }";
static final String STORE1_DX = "{ cpu.edx = (cpu.edx & ~0xffff) | (reg1 & 0xffff); }";
static final String STORE1_BX = "{ cpu.ebx = (cpu.ebx & ~0xffff) | (reg1 & 0xffff); }";
static final String STORE1_SP = "{ cpu.esp = (cpu.esp & ~0xffff) | (reg1 & 0xffff); }";
static final String STORE1_BP = "{ cpu.ebp = (cpu.ebp & ~0xffff) | (reg1 & 0xffff); }";
static final String STORE1_DL = "{ cpu.edx = (cpu.edx & ~0xff) | (reg1 & 0xff); }";
static final String STORE1_BL = "{ cpu.ebx = (cpu.ebx & ~0xff) | (reg1 & 0xff); }";
static final String STORE1_AH = "{ cpu.eax = (cpu.eax & ~0xff00) | ((reg1 << 8) & 0xff00); }";
static final String STORE1_CH = "{ cpu.ecx = (cpu.ecx & ~0xff00) | ((reg1 << 8) & 0xff00); }";
static final String STORE1_DH = "{ cpu.edx = (cpu.edx & ~0xff00) | ((reg1 << 8) & 0xff00); }";
static final String STORE1_BH = "{ cpu.ebx = (cpu.ebx & ~0xff00) | ((reg1 << 8) & 0xff00); }";
static final String STORE1_CS = "{ cpu.cs.setSelector(0xffff & reg1); }";
static final String STORE1_SS = "{ cpu.ss.setSelector(0xffff & reg1); }";
static final String STORE1_FS = "{ cpu.fs.setSelector(0xffff & reg1); }";
static final String STORE1_GS = "{ cpu.gs.setSelector(0xffff & reg1); }";
static final String STORE1_MEM_DWORD = "{ seg0.setDoubleWord(addr0, reg1); }";
static final String LOAD2_EAX = "{ reg2 = cpu.eax; }";
static final String LOAD2_AX = "{ reg2 = 0xffff & cpu.eax; }";
static final String LOAD2_AL = "{ reg2 = 0xff & cpu.eax; }";
static final String LOAD2_CL = "{ reg2 = 0xff & cpu.ecx; }";
static final String LOAD2_IB = "{ reg2 = 0xff & microcodes[position++]; }";
static final String LOAD_SEG_FS = "{ seg0 = cpu.fs; }";
static final String LOAD_SEG_GS = "{ seg0 = cpu.gs; }";
static final String ADDR_EAX = "{ addr0 += cpu.eax; }";
static final String ADDR_ECX = "{ addr0 += cpu.ecx; }";
static final String ADDR_EDX = "{ addr0 += cpu.edx; }";
static final String ADDR_EBX = "{ addr0 += cpu.ebx; }";
static final String ADDR_ESP = "{ addr0 += cpu.esp; }";
static final String ADDR_EBP = "{ addr0 += cpu.ebp; }";
static final String ADDR_ESI = "{ addr0 += cpu.esi; }";
static final String ADDR_EDI = "{ addr0 += cpu.edi; }";
static final String ADDR_AX = "{ addr0 += ((short)cpu.eax); }";
static final String ADDR_CX = "{ addr0 += ((short)cpu.ecx); }";
static final String ADDR_DX = "{ addr0 += ((short)cpu.edx); }";
static final String ADDR_SP = "{ addr0 += ((short)cpu.esp); }";
static final String ADDR_2EAX = "{ addr0 += (cpu.eax << 1); }";
static final String ADDR_2ECX = "{ addr0 += (cpu.ecx << 1); }";
static final String ADDR_2EDX = "{ addr0 += (cpu.edx << 1); }";
static final String ADDR_2EBX = "{ addr0 += (cpu.ebx << 1); }";
static final String ADDR_2ESP = "{ addr0 += (cpu.esp << 1); }";
static final String ADDR_2EBP = "{ addr0 += (cpu.ebp << 1); }";
static final String ADDR_2ESI = "{ addr0 += (cpu.esi << 1); }";
static final String ADDR_2EDI = "{ addr0 += (cpu.edi << 1); }";
static final String ADDR_4EAX = "{ addr0 += (cpu.eax << 2); }";
static final String ADDR_4ECX = "{ addr0 += (cpu.ecx << 2); }";
static final String ADDR_4EDX = "{ addr0 += (cpu.edx << 2); }";
static final String ADDR_4EBX = "{ addr0 += (cpu.ebx << 2); }";
static final String ADDR_4ESP = "{ addr0 += (cpu.esp << 2); }";
static final String ADDR_4EBP = "{ addr0 += (cpu.ebp << 2); }";
static final String ADDR_4ESI = "{ addr0 += (cpu.esi << 2); }";
static final String ADDR_4EDI = "{ addr0 += (cpu.edi << 2); }";
static final String ADDR_8EAX = "{ addr0 += (cpu.eax << 3); }";
static final String ADDR_8ECX = "{ addr0 += (cpu.ecx << 3); }";
static final String ADDR_8EDX = "{ addr0 += (cpu.edx << 3); }";
static final String ADDR_8EBX = "{ addr0 += (cpu.ebx << 3); }";
static final String ADDR_8ESP = "{ addr0 += (cpu.esp << 3); }";
static final String ADDR_8EBP = "{ addr0 += (cpu.ebp << 3); }";
static final String ADDR_8ESI = "{ addr0 += (cpu.esi << 3); }";
static final String ADDR_8EDI = "{ addr0 += (cpu.edi << 3); }";
static final String ADDR_uAL = "{ addr0 += 0xff & cpu.eax; }";
static final String JUMP_FAR_O32 = "{ {	cpu.eip = (reg0);	cpu.cs.setSelector(( reg1));}}";
static final String CALL_FAR_O16_A32 = "{ {	if ((cpu.esp < 4) && (cpu.esp > 0))	    throw exceptionSS;	cpu.ss.setWord(cpu.esp - 2, (short)cpu.cs.getSelector());	cpu.ss.setWord(cpu.esp - 4, (short)cpu.eip);	cpu.esp -= 4;		cpu.eip = (reg0);        cpu.cs.setSelector(( reg1));}}";
static final String IMUL_O16 = "{ {	int result = ((short)reg0) * ( (short)reg1);	cpu.setOverflowFlag(result, Processor.OF_NOT_SHORT);	cpu.setCarryFlag(result, Processor.CY_NOT_SHORT);	reg0 = result;}}";
static final String IMUL_O32 = "{ {	long x = (long)(reg0);	long y = (long)( reg1);	long result = x * y;	cpu.setOverflowFlag(result, Processor.OF_NOT_INT);	cpu.setCarryFlag(result, Processor.CY_NOT_INT);	reg0 = (int)result;}}";
static final String IMULA_O8 = "{ {	byte al = (byte)cpu.eax;	int result = al * ((byte)reg0);	cpu.eax = (cpu.eax & ~0xffff) | (result & 0xffff);	cpu.setOverflowFlag(result, Processor.OF_NOT_BYTE);	cpu.setCarryFlag(result, Processor.CY_NOT_BYTE);}}";
static final String IMULA_O32 = "{ {        long eax = (long)cpu.eax;        long y = (long)(reg0);	long result = eax * y;		cpu.eax = (int)result;	cpu.edx = (int)(result >>> 32);	/*answer too wide for 32-bits?*/	cpu.setOverflowFlag(result, Processor.OF_NOT_INT);	cpu.setCarryFlag(result, Processor.CY_NOT_INT);}}";
static final String DIV_O32 = "{ {	long d = 0xffffffffl & (reg0);	if (d == 0)	    throw exceptionDE;	long temp = (long)cpu.edx;	temp <<= 32;	temp |= (0xffffffffl & cpu.eax);	long r2 = (temp & 1);	long n2 = (temp >>> 1);	long q2 = n2 / d;	long m2 = n2 % d;	long q = (q2 << 1);	long r = (m2 << 1) + r2;	q += (r / d);	r %= d;	if (q > 0xffffffffl)	    throw exceptionDE;	cpu.eax = (int)q;	cpu.edx = (int)r;}}";
static final String IDIV_O8 = "{ {        if (((byte)reg0) == 0)	    throw exceptionDE;        short temp = (short)cpu.eax;        int result = temp / ((byte)reg0);        int remainder = temp % ((byte)reg0);        if ((result > Byte.MAX_VALUE) || (result < Byte.MIN_VALUE))	    throw exceptionDE;	        cpu.eax = (cpu.eax & ~0xffff) | (0xff & result) | ((0xff & remainder) << 8); /*AH is remainder*/}}";
static final String IDIV_O32 = "{ {	if ((reg0) == 0)	    throw exceptionDE;	long temp = (0xffffffffl & cpu.edx) << 32;	temp |= (0xffffffffl & cpu.eax);	long result = temp / (reg0);	if ((result > Integer.MAX_VALUE) || (result < Integer.MIN_VALUE))	    throw exceptionDE;	long remainder = temp % (reg0);		cpu.eax =  (int)result; /*EAX is result*/	cpu.edx =  (int)remainder;    /*EDX is remainder*/}}";
static final String SAR_O8 = "{ reg2 = reg0; reg0 = ((byte)reg0) >> reg1; }";
static final String SAR_O32 = "{ reg2 = reg0; reg0 >>= reg1; }";
static final String ROL_O8 = "{  reg1 &= 0x7;  reg0 = (reg0 << reg1) | (reg0 >>> (8 - reg1));  }";
static final String ROL_O16 = "{ reg1 &= 0xf;  reg0 = (reg0 << reg1) | (reg0 >>> (16 - reg1)); }";
static final String ROL_O32 = "{ reg1 &= 0x1f; reg0 = (reg0 << reg1) | (reg0 >>> (32 - reg1)); }";
static final String ROR_O16 = "{ reg1 &= 0xf;  reg0 = (reg0 >>> reg1) | (reg0 << (16 - reg1)); }";
static final String ROR_O32 = "{ reg1 &= 0x1f; reg0 = (reg0 >>> reg1) | (reg0 << (32 - reg1)); }";
static final String RCL_O8 = "{ reg1 &= 0x1f; reg1 %= 9; reg0 |= (cpu.getCarryFlag() ? 0x100 : 0);		reg0 = (reg0 << reg1) | (reg0 >>> (9 - reg1));  }";
static final String RCL_O32 = "{ reg1 &= 0x1f; reg0l = (0xffffffffl & reg0) | (cpu.getCarryFlag() ? 0x100000000l : 0);		reg0 = (int)(reg0l = (reg0l << reg1) | (reg0l >>> (33 - reg1))); }";
static final String RCR_O8 = "{ reg1 &= 0x1f; reg1 %= 9; reg0 |= (cpu.getCarryFlag() ? 0x100 : 0);		reg0 = (reg0 >>> reg1) | (reg0 << (9 - reg1));  }";
static final String RCR_O16 = "{ reg1 &= 0x1f; reg1 %= 17; reg0 |= (cpu.getCarryFlag() ? 0x10000 : 0);		reg0 = (reg0 >>> reg1) | (reg0 << (17 - reg1)); }";
static final String RCR_O32 = "{ reg1 &= 0x1f; reg0l = (0xffffffffl & reg0) | (cpu.getCarryFlag() ? 0x100000000l : 0);		reg0 = (int)(reg0l = (reg0l >>> reg1) | (reg0l << (33 - reg1))); }";
static final String SHLD_O16 = "{ {		int i = reg0; reg2 &= 0x1f;		reg0 = (reg0 << reg2) | (reg1 >>> (16 - reg2));		reg1 = reg2; reg2 = i;	    } }";
static final String SHLD_O32 = "{ {		int i = reg0; reg2 &= 0x1f;		if (reg2 != 0)		    reg0 = (reg0 << reg2) | (reg1 >>> (32 - reg2));		reg1 = reg2; reg2 = i;	    } }";
static final String SHRD_O16 = "{ {		int i = reg0; reg2 &= 0x1f;		reg0 = (reg0 >>> reg2) | (reg1 << (16 - reg2));		reg1 = reg2; reg2 = i;	    } }";
static final String SHRD_O32 = "{ {		int i = reg0; reg2 &= 0x1f;		if (reg2 != 0) 		    reg0 = (reg0 >>> reg2) | (reg1 << (32 - reg2));		reg1 = reg2; reg2 = i;	    } }";
static final String BT_MEM = "{ {	( addr0) += (((reg1) & ~0x7) / 8);	(reg1) &= 0x7;	cpu.setCarryFlag(( seg0).getByte(( addr0)), (reg1), Processor.CY_NTH_BIT_SET);}}";
static final String BT_O16 = "{  reg1 &= 0xf;  cpu.setCarryFlag(reg0, reg1, Processor.CY_NTH_BIT_SET); }";
static final String BT_O32 = "{  reg1 &= 0x1f; cpu.setCarryFlag(reg0, reg1, Processor.CY_NTH_BIT_SET); }";
static final String BTS_MEM = "{ {	( addr0) += (((reg1) & ~0x7) / 8);	(reg1) &= 0x7;		byte data = ( seg0).getByte(( addr0));	( seg0).setByte(( addr0), (byte)(data | (1 << (reg1))));	cpu.setCarryFlag(data, (reg1), Processor.CY_NTH_BIT_SET);}}";
static final String BTS_O16 = "{ reg1 &= 0xf;  cpu.setCarryFlag(reg0, reg1, Processor.CY_NTH_BIT_SET); reg0 |= (1 << reg1); }";
static final String BTS_O32 = "{ reg1 &= 0x1f; cpu.setCarryFlag(reg0, reg1, Processor.CY_NTH_BIT_SET); reg0 |= (1 << reg1); }";
static final String BTR_MEM = "{ {	( addr0) += (((reg1) & ~0x7) / 8);	(reg1) &= 0x7;		byte data = ( seg0).getByte(( addr0));	( seg0).setByte(( addr0), (byte)(data & ~(1 << (reg1))));	cpu.setCarryFlag(data, (reg1), Processor.CY_NTH_BIT_SET);}}";
static final String BTR_O16 = "{ reg1 &= 0xf;  cpu.setCarryFlag(reg0, reg1, Processor.CY_NTH_BIT_SET); reg0 &= ~(1 << reg1); }";
static final String BTR_O32 = "{ reg1 &= 0x1f; cpu.setCarryFlag(reg0, reg1, Processor.CY_NTH_BIT_SET); reg0 &= ~(1 << reg1); }";
static final String BTC_MEM = "{ {	( addr0) += (((reg1) & ~0x7) / 8);	(reg1) &= 0x7;		byte data = ( seg0).getByte(( addr0));	( seg0).setByte(( addr0), (byte)(data ^ (1 << (reg1))));	cpu.setCarryFlag(data, (reg1), Processor.CY_NTH_BIT_SET);}}";
static final String BTC_O16 = "{ reg1 &= 0xf;  cpu.setCarryFlag(reg0, reg1, Processor.CY_NTH_BIT_SET); reg0 ^= (1 << reg1); }";
static final String BTC_O32 = "{ reg1 &= 0x1f; cpu.setCarryFlag(reg0, reg1, Processor.CY_NTH_BIT_SET); reg0 ^= (1 << reg1); }";
static final String BSF = "{ {	if ((reg1) == 0) {	    cpu.setZeroFlag(true);	    } else {	    cpu.setZeroFlag(false);	    reg0 = Integer.numberOfTrailingZeros((reg1));	}}}";
static final String BSR = "{ {	if ((reg1) == 0) {	    cpu.setZeroFlag(true);	 } else {	    cpu.setZeroFlag(false);	    reg0= 31 - Integer.numberOfLeadingZeros((reg1));	}}}";
static final String CDQ = "{ if ((cpu.eax & 0x80000000) == 0) cpu.edx = 0; else cpu.edx = -1; }";
static final String SAHF = "{ {        int ah = (cpu.eax & 0xff00);        cpu.setCarryFlag(0 != (ah & 0x0100));	cpu.setParityFlag(0 != (ah & 0x0400));        cpu.setAuxiliaryCarryFlag(0 != (ah & 0x1000));        cpu.setZeroFlag(0 != (ah & 0x4000));        cpu.setSignFlag(0 != (ah & 0x8000));}}";
static final String OUT_O32 = "{ cpu.ioports.ioPortWriteLong(reg0, reg1); }";
static final String IN_O16 = "{ reg0 = 0xffff & cpu.ioports.ioPortReadWord(reg0); }";
static final String IN_O32 = "{ reg0 = cpu.ioports.ioPortReadLong(reg0); }";
static final String JO_O8 = "{  {	if (cpu.getOverflowFlag()) {	cpu.eip += (((byte)reg0));	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= (((byte)reg0));            throw exceptionGP;        }}}}";
static final String JNO_O8 = "{ {	if (!cpu.getOverflowFlag()) {	cpu.eip += (((byte)reg0));	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= (((byte)reg0));            throw exceptionGP;        }}}}";
static final String JS_O8 = "{  {	if (cpu.getSignFlag()) {	cpu.eip += (((byte)reg0));	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= (((byte)reg0));            throw exceptionGP;        }}}}";
static final String JP_O8 = "{  {	if (cpu.getParityFlag()) {	cpu.eip += (((byte)reg0));	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= (((byte)reg0));            throw exceptionGP;        }}}}";
static final String JNP_O8 = "{ {	if (!cpu.getParityFlag()) {	cpu.eip += (((byte)reg0));	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= (((byte)reg0));            throw exceptionGP;        }}}}";
static final String JO_O16 = "{  {	if (cpu.getOverflowFlag()) {	cpu.eip = (cpu.eip + (((short)reg0))) & 0xffff;}}}";
static final String JNO_O16 = "{ {	if (!cpu.getOverflowFlag()) {	cpu.eip = (cpu.eip + (((short)reg0))) & 0xffff;}}}";
static final String JNA_O16 = "{ {	if (cpu.getCarryFlag() || cpu.getZeroFlag()) {	cpu.eip = (cpu.eip + (((short)reg0))) & 0xffff;}}}";
static final String JS_O16 = "{  {	if (cpu.getSignFlag()) {	cpu.eip = (cpu.eip + (((short)reg0))) & 0xffff;}}}";
static final String JNS_O16 = "{ {	if (!cpu.getSignFlag()) {	cpu.eip = (cpu.eip + (((short)reg0))) & 0xffff;}}}";
static final String JP_O16 = "{  {	if (cpu.getParityFlag()) {	cpu.eip = (cpu.eip + (((short)reg0))) & 0xffff;}}}";
static final String JNP_O16 = "{ {	if (!cpu.getParityFlag()) {	cpu.eip = (cpu.eip + (((short)reg0))) & 0xffff;}}}";
static final String JL_O16 = "{  {	if (cpu.getSignFlag() != cpu.getOverflowFlag()) {	cpu.eip = (cpu.eip + (((short)reg0))) & 0xffff;}}}";
static final String JNL_O16 = "{ {	if (cpu.getSignFlag() == cpu.getOverflowFlag()) {	cpu.eip = (cpu.eip + (((short)reg0))) & 0xffff;}}}";
static final String JNG_O16 = "{ {	if (cpu.getZeroFlag() || (cpu.getSignFlag() != cpu.getOverflowFlag())) {	cpu.eip = (cpu.eip + (((short)reg0))) & 0xffff;}}}";
static final String JG_O16 = "{  {	if ((!cpu.getZeroFlag()) && (cpu.getSignFlag() == cpu.getOverflowFlag())) {	cpu.eip = (cpu.eip + (((short)reg0))) & 0xffff;}}}";
static final String JO_O32 = "{  {	if (cpu.getOverflowFlag()) {	cpu.eip += ((reg0));	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((reg0));            throw exceptionGP;        }}}}";
static final String JNO_O32 = "{ {	if (!cpu.getOverflowFlag()) {	cpu.eip += ((reg0));	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((reg0));            throw exceptionGP;        }}}}";
static final String JC_O32 = "{  {	if (cpu.getCarryFlag()) {	cpu.eip += ((reg0));	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((reg0));            throw exceptionGP;        }}}}";
static final String JNC_O32 = "{ {	if (!cpu.getCarryFlag()) {	cpu.eip += ((reg0));	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((reg0));            throw exceptionGP;        }}}}";
static final String JZ_O32 = "{  {	if (cpu.getZeroFlag()) {	cpu.eip += ((reg0));	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((reg0));            throw exceptionGP;        }}}}";
static final String JNZ_O32 = "{ {	if (!cpu.getZeroFlag()) {	cpu.eip += ((reg0));	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((reg0));            throw exceptionGP;        }}}}";
static final String JNA_O32 = "{ {	if (cpu.getCarryFlag() || cpu.getZeroFlag()) {	cpu.eip += ((reg0));	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((reg0));            throw exceptionGP;        }}}}";
static final String JA_O32 = "{  {	if ((!cpu.getCarryFlag()) && (!cpu.getZeroFlag())) {	cpu.eip += ((reg0));	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((reg0));            throw exceptionGP;        }}}}";
static final String JS_O32 = "{  {	if (cpu.getSignFlag()) {	cpu.eip += ((reg0));	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((reg0));            throw exceptionGP;        }}}}";
static final String JNS_O32 = "{ {	if (!cpu.getSignFlag()) {	cpu.eip += ((reg0));	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((reg0));            throw exceptionGP;        }}}}";
static final String JP_O32 = "{  {	if (cpu.getParityFlag()) {	cpu.eip += ((reg0));	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((reg0));            throw exceptionGP;        }}}}";
static final String JNP_O32 = "{ {	if (!cpu.getParityFlag()) {	cpu.eip += ((reg0));	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((reg0));            throw exceptionGP;        }}}}";
static final String JL_O32 = "{  {	if (cpu.getSignFlag() != cpu.getOverflowFlag()) {	cpu.eip += ((reg0));	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((reg0));            throw exceptionGP;        }}}}";
static final String JNL_O32 = "{ {	if (cpu.getSignFlag() == cpu.getOverflowFlag()) {	cpu.eip += ((reg0));	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((reg0));            throw exceptionGP;        }}}}";
static final String JNG_O32 = "{ {	if (cpu.getZeroFlag() || (cpu.getSignFlag() != cpu.getOverflowFlag())) {	cpu.eip += ((reg0));	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((reg0));            throw exceptionGP;        }}}}";
static final String JG_O32 = "{  {	if ((!cpu.getZeroFlag()) && (cpu.getSignFlag() == cpu.getOverflowFlag())) {	cpu.eip += ((reg0));	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((reg0));            throw exceptionGP;        }}}}";
static final String JECXZ = "{ {	if (cpu.ecx == 0) {	cpu.eip += (((byte)reg0));	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= (((byte)reg0));            throw exceptionGP;        }}}}";
static final String JUMP_O32 = "{ {	cpu.eip += (reg0);	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= (reg0);            throw exceptionGP;        }}}";
static final String SETO = "{  reg0 = cpu.getOverflowFlag() ? 1 : 0; }";
static final String SETNO = "{ reg0 = cpu.getOverflowFlag() ? 0 : 1; }";
static final String SETNC = "{ reg0 = cpu.getCarryFlag() ? 0 : 1; }";
static final String SETZ = "{  reg0 = cpu.getZeroFlag() ? 1 : 0; }";
static final String SETNZ = "{ reg0 = cpu.getZeroFlag() ? 0 : 1; }";
static final String SETNA = "{ reg0 = cpu.getCarryFlag() || cpu.getZeroFlag() ? 1 : 0; }";
static final String SETA = "{  reg0 = cpu.getCarryFlag() || cpu.getZeroFlag() ? 0 : 1; }";
static final String SETS = "{  reg0 = cpu.getSignFlag() ? 1 : 0; }";
static final String SETNS = "{ reg0 = cpu.getSignFlag() ? 0 : 1; }";
static final String SETP = "{  reg0 = cpu.getParityFlag() ? 1 : 0; }";
static final String SETNP = "{ reg0 = cpu.getParityFlag() ? 0 : 1; }";
static final String SETL = "{  reg0 = cpu.getSignFlag() != cpu.getOverflowFlag() ? 1 : 0; }";
static final String SETNL = "{ reg0 = cpu.getSignFlag() != cpu.getOverflowFlag() ? 0 : 1; }";
static final String SETNG = "{ reg0 = cpu.getZeroFlag() || (cpu.getSignFlag() != cpu.getOverflowFlag()) ? 1 : 0; }";
static final String SETG = "{  reg0 = cpu.getZeroFlag() || (cpu.getSignFlag() != cpu.getOverflowFlag()) ? 0 : 1; }";
static final String STD = "{ cpu.eflagsDirection = true; }";
static final String CMC = "{ cpu.setCarryFlag(cpu.getCarryFlag() ^ true); }";
static final String AAA = "{ {	if (((cpu.eax & 0xf) > 0x9) || cpu.getAuxiliaryCarryFlag()) {	    int alCarry = ((cpu.eax & 0xff) > 0xf9) ? 0x100 : 0x000;	    cpu.eax = (0xffff0000 & cpu.eax) | (0x0f & (cpu.eax + 6)) | (0xff00 & (cpu.eax + 0x100 + alCarry));	    cpu.setAuxiliaryCarryFlag(true);	    cpu.setCarryFlag(true);	} else {	    cpu.setAuxiliaryCarryFlag(false);	    cpu.setCarryFlag(false);	    cpu.eax = cpu.eax & 0xffffff0f;	}}}";
static final String AAD = "{ {        int tl = (cpu.eax & 0xff);        int th = ((cpu.eax >> 8) & 0xff);	int ax1 = th * (reg0);	int ax2 = ax1 + tl;        cpu.eax = (cpu.eax & ~0xffff) | (ax2 & 0xff);	{        cpu.setOverflowFlag(false);        cpu.setCarryFlag(false);        cpu.setZeroFlag(((byte)ax2));        cpu.setParityFlag(((byte)ax2));	cpu.setSignFlag(((byte)ax2));}	cpu.setAuxiliaryCarryFlag(ax1, ax2, Processor.AC_BIT4_NEQ);	cpu.setCarryFlag(ax2, Processor.CY_GREATER_FF);	cpu.setOverflowFlag(ax2, tl, Processor.OF_BIT7_DIFFERENT);}}";
static final String AAM = "{ {        int tl = 0xff & cpu.eax;        if ((reg0) == 0)             throw exceptionDE;        int ah = 0xff & (tl / (reg0));        int al = 0xff & (tl % (reg0));        cpu.eax &= ~0xffff;        cpu.eax |= (al | (ah << 8));	cpu.setAuxiliaryCarryFlag(false);	{        cpu.setOverflowFlag(false);        cpu.setCarryFlag(false);        cpu.setZeroFlag(((byte)al));        cpu.setParityFlag(((byte)al));	cpu.setSignFlag(((byte)al));}}}";
static final String AAS = "{ {	if (((cpu.eax & 0xf) > 0x9) || cpu.getAuxiliaryCarryFlag()) {	    int alBorrow = (cpu.eax & 0xff) < 6 ? 0x100 : 0x000;	    cpu.eax = (0xffff0000 & cpu.eax) | (0x0f & (cpu.eax - 6)) | (0xff00 & (cpu.eax - 0x100 - alBorrow));	    cpu.setAuxiliaryCarryFlag(true);	    cpu.setCarryFlag(true);	} else {	    cpu.setAuxiliaryCarryFlag(false);	    cpu.setCarryFlag(false);	    cpu.eax = cpu.eax & 0xffffff0f;	}}}";
static final String DAA = "{ {	int al = cpu.eax & 0xff;	boolean newCF;	if (((cpu.eax & 0xf) > 0x9) || cpu.getAuxiliaryCarryFlag()) {            al += 6;            cpu.setAuxiliaryCarryFlag(true);        } else            cpu.setAuxiliaryCarryFlag(false);	        if (((al & 0xff) > 0x9f) || cpu.getCarryFlag()) {	    al += 0x60;            newCF = true;	} else            newCF = false;		cpu.eax = (cpu.eax & ~0xff) | (0xff & al);	{        cpu.setOverflowFlag(false);        cpu.setCarryFlag(false);        cpu.setZeroFlag(((byte)al));        cpu.setParityFlag(((byte)al));	cpu.setSignFlag(((byte)al));}	cpu.setCarryFlag(newCF);}}";
static final String DAS = "{ {	boolean tempCF = false;	int tempAL = 0xff & cpu.eax; 	if (((tempAL & 0xf) > 0x9) || cpu.getAuxiliaryCarryFlag()) {	    cpu.setAuxiliaryCarryFlag(true);	    cpu.eax = (cpu.eax & ~0xff) | ((cpu.eax - 0x06) & 0xff);	    tempCF = (tempAL < 0x06) || cpu.getCarryFlag();	}	        if ((tempAL > 0x99) || cpu.getCarryFlag()) {            cpu.eax = (cpu.eax & ~0xff) | ((cpu.eax - 0x60) & 0xff);	    tempCF = true;	}	{        cpu.setOverflowFlag(false);        cpu.setCarryFlag(false);        cpu.setZeroFlag(((byte)cpu.eax));        cpu.setParityFlag(((byte)cpu.eax));	cpu.setSignFlag(((byte)cpu.eax));}	cpu.setCarryFlag(tempCF);}}";
static final String CALL_O32_A16 = "{ {	if (((cpu.esp & 0xffff) < 4) && ((cpu.esp & 0xffff) > 0))	    throw exceptionSS;	if ((cpu.eip + (reg0)) > 0xffff)	    throw exceptionGP;	int offset = (cpu.esp - 4) & 0xffff;	cpu.ss.setDoubleWord(offset, cpu.eip);	cpu.esp = (cpu.esp & 0xffff0000) | offset;	cpu.eip = cpu.eip + (reg0);}}";
static final String RET_O32_A16 = "{ {	/* TODO:  supposed to throw SS exception*/	/* \"if top 6 bytes of stack not within stack limits\"*/	cpu.eip = cpu.ss.getDoubleWord(cpu.esp & 0xffff) & 0xffff;	cpu.esp = (cpu.esp & ~0xffff) | ((cpu.esp + 4) & 0xffff);}}";
static final String WAIT = "{}";
static final String HALT = "{ {	while (true)         {	    if (((cpu.getInterruptFlags() & Processor.IFLAGS_HARDWARE_INTERRUPT) != 0) && cpu.eflagsInterruptEnable)		break;	                cpu.waitForInterrupt(50);	    cpu.processClock();	}}}";
static final String LOOP_ECX = "{ cpu.ecx--; if (cpu.ecx != 0) {	cpu.eip += ((byte)reg0);	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((byte)reg0);            throw exceptionGP;        }}}";
static final String LOOPZ_ECX = "{ cpu.ecx--; if ((cpu.ecx != 0) && cpu.getZeroFlag()) {	cpu.eip += ((byte)reg0);	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((byte)reg0);            throw exceptionGP;        }}}";
static final String LOOPNZ_ECX = "{ cpu.ecx--; if ((cpu.ecx != 0) && !cpu.getZeroFlag()) {	cpu.eip += ((byte)reg0);	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((byte)reg0);            throw exceptionGP;        }}}";
static final String LOOPNZ_CX = "{ cpu.ecx = (cpu.ecx & ~0xffff) | ((cpu.ecx - 1) & 0xffff); if (((0xffff & cpu.ecx) != 0) && !cpu.getZeroFlag()) {	cpu.eip += ((byte)reg0);	/* check whether eip is outside of 0x0000 and 0xffff*/	if ((cpu.eip & 0xFFFF0000) != 0)        {            cpu.eip -= ((byte)reg0);            throw exceptionGP;        }}}";
static final String PUSHF_O32_A16 = "{ {	if (((cpu.esp & 0xffff) < 4) && ((cpu.esp & 0xffff) > 0))	    throw exceptionSS;	int w = cpu.getEFlags() & 0xfcffff ;	int offset = (cpu.esp - 4) & 0xffff;	cpu.ss.setDoubleWord(offset, w);	cpu.esp = (cpu.esp & ~0xffff) | offset;}}";
static final String POPF_O32_A16 = "{ {	/*SS exception?*/	int w = cpu.ss.getDoubleWord(cpu.esp & 0xffff);	/*cpu.esp += 4;*/	cpu.esp = (cpu.esp & ~0xffff) | ((cpu.esp + 4) & 0xffff);	boolean vm = cpu.eflagsVirtual8086Mode;	cpu.setEFlags(w);	cpu.eflagsVirtual8086Mode = vm;	cpu.eflagsVirtualInterrupt = false;	cpu.eflagsVirtualInterruptPending = false;}}";
static final String SIGN_EXTEND_8_32 = "{ reg0 = (byte)reg0; }";
static final String SIGN_EXTEND_16_32 = "{ reg0 = (short)reg0; }";
static final String CMPSB_A16 = "{ {	int addrOne = cpu.esi & 0xffff;	int addrTwo = cpu.edi & 0xffff;		int dataOne = 0xff & (seg0).getByte(addrOne);	int dataTwo = 0xff & cpu.es.getByte(addrTwo);	if (cpu.eflagsDirection) {	    addrOne -= 1;	    addrTwo -= 1;	} else {	    addrOne += 1;	    addrTwo += 1;	}	cpu.esi = (cpu.esi & ~0xffff) | (addrOne & 0xffff);	cpu.edi = (cpu.edi & ~0xffff) | (addrTwo & 0xffff);		{	{        cpu.setZeroFlag((byte)((dataOne - dataTwo)));        cpu.setParityFlag(((dataOne - dataTwo)));	cpu.setSignFlag((byte)((dataOne - dataTwo)));	cpu.setCarryFlag(((dataOne - dataTwo)), Processor.CY_TWIDDLE_FF);	cpu.setAuxiliaryCarryFlag(( ( dataOne)), ( ( dataTwo)), ((dataOne - dataTwo)), Processor.AC_XOR);}	cpu.setOverflowFlag(( dataOne), (dataOne - dataTwo), ( dataTwo), Processor.OF_ADDSUB_BYTE);}}}";
static final String CMPSW_A16 = "{ {	int addrOne = cpu.esi & 0xffff;	int addrTwo = cpu.edi & 0xffff;		int dataOne = 0xffff & (seg0).getWord(addrOne);	int dataTwo = 0xffff & cpu.es.getWord(addrTwo);	if (cpu.eflagsDirection) {	    addrOne -= 2;	    addrTwo -= 2;	} else {	    addrOne += 2;	    addrTwo += 2;	}	cpu.esi = (cpu.esi & ~0xffff) | (addrOne & 0xffff);	cpu.edi = (cpu.edi & ~0xffff) | (addrTwo & 0xffff);		{	{        cpu.setZeroFlag((short)((dataOne - dataTwo)));        cpu.setParityFlag(((dataOne - dataTwo)));	cpu.setSignFlag((short)((dataOne - dataTwo)));	cpu.setCarryFlag(((dataOne - dataTwo)), Processor.CY_TWIDDLE_FFFF);	cpu.setAuxiliaryCarryFlag(( ( dataOne)), ( ( dataTwo)), ((dataOne - dataTwo)), Processor.AC_XOR);}	cpu.setOverflowFlag(( dataOne), (dataOne - dataTwo), ( dataTwo), Processor.OF_ADDSUB_SHORT);}}}";
static final String CMPSD_A16 = "{ {	int addrOne = cpu.esi & 0xffff;	int addrTwo = cpu.edi & 0xffff;		int dataOne = (seg0).getDoubleWord(addrOne);	int dataTwo = cpu.es.getDoubleWord(addrTwo);	if (cpu.eflagsDirection) {	    addrOne -= 4;	    addrTwo -= 4;	} else {	    addrOne += 4;	    addrTwo += 4;	}	cpu.esi = (cpu.esi & ~0xffff) | (addrOne & 0xffff);	cpu.edi = (cpu.edi & ~0xffff) | (addrTwo & 0xffff);		{	((0xffffffffl & dataOne) - (0xffffffffl & dataTwo)) = (0xffffffffl & ( dataOne)) - (0xffffffffl & ( dataTwo));	{        cpu.setZeroFlag((int)(((0xffffffffl & dataOne) - (0xffffffffl & dataTwo))));	cpu.setParityFlag((int)(((0xffffffffl & dataOne) - (0xffffffffl & dataTwo))));	cpu.setSignFlag((int)(((0xffffffffl & dataOne) - (0xffffffffl & dataTwo))));	cpu.setCarryFlag((((0xffffffffl & dataOne) - (0xffffffffl & dataTwo))), Processor.CY_TWIDDLE_FFFFFFFF);	cpu.setAuxiliaryCarryFlag(( ( dataOne)), ( ( dataTwo)), (int)(((0xffffffffl & dataOne) - (0xffffffffl & dataTwo))), Processor.AC_XOR);}	cpu.setOverflowFlag(( dataOne), (int)((0xffffffffl & dataOne) - (0xffffffffl & dataTwo)), ( dataTwo), Processor.OF_ADDSUB_INT);}}}";
static final String REPE_CMPSW_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addrOne = cpu.esi & 0xffff;	int addrTwo = cpu.edi & 0xffff;	boolean used = count != 0;	int dataOne = 0;	int dataTwo = 0;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    dataOne = 0xffff & (seg0).getWord(addrOne);		    dataTwo = 0xffff & cpu.es.getWord(addrTwo);		    count--;		    addrOne -= 2;		    addrTwo -= 2;		    if (dataOne != dataTwo) break;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    dataOne = 0xffff & (seg0).getWord(addrOne);		    dataTwo = 0xffff & cpu.es.getWord(addrTwo);		    count--;		    addrOne += 2;		    addrTwo += 2;		    if (dataOne != dataTwo) break;		}	    }	}	finally {	    executeCount += ((cpu.ecx & 0xffff) - count);	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.esi = (cpu.esi & ~0xffff) | (addrOne & 0xffff);	    cpu.edi = (cpu.edi & ~0xffff) | (addrTwo & 0xffff);	    if (used)		{	{        cpu.setZeroFlag((short)((dataOne - dataTwo)));        cpu.setParityFlag(((dataOne - dataTwo)));	cpu.setSignFlag((short)((dataOne - dataTwo)));	cpu.setCarryFlag(((dataOne - dataTwo)), Processor.CY_TWIDDLE_FFFF);	cpu.setAuxiliaryCarryFlag(( ( dataOne)), ( ( dataTwo)), ((dataOne - dataTwo)), Processor.AC_XOR);}	cpu.setOverflowFlag(( dataOne), (dataOne - dataTwo), ( dataTwo), Processor.OF_ADDSUB_SHORT);}	}}}";
static final String REPE_CMPSD_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addrOne = cpu.esi & 0xffff;	int addrTwo = cpu.edi & 0xffff;	boolean used = count != 0;	int dataOne = 0;	int dataTwo = 0;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    dataOne = (seg0).getDoubleWord(addrOne);		    dataTwo = cpu.es.getDoubleWord(addrTwo);		    count--;		    addrOne -= 4;		    addrTwo -= 4;		    if (dataOne != dataTwo) break;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    dataOne = (seg0).getDoubleWord(addrOne);		    dataTwo = cpu.es.getDoubleWord(addrTwo);		    count--;		    addrOne += 4;		    addrTwo += 4;		    if (dataOne != dataTwo) break;		}	    }	}	finally {	    executeCount += ((cpu.ecx & 0xffff) - count);	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.esi = (cpu.esi & ~0xffff) | (addrOne & 0xffff);	    cpu.edi = (cpu.edi & ~0xffff) | (addrTwo & 0xffff);	    if (used)		{	((0xffffffffl & dataOne) - (0xffffffffl & dataTwo)) = (0xffffffffl & ( dataOne)) - (0xffffffffl & ( dataTwo));	{        cpu.setZeroFlag((int)(((0xffffffffl & dataOne) - (0xffffffffl & dataTwo))));	cpu.setParityFlag((int)(((0xffffffffl & dataOne) - (0xffffffffl & dataTwo))));	cpu.setSignFlag((int)(((0xffffffffl & dataOne) - (0xffffffffl & dataTwo))));	cpu.setCarryFlag((((0xffffffffl & dataOne) - (0xffffffffl & dataTwo))), Processor.CY_TWIDDLE_FFFFFFFF);	cpu.setAuxiliaryCarryFlag(( ( dataOne)), ( ( dataTwo)), (int)(((0xffffffffl & dataOne) - (0xffffffffl & dataTwo))), Processor.AC_XOR);}	cpu.setOverflowFlag(( dataOne), (int)((0xffffffffl & dataOne) - (0xffffffffl & dataTwo)), ( dataTwo), Processor.OF_ADDSUB_INT);}	}}}";
static final String INSB_A16 = "{ {	int addr = cpu.edi & 0xffff;	cpu.es.setByte(addr & 0xffff, (byte)cpu.ioports.ioPortReadByte((reg0)));			if (cpu.eflagsDirection) {	    addr -= 1;	} else {	    addr += 1;	}	cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);}}";
static final String INSW_A16 = "{ {	int addr = cpu.edi & 0xffff;	cpu.es.setWord(addr & 0xffff, (short)cpu.ioports.ioPortReadWord((reg0)));			if (cpu.eflagsDirection) {	    addr -= 2;	} else {	    addr += 2;	}	cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);}}";
static final String INSD_A16 = "{ {	int addr = cpu.edi & 0xffff;	cpu.es.setDoubleWord(addr & 0xffff, cpu.ioports.ioPortReadLong((reg0)));			if (cpu.eflagsDirection) {	    addr -= 4;	} else {	    addr += 4;	}	cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);}}";
static final String REP_INSB_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addr = cpu.edi & 0xffff;	executeCount += count;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setByte(addr & 0xffff, (byte)cpu.ioports.ioPortReadByte((reg0)));				    count--;		    addr -= 1;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setByte(addr & 0xffff, (byte)cpu.ioports.ioPortReadByte((reg0)));				    count--;		    addr += 1;		}	    }	}	finally {	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);	}}}";
static final String REP_INSW_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addr = cpu.edi & 0xffff;	executeCount += count;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setWord(addr & 0xffff, (short)cpu.ioports.ioPortReadWord((reg0)));				    count--;		    addr -= 2;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setWord(addr & 0xffff, (short)cpu.ioports.ioPortReadWord((reg0)));				    count--;		    addr += 2;		}	    }	}	finally {	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);	}}}";
static final String REP_INSD_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addr = cpu.edi & 0xffff;	executeCount += count;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setDoubleWord(addr & 0xffff, cpu.ioports.ioPortReadLong((reg0)));				    count--;		    addr -= 4;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setDoubleWord(addr & 0xffff, cpu.ioports.ioPortReadLong((reg0)));				    count--;		    addr += 4;		}	    }	}	finally {	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);	}}}";
static final String LODSD_A16 = "{ {	int addr = cpu.esi & 0xffff;	cpu.eax = (seg0).getDoubleWord(addr);		if (cpu.eflagsDirection)	    addr -= 4;	else	    addr += 4;		cpu.esi = (cpu.esi & ~0xffff) | (addr & 0xffff);}}";
static final String REP_LODSB_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addr = cpu.esi & 0xffff;	int data = cpu.eax & 0xff;	executeCount += count;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    data = 0xff & (seg0).getByte(addr);		    count--;		    addr -= 1;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    data = 0xff & (seg0).getByte(addr);		    count--;		    addr += 1;		}	    }	}	finally {	    cpu.eax = (cpu.eax & ~0xff) | data;	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.esi = (cpu.esi & ~0xffff) | (addr & 0xffff);	}}}";
static final String REP_LODSW_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addr = cpu.esi & 0xffff;	int data = cpu.eax & 0xffff;	executeCount += count;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    data = 0xffff & (seg0).getWord(addr);		    count--;		    addr -= 2;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    data = 0xffff & (seg0).getWord(addr);		    count--;		    addr += 2;		}	    }	}	finally {	    cpu.eax = (cpu.eax & ~0xffff) | data;	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.esi = (cpu.esi & ~0xffff) | (addr & 0xffff);	}}}";
static final String REP_LODSD_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addr = cpu.esi & 0xffff;	int data = cpu.eax;	executeCount += count;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    data = (seg0).getDoubleWord(addr);		    count--;		    addr -= 4;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    data = (seg0).getDoubleWord(addr);		    count--;		    addr += 4;		}	    }	}	finally {	    cpu.eax = data;	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.esi = (cpu.esi & ~0xffff) | (addr & 0xffff);	}}}";
static final String MOVSB_A32 = "{ {	int inAddr = cpu.edi;	int outAddr = cpu.esi;	cpu.es.setByte(inAddr, (seg0).getByte(outAddr));			if (cpu.eflagsDirection) {	    outAddr -= 1;	    inAddr -= 1;	} else {	    outAddr += 1;	    inAddr += 1;	}	cpu.edi = inAddr;	cpu.esi = outAddr;}}";
static final String MOVSW_A32 = "{ {	int inAddr = cpu.edi;	int outAddr = cpu.esi;	cpu.es.setWord(inAddr, (seg0).getWord(outAddr));			if (cpu.eflagsDirection) {	    outAddr -= 2;	    inAddr -= 2;	} else {	    outAddr += 2;	    inAddr += 2;	}	cpu.edi = inAddr;	cpu.esi = outAddr;}}";
static final String MOVSD_A16 = "{ {	int inAddr = cpu.edi & 0xffff;	int outAddr = cpu.esi & 0xffff;	cpu.es.setDoubleWord(inAddr, (seg0).getDoubleWord(outAddr));			if (cpu.eflagsDirection) {	    outAddr -= 4;	    inAddr -= 4;	} else {	    outAddr += 4;	    inAddr += 4;	}	cpu.edi = (cpu.edi & ~0xffff) | (inAddr & 0xffff);	cpu.esi = (cpu.esi & ~0xffff) | (outAddr & 0xffff);}}";
static final String MOVSD_A32 = "{ {	int inAddr = cpu.edi;	int outAddr = cpu.esi;	cpu.es.setDoubleWord(inAddr, (seg0).getDoubleWord(outAddr));			if (cpu.eflagsDirection) {	    outAddr -= 4;	    inAddr -= 4;	} else {	    outAddr += 4;	    inAddr += 4;	}	cpu.edi = inAddr & 0xffff;	cpu.esi = outAddr & 0xffff;}}";
static final String REP_MOVSB_A32 = "{ {	int count = cpu.ecx;	int inAddr = cpu.edi;	int outAddr = cpu.esi;	executeCount += count;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setByte(inAddr, (seg0).getByte(outAddr));				    count--;		    outAddr -= 1;		    inAddr -= 1;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setByte(inAddr, (seg0).getByte(outAddr));				    count--;		    outAddr += 1;		    inAddr += 1;		}	    }	}	finally {	    cpu.ecx = count;	    cpu.edi = inAddr;	    cpu.esi = outAddr;	}}}";
static final String REP_MOVSW_A32 = "{ {	int count = cpu.ecx;	int inAddr = cpu.edi;	int outAddr = cpu.esi;	executeCount += count;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setWord(inAddr, (seg0).getWord(outAddr));				    count--;		    outAddr -= 2;		    inAddr -= 2;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setWord(inAddr, (seg0).getWord(outAddr));				    count--;		    outAddr += 2;		    inAddr += 2;		}	    }	}	finally {	    cpu.ecx = count;	    cpu.edi = inAddr;	    cpu.esi = outAddr;	}}}";
static final String REP_MOVSD_A16 = "{ {	int count = cpu.ecx & 0xffff;	int inAddr = cpu.edi & 0xffff;	int outAddr = cpu.esi & 0xffff;	executeCount += count;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setDoubleWord(inAddr & 0xffff, (seg0).getDoubleWord(outAddr & 0xffff));				    count--;		    outAddr -= 4;		    inAddr -= 4;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setDoubleWord(inAddr & 0xffff, (seg0).getDoubleWord(outAddr & 0xffff));				    count--;		    outAddr += 4;		    inAddr += 4;		}	    }	}	finally {	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.edi = (cpu.edi & ~0xffff) | (inAddr & 0xffff);	    cpu.esi = (cpu.esi & ~0xffff) | (outAddr & 0xffff);	}}}";
static final String REP_MOVSD_A32 = "{ {	int count = cpu.ecx;	int inAddr = cpu.edi;	int outAddr = cpu.esi;	executeCount += count;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setDoubleWord(inAddr, (seg0).getDoubleWord(outAddr));				    count--;		    outAddr -= 4;		    inAddr -= 4;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setDoubleWord(inAddr, (seg0).getDoubleWord(outAddr));				    count--;		    outAddr += 4;		    inAddr += 4;		}	    }	}	finally {	    cpu.ecx = count;	    cpu.edi = inAddr;	    cpu.esi = outAddr;	}}}";
static final String OUTSB_A16 = "{ {	int addr = cpu.esi & 0xffff;	cpu.ioports.ioPortWriteByte((reg0), 0xff & ( seg0).getByte(addr));	if (cpu.eflagsDirection)	    addr -= 1;	else	    addr += 1;			cpu.esi = (cpu.esi & ~0xffff) | (addr & 0xffff);}}";
static final String OUTSW_A16 = "{ {	int addr = cpu.esi & 0xffff;	cpu.ioports.ioPortWriteWord((reg0), 0xffff & ( seg0).getWord(addr));	if (cpu.eflagsDirection)	    addr -= 2;	else	    addr += 2;			cpu.esi = (cpu.esi & ~0xffff) | (addr & 0xffff);}}";
static final String OUTSD_A16 = "{ {	int addr = cpu.esi & 0xffff;	cpu.ioports.ioPortWriteLong((reg0), ( seg0).getDoubleWord(addr));	if (cpu.eflagsDirection)	    addr -= 4;	else	    addr += 4;			cpu.esi = (cpu.esi & ~0xffff) | (addr & 0xffff);}}";
static final String REP_OUTSB_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addr = cpu.esi & 0xffff;	executeCount += count;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.ioports.ioPortWriteByte((reg0), 0xffff & ( seg0).getByte(addr & 0xffff));		    count--;		    addr -= 1;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.ioports.ioPortWriteByte((reg0), 0xffff & ( seg0).getByte(addr & 0xffff));		    count--;		    addr += 1;		}	    }	}	finally {	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.esi = (cpu.esi & ~0xffff) | (addr & 0xffff);	}}}";
static final String REP_OUTSW_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addr = cpu.esi & 0xffff;	executeCount += count;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.ioports.ioPortWriteWord((reg0), 0xffff & ( seg0).getWord(addr & 0xffff));		    count--;		    addr -= 2;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.ioports.ioPortWriteWord((reg0), 0xffff & ( seg0).getWord(addr & 0xffff));		    count--;		    addr += 2;		}	    }	}	finally {	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.esi = (cpu.esi & ~0xffff) | (addr & 0xffff);	}}}";
static final String REP_OUTSD_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addr = cpu.esi & 0xffff;	executeCount += count;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.ioports.ioPortWriteLong((reg0), ( seg0).getDoubleWord(addr & 0xffff));		    count--;		    addr -= 4;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.ioports.ioPortWriteLong((reg0), ( seg0).getDoubleWord(addr & 0xffff));		    count--;		    addr += 4;		}	    }	}	finally {	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.esi = (cpu.esi & ~0xffff) | (addr & 0xffff);	}}}";
static final String SCASB_A16 = "{ {	int addr = cpu.edi & 0xffff;	int input = 0xff & cpu.es.getByte(addr);	if (cpu.eflagsDirection)	    addr -= 1;	else	    addr += 1;		cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);	{	{        cpu.setZeroFlag((byte)(((reg0) - input)));        cpu.setParityFlag((((reg0) - input)));	cpu.setSignFlag((byte)(((reg0) - input)));	cpu.setCarryFlag((((reg0) - input)), Processor.CY_TWIDDLE_FF);	cpu.setAuxiliaryCarryFlag(( ( (reg0))), ( ( input)), (((reg0) - input)), Processor.AC_XOR);}	cpu.setOverflowFlag(( (reg0)), ((reg0) - input), ( input), Processor.OF_ADDSUB_BYTE);}}}";
static final String SCASW_A16 = "{ {	int addr = cpu.edi & 0xffff;	int input = 0xffff & cpu.es.getWord(addr);	if (cpu.eflagsDirection)	    addr -= 2;	else	    addr += 2;		cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);	{	{        cpu.setZeroFlag((short)(((reg0) - input)));        cpu.setParityFlag((((reg0) - input)));	cpu.setSignFlag((short)(((reg0) - input)));	cpu.setCarryFlag((((reg0) - input)), Processor.CY_TWIDDLE_FFFF);	cpu.setAuxiliaryCarryFlag(( ( (reg0))), ( ( input)), (((reg0) - input)), Processor.AC_XOR);}	cpu.setOverflowFlag(( (reg0)), ((reg0) - input), ( input), Processor.OF_ADDSUB_SHORT);}}}";
static final String SCASD_A16 = "{ {	int addr = cpu.edi & 0xffff;	int input = cpu.es.getDoubleWord(addr);	if (cpu.eflagsDirection)	    addr -= 4;	else	    addr += 4;		cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);	{	((0xffffffffl & (reg0)) - (0xffffffffl & input)) = (0xffffffffl & ( (reg0))) - (0xffffffffl & ( input));	{        cpu.setZeroFlag((int)(((0xffffffffl & (reg0)) - (0xffffffffl & input))));	cpu.setParityFlag((int)(((0xffffffffl & (reg0)) - (0xffffffffl & input))));	cpu.setSignFlag((int)(((0xffffffffl & (reg0)) - (0xffffffffl & input))));	cpu.setCarryFlag((((0xffffffffl & (reg0)) - (0xffffffffl & input))), Processor.CY_TWIDDLE_FFFFFFFF);	cpu.setAuxiliaryCarryFlag(( ( (reg0))), ( ( input)), (int)(((0xffffffffl & (reg0)) - (0xffffffffl & input))), Processor.AC_XOR);}	cpu.setOverflowFlag(( (reg0)), (int)((0xffffffffl & (reg0)) - (0xffffffffl & input)), ( input), Processor.OF_ADDSUB_INT);}}}";
static final String REPE_SCASB_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addr = cpu.edi & 0xffff;        boolean used = count != 0;	int input = 0;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    input = 0xff & cpu.es.getByte(addr);		    count--;		    addr -= 1;		    if ((reg0) != input) break;		}	    } else {		while (count != 0) {		    input = 0xff & cpu.es.getByte(addr);		    count--;		    addr += 1;		    if ((reg0) != input) break;		}	    }	} finally {	    executeCount += ((cpu.ecx & 0xffff) - count);	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);	    if (used)		{	{        cpu.setZeroFlag((byte)(((reg0) - input)));        cpu.setParityFlag((((reg0) - input)));	cpu.setSignFlag((byte)(((reg0) - input)));	cpu.setCarryFlag((((reg0) - input)), Processor.CY_TWIDDLE_FF);	cpu.setAuxiliaryCarryFlag(( ( (reg0))), ( ( input)), (((reg0) - input)), Processor.AC_XOR);}	cpu.setOverflowFlag(( (reg0)), ((reg0) - input), ( input), Processor.OF_ADDSUB_BYTE);}	}}}";
static final String REPE_SCASW_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addr = cpu.edi & 0xffff;        boolean used = count != 0;	int input = 0;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    input = 0xffff & cpu.es.getWord(addr);		    count--;		    addr -= 2;		    if ((reg0) != input) break;		}	    } else {		while (count != 0) {		    input = 0xffff & cpu.es.getWord(addr);		    count--;		    addr += 2;		    if ((reg0) != input) break;		}	    }	} finally {	    executeCount += ((cpu.ecx & 0xffff) - count);	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);	    if (used)		{	{        cpu.setZeroFlag((short)(((reg0) - input)));        cpu.setParityFlag((((reg0) - input)));	cpu.setSignFlag((short)(((reg0) - input)));	cpu.setCarryFlag((((reg0) - input)), Processor.CY_TWIDDLE_FFFF);	cpu.setAuxiliaryCarryFlag(( ( (reg0))), ( ( input)), (((reg0) - input)), Processor.AC_XOR);}	cpu.setOverflowFlag(( (reg0)), ((reg0) - input), ( input), Processor.OF_ADDSUB_SHORT);}	}}}";
static final String REPE_SCASD_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addr = cpu.edi & 0xffff;        boolean used = count != 0;	int input = 0;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    input = cpu.es.getDoubleWord(addr);		    count--;		    addr -= 4;		    if ((reg0) != input) break;		}	    } else {		while (count != 0) {		    input = cpu.es.getDoubleWord(addr);		    count--;		    addr += 4;		    if ((reg0) != input) break;		}	    }	} finally {	    executeCount += ((cpu.ecx & 0xffff) - count);	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);	    if (used)		{	((0xffffffffl & (reg0)) - (0xffffffffl & input)) = (0xffffffffl & ( (reg0))) - (0xffffffffl & ( input));	{        cpu.setZeroFlag((int)(((0xffffffffl & (reg0)) - (0xffffffffl & input))));	cpu.setParityFlag((int)(((0xffffffffl & (reg0)) - (0xffffffffl & input))));	cpu.setSignFlag((int)(((0xffffffffl & (reg0)) - (0xffffffffl & input))));	cpu.setCarryFlag((((0xffffffffl & (reg0)) - (0xffffffffl & input))), Processor.CY_TWIDDLE_FFFFFFFF);	cpu.setAuxiliaryCarryFlag(( ( (reg0))), ( ( input)), (int)(((0xffffffffl & (reg0)) - (0xffffffffl & input))), Processor.AC_XOR);}	cpu.setOverflowFlag(( (reg0)), (int)((0xffffffffl & (reg0)) - (0xffffffffl & input)), ( input), Processor.OF_ADDSUB_INT);}	}}}";
static final String REPNE_SCASW_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addr = cpu.edi & 0xffff;        boolean used = count != 0;	int input = 0;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    input = 0xffff & cpu.es.getWord(addr);		    count--;		    addr -= 2;		    if ((reg0) == input) break;		}	    } else {		while (count != 0) {		    input = 0xffff & cpu.es.getWord(addr);		    count--;		    addr += 2;		    if ((reg0) == input) break;		}	    }	} finally {	    executeCount += ((cpu.ecx & 0xffff) - count);	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);	    if (used)		{	{        cpu.setZeroFlag((short)(((reg0) - input)));        cpu.setParityFlag((((reg0) - input)));	cpu.setSignFlag((short)(((reg0) - input)));	cpu.setCarryFlag((((reg0) - input)), Processor.CY_TWIDDLE_FFFF);	cpu.setAuxiliaryCarryFlag(( ( (reg0))), ( ( input)), (((reg0) - input)), Processor.AC_XOR);}	cpu.setOverflowFlag(( (reg0)), ((reg0) - input), ( input), Processor.OF_ADDSUB_SHORT);}	}}}";
static final String REPNE_SCASD_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addr = cpu.edi & 0xffff;        boolean used = count != 0;	int input = 0;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    input = cpu.es.getDoubleWord(addr);		    count--;		    addr -= 4;		    if ((reg0) == input) break;		}	    } else {		while (count != 0) {		    input = cpu.es.getDoubleWord(addr);		    count--;		    addr += 4;		    if ((reg0) == input) break;		}	    }	} finally {	    executeCount += ((cpu.ecx & 0xffff) - count);	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);	    if (used)		{	((0xffffffffl & (reg0)) - (0xffffffffl & input)) = (0xffffffffl & ( (reg0))) - (0xffffffffl & ( input));	{        cpu.setZeroFlag((int)(((0xffffffffl & (reg0)) - (0xffffffffl & input))));	cpu.setParityFlag((int)(((0xffffffffl & (reg0)) - (0xffffffffl & input))));	cpu.setSignFlag((int)(((0xffffffffl & (reg0)) - (0xffffffffl & input))));	cpu.setCarryFlag((((0xffffffffl & (reg0)) - (0xffffffffl & input))), Processor.CY_TWIDDLE_FFFFFFFF);	cpu.setAuxiliaryCarryFlag(( ( (reg0))), ( ( input)), (int)(((0xffffffffl & (reg0)) - (0xffffffffl & input))), Processor.AC_XOR);}	cpu.setOverflowFlag(( (reg0)), (int)((0xffffffffl & (reg0)) - (0xffffffffl & input)), ( input), Processor.OF_ADDSUB_INT);}	}}}";
static final String STOSD_A16 = "{ {	int addr = cpu.edi & 0xffff;	cpu.es.setDoubleWord(addr, (reg0));			if (cpu.eflagsDirection)	    addr -= 4;	else	    addr += 4;		cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);}}";
static final String REP_STOSB_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addr = cpu.edi & 0xffff;	executeCount += count;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setByte(addr & 0xffff, (byte)(reg0));				    count--;		    addr -= 1;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setByte(addr & 0xffff, (byte)(reg0));				    count--;		    addr += 1;		}	    }	}	finally {	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);	}}}";
static final String REP_STOSD_A16 = "{ {	int count = cpu.ecx & 0xffff;	int addr = cpu.edi & 0xffff;	executeCount += count;	try {	    if (cpu.eflagsDirection) {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setDoubleWord(addr & 0xffff, (reg0));				    count--;		    addr -= 4;		}	    } else {		while (count != 0) {		    /*check hardware interrupts*/		    cpu.es.setDoubleWord(addr & 0xffff, (reg0));				    count--;		    addr += 4;		}	    }	}	finally {	    cpu.ecx = (cpu.ecx & ~0xffff) | (count & 0xffff);	    cpu.edi = (cpu.edi & ~0xffff) | (addr & 0xffff);	}}}";
static final String LGDT_O32 = "{ cpu.gdtr = cpu.createDescriptorTableSegment(reg1, reg0); }";
static final String LIDT_O32 = "{ cpu.idtr = cpu.createDescriptorTableSegment(reg1, reg0); }";
static final String LIDT_O16 = "{ cpu.idtr = cpu.createDescriptorTableSegment(reg1 & 0x00ffffff, reg0); }";
static final String LMSW = "{ cpu.setCR0((cpu.getCR0() & ~0xf) | (reg0 & 0xf)); }";
static final String CLTS = "{ cpu.setCR3(cpu.getCR3() & ~0x4); }";
static final String DEC_O32_FLAGS = "{ {        cpu.setZeroFlag((reg0));        cpu.setParityFlag((reg0));	cpu.setSignFlag((reg0));        cpu.setOverflowFlag((reg0), Processor.OF_MAX_INT);        cpu.setAuxiliaryCarryFlag((reg0), Processor.AC_LNIBBLE_MAX);}}";
static final String ADC_O32_FLAGS = "{ {	int carry = (cpu.getCarryFlag() ? 1 : 0);	(reg0l) = (0xffffffffl & ( reg2)) + (0xffffffffl & ( reg1)) + carry;	if (cpu.getCarryFlag() && (( reg1) == 0xffffffff)) {	    {        cpu.setZeroFlag((int)((reg0l)));	cpu.setParityFlag((int)((reg0l)));	cpu.setSignFlag((int)((reg0l)));	cpu.setCarryFlag(((reg0l)), Processor.CY_TWIDDLE_FFFFFFFF);	cpu.setAuxiliaryCarryFlag(( ( reg2)), ( ( reg1)), (int)((reg0l)), Processor.AC_XOR);}	    cpu.setOverflowFlag(false);	    cpu.setCarryFlag(true);	} else {	    cpu.setOverflowFlag((int)(reg0l), ( reg2), ( reg1) + carry, Processor.OF_ADDSUB_INT);	    {        cpu.setZeroFlag((int)((reg0l)));	cpu.setParityFlag((int)((reg0l)));	cpu.setSignFlag((int)((reg0l)));	cpu.setCarryFlag(((reg0l)), Processor.CY_TWIDDLE_FFFFFFFF);	cpu.setAuxiliaryCarryFlag(( ( reg2)), ( ( reg1)), (int)((reg0l)), Processor.AC_XOR);}	}    }}";
static final String SBB_O32_FLAGS = "{ {	int carry = (cpu.getCarryFlag() ? 1 : 0);	(reg0l) = (0xffffffffl & ( reg2)) - ((0xffffffffl & ( reg1)) + carry);	cpu.setOverflowFlag(( reg2), (int)(reg0l), ( reg1) + carry, Processor.OF_ADDSUB_INT);	{        cpu.setZeroFlag((int)((reg0l)));	cpu.setParityFlag((int)((reg0l)));	cpu.setSignFlag((int)((reg0l)));	cpu.setCarryFlag(((reg0l)), Processor.CY_TWIDDLE_FFFFFFFF);	cpu.setAuxiliaryCarryFlag(( ( reg2)), ( ( reg1)), (int)((reg0l)), Processor.AC_XOR);}}}";
static final String SAR_O8_FLAGS = "{ {        if (( reg1) > 0) {	    cpu.setCarryFlag(( (byte)reg2), ( reg1), Processor.CY_SHR_OUTBIT);            if (( reg1) == 1) cpu.setOverflowFlag(false);            cpu.setSignFlag(((byte)reg0));            cpu.setZeroFlag(((byte)reg0));            cpu.setParityFlag(((byte)reg0));        }      }}";
static final String SAR_O32_FLAGS = "{ {        if (( reg1) > 0) {	    cpu.setCarryFlag(( reg2), ( reg1), Processor.CY_SHR_OUTBIT);            if (( reg1) == 1) cpu.setOverflowFlag(false);            cpu.setSignFlag((reg0));            cpu.setZeroFlag((reg0));            cpu.setParityFlag((reg0));        }      }}";
static final String RCL_O8_FLAGS = "{  {	if (( reg1) > 0) {	    cpu.setCarryFlag((reg0), Processor.CY_OFFENDBIT_BYTE);            if (( reg1) == 1)		cpu.setOverflowFlag((reg0), Processor.OF_BIT7_XOR_CARRY);	}}}";
static final String RCL_O32_FLAGS = "{ {	if (( reg1) > 0) {	    cpu.setCarryFlag((reg0l), Processor.CY_OFFENDBIT_INT);            if (( reg1) == 1)		cpu.setOverflowFlag((reg0l), Processor.OF_BIT31_XOR_CARRY);	}}}";
static final String RCR_O8_FLAGS = "{  {	if (( reg1) > 0) {	    cpu.setCarryFlag((reg0), Processor.CY_OFFENDBIT_BYTE);            if (( reg1) == 1)		cpu.setOverflowFlag((reg0), Processor.OF_BIT7_XOR_BIT6);	}}}";
static final String RCR_O16_FLAGS = "{ {	if (( reg1) > 0) {	    cpu.setCarryFlag((reg0), Processor.CY_OFFENDBIT_SHORT);            if (( reg1) == 1)		cpu.setOverflowFlag((reg0), Processor.OF_BIT15_XOR_BIT14);	}}}";
static final String RCR_O32_FLAGS = "{ {	if (( reg1) > 0) {	    cpu.setCarryFlag((reg0l), Processor.CY_OFFENDBIT_INT);            if (( reg1) == 1)		cpu.setOverflowFlag((reg0l), Processor.OF_BIT31_XOR_BIT30);	}}}";
static final String ROL_O8_FLAGS = "{  {	if (( reg1) > 0) {	    cpu.setCarryFlag(((byte)reg0), Processor.CY_LOWBIT);	    if (( reg1) == 1)		cpu.setOverflowFlag(((byte)reg0), Processor.OF_BIT7_XOR_CARRY);	}}}";
static final String ROL_O16_FLAGS = "{ {	if (( reg1) > 0) {	    cpu.setCarryFlag(((short)reg0), Processor.CY_LOWBIT);	    if (( reg1) == 1)		cpu.setOverflowFlag(((short)reg0), Processor.OF_BIT15_XOR_CARRY);	}}}";
static final String ROL_O32_FLAGS = "{ {	if (( reg1) > 0) {	    cpu.setCarryFlag((reg0), Processor.CY_LOWBIT);	    if (( reg1) == 1)		cpu.setOverflowFlag((reg0), Processor.OF_BIT31_XOR_CARRY);	}}}";
static final String ROR_O16_FLAGS = "{ {	if (( reg1) > 0) {	    cpu.setCarryFlag(((short)reg0), Processor.CY_HIGHBIT_SHORT);	    if (( reg1) == 1)		cpu.setOverflowFlag(((short)reg0), Processor.OF_BIT6_XOR_CARRY);	}}}";
static final String ROR_O32_FLAGS = "{ {	if (( reg1) > 0) {	    cpu.setCarryFlag((reg0), Processor.CY_HIGHBIT_INT);	    if (( reg1) == 1)		cpu.setOverflowFlag((reg0), Processor.OF_BIT30_XOR_CARRY);	}}}";
static final String NEG_O32_FLAGS = "{ {	cpu.setCarryFlag((reg0), Processor.CY_NZ);	cpu.setOverflowFlag((reg0), Processor.OF_MIN_BYTE);        cpu.setAuxiliaryCarryFlag((reg0), Processor.AC_LNIBBLE_NZERO);        cpu.setZeroFlag((reg0));        cpu.setParityFlag((reg0));	cpu.setSignFlag((reg0));}}";
static final String UNDEFINED = "{ System.err.println(\"Undefined Opcode\"); throw exceptionUD;	    	    case MEM_RESET: addr0 = 0; seg0 = null; }";
}
