/*
    JPC: A x86 PC Hardware Emulator for a pure Java Virtual Machine
    Release Version 2.0

    A project from the Physics Dept, The University of Oxford

    Copyright (C) 2007 Isis Innovation Limited

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 as published by
    the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 
    Details (including contact information) can be found at: 

    www.physics.ox.ac.uk/jpc
*/

package org.jpc.sourcecompiler;

import javax.tools.*;
import java.net.*;
import java.io.*;

/**
 * A file object used to store compiled source in a byte[].
 */
public class BytesHolder extends SimpleJavaFileObject 
{
    private String className;
    private ByteArrayOutputStream byteStream;

    BytesHolder(String name)
    {
        super(URI.create("string:///" + name.replace('.','/') + Kind.CLASS.extension), Kind.CLASS);
        this.className = name;
        byteStream = new ByteArrayOutputStream();
    }
   
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException 
    {
        throw new UnsupportedOperationException();
    }

    public OutputStream openOutputStream() throws IOException 
    {
        return byteStream;
    }

    public Writer openWriter() throws IOException 
    {
        //get a stream to write bytes to bytes[]
        return new OutputStreamWriter(byteStream);
    }
    
    public byte[] getBytes()
    {
        return byteStream.toByteArray();
    }
}

