/*
    JPC: A x86 PC Hardware Emulator for a pure Java Virtual Machine
    Release Version 2.0

    A project from the Physics Dept, The University of Oxford

    Copyright (C) 2007 Isis Innovation Limited

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 as published by
    the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 
    Details (including contact information) can be found at: 

    www.physics.ox.ac.uk/jpc
*/

package org.jpc.emulator.memory.codeblock;

import org.jpc.emulator.memory.*;
import org.jpc.emulator.processor.*;

public class CodeBlockTrigger implements RealModeCodeBlock, ProtectedModeCodeBlock
{
    private Memory home;
    private CodeBlock result;

    public CodeBlockTrigger(Memory source)
    {
	home = source;
    }

    public int getX86Length()
    {
	try {
	    return result.getX86Length();
	} catch (NullPointerException e) {
	    return 0;
	}
    }

    public int getX86Count()
    {
	try {
	    return result.getX86Count();
	} catch (NullPointerException e) {
	    return 0;
	}
    }

    // Returns the number of equivalent x86 instructions executed. Negative results indicate an error
    public int execute(Processor cpu)
    {
	return construct(cpu).execute(cpu);
    }

    public String getDisplayString()
    {
	try {
	    return result.getDisplayString();
	} catch (NullPointerException e) {
	    return "Undecoded Trigger Block";
	}
    }

    private CodeBlock construct(Processor cpu)
    {
        if ((cpu.getCR0() & 0x1) == 0)
	    return (result = MemoryManager.getInstance().getRealModeCodeBlockAt(home, cpu.getInstructionPointer()));
	else
	    return (result = MemoryManager.getInstance().getProtectedModeCodeBlockAt(home, cpu.getInstructionPointer()));
    }

    public boolean handleMemoryRegionChange(int startAddress, int endAddress)
    {
        return true;
    }
}

