/*
    JPC: A x86 PC Hardware Emulator for a pure Java Virtual Machine
    Release Version 2.0

    A project from the Physics Dept, The University of Oxford

    Copyright (C) 2007 Isis Innovation Limited

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 as published by
    the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 
    Details (including contact information) can be found at: 

    www.physics.ox.ac.uk/jpc
*/

package org.jpc.emulator.memory;

import org.jpc.emulator.memory.codeblock.*;

public interface Memory extends ByteArray
{
    public void clear();

    public void clear(int start, int length);

    public void copyContentsInto(int address, byte[] buffer, int off, int len);

    public void copyContentsFrom(int address, byte[] buffer, int off, int len);

    public long getSize();

    public byte getByte(int offset);

    public short getWord(int offset);

    public int getDoubleWord(int offset);

    public long getQuadWord(int offset);

    public long getLowerDoubleQuadWord(int offset);

    public long getUpperDoubleQuadWord(int offset);

    public void setByte(int offset, byte data);

    public void setWord(int offset, short data);

    public void setDoubleWord(int offset, int data);

    public void setQuadWord(int offset, long data);

    public void setLowerDoubleQuadWord(int offset, long data);

    public void setUpperDoubleQuadWord(int offset, long data);

    //Only for use in debugger
    public CodeBlock queryCodeBlockAt(int address);

    public RealModeCodeBlock getRealModeCodeBlockAt(int address);

    public ProtectedModeCodeBlock getProtectedModeCodeBlockAt(int address);
}
