/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Header file for TEE.C
 *
 * Author: Alexis Malozemoff
 */

#ifndef TEE_HDR
#define TEE_HDR

#ifndef TRUE
#define TRUE		1
#endif
#ifndef FALSE
#define FALSE		0
#endif

#define OK			0
#define ERROR		1

/* User settings */
#define APPEND		0x01
#define INTERRUPT	0x02

/* Types of modes */
#define MODE_WRITE	0
#define MODE_APPEND 1

#ifdef ENABLE_KITTEN
	#define MSG_SET				0
	#define ERR_SET				1

	#define MSG_DESCRIPTION_NUM	0
	#define MSG_USAGE_STR_NUM	1
	#define MSG_FILE_STR_NUM	3
	#define MSG_A_OPT_NUM		4
	#define MSG_I_OPT_NUM		5
	#define MSG_HELP_OPT_NUM	6

	#define ERR_UNKNOWN_OPT_NUM	0
	#define ERR_ALLOC_NUM		1
	#define ERR_OPEN_NUM		2
	#define ERR_WRITE_NUM		3
	#define ERR_CLOSE_NUM		4
	#define ERR_CREAT_NUM		5
#endif

/* Messages */
#define MSG_DESCRIPTION	"Saves a copy of the input to a file and prints it."
#define MSG_USAGE_STR	"Usage"
#define MSG_FILE_STR	"FILE"
#define MSG_A_OPT 		"Append to given FILE"
#define MSG_I_OPT		"Ignore interrupts"
#define MSG_HELP_OPT	"Print this message"
/* Errors */
#define _ERR_UNKNOWN_OPT	"Unknown option"
#define _ERR_ALLOC			"Error allocating space for file(s)"
#define _ERR_OPEN			"Error opening output file"
#define _ERR_WRITE			"Error writing to file"
#define _ERR_CLOSE			"Error closing file"

#define ERR_UNKNOWN_OPT	kittengets(ERR_SET, ERR_UNKNOWN_OPT_NUM, \
															_ERR_UNKNOWN_OPT)
#define ERR_ALLOC		kittengets(ERR_SET, ERR_ALLOC_NUM, _ERR_ALLOC)
#define ERR_OPEN		kittengets(ERR_SET, ERR_OPEN_NUM, _ERR_OPEN)
#define ERR_WRITE		kittengets(ERR_SET, ERR_WRITE_NUM, _ERR_WRITE)
#define	ERR_CLOSE		kittengets(ERR_SET, ERR_CLOSE_NUM, _ERR_CLOSE)

#define PRINT_ERR_UNKNOWN_OPT(s)	(fprintf(stderr, "%s: %s %s\n",		\
										progName, ERR_UNKNOWN_OPT, s))
#define PRINT_ERR_ALLOC				(fprintf(stderr, "%s: %s: ", 		\
										progName, ERR_ALLOC))
#define PRINT_ERR_OPEN(s)			(fprintf(stderr, "%s: %s %s: ",		\
										progName, ERR_OPEN,	s))
#define PRINT_ERR_WRITE(s)			(fprintf(stderr, "%s: %s %s: ",		\
										progName, ERR_WRITE, s))
#define PRINT_ERR_CLOSE(s)			(fprintf(stderr, "%s: %s %s: ",		\
										progName, ERR_CLOSE, s))

#endif /* TEE_HDR */
