;
;  This file and its related programs are freewares distributed
;  under the terms of GNU GPL version 2.
;
;  Assembly language subroutines callable by pg.c
;  Originally, some routines resided in pg.c are
;     extracted here to make pg easier to debug.
;
;  Author:
;  (c) 1995-1998 Bill Weinman, wew@bearnet.com
;  Maintainer:
;  2004 BAHCL  e-mail:
;
;  Assemble:
;     nasm16 -f obj pgasm.asm -o pgasm.obj
;     The object file is linkable with tlink
;
; ***** Always save si,di if ever used in asm subroutine *****
;

; global = assembly language function names
        global  _check_mouse, _reset_mouse, _pickup_string
        global  _mouseorkey, _check_filespec, _get_fname, _chg_vid_mode
        global  _kbget, _read_infile, _move, _cursor_x, _iaca
        global  _getbiosinfo, _mvaddch, _getstr, _scroll_up

; extern = variables defined in caller C program
        extern  _DispRows, _DispCols, _DispMode, _VideoRegen, _mouse
        extern  _infilename, _lineaddr, _groups, _numlines, _lpg, _linebuf
;
;
;
; Moved here from pg.h
%define BIOS_DATA_SEG 40h
%define DISP_MODE     49h
%define DISP_COLS     4Ah
%define DISP_ROWS     84h
%define CURSOR        50h
%define MAXSIZELINE   256

segment _TEXT   CLASS=CODE

;
; Get BIOS information
;   moved here from pg.c
_getbiosinfo    ;
                push    es
                mov     ax, BIOS_DATA_SEG
                mov     es, ax
                mov     al, [es:DISP_MODE]
                mov     [_DispMode], al
                mov     ax, [es:DISP_COLS]
                mov     [_DispCols], ax
                mov     al, [es:DISP_ROWS]         ; actually last row
                inc     al
                xor     ah,ah
                mov     [_DispRows], al
                shl     ax,1
                shl     ax,1
                mov     [cs:midline],ax
                dec     word [cs:midline]
                shl     ax,1
                mov     [cs:botline],ax
                sub     word [cs:botline],9
                pop     es
                ret
;
;
_check_mouse
                mov     ax,21h          ; reset mouse
                int     33h
                cmp     bx,2            ; 2 = mouse driver present
                jne     @nodrv
                mov     [_mouse],ax     ; ax = FFFF = mouse

                mov     ax,4            ; move mouse cursor
                xor     cx,cx           ; to 0,0
                xor     dx,dx
                int     33h

                mov     ax,1            ; show mouse cursor
                int     33h

                push    es
                push    cs
                pop     es
                mov     ax,0Ch          ; set user subroutine for
                mov     cx,EVENT        ; mouse EVENT
                mov     dx,Mouse_Subrtn
                int     33h
                pop     es
@nodrv:
                ret
;
;
;
;  disable user mouse routine as program exits
_reset_mouse
                mov     ax,0Ch          ; set subroutine
                xor     cx,cx           ; disable with 0
                int     33h

                mov     ax,2            ; hide mouse cursor
                int     33h
                ret
;
;
; user mouse routine
Mouse_Subrtn    ; mouse subrountine  ** do not call directly **
                mov     [cs:mouse_x],cx
                mov     cx,011Bh
                and     ax,0FFFEh
                test    ax,8              ; right button pressed
                jnz     @0024
                sub     cx,cx
                test    ax,2              ; left button pressed
                jz      @0024
                mov     cx,8400h          ; Ctrl P.Up
                cmp     dx,7              ; mouse at zeroth line
                ja      @0021
                jmp     @0024
@0021:
                mov     cx,4900h          ; Page Up
                cmp     dx,[cs:midline]   ; mouse pointer at upper/lower screen
                ja      @0022
                jmp     @0024
@0022:
                mov     cx,5100h          ; Page Down
                cmp     dx,[cs:botline]   ; mouse pointer at upper/lower screen
                ja      @0023
                jmp     @0024
@0023:
                mov     cx,7600h
@0024:
                mov     [cs:mouseinfo],cx
                push    es
                mov     ax,40h
                mov     es,ax
                mov     [es:0F0h],cx
                pop     es
                retf                         ; return far
;
;
; convert mouse position to video address and copy string under cursor to
; another area in screen.
_pickup_string
                push     bp
                mov      bp,sp
                push     di
                push     si
                mov      ax,3
                int      33h
                shr      cx,1
                shr      cx,1
                push     cx
                mov      ax,dx
                shr      ax,1
                shr      ax,1
                mov      bx,[_DispCols]
                mul      bx
                mov      [lmargin],ax
                pop      bx

                mov      cx,[lmargin]
                add      ax,bx
                mov      si,ax
                push     ds
                push     es
                mov      ax,[_VideoRegen]
                mov      ds,ax
                mov      es,ax
@0031:                                          ; find begin of word
                cmp      si,cx
                jbe      @0032
                sub      si,2
                cmp      byte[si],20h
                jnz      @0031
                add      si,2
@0032:
                pop      es
                mov      di,[bp+4]            ; searchstr
                add      di,2                 ; [0]=field width, [1]=data_length
                mov      cx,[bp+6]
                xor      dx,dx
@0035:
                lodsw
                cmp      al,20h
                jna      @0036
                stosb
                inc      dx
                loop     @0035
@0036:
                xor      ax,ax
                stosb
                pop      ds
                mov      bx,[bp+4]            ; searchstr
                mov      byte [bx+1],dl

                pop      si
                pop      di
                pop      bp
                ret


;
; If strfind()/strrfing() is successful, this routine is called
; returns the position of string2 found in string1
_cursor_x
                push    bp
                mov     bp,sp
                push    si
                push    di
                xor     ax,ax
                xor     bx,bx
@0040:
                mov     di,[bp+4]               ; string#1 address
                add     di,bx
                inc     bx
                mov     si,[bp+6]               ; string#2 address
                mov     cx,[bp+8]               ; length of string#2
                rep     cmpsb
                jnz     @0040
                mov     ax,bx
                pop     di
                pop     si
                pop     bp
                ret
;
;
;  intercept keyboard scancode or mouse event
_mouseorkey
                xor     ax,ax           ; clearing
                mov     [cs:mouseinfo],ax
@wait:
                cmp     word [_mouse],0
                jz      @nomouse
                call    mousexy
@nomouse:
                mov     ah,1
                int     16h
                jz      @compare
                xor     ax,ax           ; wait until keypressed
                int     16h
                mov     [cs:mouseinfo],ax
                jmp     @nowait
@compare:
                mov     ax,[cs:mouseinfo]
                or      ax,ax
                jz      @wait
@nowait:
                ret
;
mouseinfo       dw      0
mouse_x         dw      0
midline         dw      0
botline         dw      0
;
;
;
mousexy
                mov     ax,[cs:mouse_x]
                shr     ax,1
                shr     ax,1
                shr     ax,1
                inc     ax
                mov     bl,10
                div     bl
                add     ax,3030h
                mov     dx,ax
                push    di
                mov     di,[_DispCols]
                sub     di,25
                shl     di,1
                push    es
                mov     ax,[_VideoRegen]
                mov     es,ax
                mov     al,dl
                stosb
                inc     di
                mov     al,dh
                stosb
                pop     es
                pop     di
                ret
;
;
;
_get_fname
                push    bp
                mov     bp,sp
                mov     ax,3D00h                ; open @file
                mov     dx,[bp+6]
                inc     dx
                int     21h
                mov     bx,ax
                mov     ax,4200h                ; move file pointer
                mov     dx,[bp+4]
                xor     cx,cx
                int     21h
                push    si
                push    di

                mov     ax,3F00h
                mov     cx,128
                mov     dx,_linebuf
                int     21h
                mov     ax,3E00h                ; close @file
                int     21h
                mov     cx,128
                mov     si,_linebuf
                mov     di,[bp+8]               ; recover
@0050:
                lodsb
                cmp     al,0Dh
                je      @0052
                cmp     al,20h
                je      @0052
                stosb
                loop    @0050
@0052:
                mov     byte [di],0
                mov     ax,[bp+8]
                pop     di
                pop     si
                pop     bp
                ret
;
;
_check_filespec
                push    bp
                mov     bp,sp
                mov     ah,1Ah
                mov     dx,_linebuf
                int     21h
                mov     ax,4E00h
                mov     cx,0
                mov     dx,[bp+4]
                int     21h
                pop     bp
                ret
;
; Print a char with attribute at a location
;   moved here from pg.c
;   with some modification
_mvaddch        ; parm : position, char, attr
                push    bp
                mov     bp,sp
                push    di
                mov     di, [bp+4]          ; position where char appear
                push    es
                mov     ax, [_VideoRegen]
                mov     es, ax
                mov     al, [bp+6]          ; char
                mov     ah, [bp+8]          ; attr
                stosw
                pop     es
                pop     di
                pop     bp
                ret
;
;
;
; get a string into buffer
_getstr         ; parm : buffer addr
                push    bp
                mov     bp,sp
                push    si
                mov     ah,0Ah                  ; get a string into buffer
                mov     dx,[bp+4]               ; buffer address
                int     21h

                mov     si,dx                   ; make a string null terminated
                inc     si                      ; actual number of chars entered
                lodsb
                cbw
                add     si,ax                   ; get end of string position
                xor     ax,ax
                mov     [si],al                 ; null terminated
                pop     si
                pop     bp
                ret
;
;
;   Scroll up an area of the screen
_scroll_up       ; parm : x1,y1,x2,y2,lines
                push    bp
                mov     bp,sp
                mov     bh,07
                mov     cl,[bp+4]                 ; x1
                mov     ch,[bp+6]                 ; y1
                mov     dl,[bp+8]                 ; x2
                mov     dh,[bp+10]                ; y2
                mov     al,[bp+12]                ; lines
                mov     ah,06
                int     10h
                pop     bp
                ret
;
;  Get keyboard scan code(AH) and char code(AL)
;  wait until a keypressed
_kbget
                 xor     ax,ax
                 int     16h
                 ret
;
;
; Move cursor to row, column, page 0
_move
                push    bp
                mov     bp,sp
                mov     ah, 2
                xor     bh, bh
                mov     dh, byte [bp+4]         ; row
                mov     dl, byte [bp+6]         ; column
                int     10h
                pop     bp
                ret
;
;
;  Change video mode
_chg_vid_mode
                mov     ax,2
                int     33h
                push    bx
                xor     bh,bh
                cmp     byte [_DispRows],50
                jne     @0060
                mov     byte [vmode],2
                jmp     @0062
@0060:
                cmp     byte [_DispRows],28
                jne     @0061
                mov     byte [vmode],1
                jmp     @0062
@0061:
                mov     byte [vmode],4
@0062:
                mov     bl,[vmode]
                shl     bl,1
                cmp     bl,4
                jna     @nextmode
                mov     bl,1
@nextmode
                mov     [vmode],bl
                mov     ax,1110h
                add     al,bl
                xor     bx,bx
                int     10h
                call    _getbiosinfo
                pop     bx
                mov     ax,1
                int     33h
                ret
;
; Intra application communication area 40:F0..FF
_iaca
                push    bp
                mov     bp,sp
                push    ds
                mov     ax,40h
                mov     ds,ax
                mov     bx,0F0h
                mov     ax,[bp+4]
                mov     [bx],ax                 ; offset lsw
                mov     ax,[bp+6]
                mov     [bx+2],ax               ; offset msw
                mov     ax,[bp+8]
                mov     [bx+4],ax               ; exit key
                pop     ds
                pop     bp
                ret
;
;
get_memory
                mov     ah,48h                  ; get memory
                mov     bx,1000h                ; = 64k = 65536 bytes
                int     21h
                mov     [fbuffer],ax            ; the allocated memory seg addr
                ret
;
;
free_memory
                mov     ax,[fbuffer]            ; release memory
                push    es
                mov     es,ax
                mov     ah,49h
                int     21h
                pop     es
                ret
;
;
; breaks the heap limit
; Supercharger
_read_infile  ; read the infile
                push    bp
                mov     bp,sp
                mov     ax,[bp+6]
                mov     [linearray],ax
                mov     ax,[bp+4]
                mov     [grouparray],ax
                xor     ax,ax
                mov     word [linidx],ax
                mov     word [grpidx],ax
                mov     word [tfmsw],ax
                mov     word [tflsw],ax
                push    si                      ; save important registers
                push    di
                call    get_memory
                mov     ax,3D00h                ; open file
                mov     dx,[_infilename]        ; file name
                int     21h
                mov     [fhandle],ax            ; save file handle

@0001:
                call    Move_file_ptr           ; move file pointer to
                mov     ax,3F00h                ; read file
                mov     bx,[fhandle]            ; file handle
                mov     cx,0FFF0h
                mov     dx,[fbuffer]
                push    ds                      ; save ds
                mov     ds,dx
                xor     dx,dx
                int     21h
                pop     ds                      ; restore ds
                jc      @eofile                 ; read error
                and     ax,ax                   ; read nothing?
                jz      @eofile
                mov     [bytesread],ax          ; bytes read

                call    Scan_CRLF               ; Scan all chars = LF = 0Ah

                mov     ax,[bytesread]
                cmp     ax,0FFF0h               ; is it eof?
                jz      @0001                   ; not yet
@eofile:
                call    free_memory
                mov     ax,3E00h                ; close infile
                mov     bx,[fhandle]
                int     21h
                pop     di
                pop     si
                cmp     byte [lastbyte],LF
                jz      @0002
                cmp     byte [lastbyte],1Ah
                jz      @0002
                add     word [_numlines],1      ; last line
                jnc     @0002
                inc     word [_numlines+2]
@0002:
                pop     bp
                ret
;
; Move file pointer
Move_file_ptr  ; move file pointer to specific position
                mov     ah,42h
                mov     al,0                    ; 0 = Set, 1=Cur 2=End
                mov     bx,[fhandle]
                mov     cx,[tfmsw]              ; most sig word
                mov     dx,[tflsw]              ; least sig word
                int     21h
                ret
;
;
;
; Scan the Carriage Return char in buffer
Scan_CRLF   ; scan a byte = LF
                push    es
                mov     ax,[fbuffer]
                mov     es,ax
                xor     di,di
                call    Load_index
                mov     cx,[bytesread]
@again:
                mov     [counter],cx
                mov     al,LF
                repnz   scasb
                jz      @LF_found
                jcxz    @exhaust
@LF_found:
                push    cx
                mov     ax,[counter]            ; calc line length
                sub     ax,cx
                call    Add_Line
                xchg    dx,ax
                or      ax,ax
                jz      @0008
                call    New_Line                ; update file offset
@0008:
                pop     cx
                or      cx,cx
                jnz     @again

@exhaust:       ; end of buffer but no LF
                mov     ax,[counter]
                cmp     ax,MAXSIZELINE
                jb      @0007
                call    Add_Line
@0007:          mov     al,[es:di-1]
                mov     [lastbyte],al
                pop     es
                ret
;
; Loading indexes to array _lineaddr, _group
Load_index
                push    bx
                push    ax
                push    dx
                mov     ax,word [linidx]        ; linidx { 0..1023 }
                xor     dx,dx
                mov     bx,word [_lpg]          ; lines per group
                div     bx
                add     word [grpidx],ax
                mov     word [linidx],dx
                mov     bx,[grpidx]
                or      bx,bx
                ja      @0003
                xchg    ax,dx
                mov     bx,[linearray]
                shl     ax,1                    ; mult by 4
                shl     ax,1
                add     bx,ax                   ; calc line array index
                mov     ax,[tflsw]              ; low order word
                mov     [bx],ax                 ; store in line array
                mov     ax,[tfmsw]              ; high order word
                mov     [bx+2],ax               ; makes a long integer
@0003:
                mov     ax,word [linidx]
                or      ax,ax
                jnz     @0004                   ; same group
; new group
                mov     bx,[grouparray]
                mov     ax,word [grpidx]        ; get group id
                shl     ax,1                    ; mult by 4
                shl     ax,1
                add     bx,ax                   ; calc group array index
                mov     ax,[tflsw]              ; low order word
                mov     [bx],ax                 ; store in group array
                mov     ax,[tfmsw]              ; high order word
                mov     [bx+2],ax               ; makes a long integer
@0004:
                pop     dx
                pop     ax
                pop     bx
                ret
;
Add_Line
                mov     bx,MAXSIZELINE
                xor     dx,dx
                div     bx
                push    dx
                or      ax,ax
                jz      @0009
                mov     cx,ax
.loop           push    cx
                mov     ax,MAXSIZELINE
                call    New_Line                ; update file offset
                pop     cx
                loop    .loop
@0009
                pop     dx
                ret

;
; Test if file pointer in low order word overflows?
New_Line
                add     ax,[tflsw]
                jnc     @0005
                inc     word [tfmsw]            ; overflow
                clc
@0005:
                mov     [tflsw],ax
                add     word [_numlines],1
                jnc     @0006
                inc     word [_numlines+2]
@0006:
                inc     word [linidx]
                call    Load_index
                ret
;
;
segment _DATA   CLASS=DATA
EVENT           EQU     0000000000001011b       ; right/left button pressed
LF              EQU     0Ah
tflsw           dw      0
tfmsw           dw      0
fhandle         dw      0                       ; infile handle
fbuffer         dw      0                       ; Seg addr of alloc memory
bytesread       dw      0                       ; # of bytes read last attempt
counter         dw      0                       ; byte count
linidx          dw      0                       ; line count
grpidx          dw      0                       ; group count
lastbyte        db      0
lmargin         dw      0                       ; left margin
linearray       dw      0                       ; store the address of lineaddr
grouparray      dw      0                       ; store the address of groups
vmode           db      4
