/*
  pg.h

  Header file for pg program

  (c) BearHeart

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Revision Notes
                  bh 95.02.27  Initial Coding
   BAHCL 2003.10.30 - move assembly language related definitions to pgasm.asm
                    - convert keyboard scan code to word size
                    - clean up unused definitions
                    - migrated to Turbo C 2.01
*/

#define true (1)
#define false (0)

#define byte unsigned char
#define word unsigned int

/* video attributes */

#define BLACK   (0x00)
#define BLUE    (0x01)
#define GREEN   (0x02)
#define CYAN    (0x03)
#define RED     (0x04)
#define MAGENTA (0x05)
#define BROWN   (0x06)
#define WHITE   (0x07)
#define BRIGHT  (0x08)
/* #define BLINK   (0x80) */
#define YELLOW  (BROWN | BRIGHT)
#define UNDERLINE (0x01)  /* for MONO only */
#define MONO    (7)

#define ATTR(fg,bg)  (((bg) << 4) | (fg))

/* keyboard scan codes */ /* convert to word size for assembly routine */
#define PG_UP      (0x4900)
#define PG_DN      (0x5100)
#define KEY_HOME   (0x4700)
#define KEY_END    (0x4F00)
#define KEY_UP     (0x4800)
#define KEY_DN     (0x5000)
#define KEY_LT     (0x4B00)
#define KEY_RT     (0x4D00)
#define RETURN     (0x1C0D)
#define ESC        (0x011B)
#define SPACE      (0x3920)
#define JUMPTO     (0x0E08) /* Backspace  Jump to a line number */

/*  to be replaced as Countries with different ASCII code */
#define ADDFILE    (0X41)   /* A Add file */
#define BITON      (0X42)   /* B Bit 7 on / off */
#define HEX        (0X48)   /* H Hex  */
#define QUIT       (0X51)   /* Q quit */
#define WRAP       (0X57)   /* W wrap */

/*  save book mark #1..5 map to key 1..5 */
#define SBM_1      (0x31)
#define SBM_2      (0x32)
#define SBM_3      (0x33)
#define SBM_4      (0x34)
#define SBM_5      (0x35)

/*  jump to book mark #1..5 map to key alt1..5 */
#define JBM_A1     (0x7800)
#define JBM_A2     (0x7900)
#define JBM_A3     (0x7A00)
#define JBM_A4     (0x7B00)
#define JBM_A5     (0x7C00)

#define KEY_F1     (0x3B00)   /* F1 show manual */
#define KEY_F2     (0x3C00)   /* F2 Search Backward (I) */
#define KEY_F3     (0x3D00)   /* F3 Search forward  (I) */
#define KEY_F4     (0x3E00)   /* F4 Search mode     (I) */
#define KEY_F5     (0x3F00)   /* F5 Save text from the screen */
#define KEY_F6     (0x4000)   /* free */
#define KEY_F7     (0x4100)   /* free */
#define KEY_F8     (0x4200)   /* free */
#define KEY_F9     (0x4300)   /* free */
#define KEY_F10    (0x4400)   /* free */
#define KEY_SF2    (0x5500)   /* S-F2 Search Backward (S) */
#define KEY_SF3    (0x5600)   /* S-F3 Search forward  (S) */
#define KEY_LFILE  (0x8400)   /* C-PageUp last file */
#define KEY_NFILE  (0x7600)   /* C-PageDn next file */
#define DOSSHELL   (0x2000)   /* Alt-D DOS command shell */


/* Symbolic constants */
#define MAXSIZELINE   (256)             /* maximum size of a line */
#define LINEADDRS     (1024)            /* # of line addresses in a group */
#define GROUPS        (1024)            /* # of groups to hold line addresses */
#define PANLIMIT      (176)
#define CO_STATUS     ATTR(BRIGHT | GREEN, MAGENTA)
#define CO_LO_STATUS  ATTR(GREEN,          MAGENTA)
#define CO_TEXT       ATTR(BRIGHT | CYAN,  BLACK)
#define MO_STATUS     ATTR(BLACK,          WHITE)
#define MO_LO_STATUS  ATTR(GREEN,          WHITE)   /* lower contrast  */
#define MO_TEXT       ATTR(BRIGHT | WHITE, BLACK)
#define TAB           (0x09)                        /* ASCII tab character */
#define TABSTOPS      (8)
#define STATOK        (0)                           /* s/b enum */
#define STATTOP       (1)
#define STATBOT       (2)
#define MAX_FILE      (256)

