;
;  This file and its related programs are freewares distributed
;  under the terms of GNU GPL version 2.
;
;  Assembly subroutines callable by pg.c
;  Originally, some routines resided in pg.c are
;     extracted here to make pg easier to debug.
;
;  Author:
;  (c) 1995-1998 Bill Weinman, wew@bearnet.com
;  Maintainer:
;  2003 BAHCL  e-mail: freedos_pg@yahoo.com.hk
;
;  Assemble:
;     nasm16 -f obj pgasm.asm -o pgasm.obj
;     The object file is linkable with tlink
;
; ***** Always save si,di if ever used in asm subroutine *****
;
        global  _getbiosinfo,_mvaddch,_getstr,_scroll_up,_scroll_down,_kbget
        global  _setup_help,_on_line_help
        extern  _vidrow, _vidcol, _vidchar, _vidattr, _VideoRegen
        extern  _DispRows, _DispCols, _DispMode

;
; Moved here from pg.h
%define BIOS_DATA_SEG 40h
%define DISP_MODE     49h
%define DISP_COLS     4ah
%define DISP_ROWS     84h
%define CURSOR        50h
%define BUFSIZE       256

segment _TEXT   CLASS=CODE

;
; Get BIOS information
;   moved here from pg.c
_getbiosinfo    ;
        push    es
        mov ax, BIOS_DATA_SEG
        mov es, ax
        mov al, [es:DISP_MODE]
        mov [_DispMode], al
        mov ax, [es:DISP_COLS]
        mov [_DispCols], ax
        mov al, [es:DISP_ROWS]         ; actually last row
        inc al
        mov [_DispRows], al
        pop     es
        ret
;
;
; Move cursor then print a char with attribute
;   moved here from pg.c
;   with some modification
_mvaddch        ; parm : vidrow, vidcol, vidchar, vidattr
        push    bp
        mov     bp,sp
        push    di
        push es
        mov ax, BIOS_DATA_SEG
        mov es, ax
        mov al, [bp+6]          ; col
        mov ah, [bp+4]          ; row
        mov [es:CURSOR], ax
        push ax
        mov al, ah
        xor ah, ah
        mov bx, [_DispCols]     ; offset = vidrow * DispCols + vidrow
        mul bl
        pop bx
        xor bh, bh              ; add in the col
        add ax, bx
        shl ax, 1               ; * 2 for word based
        mov di, ax              ; zero origin for regen
        mov ax, [_VideoRegen]
        mov es, ax
        mov ah, [bp+10]         ; attr
        mov al, [bp+8]          ; char
        stosw
        pop es
        pop     di
        pop     bp
        ret
;
;
; get a string into buffer
_getstr         ; parm : buffer addr
                push    bp
                mov     bp,sp
                push    si
                mov     ah,0Ah                  ; get a string into buffer
                mov     dx,[bp+4]               ; buffer address
                int     21h

                mov     si,dx                   ; make a string null terminated
                inc     si                      ; actual number of chars entered
                lodsb
                cbw
                add     si,ax                   ; get end of string position
                xor     ax,ax
                mov     [si],al                 ; null terminated
                pop     si
                pop     bp
                ret
;
;   Scroll down an area of the screen
_scroll_down     ; parm : x1,y1,x2,y2,lines
                push    bp
                mov     bp,sp
                mov     bh,07
                mov     cl,[bp+4]                 ; x1
                mov     ch,[bp+6]                 ; y1
                mov     dl,[bp+8]                 ; x2
                mov     dh,[bp+10]                ; y2
                mov     al,[bp+12]                ; lines
                mov     ah,07
                int     10h
                pop     bp
                ret
;
;   Scroll up an area of the screen
_scroll_up       ; parm : x1,y1,x2,y2,lines
                push    bp
                mov     bp,sp
                mov     bh,07
                mov     cl,[bp+4]                 ; x1
                mov     ch,[bp+6]                 ; y1
                mov     dl,[bp+8]                 ; x2
                mov     dh,[bp+10]                ; y2
                mov     al,[bp+12]                ; lines
                mov     ah,06
                int     10h
                pop     bp
                ret
;
;  Get keyboard scan code(AH) and char code(AL)
;  wait until a keypressed
_kbget
                xor     ax,ax
                int     16h
                ret
;
;
;  Set up the help information in video page #1
_setup_help
                mov     ax,0501h                ; switch to page 1
                int     10h
                mov     ax,25                   ; lines
                push    ax
                mov     ax,[_DispRows]          ; y2
                xor     ah,ah
                sub     ax,2
                push    ax
                mov     ax,[_DispCols]          ; x2
                sub     ax,1
                push    ax
                xor     ax,ax                   ; y1
                push    ax
                xor     ax,ax                   ; x1
                push    ax
                call    _scroll_up              ; clear entire screen
                add     sp,10
                mov     ax,0500h                ; switch back to page 0
                int     10h

                push    es                      ; save es as <> ds
                push    ds                      ; make es = ds
                pop     es
                push    si
                mov     cx,6                    ; lines in on-line help
                push    cx
                mov     bx,msgaddr
                push    bx
                call    help_heading            ; help heading
                add     sp,4

                mov     cx,17                   ; lines in on-line help
                push    cx
                mov     bx,msgaddr+12
                push    bx
                call    help_details            ; help details
                add     sp,4
                pop     di
                pop     es
                ret

help_heading     ; center message in screen
                push    bp
                mov     bp,sp
                xor     dx,dx
                xor     si,si
                mov     bx,[bp+4]               ; message address
                mov     cx,[bp+6]               ; messages to print
.loop
                push    cx
                mov     ax,[bx+si+2]            ; next message addr
                mov     bp,[bx+si]              ; message to be printed
                sub     ax,bp                   ; length of message
                mov     cx,ax
                mov     dl,80                   ; find position in screen
                sub     dl,cl                   ; calculate column
                shr     dl,1                    ; adjust column div by 2
                push    bx
                mov     bx,0103h                ; page 1, color cyan on black
                mov     ax,1300h                ; write string
                int     10h
                inc     dh                      ; line
                pop     bx
                inc     si
                inc     si
                pop     cx

                loop    .loop

                pop     bp
                ret

help_details     ; align message in screen
                push    bp
                mov     bp,sp
                mov     dx,0600h
                xor     si,si
                mov     bx,[bp+4]
                mov     cx,[bp+6]
.loop
                push    cx
                mov     ax,[bx+si+2]            ; next message addr
                mov     bp,[bx+si]              ; message to be print
                sub     ax,bp                   ; length of message
                mov     cx,ax
                mov     dl,10h
                inc     dh                      ; line
                push    bx
                mov     bx,0107h                ; page 1, normal attriute
                mov     ax,1300h
                int     10h
                pop     bx
                inc     si
                inc     si
                pop     cx

                loop    .loop

                pop     bp
                ret
;
;
; Show On-line help
_on_line_help
                mov     ax,0501h                ; page 1
                int     10h
                xor     ax,ax
                int     16h
                mov     ax,0500h                ; page 0
                int     10h
                ret
;
; Help messages
segment _DATA   CLASS=DATA
line00          db      'www.freedos.org'
line01          db      'presents the Pager'
line02          db      'version 1.04'
line03          db      'Under the terms of GNU GPL version 2'
line04          db      '(c) 1995-1998 Bill Weinman, wew@bearnet.com'
line05          db      'Maintainer: BAHCL, freedos_pg@yahoo.com.hk'
line06          db      'Esc,Q,q     Exit program'
line07          db      'Up          Down 1 line'
line08          db      'Down,Enter  Up   1 line'
line09          db      'Page Up     Down 1 page       C-PgUp  Prev file'
line10          db      'Page Down   Up   1 page       C-PgDn  Next file'
line11          db      'Home        First page'
line12          db      'End         Final page'
line13          db      'Left        Pan view left 10 columns'
line14          db      'Right       Pan view right 10 columns (max. 50)'
line15          db      '1..5        Set bookmark #1..5'
line16          db      'Alt1..Alt5  Jump to bookmark'
line17          db      '?           Jump to line'
line18          db      '/           Search text from screen'
line19          db      'F1          Help'
line20          db      'F2          Find previous text'
line21          db      'F3          Find next text'
line22          db      'F4          Save screen to "PG.SAV"'
line23          db      0            ; it's a placeholder
msgaddr         dw      line00, line01, line02, line03, line04, line05
                dw      line06, line07, line08, line09, line10, line11
                dw      line12, line13, line14, line15, line16, line17
                dw      line18, line19, line20, line21, line22, line23


